/* DO NOT EDIT: automatically built by dist/stat.py. */

#include "wt_internal.h"

static const char * const __stats_dsrc_desc[] = {
	"block-manager: file allocation unit size",
	"block-manager: blocks allocated",
	"block-manager: checkpoint size",
	"block-manager: allocations requiring file extension",
	"block-manager: blocks freed",
	"block-manager: file magic number",
	"block-manager: file major version number",
	"block-manager: minor version number",
	"block-manager: file bytes available for reuse",
	"block-manager: file size in bytes",
	"LSM: bloom filters in the LSM tree",
	"LSM: bloom filter false positives",
	"LSM: bloom filter hits",
	"LSM: bloom filter misses",
	"LSM: bloom filter pages evicted from cache",
	"LSM: bloom filter pages read into cache",
	"LSM: total size of bloom filters",
	"btree: btree checkpoint generation",
	"btree: column-store variable-size deleted values",
	"btree: column-store fixed-size leaf pages",
	"btree: column-store internal pages",
	"btree: column-store variable-size RLE encoded values",
	"btree: column-store variable-size leaf pages",
	"btree: pages rewritten by compaction",
	"btree: number of key/value pairs",
	"btree: fixed-record size",
	"btree: maximum tree depth",
	"btree: maximum internal page key size",
	"btree: maximum internal page size",
	"btree: maximum leaf page key size",
	"btree: maximum leaf page size",
	"btree: maximum leaf page value size",
	"btree: overflow pages",
	"btree: row-store internal pages",
	"btree: row-store leaf pages",
	"cache: bytes read into cache",
	"cache: bytes written from cache",
	"cache: checkpoint blocked page eviction",
	"cache: unmodified pages evicted",
	"cache: page split during eviction deepened the tree",
	"cache: modified pages evicted",
	"cache: data source pages selected for eviction unable to be evicted",
	"cache: hazard pointer blocked page eviction",
	"cache: internal pages evicted",
	"cache: pages split during eviction",
	"cache: in-memory page splits",
	"cache: in-memory page passed criteria to be split",
	"cache: overflow values cached in memory",
	"cache: pages read into cache",
	"cache: pages read into cache requiring lookaside entries",
	"cache: overflow pages read into cache",
	"cache: pages written from cache",
	"cache: page written requiring lookaside records",
	"cache: pages written requiring in-memory restoration",
	"compression: raw compression call failed, no additional data available",
	"compression: raw compression call failed, additional data available",
	"compression: raw compression call succeeded",
	"compression: compressed pages read",
	"compression: compressed pages written",
	"compression: page written failed to compress",
	"compression: page written was too small to compress",
	"cursor: create calls",
	"cursor: insert calls",
	"cursor: bulk-loaded cursor-insert calls",
	"cursor: cursor-insert key and value bytes inserted",
	"cursor: next calls",
	"cursor: prev calls",
	"cursor: remove calls",
	"cursor: cursor-remove key bytes removed",
	"cursor: reset calls",
	"cursor: restarted searches",
	"cursor: search calls",
	"cursor: search near calls",
	"cursor: update calls",
	"cursor: cursor-update value bytes updated",
	"LSM: sleep for LSM checkpoint throttle",
	"LSM: chunks in the LSM tree",
	"LSM: highest merge generation in the LSM tree",
	"LSM: queries that could have benefited from a Bloom filter that did not exist",
	"LSM: sleep for LSM merge throttle",
	"reconciliation: dictionary matches",
	"reconciliation: internal page multi-block writes",
	"reconciliation: leaf page multi-block writes",
	"reconciliation: maximum blocks required for a page",
	"reconciliation: internal-page overflow keys",
	"reconciliation: leaf-page overflow keys",
	"reconciliation: overflow values written",
	"reconciliation: pages deleted",
	"reconciliation: page checksum matches",
	"reconciliation: page reconciliation calls",
	"reconciliation: page reconciliation calls for eviction",
	"reconciliation: leaf page key bytes discarded using prefix compression",
	"reconciliation: internal page key bytes discarded using suffix compression",
	"session: object compaction",
	"session: open cursor count",
	"transaction: update conflicts",
};

const char *
__wt_stat_dsrc_desc(int slot)
{
	return (__stats_dsrc_desc[slot]);
}

void
__wt_stat_dsrc_init_single(WT_DSRC_STATS *stats)
{
	memset(stats, 0, sizeof(*stats));
}

void
__wt_stat_dsrc_init(WT_DATA_HANDLE *handle)
{
	int i;

	for (i = 0; i < WT_COUNTER_SLOTS; ++i) {
		handle->stats[i] = &handle->stat_array[i];
		__wt_stat_dsrc_init_single(handle->stats[i]);
	}
}

void
__wt_stat_dsrc_clear_single(WT_DSRC_STATS *stats)
{
	stats->block_extension = 0;
	stats->block_alloc = 0;
	stats->block_free = 0;
	stats->block_checkpoint_size = 0;
	stats->allocation_size = 0;
	stats->block_reuse_bytes = 0;
	stats->block_magic = 0;
	stats->block_major = 0;
	stats->block_size = 0;
	stats->block_minor = 0;
		/* not clearing btree_checkpoint_generation */
	stats->btree_column_fix = 0;
	stats->btree_column_internal = 0;
	stats->btree_column_deleted = 0;
	stats->btree_column_variable = 0;
	stats->btree_column_rle = 0;
	stats->btree_fixed_len = 0;
	stats->btree_maxintlkey = 0;
	stats->btree_maxintlpage = 0;
	stats->btree_maxleafkey = 0;
	stats->btree_maxleafpage = 0;
	stats->btree_maxleafvalue = 0;
	stats->btree_maximum_depth = 0;
	stats->btree_entries = 0;
	stats->btree_overflow = 0;
	stats->btree_compact_rewrite = 0;
	stats->btree_row_internal = 0;
	stats->btree_row_leaf = 0;
	stats->cache_bytes_read = 0;
	stats->cache_bytes_write = 0;
	stats->cache_eviction_checkpoint = 0;
	stats->cache_eviction_fail = 0;
	stats->cache_eviction_hazard = 0;
	stats->cache_inmem_splittable = 0;
	stats->cache_inmem_split = 0;
	stats->cache_eviction_internal = 0;
	stats->cache_eviction_dirty = 0;
	stats->cache_read_overflow = 0;
	stats->cache_overflow_value = 0;
	stats->cache_eviction_deepen = 0;
	stats->cache_write_lookaside = 0;
	stats->cache_read = 0;
	stats->cache_read_lookaside = 0;
	stats->cache_eviction_split = 0;
	stats->cache_write = 0;
	stats->cache_write_restore = 0;
	stats->cache_eviction_clean = 0;
	stats->compress_read = 0;
	stats->compress_write = 0;
	stats->compress_write_fail = 0;
	stats->compress_write_too_small = 0;
	stats->compress_raw_fail_temporary = 0;
	stats->compress_raw_fail = 0;
	stats->compress_raw_ok = 0;
	stats->cursor_insert_bulk = 0;
	stats->cursor_create = 0;
	stats->cursor_insert_bytes = 0;
	stats->cursor_remove_bytes = 0;
	stats->cursor_update_bytes = 0;
	stats->cursor_insert = 0;
	stats->cursor_next = 0;
	stats->cursor_prev = 0;
	stats->cursor_remove = 0;
	stats->cursor_reset = 0;
	stats->cursor_restart = 0;
	stats->cursor_search = 0;
	stats->cursor_search_near = 0;
	stats->cursor_update = 0;
	stats->bloom_false_positive = 0;
	stats->bloom_hit = 0;
	stats->bloom_miss = 0;
	stats->bloom_page_evict = 0;
	stats->bloom_page_read = 0;
	stats->bloom_count = 0;
	stats->lsm_chunk_count = 0;
	stats->lsm_generation_max = 0;
	stats->lsm_lookup_no_bloom = 0;
	stats->lsm_checkpoint_throttle = 0;
	stats->lsm_merge_throttle = 0;
	stats->bloom_size = 0;
	stats->rec_dictionary = 0;
	stats->rec_suffix_compression = 0;
	stats->rec_multiblock_internal = 0;
	stats->rec_overflow_key_internal = 0;
	stats->rec_prefix_compression = 0;
	stats->rec_multiblock_leaf = 0;
	stats->rec_overflow_key_leaf = 0;
	stats->rec_multiblock_max = 0;
	stats->rec_overflow_value = 0;
	stats->rec_page_match = 0;
	stats->rec_pages = 0;
	stats->rec_pages_eviction = 0;
	stats->rec_page_delete = 0;
	stats->session_compact = 0;
		/* not clearing session_cursor_open */
	stats->txn_update_conflict = 0;
}

void
__wt_stat_dsrc_clear_all(WT_DSRC_STATS **stats)
{
	u_int i;

	for (i = 0; i < WT_COUNTER_SLOTS; ++i)
		__wt_stat_dsrc_clear_single(stats[i]);
}

void
__wt_stat_dsrc_aggregate_single(
    WT_DSRC_STATS *from, WT_DSRC_STATS *to)
{
	to->block_extension += from->block_extension;
	to->block_alloc += from->block_alloc;
	to->block_free += from->block_free;
	to->block_checkpoint_size += from->block_checkpoint_size;
	to->allocation_size = from->allocation_size;
	to->block_reuse_bytes += from->block_reuse_bytes;
	to->block_magic = from->block_magic;
	to->block_major = from->block_major;
	to->block_size += from->block_size;
	to->block_minor = from->block_minor;
	to->btree_checkpoint_generation += from->btree_checkpoint_generation;
	to->btree_column_fix += from->btree_column_fix;
	to->btree_column_internal += from->btree_column_internal;
	to->btree_column_deleted += from->btree_column_deleted;
	to->btree_column_variable += from->btree_column_variable;
	to->btree_column_rle += from->btree_column_rle;
	to->btree_fixed_len = from->btree_fixed_len;
	if (from->btree_maxintlkey > to->btree_maxintlkey)
		to->btree_maxintlkey = from->btree_maxintlkey;
	if (from->btree_maxintlpage > to->btree_maxintlpage)
		to->btree_maxintlpage = from->btree_maxintlpage;
	if (from->btree_maxleafkey > to->btree_maxleafkey)
		to->btree_maxleafkey = from->btree_maxleafkey;
	if (from->btree_maxleafpage > to->btree_maxleafpage)
		to->btree_maxleafpage = from->btree_maxleafpage;
	if (from->btree_maxleafvalue > to->btree_maxleafvalue)
		to->btree_maxleafvalue = from->btree_maxleafvalue;
	if (from->btree_maximum_depth > to->btree_maximum_depth)
		to->btree_maximum_depth = from->btree_maximum_depth;
	to->btree_entries += from->btree_entries;
	to->btree_overflow += from->btree_overflow;
	to->btree_compact_rewrite += from->btree_compact_rewrite;
	to->btree_row_internal += from->btree_row_internal;
	to->btree_row_leaf += from->btree_row_leaf;
	to->cache_bytes_read += from->cache_bytes_read;
	to->cache_bytes_write += from->cache_bytes_write;
	to->cache_eviction_checkpoint += from->cache_eviction_checkpoint;
	to->cache_eviction_fail += from->cache_eviction_fail;
	to->cache_eviction_hazard += from->cache_eviction_hazard;
	to->cache_inmem_splittable += from->cache_inmem_splittable;
	to->cache_inmem_split += from->cache_inmem_split;
	to->cache_eviction_internal += from->cache_eviction_internal;
	to->cache_eviction_dirty += from->cache_eviction_dirty;
	to->cache_read_overflow += from->cache_read_overflow;
	to->cache_overflow_value += from->cache_overflow_value;
	to->cache_eviction_deepen += from->cache_eviction_deepen;
	to->cache_write_lookaside += from->cache_write_lookaside;
	to->cache_read += from->cache_read;
	to->cache_read_lookaside += from->cache_read_lookaside;
	to->cache_eviction_split += from->cache_eviction_split;
	to->cache_write += from->cache_write;
	to->cache_write_restore += from->cache_write_restore;
	to->cache_eviction_clean += from->cache_eviction_clean;
	to->compress_read += from->compress_read;
	to->compress_write += from->compress_write;
	to->compress_write_fail += from->compress_write_fail;
	to->compress_write_too_small += from->compress_write_too_small;
	to->compress_raw_fail_temporary += from->compress_raw_fail_temporary;
	to->compress_raw_fail += from->compress_raw_fail;
	to->compress_raw_ok += from->compress_raw_ok;
	to->cursor_insert_bulk += from->cursor_insert_bulk;
	to->cursor_create += from->cursor_create;
	to->cursor_insert_bytes += from->cursor_insert_bytes;
	to->cursor_remove_bytes += from->cursor_remove_bytes;
	to->cursor_update_bytes += from->cursor_update_bytes;
	to->cursor_insert += from->cursor_insert;
	to->cursor_next += from->cursor_next;
	to->cursor_prev += from->cursor_prev;
	to->cursor_remove += from->cursor_remove;
	to->cursor_reset += from->cursor_reset;
	to->cursor_restart += from->cursor_restart;
	to->cursor_search += from->cursor_search;
	to->cursor_search_near += from->cursor_search_near;
	to->cursor_update += from->cursor_update;
	to->bloom_false_positive += from->bloom_false_positive;
	to->bloom_hit += from->bloom_hit;
	to->bloom_miss += from->bloom_miss;
	to->bloom_page_evict += from->bloom_page_evict;
	to->bloom_page_read += from->bloom_page_read;
	to->bloom_count += from->bloom_count;
	to->lsm_chunk_count += from->lsm_chunk_count;
	if (from->lsm_generation_max > to->lsm_generation_max)
		to->lsm_generation_max = from->lsm_generation_max;
	to->lsm_lookup_no_bloom += from->lsm_lookup_no_bloom;
	to->lsm_checkpoint_throttle += from->lsm_checkpoint_throttle;
	to->lsm_merge_throttle += from->lsm_merge_throttle;
	to->bloom_size += from->bloom_size;
	to->rec_dictionary += from->rec_dictionary;
	to->rec_suffix_compression += from->rec_suffix_compression;
	to->rec_multiblock_internal += from->rec_multiblock_internal;
	to->rec_overflow_key_internal += from->rec_overflow_key_internal;
	to->rec_prefix_compression += from->rec_prefix_compression;
	to->rec_multiblock_leaf += from->rec_multiblock_leaf;
	to->rec_overflow_key_leaf += from->rec_overflow_key_leaf;
	if (from->rec_multiblock_max > to->rec_multiblock_max)
		to->rec_multiblock_max = from->rec_multiblock_max;
	to->rec_overflow_value += from->rec_overflow_value;
	to->rec_page_match += from->rec_page_match;
	to->rec_pages += from->rec_pages;
	to->rec_pages_eviction += from->rec_pages_eviction;
	to->rec_page_delete += from->rec_page_delete;
	to->session_compact += from->session_compact;
	to->session_cursor_open += from->session_cursor_open;
	to->txn_update_conflict += from->txn_update_conflict;
}

void
__wt_stat_dsrc_aggregate(
    WT_DSRC_STATS **from, WT_DSRC_STATS *to)
{
	int64_t v;

	to->block_extension += WT_STAT_READ(from, block_extension);
	to->block_alloc += WT_STAT_READ(from, block_alloc);
	to->block_free += WT_STAT_READ(from, block_free);
	to->block_checkpoint_size +=
	    WT_STAT_READ(from, block_checkpoint_size);
	to->allocation_size = from[0]->allocation_size;
	to->block_reuse_bytes += WT_STAT_READ(from, block_reuse_bytes);
	to->block_magic = from[0]->block_magic;
	to->block_major = from[0]->block_major;
	to->block_size += WT_STAT_READ(from, block_size);
	to->block_minor = from[0]->block_minor;
	to->btree_checkpoint_generation +=
	    WT_STAT_READ(from, btree_checkpoint_generation);
	to->btree_column_fix += WT_STAT_READ(from, btree_column_fix);
	to->btree_column_internal +=
	    WT_STAT_READ(from, btree_column_internal);
	to->btree_column_deleted += WT_STAT_READ(from, btree_column_deleted);
	to->btree_column_variable +=
	    WT_STAT_READ(from, btree_column_variable);
	to->btree_column_rle += WT_STAT_READ(from, btree_column_rle);
	to->btree_fixed_len = from[0]->btree_fixed_len;
	if ((v = WT_STAT_READ(from, btree_maxintlkey)) >
	    to->btree_maxintlkey)
		to->btree_maxintlkey = v;
	if ((v = WT_STAT_READ(from, btree_maxintlpage)) >
	    to->btree_maxintlpage)
		to->btree_maxintlpage = v;
	if ((v = WT_STAT_READ(from, btree_maxleafkey)) >
	    to->btree_maxleafkey)
		to->btree_maxleafkey = v;
	if ((v = WT_STAT_READ(from, btree_maxleafpage)) >
	    to->btree_maxleafpage)
		to->btree_maxleafpage = v;
	if ((v = WT_STAT_READ(from, btree_maxleafvalue)) >
	    to->btree_maxleafvalue)
		to->btree_maxleafvalue = v;
	if ((v = WT_STAT_READ(from, btree_maximum_depth)) >
	    to->btree_maximum_depth)
		to->btree_maximum_depth = v;
	to->btree_entries += WT_STAT_READ(from, btree_entries);
	to->btree_overflow += WT_STAT_READ(from, btree_overflow);
	to->btree_compact_rewrite +=
	    WT_STAT_READ(from, btree_compact_rewrite);
	to->btree_row_internal += WT_STAT_READ(from, btree_row_internal);
	to->btree_row_leaf += WT_STAT_READ(from, btree_row_leaf);
	to->cache_bytes_read += WT_STAT_READ(from, cache_bytes_read);
	to->cache_bytes_write += WT_STAT_READ(from, cache_bytes_write);
	to->cache_eviction_checkpoint +=
	    WT_STAT_READ(from, cache_eviction_checkpoint);
	to->cache_eviction_fail += WT_STAT_READ(from, cache_eviction_fail);
	to->cache_eviction_hazard +=
	    WT_STAT_READ(from, cache_eviction_hazard);
	to->cache_inmem_splittable +=
	    WT_STAT_READ(from, cache_inmem_splittable);
	to->cache_inmem_split += WT_STAT_READ(from, cache_inmem_split);
	to->cache_eviction_internal +=
	    WT_STAT_READ(from, cache_eviction_internal);
	to->cache_eviction_dirty += WT_STAT_READ(from, cache_eviction_dirty);
	to->cache_read_overflow += WT_STAT_READ(from, cache_read_overflow);
	to->cache_overflow_value += WT_STAT_READ(from, cache_overflow_value);
	to->cache_eviction_deepen +=
	    WT_STAT_READ(from, cache_eviction_deepen);
	to->cache_write_lookaside +=
	    WT_STAT_READ(from, cache_write_lookaside);
	to->cache_read += WT_STAT_READ(from, cache_read);
	to->cache_read_lookaside += WT_STAT_READ(from, cache_read_lookaside);
	to->cache_eviction_split += WT_STAT_READ(from, cache_eviction_split);
	to->cache_write += WT_STAT_READ(from, cache_write);
	to->cache_write_restore += WT_STAT_READ(from, cache_write_restore);
	to->cache_eviction_clean += WT_STAT_READ(from, cache_eviction_clean);
	to->compress_read += WT_STAT_READ(from, compress_read);
	to->compress_write += WT_STAT_READ(from, compress_write);
	to->compress_write_fail += WT_STAT_READ(from, compress_write_fail);
	to->compress_write_too_small +=
	    WT_STAT_READ(from, compress_write_too_small);
	to->compress_raw_fail_temporary +=
	    WT_STAT_READ(from, compress_raw_fail_temporary);
	to->compress_raw_fail += WT_STAT_READ(from, compress_raw_fail);
	to->compress_raw_ok += WT_STAT_READ(from, compress_raw_ok);
	to->cursor_insert_bulk += WT_STAT_READ(from, cursor_insert_bulk);
	to->cursor_create += WT_STAT_READ(from, cursor_create);
	to->cursor_insert_bytes += WT_STAT_READ(from, cursor_insert_bytes);
	to->cursor_remove_bytes += WT_STAT_READ(from, cursor_remove_bytes);
	to->cursor_update_bytes += WT_STAT_READ(from, cursor_update_bytes);
	to->cursor_insert += WT_STAT_READ(from, cursor_insert);
	to->cursor_next += WT_STAT_READ(from, cursor_next);
	to->cursor_prev += WT_STAT_READ(from, cursor_prev);
	to->cursor_remove += WT_STAT_READ(from, cursor_remove);
	to->cursor_reset += WT_STAT_READ(from, cursor_reset);
	to->cursor_restart += WT_STAT_READ(from, cursor_restart);
	to->cursor_search += WT_STAT_READ(from, cursor_search);
	to->cursor_search_near += WT_STAT_READ(from, cursor_search_near);
	to->cursor_update += WT_STAT_READ(from, cursor_update);
	to->bloom_false_positive += WT_STAT_READ(from, bloom_false_positive);
	to->bloom_hit += WT_STAT_READ(from, bloom_hit);
	to->bloom_miss += WT_STAT_READ(from, bloom_miss);
	to->bloom_page_evict += WT_STAT_READ(from, bloom_page_evict);
	to->bloom_page_read += WT_STAT_READ(from, bloom_page_read);
	to->bloom_count += WT_STAT_READ(from, bloom_count);
	to->lsm_chunk_count += WT_STAT_READ(from, lsm_chunk_count);
	if ((v = WT_STAT_READ(from, lsm_generation_max)) >
	    to->lsm_generation_max)
		to->lsm_generation_max = v;
	to->lsm_lookup_no_bloom += WT_STAT_READ(from, lsm_lookup_no_bloom);
	to->lsm_checkpoint_throttle +=
	    WT_STAT_READ(from, lsm_checkpoint_throttle);
	to->lsm_merge_throttle += WT_STAT_READ(from, lsm_merge_throttle);
	to->bloom_size += WT_STAT_READ(from, bloom_size);
	to->rec_dictionary += WT_STAT_READ(from, rec_dictionary);
	to->rec_suffix_compression +=
	    WT_STAT_READ(from, rec_suffix_compression);
	to->rec_multiblock_internal +=
	    WT_STAT_READ(from, rec_multiblock_internal);
	to->rec_overflow_key_internal +=
	    WT_STAT_READ(from, rec_overflow_key_internal);
	to->rec_prefix_compression +=
	    WT_STAT_READ(from, rec_prefix_compression);
	to->rec_multiblock_leaf += WT_STAT_READ(from, rec_multiblock_leaf);
	to->rec_overflow_key_leaf +=
	    WT_STAT_READ(from, rec_overflow_key_leaf);
	if ((v = WT_STAT_READ(from, rec_multiblock_max)) >
	    to->rec_multiblock_max)
		to->rec_multiblock_max = v;
	to->rec_overflow_value += WT_STAT_READ(from, rec_overflow_value);
	to->rec_page_match += WT_STAT_READ(from, rec_page_match);
	to->rec_pages += WT_STAT_READ(from, rec_pages);
	to->rec_pages_eviction += WT_STAT_READ(from, rec_pages_eviction);
	to->rec_page_delete += WT_STAT_READ(from, rec_page_delete);
	to->session_compact += WT_STAT_READ(from, session_compact);
	to->session_cursor_open += WT_STAT_READ(from, session_cursor_open);
	to->txn_update_conflict += WT_STAT_READ(from, txn_update_conflict);
}

static const char * const __stats_connection_desc[] = {
	"async: number of allocation state races",
	"async: number of operation slots viewed for allocation",
	"async: current work queue length",
	"async: number of flush calls",
	"async: number of times operation allocation failed",
	"async: maximum work queue length",
	"async: number of times worker found no work",
	"async: total allocations",
	"async: total compact calls",
	"async: total insert calls",
	"async: total remove calls",
	"async: total search calls",
	"async: total update calls",
	"block-manager: mapped bytes read",
	"block-manager: bytes read",
	"block-manager: bytes written",
	"block-manager: mapped blocks read",
	"block-manager: blocks pre-loaded",
	"block-manager: blocks read",
	"block-manager: blocks written",
	"cache: tracked dirty bytes in the cache",
	"cache: tracked bytes belonging to internal pages in the cache",
	"cache: bytes currently in the cache",
	"cache: tracked bytes belonging to leaf pages in the cache",
	"cache: maximum bytes configured",
	"cache: tracked bytes belonging to overflow pages in the cache",
	"cache: bytes read into cache",
	"cache: bytes written from cache",
	"cache: pages evicted by application threads",
	"cache: checkpoint blocked page eviction",
	"cache: unmodified pages evicted",
	"cache: page split during eviction deepened the tree",
	"cache: modified pages evicted",
	"cache: pages selected for eviction unable to be evicted",
	"cache: pages evicted because they exceeded the in-memory maximum",
	"cache: pages evicted because they had chains of deleted items",
	"cache: failed eviction of pages that exceeded the in-memory maximum",
	"cache: hazard pointer blocked page eviction",
	"cache: internal pages evicted",
	"cache: maximum page size at eviction",
	"cache: eviction server candidate queue empty when topping up",
	"cache: eviction server candidate queue not empty when topping up",
	"cache: eviction server evicting pages",
	"cache: eviction server populating queue, but not evicting pages",
	"cache: eviction server unable to reach eviction goal",
	"cache: pages split during eviction",
	"cache: pages walked for eviction",
	"cache: eviction worker thread evicting pages",
	"cache: in-memory page splits",
	"cache: in-memory page passed criteria to be split",
	"cache: lookaside table insert calls",
	"cache: lookaside table remove calls",
	"cache: percentage overhead",
	"cache: tracked dirty pages in the cache",
	"cache: pages currently held in the cache",
	"cache: pages read into cache",
	"cache: pages read into cache requiring lookaside entries",
	"cache: pages written from cache",
	"cache: page written requiring lookaside records",
	"cache: pages written requiring in-memory restoration",
	"connection: pthread mutex condition wait calls",
	"cursor: cursor create calls",
	"cursor: cursor insert calls",
	"cursor: cursor next calls",
	"cursor: cursor prev calls",
	"cursor: cursor remove calls",
	"cursor: cursor reset calls",
	"cursor: cursor restarted searches",
	"cursor: cursor search calls",
	"cursor: cursor search near calls",
	"cursor: cursor update calls",
	"data-handle: connection data handles currently active",
	"data-handle: session dhandles swept",
	"data-handle: session sweep attempts",
	"data-handle: connection sweep dhandles closed",
	"data-handle: connection sweep candidate became referenced",
	"data-handle: connection sweep dhandles removed from hash list",
	"data-handle: connection sweep time-of-death sets",
	"data-handle: connection sweeps",
	"connection: files currently open",
	"log: total log buffer size",
	"log: log bytes of payload data",
	"log: log bytes written",
	"log: yields waiting for previous log file close",
	"log: total size of compressed records",
	"log: total in-memory size of compressed records",
	"log: log records too small to compress",
	"log: log records not compressed",
	"log: log records compressed",
	"log: maximum log file size",
	"log: pre-allocated log files prepared",
	"log: number of pre-allocated log files to create",
	"log: pre-allocated log files used",
	"log: log release advances write LSN",
	"log: records processed by log scan",
	"log: log scan records requiring two reads",
	"log: log scan operations",
	"log: consolidated slot closures",
	"log: written slots coalesced",
	"log: logging bytes consolidated",
	"log: consolidated slot joins",
	"log: consolidated slot join races",
	"log: busy returns attempting to switch slots",
	"log: consolidated slot join transitions",
	"log: consolidated slot unbuffered writes",
	"log: log sync operations",
	"log: log sync_dir operations",
	"log: log server thread advances write LSN",
	"log: log write operations",
	"LSM: sleep for LSM checkpoint throttle",
	"LSM: sleep for LSM merge throttle",
	"LSM: rows merged in an LSM tree",
	"LSM: application work units currently queued",
	"LSM: merge work units currently queued",
	"LSM: tree queue hit maximum",
	"LSM: switch work units currently queued",
	"LSM: tree maintenance operations scheduled",
	"LSM: tree maintenance operations discarded",
	"LSM: tree maintenance operations executed",
	"connection: memory allocations",
	"connection: memory frees",
	"connection: memory re-allocations",
	"thread-yield: page acquire busy blocked",
	"thread-yield: page acquire eviction blocked",
	"thread-yield: page acquire locked blocked",
	"thread-yield: page acquire read blocked",
	"thread-yield: page acquire time sleeping (usecs)",
	"connection: total read I/Os",
	"reconciliation: page reconciliation calls",
	"reconciliation: page reconciliation calls for eviction",
	"reconciliation: split bytes currently awaiting free",
	"reconciliation: split objects currently awaiting free",
	"connection: pthread mutex shared lock read-lock calls",
	"connection: pthread mutex shared lock write-lock calls",
	"session: open cursor count",
	"session: open session count",
	"transaction: transaction begins",
	"transaction: transaction checkpoints",
	"transaction: transaction checkpoint generation",
	"transaction: transaction checkpoint currently running",
	"transaction: transaction checkpoint max time (msecs)",
	"transaction: transaction checkpoint min time (msecs)",
	"transaction: transaction checkpoint most recent time (msecs)",
	"transaction: transaction checkpoint total time (msecs)",
	"transaction: transactions committed",
	"transaction: transaction failures due to cache overflow",
	"transaction: transaction range of IDs currently pinned by a checkpoint",
	"transaction: transaction range of IDs currently pinned",
	"transaction: transactions rolled back",
	"transaction: transaction sync calls",
	"connection: total write I/Os",
};

const char *
__wt_stat_connection_desc(int slot)
{
	return (__stats_connection_desc[slot]);
}

void
__wt_stat_connection_init_single(WT_CONNECTION_STATS *stats)
{
	memset(stats, 0, sizeof(*stats));
}

void
__wt_stat_connection_init(WT_CONNECTION_IMPL *handle)
{
	int i;

	for (i = 0; i < WT_COUNTER_SLOTS; ++i) {
		handle->stats[i] = &handle->stat_array[i];
		__wt_stat_connection_init_single(handle->stats[i]);
	}
}

void
__wt_stat_connection_clear_single(WT_CONNECTION_STATS *stats)
{
	stats->async_cur_queue = 0;
		/* not clearing async_max_queue */
	stats->async_alloc_race = 0;
	stats->async_flush = 0;
	stats->async_alloc_view = 0;
	stats->async_full = 0;
	stats->async_nowork = 0;
	stats->async_op_alloc = 0;
	stats->async_op_compact = 0;
	stats->async_op_insert = 0;
	stats->async_op_remove = 0;
	stats->async_op_search = 0;
	stats->async_op_update = 0;
	stats->block_preload = 0;
	stats->block_read = 0;
	stats->block_write = 0;
	stats->block_byte_read = 0;
	stats->block_byte_write = 0;
	stats->block_map_read = 0;
	stats->block_byte_map_read = 0;
		/* not clearing cache_bytes_inuse */
	stats->cache_bytes_read = 0;
	stats->cache_bytes_write = 0;
	stats->cache_eviction_checkpoint = 0;
	stats->cache_eviction_queue_empty = 0;
	stats->cache_eviction_queue_not_empty = 0;
	stats->cache_eviction_server_evicting = 0;
	stats->cache_eviction_server_not_evicting = 0;
	stats->cache_eviction_slow = 0;
	stats->cache_eviction_worker_evicting = 0;
	stats->cache_eviction_force_fail = 0;
	stats->cache_eviction_hazard = 0;
	stats->cache_inmem_splittable = 0;
	stats->cache_inmem_split = 0;
	stats->cache_eviction_internal = 0;
	stats->cache_lookaside_insert = 0;
	stats->cache_lookaside_remove = 0;
		/* not clearing cache_bytes_max */
		/* not clearing cache_eviction_maximum_page_size */
	stats->cache_eviction_dirty = 0;
	stats->cache_eviction_deepen = 0;
	stats->cache_write_lookaside = 0;
		/* not clearing cache_pages_inuse */
	stats->cache_eviction_force = 0;
	stats->cache_eviction_force_delete = 0;
	stats->cache_eviction_app = 0;
	stats->cache_read = 0;
	stats->cache_read_lookaside = 0;
	stats->cache_eviction_fail = 0;
	stats->cache_eviction_split = 0;
	stats->cache_eviction_walk = 0;
	stats->cache_write = 0;
	stats->cache_write_restore = 0;
		/* not clearing cache_overhead */
		/* not clearing cache_bytes_internal */
		/* not clearing cache_bytes_leaf */
		/* not clearing cache_bytes_overflow */
		/* not clearing cache_bytes_dirty */
		/* not clearing cache_pages_dirty */
	stats->cache_eviction_clean = 0;
		/* not clearing file_open */
	stats->memory_allocation = 0;
	stats->memory_free = 0;
	stats->memory_grow = 0;
	stats->cond_wait = 0;
	stats->rwlock_read = 0;
	stats->rwlock_write = 0;
	stats->read_io = 0;
	stats->write_io = 0;
	stats->cursor_create = 0;
	stats->cursor_insert = 0;
	stats->cursor_next = 0;
	stats->cursor_prev = 0;
	stats->cursor_remove = 0;
	stats->cursor_reset = 0;
	stats->cursor_restart = 0;
	stats->cursor_search = 0;
	stats->cursor_search_near = 0;
	stats->cursor_update = 0;
		/* not clearing dh_conn_handle_count */
	stats->dh_sweep_ref = 0;
	stats->dh_sweep_close = 0;
	stats->dh_sweep_remove = 0;
	stats->dh_sweep_tod = 0;
	stats->dh_sweeps = 0;
	stats->dh_session_handles = 0;
	stats->dh_session_sweeps = 0;
	stats->log_slot_switch_busy = 0;
	stats->log_slot_closes = 0;
	stats->log_slot_races = 0;
	stats->log_slot_transitions = 0;
	stats->log_slot_joins = 0;
	stats->log_slot_unbuffered = 0;
	stats->log_bytes_payload = 0;
	stats->log_bytes_written = 0;
	stats->log_compress_writes = 0;
	stats->log_compress_write_fails = 0;
	stats->log_compress_small = 0;
	stats->log_release_write_lsn = 0;
	stats->log_scans = 0;
	stats->log_scan_rereads = 0;
	stats->log_write_lsn = 0;
	stats->log_sync = 0;
	stats->log_sync_dir = 0;
	stats->log_writes = 0;
	stats->log_slot_consolidated = 0;
		/* not clearing log_max_filesize */
		/* not clearing log_prealloc_max */
	stats->log_prealloc_files = 0;
	stats->log_prealloc_used = 0;
	stats->log_scan_records = 0;
	stats->log_compress_mem = 0;
		/* not clearing log_buffer_size */
	stats->log_compress_len = 0;
	stats->log_slot_coalesced = 0;
	stats->log_close_yields = 0;
		/* not clearing lsm_work_queue_app */
		/* not clearing lsm_work_queue_manager */
	stats->lsm_rows_merged = 0;
	stats->lsm_checkpoint_throttle = 0;
	stats->lsm_merge_throttle = 0;
		/* not clearing lsm_work_queue_switch */
	stats->lsm_work_units_discarded = 0;
	stats->lsm_work_units_done = 0;
	stats->lsm_work_units_created = 0;
	stats->lsm_work_queue_max = 0;
	stats->rec_pages = 0;
	stats->rec_pages_eviction = 0;
		/* not clearing rec_split_stashed_bytes */
		/* not clearing rec_split_stashed_objects */
		/* not clearing session_cursor_open */
		/* not clearing session_open */
	stats->page_busy_blocked = 0;
	stats->page_forcible_evict_blocked = 0;
	stats->page_locked_blocked = 0;
	stats->page_read_blocked = 0;
	stats->page_sleep = 0;
	stats->txn_begin = 0;
		/* not clearing txn_checkpoint_running */
		/* not clearing txn_checkpoint_generation */
		/* not clearing txn_checkpoint_time_max */
		/* not clearing txn_checkpoint_time_min */
		/* not clearing txn_checkpoint_time_recent */
		/* not clearing txn_checkpoint_time_total */
	stats->txn_checkpoint = 0;
	stats->txn_fail_cache = 0;
		/* not clearing txn_pinned_range */
		/* not clearing txn_pinned_checkpoint_range */
	stats->txn_sync = 0;
	stats->txn_commit = 0;
	stats->txn_rollback = 0;
}

void
__wt_stat_connection_clear_all(WT_CONNECTION_STATS **stats)
{
	u_int i;

	for (i = 0; i < WT_COUNTER_SLOTS; ++i)
		__wt_stat_connection_clear_single(stats[i]);
}

void
__wt_stat_connection_aggregate(
    WT_CONNECTION_STATS **from, WT_CONNECTION_STATS *to)
{
	to->async_cur_queue += WT_STAT_READ(from, async_cur_queue);
	to->async_max_queue += WT_STAT_READ(from, async_max_queue);
	to->async_alloc_race += WT_STAT_READ(from, async_alloc_race);
	to->async_flush += WT_STAT_READ(from, async_flush);
	to->async_alloc_view += WT_STAT_READ(from, async_alloc_view);
	to->async_full += WT_STAT_READ(from, async_full);
	to->async_nowork += WT_STAT_READ(from, async_nowork);
	to->async_op_alloc += WT_STAT_READ(from, async_op_alloc);
	to->async_op_compact += WT_STAT_READ(from, async_op_compact);
	to->async_op_insert += WT_STAT_READ(from, async_op_insert);
	to->async_op_remove += WT_STAT_READ(from, async_op_remove);
	to->async_op_search += WT_STAT_READ(from, async_op_search);
	to->async_op_update += WT_STAT_READ(from, async_op_update);
	to->block_preload += WT_STAT_READ(from, block_preload);
	to->block_read += WT_STAT_READ(from, block_read);
	to->block_write += WT_STAT_READ(from, block_write);
	to->block_byte_read += WT_STAT_READ(from, block_byte_read);
	to->block_byte_write += WT_STAT_READ(from, block_byte_write);
	to->block_map_read += WT_STAT_READ(from, block_map_read);
	to->block_byte_map_read += WT_STAT_READ(from, block_byte_map_read);
	to->cache_bytes_inuse += WT_STAT_READ(from, cache_bytes_inuse);
	to->cache_bytes_read += WT_STAT_READ(from, cache_bytes_read);
	to->cache_bytes_write += WT_STAT_READ(from, cache_bytes_write);
	to->cache_eviction_checkpoint +=
	    WT_STAT_READ(from, cache_eviction_checkpoint);
	to->cache_eviction_queue_empty +=
	    WT_STAT_READ(from, cache_eviction_queue_empty);
	to->cache_eviction_queue_not_empty +=
	    WT_STAT_READ(from, cache_eviction_queue_not_empty);
	to->cache_eviction_server_evicting +=
	    WT_STAT_READ(from, cache_eviction_server_evicting);
	to->cache_eviction_server_not_evicting +=
	    WT_STAT_READ(from, cache_eviction_server_not_evicting);
	to->cache_eviction_slow += WT_STAT_READ(from, cache_eviction_slow);
	to->cache_eviction_worker_evicting +=
	    WT_STAT_READ(from, cache_eviction_worker_evicting);
	to->cache_eviction_force_fail +=
	    WT_STAT_READ(from, cache_eviction_force_fail);
	to->cache_eviction_hazard +=
	    WT_STAT_READ(from, cache_eviction_hazard);
	to->cache_inmem_splittable +=
	    WT_STAT_READ(from, cache_inmem_splittable);
	to->cache_inmem_split += WT_STAT_READ(from, cache_inmem_split);
	to->cache_eviction_internal +=
	    WT_STAT_READ(from, cache_eviction_internal);
	to->cache_lookaside_insert +=
	    WT_STAT_READ(from, cache_lookaside_insert);
	to->cache_lookaside_remove +=
	    WT_STAT_READ(from, cache_lookaside_remove);
	to->cache_bytes_max += WT_STAT_READ(from, cache_bytes_max);
	to->cache_eviction_maximum_page_size +=
	    WT_STAT_READ(from, cache_eviction_maximum_page_size);
	to->cache_eviction_dirty += WT_STAT_READ(from, cache_eviction_dirty);
	to->cache_eviction_deepen +=
	    WT_STAT_READ(from, cache_eviction_deepen);
	to->cache_write_lookaside +=
	    WT_STAT_READ(from, cache_write_lookaside);
	to->cache_pages_inuse += WT_STAT_READ(from, cache_pages_inuse);
	to->cache_eviction_force += WT_STAT_READ(from, cache_eviction_force);
	to->cache_eviction_force_delete +=
	    WT_STAT_READ(from, cache_eviction_force_delete);
	to->cache_eviction_app += WT_STAT_READ(from, cache_eviction_app);
	to->cache_read += WT_STAT_READ(from, cache_read);
	to->cache_read_lookaside += WT_STAT_READ(from, cache_read_lookaside);
	to->cache_eviction_fail += WT_STAT_READ(from, cache_eviction_fail);
	to->cache_eviction_split += WT_STAT_READ(from, cache_eviction_split);
	to->cache_eviction_walk += WT_STAT_READ(from, cache_eviction_walk);
	to->cache_write += WT_STAT_READ(from, cache_write);
	to->cache_write_restore += WT_STAT_READ(from, cache_write_restore);
	to->cache_overhead += WT_STAT_READ(from, cache_overhead);
	to->cache_bytes_internal += WT_STAT_READ(from, cache_bytes_internal);
	to->cache_bytes_leaf += WT_STAT_READ(from, cache_bytes_leaf);
	to->cache_bytes_overflow += WT_STAT_READ(from, cache_bytes_overflow);
	to->cache_bytes_dirty += WT_STAT_READ(from, cache_bytes_dirty);
	to->cache_pages_dirty += WT_STAT_READ(from, cache_pages_dirty);
	to->cache_eviction_clean += WT_STAT_READ(from, cache_eviction_clean);
	to->file_open += WT_STAT_READ(from, file_open);
	to->memory_allocation += WT_STAT_READ(from, memory_allocation);
	to->memory_free += WT_STAT_READ(from, memory_free);
	to->memory_grow += WT_STAT_READ(from, memory_grow);
	to->cond_wait += WT_STAT_READ(from, cond_wait);
	to->rwlock_read += WT_STAT_READ(from, rwlock_read);
	to->rwlock_write += WT_STAT_READ(from, rwlock_write);
	to->read_io += WT_STAT_READ(from, read_io);
	to->write_io += WT_STAT_READ(from, write_io);
	to->cursor_create += WT_STAT_READ(from, cursor_create);
	to->cursor_insert += WT_STAT_READ(from, cursor_insert);
	to->cursor_next += WT_STAT_READ(from, cursor_next);
	to->cursor_prev += WT_STAT_READ(from, cursor_prev);
	to->cursor_remove += WT_STAT_READ(from, cursor_remove);
	to->cursor_reset += WT_STAT_READ(from, cursor_reset);
	to->cursor_restart += WT_STAT_READ(from, cursor_restart);
	to->cursor_search += WT_STAT_READ(from, cursor_search);
	to->cursor_search_near += WT_STAT_READ(from, cursor_search_near);
	to->cursor_update += WT_STAT_READ(from, cursor_update);
	to->dh_conn_handle_count += WT_STAT_READ(from, dh_conn_handle_count);
	to->dh_sweep_ref += WT_STAT_READ(from, dh_sweep_ref);
	to->dh_sweep_close += WT_STAT_READ(from, dh_sweep_close);
	to->dh_sweep_remove += WT_STAT_READ(from, dh_sweep_remove);
	to->dh_sweep_tod += WT_STAT_READ(from, dh_sweep_tod);
	to->dh_sweeps += WT_STAT_READ(from, dh_sweeps);
	to->dh_session_handles += WT_STAT_READ(from, dh_session_handles);
	to->dh_session_sweeps += WT_STAT_READ(from, dh_session_sweeps);
	to->log_slot_switch_busy += WT_STAT_READ(from, log_slot_switch_busy);
	to->log_slot_closes += WT_STAT_READ(from, log_slot_closes);
	to->log_slot_races += WT_STAT_READ(from, log_slot_races);
	to->log_slot_transitions += WT_STAT_READ(from, log_slot_transitions);
	to->log_slot_joins += WT_STAT_READ(from, log_slot_joins);
	to->log_slot_unbuffered += WT_STAT_READ(from, log_slot_unbuffered);
	to->log_bytes_payload += WT_STAT_READ(from, log_bytes_payload);
	to->log_bytes_written += WT_STAT_READ(from, log_bytes_written);
	to->log_compress_writes += WT_STAT_READ(from, log_compress_writes);
	to->log_compress_write_fails +=
	    WT_STAT_READ(from, log_compress_write_fails);
	to->log_compress_small += WT_STAT_READ(from, log_compress_small);
	to->log_release_write_lsn +=
	    WT_STAT_READ(from, log_release_write_lsn);
	to->log_scans += WT_STAT_READ(from, log_scans);
	to->log_scan_rereads += WT_STAT_READ(from, log_scan_rereads);
	to->log_write_lsn += WT_STAT_READ(from, log_write_lsn);
	to->log_sync += WT_STAT_READ(from, log_sync);
	to->log_sync_dir += WT_STAT_READ(from, log_sync_dir);
	to->log_writes += WT_STAT_READ(from, log_writes);
	to->log_slot_consolidated +=
	    WT_STAT_READ(from, log_slot_consolidated);
	to->log_max_filesize += WT_STAT_READ(from, log_max_filesize);
	to->log_prealloc_max += WT_STAT_READ(from, log_prealloc_max);
	to->log_prealloc_files += WT_STAT_READ(from, log_prealloc_files);
	to->log_prealloc_used += WT_STAT_READ(from, log_prealloc_used);
	to->log_scan_records += WT_STAT_READ(from, log_scan_records);
	to->log_compress_mem += WT_STAT_READ(from, log_compress_mem);
	to->log_buffer_size += WT_STAT_READ(from, log_buffer_size);
	to->log_compress_len += WT_STAT_READ(from, log_compress_len);
	to->log_slot_coalesced += WT_STAT_READ(from, log_slot_coalesced);
	to->log_close_yields += WT_STAT_READ(from, log_close_yields);
	to->lsm_work_queue_app += WT_STAT_READ(from, lsm_work_queue_app);
	to->lsm_work_queue_manager +=
	    WT_STAT_READ(from, lsm_work_queue_manager);
	to->lsm_rows_merged += WT_STAT_READ(from, lsm_rows_merged);
	to->lsm_checkpoint_throttle +=
	    WT_STAT_READ(from, lsm_checkpoint_throttle);
	to->lsm_merge_throttle += WT_STAT_READ(from, lsm_merge_throttle);
	to->lsm_work_queue_switch +=
	    WT_STAT_READ(from, lsm_work_queue_switch);
	to->lsm_work_units_discarded +=
	    WT_STAT_READ(from, lsm_work_units_discarded);
	to->lsm_work_units_done += WT_STAT_READ(from, lsm_work_units_done);
	to->lsm_work_units_created +=
	    WT_STAT_READ(from, lsm_work_units_created);
	to->lsm_work_queue_max += WT_STAT_READ(from, lsm_work_queue_max);
	to->rec_pages += WT_STAT_READ(from, rec_pages);
	to->rec_pages_eviction += WT_STAT_READ(from, rec_pages_eviction);
	to->rec_split_stashed_bytes +=
	    WT_STAT_READ(from, rec_split_stashed_bytes);
	to->rec_split_stashed_objects +=
	    WT_STAT_READ(from, rec_split_stashed_objects);
	to->session_cursor_open += WT_STAT_READ(from, session_cursor_open);
	to->session_open += WT_STAT_READ(from, session_open);
	to->page_busy_blocked += WT_STAT_READ(from, page_busy_blocked);
	to->page_forcible_evict_blocked +=
	    WT_STAT_READ(from, page_forcible_evict_blocked);
	to->page_locked_blocked += WT_STAT_READ(from, page_locked_blocked);
	to->page_read_blocked += WT_STAT_READ(from, page_read_blocked);
	to->page_sleep += WT_STAT_READ(from, page_sleep);
	to->txn_begin += WT_STAT_READ(from, txn_begin);
	to->txn_checkpoint_running +=
	    WT_STAT_READ(from, txn_checkpoint_running);
	to->txn_checkpoint_generation +=
	    WT_STAT_READ(from, txn_checkpoint_generation);
	to->txn_checkpoint_time_max +=
	    WT_STAT_READ(from, txn_checkpoint_time_max);
	to->txn_checkpoint_time_min +=
	    WT_STAT_READ(from, txn_checkpoint_time_min);
	to->txn_checkpoint_time_recent +=
	    WT_STAT_READ(from, txn_checkpoint_time_recent);
	to->txn_checkpoint_time_total +=
	    WT_STAT_READ(from, txn_checkpoint_time_total);
	to->txn_checkpoint += WT_STAT_READ(from, txn_checkpoint);
	to->txn_fail_cache += WT_STAT_READ(from, txn_fail_cache);
	to->txn_pinned_range += WT_STAT_READ(from, txn_pinned_range);
	to->txn_pinned_checkpoint_range +=
	    WT_STAT_READ(from, txn_pinned_checkpoint_range);
	to->txn_sync += WT_STAT_READ(from, txn_sync);
	to->txn_commit += WT_STAT_READ(from, txn_commit);
	to->txn_rollback += WT_STAT_READ(from, txn_rollback);
}
