/**
 *    Copyright 2015 MongoDB Inc.
 *
 *    This program is free software: you can redistribute it and/or  modify
 *    it under the terms of the GNU Affero General Public License, version 3,
 *    as published by the Free Software Foundation.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Affero General Public License for more details.
 *
 *    You should have received a copy of the GNU Affero General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    As a special exception, the copyright holders give permission to link the
 *    code of portions of this program with the OpenSSL library under certain
 *    conditions as described in each individual source file and distribute
 *    linked combinations including the program with the OpenSSL library. You
 *    must comply with the GNU Affero General Public License in all respects for
 *    all of the code used other than as permitted herein. If you modify file(s)
 *    with this exception, you may extend this exception to your version of the
 *    file(s), but you are not obligated to do so. If you do not wish to do so,
 *    delete this exception statement from your version. If you delete this
 *    exception statement from all source files in the program, then also delete
 *    it in the license file.
 */

#pragma once

#include <memory>

#include "mongo/base/status.h"
#include "mongo/unittest/unittest.h"

namespace mongo {

    class OperationContext;

namespace threadpool {

    class ThreadPool;

} // namespace threadpool

namespace repl {

    class TaskRunner;

    /**
     * Test fixture for tests that require a TaskRunner and/or
     * ThreadPool.
     */
    class TaskRunnerTest : public unittest::Test {
    public:
        static Status getDefaultStatus();

        /**
         * Returns ID of mock operation context returned from createOperationContext().
         * Returns -1 if txn is null.
         * Returns -2 if txn cannot be converted to a mock operation context containing an ID.
         */
        static int getOperationContextId(OperationContext* txn);

        /**
         * Returns an noop operation context with an embedded numerical ID.
         */
        virtual OperationContext* createOperationContext() const;

        threadpool::ThreadPool& getThreadPool() const;
        TaskRunner& getTaskRunner() const;

        void resetTaskRunner(TaskRunner* taskRunner);
        void destroyTaskRunner();

        void setUp() override;
        void tearDown() override;

    private:
        std::unique_ptr<threadpool::ThreadPool> _threadPool;
        std::unique_ptr<TaskRunner> _taskRunner;
    };

} // namespace repl
} // namespace mongo
