// mongo/db/authlevel.h

/*    Copyright 2012 10gen Inc.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

#pragma once

#include <string>

#include "mongo/client/export_macros.h"

namespace mongo {

    /*
     * for a particular db
     * levels
     *     0 : none
     *     1 : read
     *     2 : write
     */
    struct MONGO_CLIENT_API Auth {

        enum Level { NONE = 0 ,
                     READ = 1 ,
                     WRITE = 2 };

        Auth() : level( NONE ) {}

        Level level;
        std::string user;
    };
}  // namespace mongo
