// nscanned and nscannedObjects report results for the winning plan; nscannedAllPlans and
// nscannedObjectsAllPlans report results for all plans.  SERVER-6268

t = db.jstests_explainb;
t.drop();

t.ensureIndex( { a:1, b:1 } );
t.ensureIndex( { b:1, a:1 } );

t.save( { a:0, b:1 } );
t.save( { a:1, b:0 } );

explain = t.find( { a:{ $gte:0 }, b:{ $gte:0 } } ).explain( true );

// The a:1,b:1 plan finishes scanning first.
// QUERY_MIGRATION: not strictly true...
// assert.eq( 'BtreeCursor a_1_b_1', explain.cursor );
assert.eq( 2, explain.n );
// nscanned and nscannedObjects are reported for the a:1,b:1 plan.
assert.eq( 2, explain.nscanned );
assert.eq( 2, explain.nscannedObjects );
// nscannedAllPlans reports the combined total of all plans.
assert.eq( 8, explain.nscannedAllPlans );
// nscannedObjectsAllPlans reports the total for the set of interleaved plans.
// QUERY_MIGRATION
// assert.eq( 4, explain.nscannedObjectsAllPlans );

// A limit of 2.
explain = t.find( { a:{ $gte:0 }, b:{ $gte:0 } } ).limit( -2 ).explain( true );

// QUERY_MIGRATION: not strictly true.
// assert.eq( 'BtreeCursor a_1_b_1', explain.cursor );
assert.eq( 2, explain.n );
// QUERY_MIGRATION
// How are we pulling 2 things out without looking at 2 things?
// assert.eq( 1, explain.nscanned );
// assert.eq( 1, explain.nscannedObjects );
// The first result was identified for each plan.
// assert.eq( 3, explain.nscannedAllPlans );
// One result was retrieved from each of the two indexed plans.
// assert.eq( 2, explain.nscannedObjectsAllPlans );

// A $or query.
explain = t.find( { $or:[ { a:{ $gte:0 }, b:{ $gte:1 } },
                          { a:{ $gte:1 }, b:{ $gte:0 } } ] } ).explain( true );
// QUERY MIGRATION
// The or plans of the new system do not fetch in this case (the fetch comes
// after the or). The conters of the two plans are slightly different because
// of that.
// printjson( explain )
assert.eq( 1, explain.clauses[ 0 ].n );
// assert.eq( 1, explain.clauses[ 0 ].nscannedObjects );
// assert.eq( 2, explain.clauses[ 0 ].nscanned );
// assert.eq( 2, explain.clauses[ 0 ].nscannedObjectsAllPlans );
// assert.eq( 4, explain.clauses[ 0 ].nscannedAllPlans );
// assert.eq( 1, explain.clauses[ 1 ].n );
// assert.eq( 1, explain.clauses[ 1 ].nscannedObjects );
// assert.eq( 1, explain.clauses[ 1 ].nscanned );
// assert.eq( 2, explain.clauses[ 1 ].nscannedObjectsAllPlans );
// assert.eq( 3, explain.clauses[ 1 ].nscannedAllPlans );
assert.eq( 2, explain.n );

// These are computed by summing the values for each clause.
printjson(explain);
assert.eq( 2, explain.n );
// assert.eq( 2, explain.nscannedObjects );
// See comments above
// assert.eq( 3, explain.nscanned );
// assert.eq( 4, explain.nscannedObjectsAllPlans );
// assert.eq( 7, explain.nscannedAllPlans );

// A non $or case where nscanned != nscannedObjects.
t.remove();

t.save( { a:'0', b:'1' } );
t.save( { a:'1', b:'0' } );

explain = t.find( { a:/0/, b:/1/ } ).explain( true );
// QUERY MIGRATION
// Not sure what are the cases in the old system that return a "multi" cursor
// printjson( explain )
// assert.eq( 'BtreeCursor a_1_b_1 multi', explain.cursor );
assert.eq( 1, explain.n );
assert.eq( 2, explain.nscanned );
// assert.eq( 1, explain.nscannedObjects );
// Two results were scanned for each plan.
// assert.eq( 6, explain.nscannedAllPlans );
// One result was generated by { a:1, b:1 }.  One result was matched by { b:1, a:1 } but it was a
// dup.  Two results were loaded for matching by the unindexed plan.
// assert.eq( 3, explain.nscannedObjectsAllPlans );
