/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.util.ThreadUtil;
import ed.util.Updatable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UpdateManager {
    private static final List<UpdateThing> _thingsToUpdate = Collections.synchronizedList(new ArrayList());
    private static final UpdateThread _thread = new UpdateThread();

    public static void add(Updatable u) {
        _thingsToUpdate.add(new UpdateThing(u));
    }

    static class UpdateThread
    extends Thread {
        UpdateThread() {
            super("UpdateThread");
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            while (true) {
                long now = System.currentTimeMillis();
                try {
                    int max = _thingsToUpdate.size();
                    for (int i = 0; i < _thingsToUpdate.size(); ++i) {
                        UpdateThing ut = (UpdateThing)_thingsToUpdate.get(i);
                        if (ut.dead()) {
                            _thingsToUpdate.remove(i);
                            --i;
                            continue;
                        }
                        if (!ut.needsUpdate(now)) continue;
                        try {
                            ut.update();
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ThreadUtil.sleep(2000L);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UpdateThing
    extends WeakReference<Updatable> {
        long _lastUpdate = System.currentTimeMillis();

        UpdateThing(Updatable u) {
            super(u);
        }

        boolean dead() {
            return this.get() == null;
        }

        boolean needsUpdate(long now) {
            Updatable u = (Updatable)this.get();
            if (u == null) {
                return false;
            }
            return u.timeBeforeUpdates() + this._lastUpdate < now;
        }

        void update() {
            this._lastUpdate = System.currentTimeMillis();
            Updatable u = (Updatable)this.get();
            if (u == null) {
                return;
            }
            u.update();
        }
    }
}

