/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.TestCase;
import ed.util.TextSimpleConfig;
import org.testng.annotations.Test;

public class TextSimpleConfigTest
extends TestCase {
    @Test
    public void test1() {
        String data = "a b\n  c : d \n  e : f \na n\n  o\nr s t\nr s u\n";
        TextSimpleConfig config = TextSimpleConfig.readString("a b\n  c : d \n  e : f \na n\n  o\nr s t\nr s u\n");
        TextSimpleConfigTest.assertEquals(2, config.getTypes().size());
        TextSimpleConfigTest.assertEquals("[a, r]", (Object)config.getTypes().toString());
        TextSimpleConfigTest.assertEquals(2, config.getNames("a").size());
        TextSimpleConfigTest.assertEquals("[b, n]", (Object)config.getNames("a").toString());
        TextSimpleConfigTest.assertEquals(1, config.getNames("r").size());
        TextSimpleConfigTest.assertEquals("[s]", (Object)config.getNames("r").toString());
        TextSimpleConfigTest.assertEquals("{c=d, e=f}", (Object)config.getMap("a", "b"));
        TextSimpleConfigTest.assertEquals("[o]", config.getValues("a", "n"));
        try {
            config.getValues("a", "b");
            assert (false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            config.getMap("a", "n");
            assert (false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TextSimpleConfigTest.assertEquals("[t, u]", config.getValues("r", "s"));
    }

    @Test
    public void testOutput1() {
        String data = "a b\n  c : d \n  e : f \na n\n  o\nr s\n    t\n    u\n";
        String data2 = "a b\n  c : d \n  e : f \na n\n  o\nr s t\nr s u\n";
        TextSimpleConfigTest.assertClose("a b\n  c : d \n  e : f \na n\n  o\nr s\n    t\n    u\n", TextSimpleConfig.readString("a b\n  c : d \n  e : f \na n\n  o\nr s\n    t\n    u\n").outputToString());
        TextSimpleConfigTest.assertClose(TextSimpleConfig.readString("a b\n  c : d \n  e : f \na n\n  o\nr s\n    t\n    u\n").outputToString(), TextSimpleConfig.readString("a b\n  c : d \n  e : f \na n\n  o\nr s t\nr s u\n").outputToString());
    }

    public static void main(String[] args) throws Exception {
        new TextSimpleConfigTest().runConsole();
    }
}

