/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.io.LineReader;
import ed.util.OptionMap;
import ed.util.SimpleConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSimpleConfig
implements SimpleConfig {
    private Map<String, Type> _types = new TreeMap<String, Type>();
    private static final List<String> EMPTY_LIST = Collections.unmodifiableList(new LinkedList());
    private static final OptionMap EMPTY_MAP = new OptionMap();

    public static TextSimpleConfig readString(String s) {
        try {
            return TextSimpleConfig.read(new LineReader(new StringReader(s)));
        }
        catch (IOException ioe) {
            throw new RuntimeException("should be impossible", ioe);
        }
    }

    public static TextSimpleConfig read(File f) throws IOException {
        return TextSimpleConfig.read(new FileInputStream(f));
    }

    public static TextSimpleConfig read(InputStream in) throws IOException {
        return TextSimpleConfig.read(new LineReader(in));
    }

    public static TextSimpleConfig read(LineReader in) throws IOException {
        TextSimpleConfig sc = new TextSimpleConfig();
        String type = null;
        String name = null;
        for (String line : in) {
            if (line.trim().length() == 0) continue;
            if (Character.isWhitespace(line.charAt(0))) {
                int idx = (line = line.trim()).indexOf(": ");
                if (idx < 0) {
                    idx = line.indexOf(" ");
                }
                if (idx < 0) {
                    sc.addValue(type, name, line);
                    continue;
                }
                sc.addEntry(type, name, line.substring(0, idx).trim(), line.substring(idx + 1).trim());
                continue;
            }
            String[] pcs = line.trim().split(" +");
            if (pcs.length < 2 || pcs.length > 3) {
                throw new IllegalArgumentException("invalid base line [" + line + "]");
            }
            type = pcs[0].trim();
            name = pcs[1].trim();
            if (pcs.length != 3) continue;
            sc.addValue(type, name, pcs[2]);
        }
        return sc;
    }

    public static String outputToString(SimpleConfig config) {
        StringBuilder buf = new StringBuilder();
        try {
            TextSimpleConfig.outputToString(config, buf);
        }
        catch (IOException ioe) {
            throw new RuntimeException("should be impossible", ioe);
        }
        return buf.toString();
    }

    public static void outputToString(SimpleConfig config, Appendable out) throws IOException {
        for (String type : config.getTypes()) {
            for (String name : config.getNames(type)) {
                out.append(type).append(" ").append(name);
                if (config.isMap(type, name)) {
                    OptionMap m = config.getMap(type, name);
                    out.append("\n");
                    for (String key : m.keySet()) {
                        out.append("    ").append(key).append(" : ").append((CharSequence)m.get(key)).append("\n");
                    }
                } else if (config.isValue(type, name)) {
                    List<String> values = config.getValues(type, name);
                    if (values.size() == 1) {
                        out.append(" ").append(values.get(0)).append("\n");
                    } else {
                        out.append("\n");
                        for (String value : values) {
                            out.append("    ").append(value).append("\n");
                        }
                    }
                }
                out.append("\n");
            }
        }
    }

    @Override
    public void addEntry(String type, String name, String key, String value) {
        this.getType(type, true).addEntry(name, key, value);
    }

    @Override
    public void addValue(String type, String name, String value) {
        this.getType(type, true).addValue(name, value);
    }

    @Override
    public OptionMap getMap(String type, String name) {
        Type t = this.getType(type, false);
        if (t == null) {
            return EMPTY_MAP;
        }
        return t.getMap(name);
    }

    @Override
    public List<String> getValues(String type, String name) {
        Type t = this.getType(type, false);
        if (t == null) {
            return EMPTY_LIST;
        }
        return t.getValues(name);
    }

    @Override
    public List<String> getTypes() {
        ArrayList<String> l = new ArrayList<String>(this._types.keySet());
        Collections.sort(l);
        return l;
    }

    @Override
    public List<String> getNames(String type) {
        Type t = this.getType(type, false);
        if (t == null) {
            return EMPTY_LIST;
        }
        ArrayList<String> l = new ArrayList<String>(t.keySet());
        Collections.sort(l);
        return l;
    }

    @Override
    public boolean isMap(String type, String name) {
        Type t = this.getType(type, false);
        if (t == null) {
            return false;
        }
        return t.isMap(name);
    }

    @Override
    public boolean isValue(String type, String name) {
        Type t = this.getType(type, false);
        if (t == null) {
            return false;
        }
        return t.isValue(name);
    }

    public String outputToString() {
        return TextSimpleConfig.outputToString(this);
    }

    public String toString() {
        return TextSimpleConfig.outputToString(this);
    }

    Type getType(String type, boolean create) {
        Type t = this._types.get(type);
        if (t != null || !create) {
            return t;
        }
        t = new Type(type);
        this._types.put(type, t);
        return t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Type
    extends TreeMap<String, Object> {
        final String _type;

        Type(String type) {
            this._type = type;
        }

        OptionMap getMap(String name) {
            Object foo = this.get(name);
            if (foo == null) {
                return EMPTY_MAP;
            }
            if (foo instanceof Map) {
                return (OptionMap)foo;
            }
            throw new RuntimeException(this._type + "." + name + " is not a map");
        }

        List<String> getValues(String name) {
            Object foo = this.get(name);
            if (foo == null) {
                return EMPTY_LIST;
            }
            if (foo instanceof List) {
                return (List)foo;
            }
            throw new RuntimeException(this._type + "." + name + " is not a list");
        }

        boolean isMap(String name) {
            return this.get(name) instanceof Map;
        }

        boolean isValue(String name) {
            return this.get(name) instanceof List;
        }

        void addEntry(String name, String key, String value) {
            Object foo = this.get(name);
            if (foo != null && !(foo instanceof Map)) {
                throw new IllegalArgumentException(this._type + "." + name + " not in map mode");
            }
            if (foo == null) {
                foo = new OptionMap();
                this.put(name, foo);
            }
            ((Map)foo).put(key, value);
        }

        void addValue(String name, String value) {
            Object foo = this.get(name);
            if (foo != null && !(foo instanceof List)) {
                throw new IllegalArgumentException(this._type + "." + name + " not in value mode");
            }
            if (foo == null) {
                foo = new ArrayList();
                this.put(name, foo);
            }
            ((List)foo).add(value);
        }
    }
}

