/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.TestCase;
import ed.util.SimplePool;
import org.testng.annotations.Test;

public class SimplePoolTest
extends TestCase {
    @Test
    public void testBasic1() {
        MyPool p = new MyPool(10, 10);
        int a = (Integer)p.get();
        SimplePoolTest.assertEquals(0, a);
        int b = (Integer)p.get();
        SimplePoolTest.assertEquals(1, b);
        p.done(a);
        a = (Integer)p.get();
        SimplePoolTest.assertEquals(0, a);
    }

    @Test
    public void testBasic2() {
        MyPool p = new MyPool(0, 0);
        int a = (Integer)p.get();
        SimplePoolTest.assertEquals(0, a);
        int b = (Integer)p.get();
        SimplePoolTest.assertEquals(1, b);
        p.done(a);
        a = (Integer)p.get();
        SimplePoolTest.assertEquals(2, a);
    }

    @Test
    public void testMax1() {
        MyPool p = new MyPool(10, 2);
        int a = (Integer)p.get();
        SimplePoolTest.assertEquals(0, a);
        int b = (Integer)p.get();
        SimplePoolTest.assertEquals(1, b);
        SimplePoolTest.assertNull(p.get(0L));
    }

    @Test
    public void testMax2() {
        MyPool p = new MyPool(10, 3);
        int a = (Integer)p.get();
        SimplePoolTest.assertEquals(0, a);
        int b = (Integer)p.get();
        SimplePoolTest.assertEquals(1, b);
        SimplePoolTest.assertEquals(2, (Integer)p.get(-1L));
    }

    @Test
    public void testMax3() {
        MyPool p = new MyPool(10, 3);
        int a = (Integer)p.get();
        SimplePoolTest.assertEquals(0, a);
        int b = (Integer)p.get();
        SimplePoolTest.assertEquals(1, b);
        SimplePoolTest.assertEquals(2, (Integer)p.get(1L));
    }

    public static void main(String[] args) {
        SimplePoolTest t = new SimplePoolTest();
        t.runConsole();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyPool
    extends SimplePool<Integer> {
        int _num;

        MyPool(int maxToKeep, int maxTotal) {
            super("blah", maxToKeep, maxTotal);
            this._num = 0;
        }

        @Override
        public Integer createNew() {
            return this._num++;
        }
    }
}

