/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.js.JSObjectSize;
import ed.util.SeenPath;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V> {
    static final boolean D = false;
    final long _defaultCacheTime;
    final int _maxSize;
    final Map<K, Entry> _cache = new LinkedHashMap<K, Entry>(){
        static final long serialVersionUID = -1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, Entry> eldest) {
            if (LRUCache.this._maxSize > 0 && this.size() > LRUCache.this._maxSize) {
                return true;
            }
            return !eldest.getValue().valid();
        }
    };

    public LRUCache(long defaultCacheTime) {
        this(defaultCacheTime, -1);
    }

    public LRUCache(long defaultCacheTime, int maxSize) {
        this._defaultCacheTime = defaultCacheTime;
        this._maxSize = maxSize;
    }

    public void put(K k, V v) {
        this.put(k, v, this._defaultCacheTime);
    }

    public void put(K k, V v, long cacheTime) {
        this._cache.put(k, new Entry(v, cacheTime));
    }

    public V get(K k, long cacheTime) {
        Entry e = this._cache.get(k);
        if (e == null) {
            return null;
        }
        if (!e.valid(cacheTime)) {
            this._cache.remove(k);
            return null;
        }
        return e._v;
    }

    public V get(K k) {
        Entry e = this._cache.get(k);
        if (e == null) {
            return null;
        }
        if (!e.valid()) {
            this._cache.remove(k);
            return null;
        }
        return e._v;
    }

    public int size() {
        return this._cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long approxSize(SeenPath seen) {
        long s = 0L;
        Map<K, Entry> map = this._cache;
        synchronized (map) {
            for (Map.Entry<K, Entry> e : this._cache.entrySet()) {
                s += JSObjectSize.size(e.getKey(), (SeenPath)seen, (Object)this);
                s += JSObjectSize.size((Object)e.getValue(), (SeenPath)seen, (Object)this);
            }
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Entry {
        final V _v;
        final long _cacheTime;
        final long _expireTime;
        final long _createTime = System.currentTimeMillis();

        Entry(V v, long cacheTime) {
            this._v = v;
            this._cacheTime = cacheTime;
            this._expireTime = this._createTime + this._cacheTime;
        }

        boolean valid(long cacheTime) {
            return this.valid() && this._createTime + cacheTime > System.currentTimeMillis();
        }

        boolean valid() {
            return this._expireTime > System.currentTimeMillis();
        }
    }
}

