/*
 * Decompiled with CFR 0.152.
 */
package ed.util;

import ed.TestCase;
import ed.util.FastStringMap;
import ed.util.MemUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.testng.annotations.Test;

public class FastStringMapTest
extends TestCase {
    @Test(groups={"basic"})
    public void testBasic() {
        FastStringMap m = new FastStringMap();
        m.put("a", (Object)5);
        FastStringMapTest.assertEquals((Object)5, m.get("a"));
        FastStringMapTest.assertTrue(m.containsKey("a"));
        FastStringMapTest.assertFalse(m.containsKey("b"));
        FastStringMapTest.assertEquals(1, m.keySet().size());
        FastStringMapTest.assertTrue(m.keySet().contains("a"));
        FastStringMapTest.assertEquals(1, m.size());
        m.put("b", (Object)6);
        FastStringMapTest.assertEquals((Object)6, m.get("b"));
        FastStringMapTest.assertEquals((Object)5, m.get("a"));
        FastStringMapTest.assertEquals(2, m.keySet().size());
        FastStringMapTest.assertEquals(2, m.size());
        FastStringMapTest.assertTrue(m.containsKey("a"));
        FastStringMapTest.assertTrue(m.containsKey("b"));
        FastStringMapTest.assertFalse(m.containsKey("c"));
        FastStringMapTest.assertEquals((Object)6, m.put("b", (Object)7));
        FastStringMapTest.assertEquals((Object)7, m.get("b"));
        FastStringMapTest.assertEquals(2, m.keySet().size());
        FastStringMapTest.assertTrue(m.keySet().contains("a"));
        FastStringMapTest.assertTrue(m.keySet().contains("b"));
        FastStringMapTest.assertFalse(m.keySet().contains("c"));
    }

    @Test(groups={"basic"})
    public void testRemove() {
        FastStringMap m = new FastStringMap();
        m.put("a", (Object)5);
        FastStringMapTest.assertEquals((Object)5, m.get("a"));
        FastStringMapTest.assertTrue(m.containsKey("a"));
        FastStringMapTest.assertFalse(m.containsKey("b"));
        FastStringMapTest.assertEquals(1, m.keySet().size());
        FastStringMapTest.assertTrue(m.keySet().contains("a"));
        FastStringMapTest.assertEquals(1, m.size());
        m.remove("a");
        FastStringMapTest.assertNull(m.get("a"));
        FastStringMapTest.assertFalse(m.containsKey("a"));
        FastStringMapTest.assertFalse(m.keySet().contains("a"));
        FastStringMapTest.assertEquals(0, m.size());
        m.put("a", (Object)5);
        FastStringMapTest.assertEquals((Object)5, m.get("a"));
        FastStringMapTest.assertTrue(m.containsKey("a"));
        FastStringMapTest.assertFalse(m.containsKey("b"));
        FastStringMapTest.assertEquals(1, m.keySet().size());
        FastStringMapTest.assertTrue(m.keySet().contains("a"));
        FastStringMapTest.assertEquals(1, m.size());
    }

    @Test(groups={"basic"})
    public void testMedSize() {
        int i;
        FastStringMap m = new FastStringMap();
        for (i = 0; i < 100; ++i) {
            m.put(String.valueOf(i), (Object)String.valueOf(i + 1000));
        }
        for (i = 0; i < 100; ++i) {
            FastStringMapTest.assertEquals(String.valueOf(i + 1000), m.get(String.valueOf(i)));
            FastStringMapTest.assertTrue(m.containsKey(String.valueOf(i)));
            FastStringMapTest.assertTrue(m.keySet().contains(String.valueOf(i)));
        }
    }

    public void testSize1() {
        this._testSize(1000);
    }

    public void testSize2() {
        this._testSize(10000);
    }

    public void testSize3() {
        this._testSize(100000);
    }

    public void testSize4() {
        this._testSize(500000);
    }

    private void _testSize(int num) {
        System.gc();
        System.gc();
        System.gc();
        long before = MemUtil.bytesAvailable();
        long start = System.currentTimeMillis();
        Map<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < num; ++i) {
            m.put(String.valueOf(Math.random()), "asdsad");
        }
        long javaTime = System.currentTimeMillis() - start;
        long javaSize = before - MemUtil.bytesAvailable();
        m = new FastStringMap();
        System.gc();
        System.gc();
        System.gc();
        before = MemUtil.bytesAvailable();
        start = System.currentTimeMillis();
        for (int i = 0; i < num; ++i) {
            m.put(String.valueOf(Math.random()), "asdsad");
        }
        long ourTime = System.currentTimeMillis() - start;
        long ourSize = before - MemUtil.bytesAvailable();
        FastStringMapTest.assertLess((double)ourSize, (double)javaSize * 1.5);
        FastStringMapTest.assertLess((double)ourTime, (double)javaTime * 1.5);
    }

    @Test(groups={"basic"})
    public void testPutAll() {
        FastStringMap m = new FastStringMap();
        m.put("a", (Object)5);
        FastStringMapTest.assertEquals((Object)5, m.get("a"));
        HashMap<String, Integer> other = new HashMap<String, Integer>();
        other.put("b", 6);
        m.putAll((Map<? extends String, ? extends Object>)other);
        FastStringMapTest.assertEquals((Object)5, m.get("a"));
        FastStringMapTest.assertEquals((Object)6, m.get("b"));
        FastStringMapTest.assertEquals(2, m.size());
    }

    @Test(groups={"basic"})
    public void testRandom() {
        Random r = new Random(123123L);
        this.rand(r, 10, 10);
        this.rand(r, 10, 100);
        this.rand(r, 100, 1000);
        this.rand(r, 100, 10000);
        this.rand(r, 100, 100000);
        this.rand(r, 10000, 10);
        this.rand(r, 1000, 10000);
        this.rand(r, 1000, 50000);
    }

    void rand(Random r, int space, int time) {
        HashMap<String, String> m = new HashMap<String, String>();
        FastStringMap f = new FastStringMap();
        for (int i = 0; i < time; ++i) {
            FastStringMapTest.assertEquals(m.size(), f.size());
            String what = String.valueOf(r.nextInt(space));
            switch (r.nextInt(2)) {
                case 0: {
                    FastStringMapTest.assertEquals(m.get(what), f.get(what));
                    f.put(what, (Object)what);
                    m.put(what, what);
                    FastStringMapTest.assertEquals(m.get(what), f.get(what));
                    break;
                }
                case 1: {
                    f.remove(what);
                    m.remove(what);
                    FastStringMapTest.assertEquals(m.get(what), f.get(what));
                }
            }
            for (String s : m.keySet()) {
                FastStringMapTest.assertEquals(m.get(s), f.get(s));
            }
        }
        FastStringMapTest.assertEquals(m.keySet().size(), f.keySet().size());
        FastStringMapTest.assertEquals(m.size(), f.size());
        for (String s : m.keySet()) {
            FastStringMapTest.assertEquals(m.get(s), f.get(s));
        }
    }

    public static void main(String[] args) {
        new FastStringMapTest().runConsole();
    }
}

