/*
 * Decompiled with CFR 0.152.
 */
package ed.log;

import ed.js.JSArray;
import ed.js.JSDate;
import ed.js.JSException;
import ed.js.JSFunction;
import ed.js.JSObjectSize;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls2;
import ed.lang.StackTraceHolder;
import ed.log.Appender;
import ed.log.ConsoleAppender;
import ed.log.Event;
import ed.log.InMemoryAppender;
import ed.log.Level;
import ed.util.SeenPath;
import ed.util.Sizable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Logger
extends JSFunctionCalls2 {
    private static final ThreadLocal<Appender> _tlAppender = new ThreadLocal();
    final Logger _parent;
    final String _name;
    final String _fullName;
    private boolean _inherit = true;
    private JSDate _sentEmail;
    List<Appender> _appenders;
    Level _level = null;
    final Map<Level, JSFunction> _levelLoggers = Collections.synchronizedMap(new TreeMap());
    static final ThreadLocal<Logger> _tl = new ThreadLocal();
    private static final Map<String, Logger> _fullNameToLogger = Collections.synchronizedMap(new HashMap());
    private static final List<Appender> _defaultAppenders;

    public static Logger getLogger(Class c) {
        return Logger.getLogger(c.getName());
    }

    public static Logger getLogger(String fullName) {
        Logger l = _fullNameToLogger.get(fullName);
        if (l != null) {
            return l;
        }
        String base = fullName;
        int idx = fullName.indexOf(".");
        if (idx > 0) {
            base = fullName.substring(0, idx);
        }
        if ((l = _fullNameToLogger.get(base)) == null) {
            l = new Logger(null, base);
        }
        String[] pcs = fullName.split("\\.");
        for (int i = 1; i < pcs.length; ++i) {
            l = (Logger)((Object)l.get(pcs[i]));
        }
        _fullNameToLogger.put(fullName, l);
        return l;
    }

    public static Logger getRoot() {
        Logger l = Logger.getThreadLocalRoot();
        return l == null ? Logger.getLogger("noroot") : l;
    }

    public static Logger getThreadLocalRoot() {
        return _tl.get();
    }

    public static void setThreadLocalAppender(Appender a) {
        _tlAppender.set(a);
    }

    public Logger(Logger parent, String name) {
        this(parent, name, true);
    }

    public Logger(Logger parent, String name, boolean cache) {
        this._parent = parent;
        this._name = name;
        this._fullName = this._parent == null ? name : this._parent._fullName + "." + this._name;
        this._sentEmail = new JSDate(0L);
        if (cache && !this._fullName.contains(".")) {
            _fullNameToLogger.put(this._fullName, this);
        }
        if (this._parent == null) {
            this._appenders = new ArrayList<Appender>(_defaultAppenders);
        }
        if (this._parent == null) {
            this._level = Level.DEBUG;
        }
    }

    public void makeThreadLocal() {
        _tl.set(this);
    }

    public void debug(int debugLevel, Object o1, Object o2) {
        this.debug(debugLevel, o1, o2, null, null, null);
    }

    public void debug(int debugLevel, Object o1, Object o2, Object o3) {
        this.debug(debugLevel, o1, o2, o3, null, null);
    }

    public void debug(int debugLevel, Object o1, Object o2, Object o3, Object o4) {
        this.debug(debugLevel, o1, o2, o3, o4, null);
    }

    public void debug(int debugLevel, Object o1, Object o2, Object o3, Object o4, Object o5) {
        Level l = Level.forDebugId(debugLevel);
        if (!this.shouldLog(l)) {
            return;
        }
        StringBuilder buf = new StringBuilder(o1.toString());
        if (o2 != null) {
            buf.append(" [").append(o2).append("] ");
        }
        if (o3 != null) {
            buf.append(" [").append(o3).append("] ");
        }
        if (o4 != null) {
            buf.append(" [").append(o4).append("] ");
        }
        if (o5 != null) {
            buf.append(" [").append(o5).append("] ");
        }
        this.log(l, buf);
    }

    public void debug(int debugLevel, Object msg) {
        this.log(Level.forDebugId(debugLevel), msg);
    }

    public void debug(Object msg) {
        this.log(Level.DEBUG, msg, null);
    }

    public void debug(Object msg, Throwable t) {
        this.log(Level.DEBUG, msg, t);
    }

    public void info(Object msg) {
        this.log(Level.INFO, msg, null);
    }

    public void info(Object msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    public void warn(Object msg) {
        this.log(Level.WARN, msg, null);
    }

    public void warn(Object msg, Throwable t) {
        this.log(Level.WARN, msg, t);
    }

    public void error(Object msg) {
        this.log(Level.ERROR, msg, null);
    }

    public void error(Object msg, Throwable t) {
        this.log(Level.ERROR, msg, t);
    }

    public void alert(Object msg) {
        this.log(Level.ALERT, msg, null);
    }

    public void alert(Object msg, Throwable t) {
        this.log(Level.ALERT, msg, t);
    }

    public void fatal(Object msg) {
        this.log(Level.FATAL, msg, null);
    }

    public void fatal(Object msg, Throwable t) {
        this.log(Level.FATAL, msg, t);
    }

    public Object call(Scope s, Object oName, Object oT, Object[] foo) {
        this.log(Level.INFO, oName != null ? oName.toString() : "null", this._makeThrowable(oT));
        return null;
    }

    public Logger getChild(String s) {
        return (Logger)((Object)this.get(s));
    }

    public Object get(Object n) {
        String s = n.toString();
        if (s.equals("log")) {
            return null;
        }
        if (s.equals("debug") || s.equals("info") || s.equals("error") || s.equals("alert") || s.equals("fatal")) {
            return this._getLevelLogger(s);
        }
        if (s.equals("LEVEL")) {
            return Level.me;
        }
        if (s.equals("level")) {
            return this._level;
        }
        Object foo = super.get(n);
        if (foo != null) {
            return foo;
        }
        if (s.equals("appenders")) {
            if (this._appenders == null) {
                this._appenders = new ArrayList<Appender>();
            }
            JSArray a = JSArray.wrap((ArrayList)((ArrayList)this._appenders));
            super.set((Object)"appenders", (Object)a);
            return a;
        }
        Logger child = new Logger(this, s);
        this.set(s, (Object)child);
        return child;
    }

    public Object set(Object n, Object v) {
        String s = n.toString();
        if (s.equals("level")) {
            this._level = (Level)((Object)v);
            return this._level;
        }
        if (s.equals("appenders")) {
            throw new RuntimeException("can't change");
        }
        return super.set(n, v);
    }

    JSFunction _getLevelLogger(String levelName) {
        final Level level = Level.forName(levelName);
        if (level == null) {
            throw new RuntimeException("don't know about level [" + levelName + "]");
        }
        Object f = this._levelLoggers.get((Object)level);
        if (f == null) {
            f = new JSFunctionCalls2(){

                public Object call(Scope s, Object msgObject, Object excObject, Object[] extra) {
                    if (msgObject == null) {
                        msgObject = "null";
                    }
                    Logger.this.log(level, msgObject.toString(), Logger.this._makeThrowable(excObject));
                    return true;
                }

                public Object get(Object n) {
                    if (n.toString().equals("__puts__") || n.toString().equals("puts") || n.toString().equals("print")) {
                        return this;
                    }
                    return super.get(n);
                }
            };
            this._levelLoggers.put(level, (JSFunction)f);
        }
        return f;
    }

    public Level getEffectiveLevel() {
        if (this._level != null) {
            return this._level;
        }
        Logger t = this._parent;
        while (t != null) {
            if (t._level != null) {
                return t._level;
            }
            t = t._parent;
        }
        return Level.DEBUG;
    }

    public boolean shouldLog(Level l) {
        Level eLevel = this.getEffectiveLevel();
        return eLevel.compareTo(l) <= 0;
    }

    public void log(Level level, Object msg) {
        this.log(level, msg, null);
    }

    public void log(Level level, Object msgObject, Throwable throwable) {
        if (!this.shouldLog(level)) {
            return;
        }
        String msg = msgObject == null ? null : msgObject.toString();
        try {
            StackTraceHolder.getInstance().fix(throwable);
        }
        catch (Throwable t) {
            System.err.println("couldn't fix stack trace");
            t.printStackTrace();
        }
        Event e = new Event(this._fullName, new JSDate(), level, msg, throwable, Thread.currentThread());
        Appender tl = _tlAppender.get();
        if (tl != null) {
            try {
                tl.append(e);
            }
            catch (Throwable t) {
                System.err.println("error running tl appender");
                t.printStackTrace();
            }
        }
        Logger l = this;
        while (l != null) {
            if (l._appenders != null) {
                for (int i = 0; i < l._appenders.size(); ++i) {
                    try {
                        l._appenders.get(i).append(e);
                        continue;
                    }
                    catch (Throwable t) {
                        System.err.println("error running appender");
                        try {
                            StackTraceHolder.getInstance().fix(t);
                        }
                        catch (Throwable tt) {
                            tt.printStackTrace();
                        }
                        t.printStackTrace();
                    }
                }
            }
            if (!l._inherit) break;
            l = l._parent;
        }
    }

    public void addAppender(Appender a) {
        if (this._appenders == null) {
            this._appenders = new ArrayList<Appender>();
        }
        this._appenders.add(a);
    }

    public void setLevel(Level l) {
        this._level = l;
    }

    public void setInherit(boolean inherit) {
        this._inherit = inherit;
    }

    public boolean inherits() {
        return this._inherit;
    }

    public String _getName() {
        return this.getFullName();
    }

    public String getFullName() {
        return this._fullName;
    }

    public String toString() {
        return "Logger:" + this._fullName;
    }

    Throwable _makeThrowable(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Throwable) {
            return (Throwable)o;
        }
        JSException e = new JSException(o);
        e.fillInStackTrace();
        return e;
    }

    public long approxSize(SeenPath seen) {
        seen.visited((Object)this);
        long size = super.approxSize(seen);
        size += JSObjectSize.size(this._appenders, (SeenPath)seen, (Object)((Object)this));
        return size += JSObjectSize.size(this._levelLoggers, (SeenPath)seen, (Object)((Object)this));
    }

    static {
        ArrayList<Sizable> lst = new ArrayList<Sizable>();
        lst.add(new ConsoleAppender());
        lst.add(InMemoryAppender.getInstance());
        _defaultAppenders = Collections.unmodifiableList(lst);
    }
}

