/*
 * Decompiled with CFR 0.152.
 */
package ed.log;

import ed.js.JSObject;
import ed.js.JSObjectBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Level {
    DEBUG_7,
    DEBUG_6,
    DEBUG_5,
    DEBUG_4,
    DEBUG_3,
    DEBUG_2,
    DEBUG_1,
    DEBUG,
    INFO,
    WARN,
    ERROR,
    ALERT,
    FATAL;

    static final JSObject me;
    static final Level[] LEVELS;
    static final int DEBUG_LEVELS;

    public static Level forDebugId(int id) {
        int idx = -1 * id + DEBUG_LEVELS;
        if (idx < 0) {
            idx = 0;
        }
        if (idx >= LEVELS.length) {
            idx = LEVELS.length - 1;
        }
        return LEVELS[idx];
    }

    public static Level forId(int id) {
        return LEVELS[id + DEBUG_LEVELS];
    }

    public static Level forName(String name) {
        if (name.equalsIgnoreCase("debug")) {
            return DEBUG;
        }
        if (name.equalsIgnoreCase("info")) {
            return INFO;
        }
        if (name.equalsIgnoreCase("warn")) {
            return WARN;
        }
        if (name.equalsIgnoreCase("error")) {
            return ERROR;
        }
        if (name.equalsIgnoreCase("alert")) {
            return ALERT;
        }
        if (name.equalsIgnoreCase("fatal")) {
            return FATAL;
        }
        throw new RuntimeException("unknown level : " + name);
    }

    static {
        me = new JSObjectBase();
        me.set((Object)"DEBUG", (Object)DEBUG);
        me.set((Object)"INFO", (Object)INFO);
        me.set((Object)"WARN", (Object)WARN);
        me.set((Object)"ERROR", (Object)ERROR);
        me.set((Object)"ALERT", (Object)ALERT);
        me.set((Object)"FATAL", (Object)FATAL);
        me.set((Object)"ALL", (Object)DEBUG);
        LEVELS = Level.values();
        int debug = 0;
        for (int i = 0; i < LEVELS.length; ++i) {
            if (!LEVELS[i].name().equalsIgnoreCase("info")) continue;
            debug = i;
        }
        DEBUG_LEVELS = debug;
    }
}

