/*
 * Decompiled with CFR 0.152.
 */
package ed.lang;

import ed.util.IdentitySet;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

public interface ReflectionVisitor {
    public boolean visit(Object var1, Class var2);

    public boolean follow(Object var1, Class var2, Field var3);

    public static class ShortestPathFinder
    extends Reachable {
        final Object[] _toFind;

        ShortestPathFinder(Object ... toFind) {
            super(false);
            this._toFind = toFind;
        }

        public boolean visit(Object o, Class c) {
            for (int i = 0; i < this._toFind.length; ++i) {
                if (o != this._toFind[i]) continue;
                throw new RuntimeException("yay!");
            }
            return super.visit(o, c);
        }
    }

    public static class Reachable
    implements ReflectionVisitor {
        final boolean _followWeakRefs;
        final IdentitySet _seen = new IdentitySet();
        final Set<Class> _seenClasses = new HashSet<Class>();
        final Set<Class> _stoppers = new HashSet<Class>();

        public Reachable() {
            this(false);
        }

        public Reachable(boolean followWeakRefs) {
            this._followWeakRefs = followWeakRefs;
        }

        public boolean visit(Object o, Class c) {
            if (this._seen.contains(o)) {
                return false;
            }
            this._seen.add(o);
            if (!this._seenClasses.contains(c)) {
                this._seenClasses.add(c);
            }
            return true;
        }

        public boolean follow(Object o, Class c, Field f) {
            if (o instanceof Number || o instanceof Boolean || o instanceof String || o instanceof Byte || o instanceof Class || o instanceof ClassLoader || o instanceof Character) {
                return false;
            }
            if (!this._followWeakRefs && o instanceof WeakReference) {
                return false;
            }
            return !this._stoppers.contains(c);
        }

        public int seenSize() {
            return this._seen.size();
        }

        public void addStopper(Class c) {
            this._stoppers.add(c);
        }
    }
}

