/*
 * Decompiled with CFR 0.152.
 */
package ed.lang;

import ed.lang.StackTraceFixer;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicLineNumberMapper
implements StackTraceFixer {
    final String _source;
    final String _generated;
    final Map<Integer, Integer> _mapping;

    public BasicLineNumberMapper(String source, String generated, Map<Integer, Integer> mapping) {
        this._source = source;
        this._generated = generated;
        this._mapping = mapping;
    }

    @Override
    public StackTraceElement fixSTElement(StackTraceElement element) {
        if (element == null || this._mapping == null) {
            return element;
        }
        if (!element.getClassName().equals(this._generated) && !element.getFileName().equals(this._generated)) {
            return element;
        }
        Integer line = this._mapping.get(element.getLineNumber());
        if (line == null) {
            return element;
        }
        return new StackTraceElement(this._source, "___", this._source, line);
    }

    @Override
    public boolean removeSTElement(StackTraceElement element) {
        return false;
    }

    public String toString() {
        String s = "{" + this._source + " -> " + this._generated + " ";
        if (this._mapping instanceof TreeMap && this._mapping.size() > 0) {
            TreeMap tm = (TreeMap)this._mapping;
            s = s + tm.firstKey() + " -> " + tm.lastKey();
        }
        s = s + " }";
        return s;
    }
}

