/*
 * Decompiled with CFR 0.152.
 */
package ed.io;

import ed.io.ByteBufferFactory;
import ed.io.ByteBufferInputStream;
import ed.io.ByteBufferOutputStream;
import ed.io.StreamUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipUtil {
    public static List<ByteBuffer> gzip(List<ByteBuffer> in, ByteBufferFactory factory) {
        if (in == null || in.size() == 0) {
            throw new IllegalArgumentException("no data");
        }
        try {
            ByteBufferOutputStream bout = new ByteBufferOutputStream(factory);
            GZIPOutputStream gout = new GZIPOutputStream(bout);
            if (in.get(0).hasArray()) {
                for (ByteBuffer buf : in) {
                    bout.write(buf.array());
                }
            } else {
                ByteBufferInputStream bin = new ByteBufferInputStream(in, false);
                StreamUtil.pipe(bin, gout);
            }
            gout.flush();
            gout.close();
            return bout.getBuffers(true);
        }
        catch (IOException ioe) {
            throw new RuntimeException("should be impossible", ioe);
        }
    }
}

