/*
 * Decompiled with CFR 0.152.
 */
package ed.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class StreamUtil {
    public static String[] execSafe(String command) {
        try {
            return StreamUtil.exec(command);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String[] exec(String command) throws IOException {
        Process p = Runtime.getRuntime().exec(command);
        String out = StreamUtil.readFully(p.getInputStream());
        String err = StreamUtil.readFully(p.getErrorStream());
        p.destroy();
        return new String[]{out, err};
    }

    public static String readFully(File f) throws IOException {
        return StreamUtil.readFully(f, "utf8");
    }

    public static String readFully(File f, String encoding) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        String s = StreamUtil.readFully(fin, encoding);
        fin.close();
        return s;
    }

    public static String readFully(InputStream is) throws IOException {
        return StreamUtil.readFully(is, null);
    }

    public static String readFully(InputStream is, String encoding) throws IOException {
        return StreamUtil.readFully(encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, encoding));
    }

    public static String readFully(InputStreamReader isr) throws IOException {
        return StreamUtil.readFully(new BufferedReader(isr));
    }

    public static String readFully(BufferedReader br) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        while ((line = br.readLine()) != null) {
            buf.append(line);
            buf.append('\n');
        }
        return buf.toString();
    }

    public static byte[] readBytesFully(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtil.pipe(is, baos);
        return baos.toByteArray();
    }

    public static int pipe(InputStream is, OutputStream out) throws IOException {
        return StreamUtil.pipe(is, out, -1);
    }

    public static int pipe(InputStream is, OutputStream out, int maxSize) throws IOException {
        byte[] buf = new byte[4096];
        int len = -1;
        int total = 0;
        while ((len = is.read(buf)) != -1) {
            out.write(buf, 0, len);
            if (maxSize <= 0 || (total += len) <= maxSize) continue;
            throw new IOException("too big");
        }
        return total;
    }

    public static int send(byte[] b, OutputStream out) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        return StreamUtil.pipe(in, out);
    }

    public static byte readByte(InputStream in) throws IOException {
        int b = in.read();
        if (b < 0) {
            throw new IOException("end of stream");
        }
        return (byte)(b & 0xFF);
    }

    public static char readChar(InputStream in) throws IOException {
        return (char)StreamUtil.readByte(in);
    }
}

