/*
 * Decompiled with CFR 0.152.
 */
package ed.io;

import ed.io.SysExec;
import ed.log.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class RollingNamedPipe {
    private static final String _namedDir = "logs/pipes/";
    final File _path;
    final boolean _require;
    final int _queueSize;
    final boolean _fake;
    final MyWriter _writer;
    final BlockingQueue<byte[]> _buffer;
    private byte[] _messageDivider = "\n------\n\n".getBytes();
    private static Logger _logger;

    public RollingNamedPipe(String name) {
        this(_namedDir + name, 5, false);
    }

    public RollingNamedPipe(String path, int queueSize, boolean require) {
        this(new File(path), queueSize, require);
    }

    public RollingNamedPipe(File path, int queueSize, boolean require) {
        this._path = path;
        this._queueSize = queueSize;
        this._require = require;
        boolean fake = true;
        if (this._path.exists()) {
            fake = false;
        } else {
            SysExec.Result res = null;
            Exception error = null;
            try {
                res = SysExec.exec("mkfifo " + path.toString());
                fake = res.exitValue() != 0;
            }
            catch (Exception ioe) {
                fake = true;
                error = ioe;
            }
            if (fake && require) {
                throw new RuntimeException("can't make named pipe : " + this._path, error);
            }
        }
        this._fake = fake;
        this._buffer = new ArrayBlockingQueue<byte[]>(queueSize);
        this._writer = this._fake ? null : new MyWriter();
    }

    public boolean canWrite() {
        return !this._fake && this._buffer.size() < this._queueSize;
    }

    public boolean write(String s) {
        if (this._fake) {
            return false;
        }
        if (this._buffer.size() >= this._queueSize) {
            return false;
        }
        return this._buffer.offer(s.getBytes());
    }

    public void setMessageDivider(String s) {
        this._messageDivider = s.getBytes();
    }

    static /* synthetic */ byte[] access$000(RollingNamedPipe x0) {
        return x0._messageDivider;
    }

    static /* synthetic */ Logger access$100() {
        return _logger;
    }

    static {
        File f = new File(_namedDir);
        f.mkdirs();
        _logger = Logger.getLogger("ed.RollingNamedPipe");
    }

    class MyWriter
    extends Thread {
        MyWriter() {
            super("NamedPipe-Writer : " + RollingNamedPipe.this._path);
            this.setDaemon(true);
            this.start();
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            while (true) {
                try {
                    block4: while (true) {
                        if ((b = RollingNamedPipe.this._buffer.take()) == null) {
                            continue;
                        }
                        start = System.currentTimeMillis();
                        out = new FileOutputStream(RollingNamedPipe.this._path);
                        out.write(b);
                        out.write(RollingNamedPipe.access$000(RollingNamedPipe.this));
                        out.close();
                        end = System.currentTimeMillis();
                        if (end - start <= 60000L) continue;
                        while (true) {
                            if (RollingNamedPipe.this._buffer.poll() != null) ** break;
                            continue block4;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    continue;
                }
                catch (Exception e) {
                    RollingNamedPipe.access$100().error("error running", e);
                    continue;
                }
                break;
            }
        }
    }
}

