/*
 * Decompiled with CFR 0.152.
 */
package ed.io;

import ed.TestCase;
import ed.io.ByteBufferInputStream;
import ed.io.ByteBufferOutputStream;
import ed.io.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.testng.annotations.Test;

public class ByteBufferStreamTest
extends TestCase {
    static final Random _rand = new Random(123123L);

    @Test(groups={"basic"})
    public void test1() throws IOException {
        this._testInOut(16, 128);
        this._testInOut(16, 4);
        this._testInOut(1024, 128);
        this._testInOut(1024, 2048);
    }

    private void _testInOut(int dataSize, int bufSize) throws IOException {
        String s = this._getData(dataSize);
        byte[] bytes = s.getBytes();
        ByteBufferOutputStream bout = new ByteBufferOutputStream(bufSize);
        bout.write(bytes);
        ByteBufferStreamTest.assertEquals((int)Math.ceil((double)bytes.length / (double)bufSize), bout.getBuffers().size());
        ByteBufferInputStream bin = new ByteBufferInputStream(bout.getBuffers(), true);
        String out = new String(StreamUtil.readBytesFully(bin));
        ByteBufferStreamTest.assertEquals(s, (Object)out);
    }

    @Test(groups={"basic"})
    public void testplay() throws IOException {
        this._testplay(16, 128);
        this._testplay(16, 4);
        this._testplay(1024, 128);
        this._testplay(1024, 2048);
        this._testplay(20000, 200);
    }

    private void _testplay(int dataSize, int bufSize) throws IOException {
        String s = this._getData(dataSize);
        byte[] bytes = s.getBytes();
        ByteBufferOutputStream bout = new ByteBufferOutputStream(bufSize);
        bout.write(bytes);
        ByteBufferStreamTest.assertEquals((int)Math.ceil((double)bytes.length / (double)bufSize), bout.getBuffers().size());
        ByteBufferInputStream bin = new ByteBufferInputStream(bout.getBuffers(), true);
        ByteArrayInputStream arr = new ByteArrayInputStream(bytes);
        ByteBufferStreamTest.assertEquals(bin.available(), arr.available());
        while (arr.available() > 0) {
            ByteBufferStreamTest.assertEquals(bin.available(), arr.available());
            ByteBufferStreamTest.assertEquals(bin.read(), arr.read());
            ByteBufferStreamTest.assertEquals(bin.read(new byte[12]), arr.read(new byte[12]));
        }
        ByteBufferStreamTest.assertEquals(bin.available(), arr.available());
    }

    @Test(groups={"basic"})
    public void testZip1() throws IOException {
        this._testZip(128, 2048);
        this._testZip(1024, 128);
    }

    void _testZip(int dataSize, int bufSize) throws IOException {
        String s = this._getData(dataSize);
        ByteBufferOutputStream bout = new ByteBufferOutputStream(bufSize);
        GZIPOutputStream gout = new GZIPOutputStream(bout);
        gout.write(s.getBytes());
        gout.flush();
        gout.close();
        ByteBufferInputStream bin = new ByteBufferInputStream(bout.getBuffers(), true);
        GZIPInputStream gin = new GZIPInputStream(bin);
        String out = new String(StreamUtil.readBytesFully(gin));
        ByteBufferStreamTest.assertEquals(s, (Object)out);
    }

    String _getData(int size) {
        StringBuilder buf = new StringBuilder(size + 200);
        while (buf.length() < size) {
            buf.append("eliot was here " + _rand.nextDouble());
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        new ByteBufferStreamTest().runConsole();
    }
}

