/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import ed.io.StreamUtil;
import ed.js.JS;
import ed.js.JSException;
import ed.js.JSFunction;
import ed.js.JSInternalFunctions;
import ed.js.JSNumber;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.engine.CompileOptions;
import ed.js.engine.Convert;
import ed.js.engine.JSBuiltInFunctions;
import ed.js.engine.NativeBridge;
import ed.lang.Language;
import ed.lang.StackTraceHolder;
import ed.util.FastStringMap;
import ed.util.SeenPath;
import ed.util.SimpleStack;
import ed.util.Sizable;
import ed.util.StringParseUtil;
import ed.util.WeakBag;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope
implements JSObject {
    static final boolean DEBUG;
    private static long ID;
    private static ThreadLocal<Scope> _threadLocal;
    static _NULL NULL;
    final String _name;
    final Scope _maybeWritableGlobal;
    final Scope _alternate;
    final JSObjectBase _possibleThis;
    final Language _lang;
    private Scope _parent;
    private File _root;
    public final long _id = ID++;
    boolean _locked = false;
    boolean _global = false;
    boolean _killed = false;
    FastStringMap _objects;
    Set<String> _lockedObject;
    Set<String> _warnedObject;
    private ThreadLocal<Scope> _tlPreferred = null;
    Map<String, Object> _attributes;
    SimpleStack<This> _this = new SimpleStack();
    SimpleStack<Throwable> _exceptions;
    SimpleStack<JSObject> _with;
    Object _orSave;
    Object _andSave;
    JSObject _globalThis;
    RuntimeException _toThrow;
    Error _toThrowError;
    private WeakBag<Scope> _children;
    private int _childrenAdds = 0;
    private static String _loadedMarker;

    public static Scope newGlobal() {
        return JSBuiltInFunctions.create();
    }

    public static Scope newGlobal(String name) {
        return JSBuiltInFunctions.create(name);
    }

    static final Object _fixNull(Object o) {
        if (o == NULL) {
            return null;
        }
        return o;
    }

    public Scope() {
        this("empty scope", null);
    }

    public Scope(String name, Scope parent) {
        this(name, parent, null, Language.JS());
    }

    public Scope(String name, Scope parent, File root) {
        this(name, parent, null, Language.JS(), root);
    }

    public Scope(String name, Scope parent, Scope alternate, Language lang) {
        this(name, parent, alternate, lang, null);
    }

    public Scope(String name, Scope parent, Scope alternate, Language lang, File root) {
        Scope them;
        Scope me;
        if (DEBUG) {
            System.err.println("Creating scope with name : " + name + "\t" + this._id);
        }
        this._name = name;
        this._parent = parent;
        this._root = root;
        this._lang = lang;
        this._maybeWritableGlobal = this.getGlobal(false);
        Object pt = alternate == null ? null : alternate.getThis(false);
        this._possibleThis = pt instanceof JSObjectBase ? (JSObjectBase)pt : null;
        Scope alt = null;
        if (alternate != null && (me = this.getGlobal()) != (them = alternate.getGlobal()) && them.hasParent(me)) {
            alt = them;
        }
        this._alternate = alt;
        if (this._parent == null) {
            this._globalThis = Scope._createGlobalThis();
        } else {
            this._parent.registerChild(this);
        }
    }

    public Scope child() {
        return this.child((File)null);
    }

    public Scope child(String name) {
        return new Scope(name, this, null, this._lang, null);
    }

    public Scope child(File f) {
        return new Scope(this._name + ".child", this, null, this._lang, f);
    }

    @Override
    public Object set(Object n, Object v) {
        return this.put(n.toString(), v, true);
    }

    @Override
    public Object get(Object n) {
        return this.get(n.toString());
    }

    public Object remove(Object n) {
        return this.removeField(n);
    }

    @Override
    public Object removeField(Object n) {
        return this.removeField(n.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChild(Scope s) {
        WeakBag<Scope> weakBag = this._children;
        synchronized (weakBag) {
            this._children.remove((Object)s);
        }
        --this._childrenAdds;
    }

    public void removeFromParent() {
        if (this._parent == null) {
            return;
        }
        this._parent.removeChild(this);
    }

    @Override
    public Object setInt(int n, Object v) {
        throw new RuntimeException("no");
    }

    @Override
    public Object getInt(int n) {
        throw new RuntimeException("no");
    }

    public boolean containsKeyLocalOrGlobal(String name) {
        Object o = this._geti(name.hashCode(), name, null, null, false, 0);
        return o != null;
    }

    @Override
    public Set<String> keySet() {
        return this.keySet(false);
    }

    @Override
    public Set<String> keySet(boolean walkUpStack) {
        if (walkUpStack) {
            return this.allKeys();
        }
        if (this._objects == null) {
            return new HashSet<String>();
        }
        return this._objects.keySet(true);
    }

    public Set<String> allKeys() {
        HashSet<String> all = new HashSet<String>();
        Scope cur = this;
        while (cur != null) {
            if (cur._objects != null) {
                all.addAll(cur._objects.keySet());
            }
            cur = cur._parent;
        }
        return all;
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        throw new RuntimeException("not sure this makes sense");
    }

    public Collection<Object> values() {
        throw new RuntimeException("not sure this makes sense");
    }

    public void clear() {
        throw new RuntimeException("can't clear a scope");
    }

    public boolean containsKey(Object o) {
        if (o == null) {
            return false;
        }
        return this.containsKey(o.toString());
    }

    @Override
    public boolean containsKey(String s) {
        if (this._objects == null) {
            return false;
        }
        return this._objects.containsKey(s);
    }

    @Override
    public boolean containsKey(String s, boolean walkUpStack) {
        if (walkUpStack) {
            return this.containsKeyLocalOrGlobal(s);
        }
        return this.containsKey(s);
    }

    public boolean containsValue(Object o) {
        throw new RuntimeException("not sure this makes sense");
    }

    public boolean isEmpty() {
        return this._objects != null && !this._objects.isEmpty();
    }

    public int size() {
        if (this._objects == null) {
            return 0;
        }
        return this._objects.size();
    }

    public Object removeField(String name) {
        return this._removeField(name, name.hashCode());
    }

    Object _removeField(String name, int hash) {
        if (this._objects != null && this._objects.containsKey(hash, name)) {
            if (this._locked) {
                throw new RuntimeException("can't modify a locked scope");
            }
            return this._objects.remove(hash, name);
        }
        if (this._parent == null) {
            return false;
        }
        return this._parent._removeField(name, hash);
    }

    public Object putExplicit(String name, Object o) {
        if (this._locked) {
            throw new RuntimeException("locked");
        }
        if (this._killed) {
            throw new RuntimeException("killed");
        }
        this._ensureObjectMap();
        this._mapSet(name.hashCode(), name, o);
        return o;
    }

    public Object put(String name, Object o) {
        return this.put(name, o, true);
    }

    public Object put(String name, Object o, boolean local) {
        this._throw();
        o = JSInternalFunctions.fixType(o, false);
        if (o == null) {
            o = NULL;
        }
        return this._put(name.hashCode(), name, o, local);
    }

    private Object _put(int nameHash, String name, Object o, boolean local) {
        if (this._locked) {
            throw new RuntimeException("locked");
        }
        if (this._with != null) {
            for (int i = this._with.size() - 1; i >= 0; --i) {
                JSObject temp = (JSObject)this._with.get(i);
                if (!temp.containsKey(name)) continue;
                return temp.set(name, Scope._fixNull(o));
            }
        }
        if (this._killed) {
            if (this._parent == null) {
                throw new RuntimeException("already killed and no parent");
            }
            return this._parent.put(name, o, local);
        }
        if (local || this._global || this._parent == null || this._parent._locked || this._objects != null && this._objects.containsKey(nameHash, name)) {
            Scope pref = this.getTLPreferred();
            if (pref != null) {
                pref._mapSet(nameHash, name, o);
                return Scope._fixNull(o);
            }
            if (this._lockedObject != null && this._lockedObject.contains(name)) {
                throw new RuntimeException("trying to set locked object : " + name);
            }
            this._mapSet(nameHash, name, o);
            return Scope._fixNull(o);
        }
        this._parent._put(nameHash, name, o, false);
        return Scope._fixNull(o);
    }

    private final void _mapSet(int nameHash, String name, Object o) {
        this._ensureObjectMap();
        this._objects.put(nameHash, name, o);
        if (o instanceof JSObjectBase) {
            ((JSObjectBase)o)._setName(name);
        }
    }

    public Object get(String name) {
        return this.get(name, this._alternate);
    }

    public Object get(String name, Scope alt) {
        return this.get(name, alt, null);
    }

    public Object get(String name, Scope alt, JSObject[] with) {
        boolean noThis = false;
        if ("scope".equals(name)) {
            return this;
        }
        if ("globals".equals(name)) {
            Scope foo = this;
            while (!foo._global && foo._parent != null && !foo._parent._locked) {
                foo = foo._parent;
            }
            return foo;
        }
        return this._get(name.hashCode(), name, alt, with, noThis, 0);
    }

    private Object _get(int nameHash, String name, Scope alt, JSObject[] with, boolean noThis, int depth) {
        Object r = this._geti(nameHash, name, alt, with, noThis, depth);
        if (DEBUG) {
            System.out.println("GET [" + name + "] = " + r);
            if (r == null && depth == 0) {
                this.debug();
            }
        }
        return Scope._fixNull(r);
    }

    protected Object _geti(int nameHash, String name, Scope alt, JSObject[] with, boolean noThis, int depth) {
        Object fg;
        Object t;
        Object foo;
        if (this.skipGoingDown()) {
            return this._parent._geti(nameHash, name, alt, with, noThis, depth + 1);
        }
        Scope pref = this.getTLPreferred();
        if (pref != null && pref._objects.containsKey(nameHash, name)) {
            return pref._objects.get(nameHash, name);
        }
        Object object = foo = this._killed || this._objects == null ? null : this._objects.get(nameHash, name);
        if (foo != null) {
            return foo;
        }
        if (this._with != null) {
            for (int i = this._with.size() - 1; i >= 0; --i) {
                JSObject temp = (JSObject)this._with.get(i);
                if (temp == null || !temp.containsKey(name)) continue;
                if (with != null && with.length > 0) {
                    with[0] = temp;
                }
                return temp.get(name);
            }
        }
        if (alt != null && this._global) {
            if (!alt._global) {
                throw new RuntimeException("i fucked up");
            }
            return alt.get(name, null);
        }
        if (this._parent == null) {
            return null;
        }
        if (foo != null) {
            throw new RuntimeException("eliot is stupid");
        }
        JSObjectBase pt = null;
        if (depth == 1 && !noThis && (t = this.getThis(false)) != null && t.getClass() == JSObjectBase.class) {
            JSObjectBase obj;
            pt = obj = (JSObjectBase)t;
            foo = this._getFromThis(obj, name);
            if (foo != null) {
                if (foo instanceof JSFunction && with != null) {
                    with[0] = pt;
                }
                return foo;
            }
        }
        if (depth == 0 && this._possibleThis != null && !name.equals("print")) {
            pt = this._possibleThis;
            foo = this._getFromThis(this._possibleThis, name);
            if (foo != null) {
                if (foo instanceof JSFunction && with != null) {
                    with[0] = pt;
                }
                return foo;
            }
        }
        if (this._globalThis != null && (fg = this._globalThis.get(name)) != null) {
            return fg;
        }
        return this._parent._geti(nameHash, name, alt, with, noThis, depth + 1);
    }

    private Object _getFromThis(JSObjectBase t, String name) {
        return null;
    }

    public Object getOrThis(String name) {
        return this._get(name.hashCode(), name, null, null, false, 0);
    }

    protected boolean skipGoingDown() {
        return false;
    }

    public Language getLanguage() {
        return this._lang;
    }

    public void enterWith(JSObject o) {
        if (this._with == null) {
            this._with = new SimpleStack();
        }
        this._with.push((Object)o);
    }

    public void leaveWith() {
        this._with.pop();
    }

    public final Scope getGlobal() {
        return this._maybeWritableGlobal;
    }

    public final Scope getGlobal(boolean writable) {
        if (!writable && this._maybeWritableGlobal != null) {
            return this._maybeWritableGlobal;
        }
        if (this._killed) {
            return this._parent.getGlobal();
        }
        if (this._global) {
            return this;
        }
        if (this._parent == null) {
            return this;
        }
        if (this._parent._locked && writable) {
            return this;
        }
        return this._parent.getGlobal(writable);
    }

    public Scope getParent() {
        return this._parent;
    }

    @Override
    public JSObject getSuper() {
        return this.getParent();
    }

    public final boolean hasParent(Scope s) {
        if (this == s) {
            return true;
        }
        if (this._parent == null) {
            return false;
        }
        return this._parent.hasParent(s);
    }

    public Scope getTLPreferred() {
        if (this._tlPreferred == null) {
            return null;
        }
        return this._tlPreferred.get();
    }

    public void setTLPreferred(Scope from, Scope s) {
        this.setTLPreferred(s);
    }

    public void setTLPreferred(Scope s) {
        if (s == this) {
            s = null;
        }
        if (s == null && this._tlPreferred == null) {
            return;
        }
        if (s != null) {
            if (this != s._parent) {
                throw new RuntimeException("_tlPreferred has to be child of this");
            }
            if (s._parent._objects == null) {
                throw new RuntimeException("this is weird");
            }
        }
        if (this._tlPreferred == null) {
            this._tlPreferred = new ThreadLocal();
        }
        this._tlPreferred.set(s);
    }

    @Override
    public JSFunction getFunction(String name) {
        return this.getFunctionFromScope(name, false);
    }

    public JSFunction getFunctionFromScope(String name) {
        return this.getFunctionFromScope(name, true);
    }

    public JSFunction getFunctionFromScope(String name, boolean errorOnNull) {
        JSObject pt;
        JSObject[] with = new JSObject[1];
        Object o = this.get(name, this._alternate, with);
        if (o == null && this.getParent() != null && this.getParent().getThis(false) instanceof JSObject && (o = (pt = (JSObject)this.getParent().getThis()).getFunction(name)) instanceof JSFunction) {
            JSFunction func = (JSFunction)o;
            this._this.push((Object)new This(pt));
        }
        if (o == null) {
            if (errorOnNull) {
                throw new NullPointerException(name);
            }
            return null;
        }
        if (!(o instanceof JSFunction)) {
            throw new RuntimeException("not a function : " + name);
        }
        if (with[0] != null) {
            this._this.push((Object)new This(with[0]));
        }
        return (JSFunction)o;
    }

    public Scope newThis(JSFunction f) {
        JSObject o = null;
        o = f != null ? f.newOne() : new JSObjectBase();
        this._this.push((Object)new This(o));
        return this;
    }

    public Scope setThis(Object o) {
        this._this.push((Object)new This(o));
        return this;
    }

    public JSFunction getFunctionAndSetThis(Object obj, String name) {
        JSObject jsobj;
        JSFunction func;
        JSFunction func2;
        if (obj == null) {
            throw new NullPointerException("try to get function [" + name + "] from a null object");
        }
        if (DEBUG) {
            System.out.println(this._id + " getFunctionAndSetThis.  name:" + name);
        }
        if (obj instanceof Number) {
            func2 = (JSFunction)this.getFunctionFromScope("Number").getPrototype().get(name);
            if (func2 != null) {
                this._this.push((Object)new This(obj));
                return func2;
            }
        } else if (obj instanceof Boolean && (func2 = (JSFunction)this.getFunctionFromScope("Boolean").getPrototype().get(name)) != null) {
            this._this.push((Object)new This(obj));
            return func2;
        }
        if (obj instanceof JSObject && (func = (jsobj = (JSObject)obj).getFunction(name)) != null) {
            if (DEBUG) {
                System.out.println("\t pushing js");
            }
            this._this.push((Object)new This(jsobj));
            return func;
        }
        if (DEBUG) {
            System.out.println("\t pushing native");
        }
        this._this.push((Object)new This(obj, name));
        return NativeBridge._nativeFuncCall;
    }

    public Object getThis() {
        return this.getThis(true);
    }

    public Object getThis(boolean getGlobalIfNeeded) {
        if (this._this.size() == 0) {
            if (getGlobalIfNeeded) {
                return this.getGlobalThis();
            }
            return null;
        }
        return ((This)this._this.peek())._this;
    }

    public JSObject getGlobalThis() {
        if (this._globalThis != null) {
            return this._globalThis;
        }
        if (this._parent != null) {
            return this._parent.getGlobalThis();
        }
        return null;
    }

    public Object clearThisNew(Object whoCares) {
        if (DEBUG) {
            System.out.println("popping this from (clearThisNew) : " + this._id);
        }
        Object o = ((This)this._this.pop())._this;
        if (whoCares != null) {
            return whoCares;
        }
        if (o instanceof JSNumber) {
            return ((JSNumber)o).get();
        }
        return o;
    }

    public Object clearThisNormal(Object o) {
        if (DEBUG) {
            System.out.println("popping this from (clearThisNormal) : " + this._id);
        }
        this._this.pop();
        return o;
    }

    public void lock() {
        this._locked = true;
    }

    public void reset() {
        if (this._locked) {
            throw new RuntimeException("can't reset locked scope");
        }
        if (this._objects != null) {
            this._objects.clear();
        }
        this._this.clear();
    }

    public void kill() {
        this._killed = true;
        if (this._children != null) {
            for (Scope child : this._children) {
                child._parent = this._parent;
            }
        }
    }

    public void setGlobal(boolean g) {
        this._global = g;
        if (this._global) {
            if (this._globalThis == null) {
                this._globalThis = Scope._createGlobalThis();
            }
        } else {
            this._globalThis = null;
        }
    }

    public Object evalFromPath(String file) throws IOException {
        return this.evalFromPath(file, file.replaceAll("^.*/(\\w+.js)$", "$1"));
    }

    public Object evalFromPath(String file, String name) throws IOException {
        return this.eval(ClassLoader.getSystemClassLoader().getResourceAsStream(file), name);
    }

    public Object eval(File f) throws IOException {
        return this.eval(f, f.toString());
    }

    public Object eval(File f, String name) throws IOException {
        return this.eval(new FileInputStream(f), name);
    }

    public Object eval(InputStream in, String name) throws IOException {
        return this.eval(StreamUtil.readFully((InputStream)in), name);
    }

    public Object eval(String code) {
        return this.eval(code, "anon" + Math.random());
    }

    public Object eval(String code, String name) {
        return this.eval(code, name, null);
    }

    public Object eval(String code, String name, boolean[] hasReturn) {
        try {
            if (code.matches(JSNumber.POSSIBLE_NUM)) {
                return StringParseUtil.parseStrict((String)code);
            }
            if (code.matches("\\w+(\\.\\w+)*")) {
                if (code.equals("true") || code.equals("false")) {
                    return Boolean.valueOf(code);
                }
                Object o = this.findObject(code);
                if (hasReturn != null && hasReturn.length > 0) {
                    hasReturn[0] = o != null;
                }
                return o;
            }
            Convert c = new Convert(name, code, CompileOptions.forEval());
            if (hasReturn != null && hasReturn.length > 0) {
                hasReturn[0] = c.hasReturn();
            }
            return c.get().call(this);
        }
        catch (IOException ioe) {
            throw new RuntimeException("weird ioexception", ioe);
        }
    }

    Object findObject(String origName) {
        int idx;
        String name = origName;
        JSObject o = this;
        String soFar = "";
        while ((idx = name.indexOf(".")) > 0) {
            String a = name.substring(0, idx);
            if (soFar.length() > 0) {
                soFar = soFar + ".";
            }
            soFar = soFar + a;
            name = name.substring(idx + 1);
            Object foo = o.get(a);
            if (foo == null) {
                throw new NullPointerException(soFar);
            }
            if (foo instanceof Number) {
                return this.getFunctionFromScope("Number").get(origName);
            }
            if (!(foo instanceof JSObject)) {
                throw new JSException((Object)(soFar + " is not a JSObject"));
            }
            o = (JSObject)foo;
        }
        if (o == null) {
            throw new NullPointerException(origName);
        }
        return o.get(name);
    }

    public File getRoot() {
        if (this._root != null) {
            return this._root;
        }
        if (this._parent == null) {
            return null;
        }
        return this._parent.getRoot();
    }

    public boolean orSave(Object a) {
        boolean res = JSInternalFunctions.JS_evalToBool(a);
        if (res) {
            this._orSave = a;
        }
        return res;
    }

    public Object getorSave() {
        return this._orSave;
    }

    public boolean andSave(Object a) {
        boolean res;
        boolean bl = res = !JSInternalFunctions.JS_evalToBool(a);
        if (res) {
            this._andSave = a;
        }
        return res;
    }

    public Object getandSave() {
        return this._andSave;
    }

    public void debug() {
        this.debug(0);
    }

    public void debug(int indent) {
        this.debug(indent, true);
    }

    public void debug(int indent, boolean showKeys) {
        int i;
        for (i = 0; i < indent; ++i) {
            System.out.print("  ");
        }
        System.out.print(this.toString() + ":");
        if (this._global) {
            System.out.print("G");
        }
        if (this._killed) {
            System.out.print("K");
        }
        if (this._locked) {
            System.out.print("L");
        }
        System.out.print(":");
        if (showKeys && this._objects != null) {
            System.out.print(this._objects.keySet());
        }
        System.out.print("||");
        for (i = 0; i < this._this.size(); ++i) {
            This t = (This)this._this.get(i);
            System.out.print(t);
            System.out.print("|");
        }
        System.out.println();
        if (this._alternate != null) {
            System.out.println("  ALT:");
            this._alternate.debug(indent + 1);
        }
        if (this._parent != null) {
            this._parent.debug(indent + 1);
        }
    }

    public long getId() {
        return this._id;
    }

    public String toString() {
        return this._id + ":" + this._name;
    }

    public void lock(String s) {
        if (this._lockedObject == null) {
            this._lockedObject = new HashSet<String>();
        }
        this._lockedObject.add(s);
    }

    public void warn(String s) {
        if (this._warnedObject == null) {
            this._warnedObject = new HashSet<String>();
        }
        this._warnedObject.add(s);
    }

    @Override
    public JSFunction getConstructor() {
        return null;
    }

    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        throw new RuntimeException("not implemented");
    }

    public void putAll(Scope s) {
        if (s == null) {
            return;
        }
        if (s._objects == null) {
            return;
        }
        this._ensureObjectMap();
        this._objects.putAll((Map)s._objects);
    }

    public void putAll(JSObject obj) {
        if (obj == null) {
            return;
        }
        for (String s : obj.keySet()) {
            this.put(s, obj.get(s));
        }
    }

    public Throwable currentException() {
        if (this._exceptions == null) {
            return null;
        }
        return (Throwable)this._exceptions.peek();
    }

    public void pushException(Throwable t) {
        if (this._exceptions == null) {
            this._exceptions = new SimpleStack();
        }
        StackTraceHolder.getInstance().fix(t);
        this._exceptions.push((Object)t);
    }

    public Throwable popException() {
        return (Throwable)this._exceptions.pop();
    }

    public void setToThrow(RuntimeException e) {
        this._toThrow = e;
    }

    public void setToThrow(Error e) {
        this._toThrowError = e;
    }

    public void clearToThrow() {
        this._toThrowError = null;
        this._toThrow = null;
    }

    private void _throw() {
        if (!this._killed) {
            if (this._toThrow != null) {
                this._toThrow.fillInStackTrace();
                throw this._toThrow;
            }
            if (this._toThrowError != null) {
                this._toThrowError.fillInStackTrace();
                throw this._toThrowError;
            }
        }
        if (this._parent == null) {
            return;
        }
        this._parent._throw();
    }

    private void _ensureObjectMap() {
        if (this._objects == null) {
            this._objects = new FastStringMap();
        }
    }

    public long approxSize() {
        return this.approxSize(new SeenPath());
    }

    public long myApproxSize() {
        return this.approxSize(new SeenPath(), true, false);
    }

    public long approxSize(SeenPath seen) {
        return this.approxSize(seen, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long approxSize(SeenPath seen, boolean includeChildren, boolean includeParents) {
        if (seen == null) {
            seen = new SeenPath();
        }
        seen.visited((Object)this);
        long size = 128L;
        if (seen.shouldVisit((Object)this._objects, (Object)this)) {
            size += this._objects.approxSize(seen);
        }
        if (includeChildren && seen.shouldVisit(this._children, (Object)this)) {
            List children;
            WeakBag<Scope> weakBag = this._children;
            synchronized (weakBag) {
                children = this._children.getAll();
            }
            for (Scope c : children) {
                size += c.approxSize(seen);
            }
        }
        if (includeParents && seen.shouldVisit((Object)this._parent, (Object)this)) {
            size += this._parent.approxSize(seen, false, true);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerChild(Scope s) {
        if (this._children == null) {
            this._children = new WeakBag();
        }
        WeakBag<Scope> weakBag = this._children;
        synchronized (weakBag) {
            if (++this._childrenAdds > 1000) {
                this._children.clean();
                this._childrenAdds = 0;
            }
            this._children.add((Object)s);
        }
    }

    public Object getLoaded(String thing) {
        return this.get(_loadedMarker + thing);
    }

    public void markLoaded(String thing, Object res) {
        this.put(_loadedMarker + thing, true);
    }

    public Object getAttribute(String name, boolean lookUpTree) {
        if (this._attributes != null && !this.skipGoingDown() && this._attributes.containsKey(name)) {
            return this._attributes.get(name);
        }
        if (this._parent == null || !lookUpTree) {
            return null;
        }
        return this._parent.getAttribute(name, lookUpTree);
    }

    public void setAttribute(String name, Object val) {
        if (this._attributes == null) {
            this._attributes = new TreeMap<String, Object>();
        }
        this._attributes.put(name, val);
    }

    public void makeThreadLocal() {
        _threadLocal.set(this);
    }

    public static void clearThreadLocal() {
        _threadLocal.set(null);
    }

    public static Scope getThreadLocal() {
        if (_threadLocal == null) {
            return null;
        }
        return _threadLocal.get();
    }

    public static Object getThreadLocal(String name, Object def) {
        return Scope.getThreadLocal(name, def, false);
    }

    public static Object getThreadLocal(String name, Object def, boolean warn) {
        Object o;
        Scope s = Scope.getThreadLocal();
        if (s != null && (o = s.get(name)) != null) {
            return o;
        }
        return def;
    }

    public static JSFunction getThreadLocalFunction(String name, JSFunction def) {
        return (JSFunction)Scope.getThreadLocal(name, def);
    }

    public static JSFunction getThreadLocalFunction(String name, JSFunction def, boolean warn) {
        return (JSFunction)Scope.getThreadLocal(name, def, warn);
    }

    public static Scope getAScope() {
        return Scope.getAScope(true);
    }

    public static Scope getAScope(boolean createIfNeeded) {
        Scope s = Scope.getThreadLocal();
        if (s != null) {
            return s;
        }
        if (!createIfNeeded) {
            return null;
        }
        s = Scope.newGlobal();
        s.makeThreadLocal();
        return s;
    }

    static JSObject _createGlobalThis() {
        JSObjectBase o = new JSObjectBase();
        o.set("__globalThis", true);
        return o;
    }

    static {
        JS._debugSIStart("Scope");
        DEBUG = Boolean.getBoolean("DEBUG.SCOPE");
        ID = 1L;
        _threadLocal = new ThreadLocal();
        NULL = new _NULL();
        _loadedMarker = "___loaded___";
        JS._debugSIDone("Scope");
    }

    static class This {
        Object _this;
        Object _nThis;
        String _nThisFunc;

        This(Object o) {
            this._this = o;
        }

        This(Object o, String n) {
            this._nThis = o;
            this._nThisFunc = n;
        }

        public String toString() {
            if (this._this == null && this._nThisFunc == null) {
                return null;
            }
            if (this._this == null) {
                return this._nThis.toString();
            }
            return ((JSObject)this._this).keySet().toString();
        }
    }

    static class _NULL
    implements Sizable {
        _NULL() {
        }

        public String toString() {
            return "This is an internal thing for Scope.  It means something is null.  You should never seen this.";
        }

        public long approxSize(SeenPath seen) {
            return 24L;
        }
    }
}

