/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import ed.ext.org.mozilla.javascript.Node;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeUtil {
    static Iterator<Node> childIterator(Node start) {
        final LinkedList<Node> toSearch = new LinkedList<Node>();
        toSearch.add(start);
        return new Iterator<Node>(){

            @Override
            public boolean hasNext() {
                return !toSearch.isEmpty();
            }

            @Override
            public Node next() {
                Node n = (Node)toSearch.remove(0);
                if (n.getNext() != null) {
                    toSearch.add(n.getNext());
                }
                if (n.getFirstChild() != null) {
                    toSearch.add(n.getFirstChild());
                }
                return n;
            }

            @Override
            public void remove() {
                throw new RuntimeException("remove not supported");
            }
        };
    }

    static boolean hasString(Node n) {
        return n.getClass().getName().indexOf("StringNode") >= 0;
    }

    static int hash(Node n) {
        if (n == null) {
            return 0;
        }
        if (n.getType() == 130) {
            n = n.getNext();
        }
        if (n == null) {
            return 1;
        }
        int hash = n.getClass().getName().toString().hashCode();
        if (NodeUtil.hasString(n)) {
            hash += 7 * n.getString().hashCode();
        }
        if (n.getType() == 40) {
            hash += (int)(11.0 * n.getDouble());
        }
        if (n.getType() == 108) {
            hash += 711 * n.getIntProp(1, -17);
        }
        hash += n.getLineno() * 17;
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            hash += 11 * NodeUtil.hash(child);
        }
        return hash;
    }
}

