/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import ed.ext.org.mozilla.javascript.EvaluatorException;
import ed.lang.StackTraceHolder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSCompileException
extends RuntimeException {
    final String _msg;
    final String _file;
    final int _line;

    static JSCompileException create(EvaluatorException ee) {
        String s = ee.getMessage();
        Pattern p = Pattern.compile("^.*\\(([\\w/\\\\.]+)#(\\d+)\\)$");
        Matcher m = p.matcher(s);
        if (!m.find()) {
            return new JSCompileException(s, "", -1);
        }
        StackTraceElement broken = new StackTraceElement(m.group(1), "---", m.group(1), Integer.parseInt(m.group(2)));
        StackTraceElement fixed = StackTraceHolder.getInstance().fix(broken);
        System.out.println(s);
        return new JSCompileException(s.substring(0, m.start(1) - 1).trim(), fixed.getFileName(), fixed.getLineNumber());
    }

    JSCompileException(String msg, String file, int line) {
        super(msg + " (" + file + "#" + line + ")");
        this._msg = msg;
        this._file = file;
        this._line = line;
    }

    public String getError() {
        return this._msg;
    }

    public String getFileName() {
        return this._file;
    }

    public int getLineNumber() {
        return this._line;
    }
}

