/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import com.twmacinta.util.MD5;
import ed.db.ObjectId;
import ed.js.Encoding;
import ed.js.JS;
import ed.js.JSArray;
import ed.js.JSBoolean;
import ed.js.JSDate;
import ed.js.JSException;
import ed.js.JSFunction;
import ed.js.JSInternalFunctions;
import ed.js.JSMap;
import ed.js.JSMath;
import ed.js.JSNumber;
import ed.js.JSON;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSRegex;
import ed.js.JSString;
import ed.js.Prototype;
import ed.js.e4x.E4X;
import ed.js.e4x.ENode;
import ed.js.e4x.Namespace;
import ed.js.e4x.QName;
import ed.js.e4x.XMLList;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.js.func.JSFunctionCalls1;
import ed.js.func.JSFunctionCalls2;
import ed.js.func.JSFunctionCalls3;
import ed.log.Logger;
import ed.util.Base64;
import ed.util.StringParseUtil;
import java.io.File;

public class JSBuiltInFunctions {
    private static final Scope _base;

    public static Scope create() {
        return JSBuiltInFunctions.create("Built-In");
    }

    public static Scope create(String name) {
        return JSBuiltInFunctions.create(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scope create(String name, File root) {
        Scope tl = Scope.getThreadLocal();
        if (tl != null) {
            Scope.clearThreadLocal();
        }
        Scope s = new Scope(name, null, root);
        try {
            s.putAll(_base);
            JSBuiltInFunctions._setup(s);
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            System.exit(-1);
        }
        finally {
            if (tl != null) {
                tl.makeThreadLocal();
            }
        }
        s.setGlobal(true);
        s.lock();
        return s;
    }

    public static Class _getClass(String name) throws Exception {
        int colon = name.indexOf(":");
        if (colon < 0) {
            return Class.forName(name);
        }
        String base = name.substring(0, colon);
        Class<?> c = Class.forName(base);
        String inner = "$" + name.substring(colon + 1);
        for (Class<?> child : c.getClasses()) {
            if (!child.getName().endsWith(inner)) continue;
            return child;
        }
        throw new JSException((Object)("can't find inner class [" + inner + "] on [" + c.getName() + "]"));
    }

    public static final boolean isBase(Scope s) {
        return s == _base;
    }

    private static void _setupBase(Scope s) {
        s.put("print", new print(), true);
        s.put("printnoln", new print(false), true);
        s.put("SYSOUT", new print(), true);
        s.put("sleep", new sleep(), true);
        s.put("fork", new fork(), true);
        s.put("eval", new eval(), true);
        CrID crid = new CrID();
        s.put("CrID", crid, true);
        s.put("ObjID", crid, true);
        s.put("ObjId", crid, true);
        s.put("ObjectID", crid, true);
        s.put("ObjectId", crid, true);
        s.put("parseBool", new JSFunctionCalls1(){

            public Object call(Scope scope, Object b, Object[] extra) {
                if (b == null) {
                    return false;
                }
                String s = b.toString();
                if (s.length() == 0) {
                    return false;
                }
                char c = s.charAt(0);
                return c == 't' || c == 'T' || c == '1';
            }
        }, true);
        s.put("parseFloat", new JSFunctionCalls1(){

            public Object call(Scope scope, Object a, Object[] extra) {
                if (a == null) {
                    return Double.NaN;
                }
                try {
                    return Double.parseDouble(a.toString());
                }
                catch (Exception e) {
                    return Double.NaN;
                }
            }
        }, true);
        s.put("parseInt", new JSFunctionCalls2(){

            public Object call(Scope scope, Object a, Object b, Object[] extra) {
                if (a == null) {
                    return Double.NaN;
                }
                if (a instanceof Number) {
                    return ((Number)a).intValue();
                }
                String s = a.toString();
                try {
                    if (b != null && b instanceof Number) {
                        return StringParseUtil.parseIntRadix((String)s, (int)((Number)b).intValue());
                    }
                    return StringParseUtil.parseIntRadix((String)s, (int)10);
                }
                catch (Exception e) {
                    return Double.NaN;
                }
            }
        }, true);
        s.put("parseDate", new JSFunctionCalls1(){

            public Object call(Scope scope, Object a, Object[] extra) {
                if (a == null) {
                    return null;
                }
                if (a instanceof JSDate) {
                    return a;
                }
                if (!(a instanceof String) && !(a instanceof JSString)) {
                    return null;
                }
                long t = JSDate.parseDate(a.toString(), 0L);
                if (t == 0L) {
                    return null;
                }
                return new JSDate(t);
            }
        }, true);
        s.put("NaN", Double.NaN, true);
        s.put("Infinity", Double.POSITIVE_INFINITY, true);
        s.put("md5", new JSFunctionCalls1(){
            private final MD5 _myMd5 = new MD5();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Scope scope, Object b, Object[] extra) {
                MD5 mD5 = this._myMd5;
                synchronized (mD5) {
                    this._myMd5.Init();
                    this._myMd5.Update(b.toString());
                    return new JSString(this._myMd5.asHex());
                }
            }
        }, true);
        s.put("isArray", new isXXX(JSArray.class), true);
        s.put("isBool", new isXXX(Boolean.class), true);
        s.put("isNumber", new isXXX(Number.class), true);
        s.put("isDate", new isXXX(JSDate.class), true);
        s.put("isFunction", new isXXX(JSFunction.class), true);
        s.put("isRegExp", new isXXX(JSRegex.class), true);
        s.put("isRegex", new isXXX(JSRegex.class), true);
        s.put("isNaN", new isNaN(), true);
        s.put("isString", new isXXXs(String.class, JSString.class), true);
        s.put("isObject", new JSFunctionCalls1(){

            public Object call(Scope scope, Object o, Object[] extra) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof JSObject)) {
                    return false;
                }
                if (o instanceof JSString) {
                    return false;
                }
                return true;
            }
        }, true);
        s.put("isAlpha", new JSFunctionCalls1(){

            public Object call(Scope scope, Object o, Object[] extra) {
                char c = JSBuiltInFunctions.getChar(o);
                return Character.isLetter(c);
            }
        }, true);
        s.put("isSpace", new JSFunctionCalls1(){

            public Object call(Scope scope, Object o, Object[] extra) {
                char c = JSBuiltInFunctions.getChar(o);
                return Character.isWhitespace(c);
            }
        }, true);
        s.put("isDigit", new JSFunctionCalls1(){

            public Object call(Scope scope, Object o, Object[] extra) {
                char c = JSBuiltInFunctions.getChar(o);
                return Character.isDigit(c);
            }
        }, true);
        s.put("isXMLName", new JSFunctionCalls1(){

            public Object call(Scope scope, Object o, Object[] extra) {
                return E4X.isXMLName(o);
            }
        }, true);
        s.put("__self", new JSFunctionCalls1(){

            public Object call(Scope scope, Object o, Object[] extra) {
                return o;
            }
        }, true);
        s.put("Base64", new Base64(), true);
        s.put("processArgs", new processArgs(), true);
        s.put("createPackage", new CreatePackage());
        Encoding.install(s);
        JSON.init(s);
        for (String key : s.keySet()) {
            Object val = s.get(key);
            if (!(val instanceof JSObjectBase)) continue;
            ((JSObjectBase)val).lock();
        }
    }

    private static void _setup(Scope s) {
        s.put("Object", new NewObject(), true);
        s.put("Array", new JSArray.JSArrayCons(), true);
        s.put("Boolean", new JSBoolean.Cons(), true);
        s.put("Date", new JSDate.Cons(), true);
        s.put("JSDate", s.get("Date"), true);
        s.put("String", new JSString.JSStringCons(), true);
        s.put("XML", new ENode.Cons(), true);
        s.put("XMLList", new XMLList.ListCons(), true);
        s.put("Namespace", new Namespace.Cons(), true);
        s.put("QName", new QName.Cons(), true);
        s.put("RegExp", new JSRegex.Cons(), true);
        s.put("Regexp", s.get("RegExp"), true);
        s.put("Function", new JSInternalFunctions.FunctionCons(), true);
        s.put("Math", new JSMath(), true);
        s.put("Class", Prototype.newCopy(), true);
        s.put("Number", new JSNumber.Cons(), true);
        s.put("parseNumber", s.get("Number"), true);
        s.put("Exception", new JSException.cons(), true);
        s.put("Map", new JSMap.Cons(), true);
        s.put("assert", new jsassert(), true);
        s.lock();
    }

    private static char getChar(Object o) {
        String s;
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof JSString) {
            o = o.toString();
        }
        if (o instanceof String && (s = (String)o).length() == 1) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        JS._debugSIStart("JSBuiltInFunctions");
        Scope s = new Scope("base", null);
        try {
            JSBuiltInFunctions._setupBase(s);
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            System.exit(-1);
        }
        finally {
            _base = s;
            _base.lock();
            _base.setGlobal(true);
        }
        JS._debugSIDone("JSBuiltInFunctions");
    }

    public static class CreatePackage
    extends JSFunctionCalls1 {
        public Object call(Scope scope, Object funcObject, Object[] args) {
            if (!(funcObject instanceof JSFunction)) {
                throw new RuntimeException("createPackage needs to take a function");
            }
            Scope global = scope.child();
            global.setGlobal(true);
            Scope toPass = global.child();
            JSFunction func = (JSFunction)funcObject;
            func.setUsePassedInScopeTL(true);
            func.call(toPass, args);
            func.setUsePassedInScopeTL(false);
            JSObjectBase thePackage = new JSObjectBase();
            for (String s : global.keySet()) {
                thePackage.set(s, global.get(s));
            }
            return thePackage;
        }
    }

    public static class eval
    extends JSFunctionCalls1 {
        public Object call(Scope scope, Object thing, Object[] args) {
            if (thing == null || thing == VOID) {
                return thing;
            }
            Scope s = scope;
            Object t = scope.getThis();
            if (t instanceof Scope) {
                s = (Scope)t;
            }
            return s.eval(thing.toString());
        }
    }

    public static class processArgs
    extends JSFunctionCalls0 {
        public Object call(Scope scope, Object[] args) {
            JSArray a = (JSArray)scope.get("arguments");
            for (int i = 0; i < args.length; ++i) {
                scope.put(args[i].toString(), a.getInt(i), true);
            }
            return null;
        }
    }

    public static class fork
    extends JSFunctionCalls1 {
        public Object call(final Scope scope, Object funcJS, final Object[] extra) {
            if (!(funcJS instanceof JSFunction)) {
                throw new JSException((Object)"fork has to take a function");
            }
            final JSFunction func = (JSFunction)funcJS;
            Thread t = new Thread("fork"){
                private Object _result;

                public void run() {
                    try {
                        this._result = func.call(scope, extra);
                    }
                    catch (Throwable t) {
                        if (scope.get("log") != null) {
                            ((Logger)scope.get("log")).error((Object)"error in fork", t);
                        }
                        t.printStackTrace();
                    }
                }

                public Object returnData() throws InterruptedException {
                    this.join();
                    return this._result;
                }
            };
            return t;
        }
    }

    public static class isXXXs
    extends JSFunctionCalls1 {
        final Class[] _c;

        isXXXs(Class ... c) {
            this._c = c;
        }

        public Object call(Scope scope, Object o, Object[] extra) {
            for (int i = 0; i < this._c.length; ++i) {
                if (!this._c[i].isInstance(o)) continue;
                return true;
            }
            return false;
        }
    }

    public static class isNaN
    extends JSFunctionCalls1 {
        public Object call(Scope scope, Object o, Object[] extra) {
            return o.equals(Double.NaN);
        }
    }

    public static class isXXX
    extends JSFunctionCalls1 {
        final Class _c;

        isXXX(Class c) {
            this._c = c;
        }

        public Object call(Scope scope, Object o, Object[] extra) {
            return this._c.isInstance(o);
        }
    }

    public static class sleep
    extends JSFunctionCalls1 {
        public Object call(Scope scope, Object timeObj, Object[] extra) {
            if (!(timeObj instanceof Number)) {
                return false;
            }
            try {
                Thread.sleep(((Number)timeObj).longValue());
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class CrID
    extends JSFunctionCalls1 {
        public CrID() {
            this.set("isValid", new JSFunctionCalls1(){

                public Object call(Scope scope, Object idString, Object[] extra) {
                    if (idString == null) {
                        return false;
                    }
                    if (idString instanceof ObjectId) {
                        return true;
                    }
                    return ObjectId.isValid((String)idString.toString());
                }
            });
        }

        public Object call(Scope scope, Object idString, Object[] extra) {
            if (idString == null) {
                return ObjectId.get();
            }
            if (idString instanceof ObjectId) {
                return idString;
            }
            return new ObjectId(idString.toString());
        }

        public JSObject newOne() {
            throw new JSException((Object)"ObjectId is not a constructor");
        }
    }

    public static class NewDate
    extends JSFunctionCalls1 {
        public Object call(Scope scope, Object t, Object[] extra) {
            if (t == null) {
                return new JSDate();
            }
            if (!(t instanceof Number)) {
                return new JSDate();
            }
            return new JSDate(((Number)t).longValue());
        }
    }

    public static class NewObject
    extends JSFunctionCalls0 {
        public Object call(Scope scope, Object[] extra) {
            if (extra != null && extra.length > 0 && extra[0] instanceof JSObject) {
                scope.setThis(extra[0]);
                return extra[0];
            }
            return new JSObjectBase();
        }

        public Object get(Object o) {
            if (o == null) {
                return null;
            }
            if (o.toString().equals("prototype")) {
                return JSObjectBase._objectLowFunctions;
            }
            return super.get(o);
        }

        protected void init() {
            this.set("extend", new Prototype.Object_extend());
            this.set("values", new Prototype.Object_values());
            this.set("keys", new Prototype.Object_keys());
        }
    }

    public static class print
    extends JSFunctionCalls1 {
        final boolean _newLine;

        print() {
            this(true);
        }

        print(boolean newLine) {
            this._newLine = newLine;
        }

        public Object call(Scope scope, Object foo, Object[] extra) {
            if (this._newLine) {
                System.out.println(foo);
            } else {
                System.out.print(foo);
            }
            return null;
        }
    }

    public static class jsassert
    extends JSFunctionCalls1 {
        public jsassert() {
            JSFunctionCalls2 myThrows = new JSFunctionCalls2(){

                public Object call(Scope scope, Object exctype, Object f, Object[] extra) {
                    if (!(f instanceof JSFunction)) {
                        if (exctype instanceof JSFunction && f == null) {
                            f = exctype;
                            exctype = null;
                        } else {
                            throw new RuntimeException("Second argument to assert.throws must be a function");
                        }
                    }
                    try {
                        ((JSFunction)f).call(scope, null);
                    }
                    catch (JSException e) {
                        if (exctype == null) {
                            return true;
                        }
                        if ((exctype instanceof JSString || exctype instanceof String) && e.getObject().equals(exctype.toString())) {
                            return Boolean.TRUE;
                        }
                        Object desc = e.getObject();
                        if (desc instanceof Throwable && jsassert.this.match((Throwable)desc, exctype)) {
                            return Boolean.TRUE;
                        }
                        Throwable cause = e.getCause();
                        if (jsassert.this.match(cause, exctype)) {
                            return Boolean.TRUE;
                        }
                        throw new JSException((Object)("given function threw something else: " + cause.toString()));
                    }
                    catch (Throwable e) {
                        if (exctype == null) {
                            return true;
                        }
                        if (jsassert.this.match(e, exctype.toString())) {
                            return Boolean.TRUE;
                        }
                        throw new JSException((Object)("given function threw something else: " + e.toString()));
                    }
                    throw new JSException((Object)("given function did not throw " + exctype));
                }
            };
            this.set("throws", myThrows);
            this.set("raises", myThrows);
            this.set("eq", new JSFunctionCalls3(){

                public Object call(Scope scope, Object a, Object b, Object extraMsg, Object[] extra) {
                    if (JSInternalFunctions.JS_eq(a, b).booleanValue()) {
                        return true;
                    }
                    String msg = "not the same [" + a + "] != [" + b + "]";
                    if (extraMsg != null) {
                        msg = msg + " " + extraMsg;
                    }
                    throw new JSException((Object)msg);
                }
            });
            this.set("lt", new JSFunctionCalls3(){

                public Object call(Scope scope, Object a, Object b, Object extraMsg, Object[] extra) {
                    if (JSInternalFunctions.JS_lt(a, b).booleanValue()) {
                        return true;
                    }
                    String msg = "[" + a + "] is not less than [" + b + "]";
                    if (extraMsg != null) {
                        msg = msg + " " + extraMsg;
                    }
                    throw new JSException((Object)msg);
                }
            });
            this.set("gt", new JSFunctionCalls3(){

                public Object call(Scope scope, Object a, Object b, Object extraMsg, Object[] extra) {
                    if (JSInternalFunctions.JS_gt(a, b).booleanValue()) {
                        return true;
                    }
                    String msg = "[" + a + "] is not greater than [" + b + "]";
                    if (extraMsg != null) {
                        msg = msg + " " + extraMsg;
                    }
                    throw new JSException((Object)msg);
                }
            });
            this.set("neq", new JSFunctionCalls3(){

                public Object call(Scope scope, Object a, Object b, Object extraMsg, Object[] extra) {
                    if (!JSInternalFunctions.JS_eq(a, b).booleanValue()) {
                        return true;
                    }
                    String msg = "are the same [" + a + "] != [" + b + "]";
                    if (extraMsg != null) {
                        msg = msg + " " + extraMsg;
                    }
                    throw new JSException((Object)msg);
                }
            });
        }

        static String _getClass(Object o) {
            if (o == null) {
                return null;
            }
            return o.getClass().getName();
        }

        public Object call(Scope scope, Object foo, Object[] extra) {
            if (JSInternalFunctions.JS_evalToBool(foo)) {
                return Boolean.TRUE;
            }
            if (extra != null && extra.length > 0 && extra[0] != null) {
                throw new JSException((Object)("assert failed : " + extra[0]));
            }
            throw new JSException((Object)"assert failed");
        }

        public boolean match(Throwable e, Object exctype) {
            if (exctype instanceof JSString || exctype instanceof String) {
                String s = exctype.toString();
                String gotExc = e.getClass().toString();
                if (gotExc.equals("class " + s)) {
                    return true;
                }
                if (gotExc.equals("class java.lang." + s)) {
                    return true;
                }
                if (e instanceof JSException && ((JSException)e).getObject().equals(s)) {
                    return true;
                }
            }
            return false;
        }
    }
}

