/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import ed.ext.org.mozilla.javascript.FunctionNode;
import ed.ext.org.mozilla.javascript.Node;
import ed.js.engine.Convert;
import ed.js.engine.NodeUtil;
import ed.util.IdentitySet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionInfo
implements Iterable<String> {
    final FunctionNode _fn;
    final VarSet _vars;
    final Set<String> _globals = new HashSet<String>();
    private boolean _played = false;
    final boolean _hasLambda;
    private boolean _usesArguemnts = false;
    private boolean _usesScope = false;

    static FunctionInfo create(FunctionNode fn) {
        FunctionInfo fi = new FunctionInfo(fn);
        fi._play();
        return fi;
    }

    private FunctionInfo(FunctionNode fn) {
        int i;
        this._fn = fn;
        this._vars = new VarSet();
        for (i = 0; i < fn.getParamAndVarCount(); ++i) {
            this._vars.put(fn.getParamOrVarName(i), new Info(this._vars, fn.getParamOrVarName(i)));
        }
        for (i = 0; i < fn.getParamCount(); ++i) {
            ((Info)this._vars.get((Object)fn.getParamOrVarName((int)i)))._param = true;
        }
        this._hasLambda = fn.getFunctionCount() > 0;
    }

    boolean usesArguemnts() {
        this._play();
        return this._usesArguemnts;
    }

    boolean usesScope() {
        this._play();
        return this._usesScope;
    }

    Info getInfo(String s) {
        return (Info)this._vars.get(s);
    }

    boolean canUseLocal(String s) {
        if (this._hasLambda || this._usesScope) {
            return false;
        }
        Info i = this.getInfo(s);
        if (i == null) {
            return false;
        }
        return i.canUseLocal();
    }

    boolean isNumber(Node n) {
        if (n.getType() == 40) {
            return true;
        }
        if (n.getType() == 21) {
            return this.isNumber(n.getFirstChild()) && this.isNumber(n.getFirstChild().getNext());
        }
        if (n.getType() == 55 || n.getType() == 39) {
            return this.isNumber(n.getString());
        }
        return false;
    }

    boolean isNumber(String s) {
        Info i = this.getInfo(s);
        if (i == null) {
            return false;
        }
        return i.isNumber();
    }

    @Override
    public Iterator<String> iterator() {
        return this._vars.keySet().iterator();
    }

    private void _play() {
        if (this._played) {
            return;
        }
        Iterator<Node> ni = NodeUtil.childIterator((Node)this._fn);
        while (ni.hasNext()) {
            Node cur = ni.next();
            if (cur.getType() == 39 || cur.getType() == 55) {
                String name = cur.getString();
                if (name.equals("arguments") || name.equals("processArgs")) {
                    this._usesArguemnts = true;
                }
                if (name.equals("scope")) {
                    this._usesScope = true;
                }
                if (this._vars.containsKey(name)) continue;
                this._globals.add(name);
                continue;
            }
            if (cur.getType() == 105 || cur.getType() == 106) {
                if (cur.getFirstChild().getType() != 55 && cur.getFirstChild().getType() != 39) continue;
                this._vars.incOrDec(cur.getFirstChild().getString());
                continue;
            }
            if (cur.getType() == 118 && Convert.countChildren(cur) == 3) {
                this._vars.unknownEvidence(cur.getFirstChild().getString());
                continue;
            }
            if (cur.getType() != 56 && cur.getType() != 8) continue;
            this._vars.settingTo(cur.getFirstChild().getString(), cur.getFirstChild().getNext());
        }
        this._played = true;
    }

    static void _warn(String s) {
        System.out.println("TypeInference.warn : " + s);
    }

    public String toString() {
        return "FunctionInfo: " + this._fn + "\n" + "\t _hasLambda: " + this._hasLambda + "\n" + this._vars;
    }

    static class Info {
        final String _name;
        final VarSet _vars;
        final List<Info> _depends = new LinkedList<Info>();
        boolean _param = false;
        boolean _incOrDec = false;
        boolean _numberEvidence = false;
        boolean _unknownEvidence = false;

        Info(VarSet vars, String name) {
            this._vars = vars;
            this._name = name;
        }

        void incOrDec() {
            this.numberEvidence();
            this._incOrDec = true;
        }

        void numberEvidence() {
            this._numberEvidence = true;
        }

        void unknownEvidence() {
            this._unknownEvidence = true;
        }

        boolean isNumber() {
            return this.isNumber(new IdentitySet());
        }

        boolean isNumber(IdentitySet seen) {
            for (Info i : this._depends) {
                if (seen.contains((Object)i)) continue;
                seen.add((Object)i);
                if (i.isNumber(seen)) continue;
                return false;
            }
            return !this._param && this._numberEvidence && !this._unknownEvidence;
        }

        void settingTo(Node n) {
            if (n.getType() == 40) {
                this.numberEvidence();
                return;
            }
            if (n.getType() == 21) {
                this.settingTo(n.getFirstChild());
                this.settingTo(n.getFirstChild().getNext());
                return;
            }
            if (n.getType() == 55 || n.getType() == 39) {
                String s = n.getString();
                if (s.equals(this._name)) {
                    return;
                }
                if (this._vars.containsKey(s)) {
                    this._depends.add((Info)this._vars.get(s));
                    return;
                }
                this.unknownEvidence();
                return;
            }
            this.unknownEvidence();
        }

        boolean canUseLocal() {
            if (this.isNumber()) {
                return true;
            }
            return !this._incOrDec;
        }

        public String toString() {
            return this._name + " isNumber:" + this.isNumber() + " incOrDec:" + this._incOrDec;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VarSet
    extends TreeMap<String, Info> {
        VarSet() {
        }

        boolean isNumber(String name) {
            Info i = (Info)this.get(name);
            if (i == null) {
                return false;
            }
            return i.isNumber();
        }

        void numberEvidence(String name) {
            Info i = (Info)this.get(name);
            if (i == null) {
                return;
            }
            i.numberEvidence();
        }

        void incOrDec(String name) {
            Info i = (Info)this.get(name);
            if (i == null) {
                return;
            }
            i.incOrDec();
        }

        void unknownEvidence(String name) {
            Info i = (Info)this.get(name);
            if (i == null) {
                return;
            }
            i.unknownEvidence();
        }

        void settingTo(String name, Node n) {
            Info i = (Info)this.get(name);
            if (i == null) {
                return;
            }
            i.settingTo(n);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder("VarSet\n");
            for (String s : this.keySet()) {
                buf.append("\t").append(this.get(s)).append("\n");
            }
            return buf.toString();
        }
    }
}

