/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import com.twmacinta.util.MD5;
import ed.ext.org.mozilla.javascript.CompilerEnvirons;
import ed.ext.org.mozilla.javascript.Decompiler;
import ed.ext.org.mozilla.javascript.EvaluatorException;
import ed.ext.org.mozilla.javascript.FunctionNode;
import ed.ext.org.mozilla.javascript.Node;
import ed.ext.org.mozilla.javascript.NodeTransformer;
import ed.ext.org.mozilla.javascript.Parser;
import ed.ext.org.mozilla.javascript.ScriptOrFnNode;
import ed.ext.org.mozilla.javascript.Token;
import ed.ext.org.mozilla.javascript.UintMap;
import ed.io.FileUtil;
import ed.io.StreamUtil;
import ed.js.JSFunction;
import ed.js.JSNumericFunctions;
import ed.js.JSObjectBase;
import ed.js.engine.CompileOptions;
import ed.js.engine.CompileUtil;
import ed.js.engine.Debug;
import ed.js.engine.FunctionInfo;
import ed.js.engine.JSCompileException;
import ed.js.engine.JSCompiledScript;
import ed.js.engine.Scope;
import ed.js.engine.State;
import ed.lang.Language;
import ed.lang.StackTraceFixer;
import ed.lang.StackTraceHolder;
import ed.util.IdentitySet;
import ed.util.Pair;
import ed.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class Convert {
    static boolean DJS = Boolean.getBoolean("DEBUG.JS");
    final boolean D;
    public static final String DEFAULT_PACKAGE = "ed.js.gen";
    public static final String RETURN_VARIABLE = "returnee";
    final Random _random;
    final String _name;
    final String _source;
    final String _encodedSource;
    final String _className;
    final String _fullClassName;
    final String _package = "ed.js.gen";
    final CompileOptions _options;
    final int _id;
    private int _currentLineNumber = 0;
    final Map<Integer, List<Node>> _javaCodeToLines = new TreeMap<Integer, List<Node>>();
    final Map<Node, Integer> _nodeToSourceLine = new IdentityHashMap<Node, Integer>();
    final Map<Node, ScriptOrFnNode> _nodeToSOR = new IdentityHashMap<Node, ScriptOrFnNode>();
    final List<Pair<String, String>> _regex = new ArrayList<Pair<String, String>>();
    final List<String> _strings = new ArrayList<String>();
    final ScriptInfo _scriptInfo;
    int _preMainLines = -1;
    private final StringBuilder _mainJavaCode = new StringBuilder();
    private boolean _useDefaultReturn = true;
    private boolean _hasReturn = false;
    private JSFunction _it;
    private boolean _loadOnce = false;
    private int _methodId = 0;
    private final int MAX_NUM_PARAMS = 28;
    private static final int[] _while1 = new int[]{5, 130, 0, 0, 130, 6, 130};
    private static final int[] _doWhile1 = new int[]{130, 0, 130, 6, 130};
    private static Map<String, ClassInfo> _classes = Collections.synchronizedMap(new HashMap());

    public static JSFunction makeAnon(String code) {
        return Convert.makeAnon(code, false);
    }

    public static JSFunction makeAnon(String code, boolean forceEval) {
        return Convert.makeAnon(code, forceEval, new CompileOptions());
    }

    public static JSFunction makeAnon(String code, boolean forceEval, CompileOptions options) {
        try {
            Convert c;
            String nice = code.trim();
            String name = "anon" + Math.random();
            if (nice.startsWith("function") && nice.endsWith("}")) {
                Object val;
                c = new Convert(name, code, options.createNewScope(false));
                JSFunction func = c.get();
                Scope s = Scope.newGlobal().child();
                s.setGlobal(true);
                func.call(s);
                String keyToUse = null;
                int numKeys = 0;
                for (String key : s.keySet()) {
                    if (key.equals("arguments")) continue;
                    keyToUse = key;
                    ++numKeys;
                }
                if (numKeys == 1 && (val = s.get(keyToUse)) instanceof JSFunction) {
                    JSFunction f = (JSFunction)val;
                    f.setUsePassedInScope(forceEval);
                    return f;
                }
            }
            if (forceEval) {
                options.createNewScope(false);
            }
            c = new Convert(name, nice, options);
            return c.get();
        }
        catch (IOException ioe) {
            throw new RuntimeException("should be impossible", ioe);
        }
    }

    public Convert(File sourceFile) throws IOException {
        this(sourceFile, new CompileOptions());
    }

    public Convert(File sourceFile, CompileOptions options) throws IOException {
        this(sourceFile.getAbsolutePath(), StreamUtil.readFully((File)sourceFile, (String)"UTF-8"), options);
    }

    public Convert(String name, String source) throws IOException {
        this(name, source, new CompileOptions());
    }

    public Convert(String name, String source, CompileOptions options) throws IOException {
        this.D = DJS && !name.contains("src/main/ed/lang") && !name.contains("src/main/ed/appserver/") && !name.contains("src_main_ed_lang");
        this._name = name;
        this._source = source;
        this._options = options;
        this._className = Convert.cleanName(this._name) + Convert._getNumForClass(this._name, this._source);
        this._fullClassName = "ed.js.gen." + this._className;
        this._random = Convert._random(this._fullClassName);
        this._id = this._randNonNegativeInt();
        this._scriptInfo = new ScriptInfo(this._name, this._fullClassName, options.sourceLanguage(), this);
        CompilerEnvirons ce = new CompilerEnvirons();
        Parser p = new Parser(ce, ce.getErrorReporter());
        ScriptOrFnNode theNode = null;
        try {
            theNode = p.parse(this._source, this._name, 0);
        }
        catch (EvaluatorException ee) {
            throw JSCompileException.create(ee);
        }
        this._encodedSource = p.getEncodedSource();
        this.init(theNode);
    }

    public static String cleanName(String name) {
        StringBuilder buf = new StringBuilder(name.length() + 5);
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) {
                if (buf.length() == 0 && Character.isDigit(c)) {
                    buf.append("N");
                }
                buf.append(c);
                continue;
            }
            if (buf.length() == 0) continue;
            buf.append("_");
        }
        return buf.toString();
    }

    private void init(ScriptOrFnNode sn) {
        if (this._it != null) {
            throw new RuntimeException("too late");
        }
        NodeTransformer nf = new NodeTransformer();
        nf.transform(sn);
        if (this.D) {
            Debug.print(sn, 0);
        }
        State state = new State(this._options);
        this._setLineNumbers((Node)sn, sn);
        this._addFunctionNodes(sn, state);
        if (this.D) {
            System.out.println("***************");
        }
        Node n = sn.getFirstChild();
        this._loadOnce = this._isLoadOnce(n);
        if (this._loadOnce) {
            n = n.getNext();
        }
        this._append("\nObject returnee = null;\n", n);
        String whyRasReturn = null;
        while (n != null) {
            if (n.getType() != 108) {
                if (n.getNext() == null) {
                    if (n.getType() == 133) {
                        this._append("return ", n);
                        this._useDefaultReturn = false;
                        this._hasReturn = true;
                        whyRasReturn = "EXPR_RESULT";
                    }
                    if (n.getType() == 4) {
                        this._useDefaultReturn = false;
                        this._hasReturn = true;
                        whyRasReturn = "RETURN";
                    }
                }
                this._add(n, sn, state);
                this._append("\n", n);
            }
            n = n.getNext();
        }
        if (this._useDefaultReturn) {
            this._append("scope.removeFromParent(); \n return returnee; ", (Node)sn);
        } else {
            this._append("/* no return b/c : " + whyRasReturn + " */", (Node)sn);
            boolean alreadyHaveOne = false;
            for (int end = this._mainJavaCode.length() - 1; end >= 0; --end) {
                char c = this._mainJavaCode.charAt(end);
                if (Character.isWhitespace(c)) continue;
                if (c != ';') break;
                if (!alreadyHaveOne) {
                    alreadyHaveOne = true;
                    continue;
                }
                this._mainJavaCode.setLength(end + 1);
                break;
            }
        }
    }

    private void _add(Node n, State state) {
        this._add(n, null, state);
    }

    private boolean _isLoadOnce(Node n) {
        if (n == null || n.getType() != 133) {
            return false;
        }
        if ((n = n.getFirstChild()) == null || n.getType() != 38) {
            return false;
        }
        if ((n = n.getFirstChild()) == null || n.getType() != 39) {
            return false;
        }
        return n.getString().equals("loadOnce");
    }

    private void _add(Node n, ScriptOrFnNode sn, State state) {
        switch (n.getType()) {
            case 32: {
                this._append("JS_typeof( ", n);
                Convert._assertOne(n);
                this._add(n.getFirstChild(), state);
                this._append(" ) ", n);
                break;
            }
            case 136: {
                this._append("JS_typeof( ", n);
                if (state.hasSymbol(n.getString())) {
                    this._append(n.getString(), n);
                } else {
                    this._append("scope.get( \"" + n.getString() + "\" )", n);
                }
                this._append(" ) ", n);
                break;
            }
            case 48: {
                int myId = this._regex.size();
                ScriptOrFnNode parent = this._nodeToSOR.get(n);
                if (parent == null) {
                    throw new RuntimeException("how is parent null : " + n.hashCode());
                }
                int rId = n.getIntProp(4, -1);
                this._regex.add((Pair<String, String>)new Pair((Object)parent.getRegexpString(rId), (Object)parent.getRegexpFlags(rId)));
                this._append(" _regex(" + myId + ") ", n);
                break;
            }
            case 65: {
                this._append("( JSArray.create( ", n);
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    if (c != n.getFirstChild()) {
                        this._append(" , ", n);
                    }
                    this._add(c, state);
                }
                this._append(" ) ) ", n);
                break;
            }
            case 66: {
                this._append("JS_buildLiteralObject( new String[]{ ", n);
                boolean first = true;
                Node c = n.getFirstChild();
                for (Object id : (Object[])n.getProp(12)) {
                    if (first) {
                        first = false;
                    } else {
                        this._append(" , ", n);
                    }
                    String name = id.toString();
                    if (c.getType() == 150) {
                        name = JSObjectBase.getterName(name);
                    } else if (c.getType() == 151) {
                        name = JSObjectBase.setterName(name);
                    }
                    this._append(this.getStringCode(name) + ".toString()", n);
                    c = c.getNext();
                }
                this._append(" } ", n);
                for (c = n.getFirstChild(); c != null; c = c.getNext()) {
                    this._append(" , ", n);
                    this._add(c, state);
                }
                this._append(" ) ", n);
                break;
            }
            case 30: {
                this._append("scope.clearThisNew( ", n);
                this._addCall(n, state, true);
                this._append(" ) ", n);
                break;
            }
            case 43: {
                this._append("passedIn.getThis()", n);
                break;
            }
            case 105: 
            case 106: {
                Convert._assertOne(n);
                Node tempChild = n.getFirstChild();
                if ((tempChild.getType() == 39 || tempChild.getType() == 55) && state.useLocalVariable(tempChild.getString())) {
                    if (!state.isNumber(tempChild.getString())) {
                        throw new RuntimeException("can't increment local variable : " + tempChild.getString());
                    }
                    String str = n.getType() == 105 ? "++ " : "-- ";
                    this._append(tempChild.getString() + str, n);
                    break;
                }
                this._append("JS_inc( ", n);
                this._createRef(n.getFirstChild(), state);
                this._append(" , ", n);
                this._append(String.valueOf((n.getIntProp(13, 0) & 2) > 0), n);
                this._append(" , ", n);
                this._append(String.valueOf(n.getType() == 105 ? 1 : -1), n);
                this._append(")", n);
                break;
            }
            case 137: {
                this._append("__tempObject.get( " + state._tempOpNames.pop() + " ) ", n);
                break;
            }
            case 138: 
            case 139: {
                Node theOp = n.getFirstChild().getNext().getNext();
                if (!(theOp.getType() != 21 && theOp.getType() != 22 && theOp.getType() != 23 && theOp.getType() != 24 || theOp.getFirstChild().getType() != 137 && theOp.getFirstChild().getNext().getType() != 137)) {
                    this._append("\n", n);
                    this._append("JS_setDefferedOp( (JSObject) ", n);
                    this._add(n.getFirstChild(), state);
                    this._append(" , ", n);
                    this._add(n.getFirstChild().getNext(), state);
                    this._append(" , ", n);
                    this._add(theOp.getFirstChild().getType() == 137 ? theOp.getFirstChild().getNext() : theOp.getFirstChild(), state);
                    this._append(" , " + theOp.getType(), n);
                    this._append(" \n ) \n", n);
                    break;
                }
                this._append("null; \n { \n", n);
                this._append("JSObject __tempObject = (JSObject)", n);
                this._add(n.getFirstChild(), state);
                this._append(";\n", n);
                String tempName = "__temp" + this._rand();
                state._tempOpNames.push(tempName);
                this._append("Object " + tempName + " = ", n);
                this._add(n.getFirstChild().getNext(), state);
                this._append(";\n", n);
                this._append("returnee = __tempObject.set(", n);
                this._hasReturn = true;
                this._append(tempName, n);
                this._append(" , ", n);
                this._add(n.getFirstChild().getNext().getNext(), state);
                this._append(" ); \n", n);
                this._append(" } \n", n);
                break;
            }
            case 35: 
            case 37: {
                this._addAsJSObject(n.getFirstChild(), state);
                this._append(".set( ", n);
                this._add(n.getFirstChild().getNext(), state);
                this._append(" , ", n);
                this._add(n.getFirstChild().getNext().getNext(), state);
                this._append(" ) ", n);
                break;
            }
            case 33: 
            case 34: 
            case 36: {
                this._addAsJSObject(n.getFirstChild(), state);
                this._append(".get( ", n);
                this._add(n.getFirstChild().getNext(), state);
                this._append(" )", n);
                break;
            }
            case 68: {
                Node fc = n.getFirstChild();
                if (fc.getType() != 71 && fc.getType() != 76 && fc.getType() != 77) {
                    throw new RuntimeException("token is of type " + Token.name((int)fc.getType()) + ", should be of type REF_SPECIAL or REF_MEMBER or REF_NS_MEMBER.");
                }
                this._addAsJSObject(n.getFirstChild().getFirstChild(), state);
                this._append(".set( ", n);
                this._add(fc, state);
                this._append(" , ", n);
                this._add(fc.getNext(), state);
                this._append(" )", n);
                break;
            }
            case 67: {
                this._addAsJSObject(n.getFirstChild().getFirstChild(), state);
                this._append(".get( ", n);
                this._add(n.getFirstChild(), state);
                this._append(" ) ", n);
                break;
            }
            case 71: {
                this._append("\"" + n.getProp(17).toString() + "\"", n);
                break;
            }
            case 76: {
                int memberTypeFlags = n.getIntProp(16, 0);
                if ((memberTypeFlags & 4) != 0) {
                    this._append("\"..\" + ", n);
                }
                if ((memberTypeFlags & 2) != 0) {
                    this._append("\"@\" + ", n);
                }
                this._add(n.getFirstChild().getNext(), state);
                break;
            }
            case 77: {
                this._append(" new ed.js.e4x.QName( (ed.js.e4x.Namespace)", n);
                this._add(n.getFirstChild().getNext(), state);
                this._append(", ", n);
                int memberTypeFlags2 = n.getIntProp(16, 0);
                if ((memberTypeFlags2 & 4) != 0) {
                    this._append("\"..\" + ", n);
                }
                if ((memberTypeFlags2 & 2) != 0) {
                    this._append("\"@\" + ", n);
                }
                this._add(n.getFirstChild().getNext().getNext(), state);
                this._append(" ) ", n);
                break;
            }
            case 74: 
            case 75: 
            case 78: {
                this._add(n.getFirstChild(), state);
                break;
            }
            case 133: {
                Convert._assertOne(n);
                this._hasReturn = true;
                this._append("returnee = ", n);
                this._add(n.getFirstChild(), state);
                this._append(";\n", n);
                break;
            }
            case 38: {
                this._addCall(n, state);
                break;
            }
            case 40: {
                double d = n.getDouble();
                String temp = String.valueOf(d);
                if (Double.isNaN(d)) {
                    this._append("Double.NaN", n);
                    break;
                }
                if (Double.isInfinite(d)) {
                    this._append(d < 0.0 ? "Double.NEGATIVE_INFINITY" : "Double.POSITIVE_INFINITY", n);
                    break;
                }
                if ((temp.endsWith(".0") || JSNumericFunctions.couldBeInt(d)) && !temp.equals("-0.0") && !temp.equals("-0")) {
                    temp = String.valueOf((int)d);
                }
                this._append("JSNumber.self( " + temp + ")", n);
                break;
            }
            case 41: {
                String theString = n.getString();
                this._append(this.getStringCode(theString), n);
                break;
            }
            case 45: {
                this._append(" true ", n);
                break;
            }
            case 44: {
                this._append(" false ", n);
                break;
            }
            case 42: {
                this._append(" null ", n);
                break;
            }
            case 125: {
                this._append(" VOID ", n);
                break;
            }
            case 121: {
                this._addVar(n, state);
                break;
            }
            case 55: {
                if (state.useLocalVariable(n.getString())) {
                    this._append(n.getString(), n);
                    break;
                }
            }
            case 39: {
                if (state.useLocalVariable(n.getString()) && state.hasSymbol(n.getString())) {
                    this._append(n.getString(), n);
                    break;
                }
                this._append("scope.get( \"" + n.getString() + "\" )", n);
                break;
            }
            case 63: {
                this._append("this", n);
                break;
            }
            case 56: {
                String foo = n.getFirstChild().getString();
                if (state.useLocalVariable(foo)) {
                    if (!state.hasSymbol(foo)) {
                        throw new RuntimeException("something is wrong");
                    }
                    if (!state.isPrimitive(foo)) {
                        this._append("JSInternalFunctions.self ( ", n);
                    }
                    this._append(foo + " = ", n);
                    this._add(n.getFirstChild().getNext(), state);
                    if (state.isPrimitive(foo)) break;
                    this._append(" )\n", n);
                    break;
                }
                this._setVar(foo, n.getFirstChild().getNext(), state, true);
                break;
            }
            case 8: {
                this._addSet(n, state);
                break;
            }
            case 150: {
                this._addFunction(n.getFirstChild(), state);
                break;
            }
            case 151: {
                this._addFunction(n.getFirstChild(), state);
                break;
            }
            case 108: {
                this._addFunction(n, state);
                break;
            }
            case 128: {
                this._addBlock(n, state);
                break;
            }
            case 132: {
                Convert._assertOne(n);
                this._append("returnee = ", n);
                this._hasReturn = true;
                this._add(n.getFirstChild(), state);
                this._append(";\n", n);
                break;
            }
            case 4: {
                boolean last;
                boolean bl = last = state._depth <= 1 && n.getNext() == null;
                if (!last) {
                    this._append("if ( true ) { ", n);
                }
                this._append("returnee = ", n);
                if (n.getFirstChild() != null) {
                    Convert._assertOne(n);
                    this._add(n.getFirstChild(), state);
                } else {
                    this._append(" null ", n);
                }
                this._append(";\nscope.removeFromParent();\n", n);
                this._append("return returnee", n);
                this._append("; /* explicit return */", n);
                if (!last) {
                    this._append("}", n);
                }
                this._append("\n", n);
                break;
            }
            case 27: {
                Convert._assertOne(n);
                this._append("JS_bitnot( ", n);
                this._add(n.getFirstChild(), state);
                this._append(" ) ", n);
                break;
            }
            case 101: {
                this._append(" JSInternalFunctions.self( JS_evalToBool( ", n);
                this._add(n.getFirstChild(), state);
                this._append(" ) ? ( ", n);
                this._add(n.getFirstChild().getNext(), state);
                this._append(" ) : ( ", n);
                this._add(n.getFirstChild().getNext().getNext(), state);
                this._append(" ) ) ", n);
                break;
            }
            case 28: {
                Convert._assertOne(n);
                this._append("JSNumber.getNumber( ", n);
                this._add(n.getFirstChild(), state);
                this._append(" ) ", n);
                break;
            }
            case 21: {
                if (state.isNumberAndLocal(n.getFirstChild()) && state.isNumberAndLocal(n.getFirstChild().getNext())) {
                    this._append("(", n);
                    this._add(n.getFirstChild(), state);
                    this._append(" + ", n);
                    this._add(n.getFirstChild().getNext(), state);
                    this._append(")", n);
                    break;
                }
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 46: 
            case 47: {
                this._append("JS_" + Token.name((int)n.getType()).toLowerCase(), n);
                this._append("( ", n);
                this._add(n.getFirstChild(), state);
                this._append(" , ", n);
                this._add(n.getFirstChild().getNext(), state);
                this._append(" )\n ", n);
                break;
            }
            case 7: {
                this._addIFNE(n, state);
                break;
            }
            case 131: {
                this._addLoop(n, state);
                break;
            }
            case 127: {
                if (n.getFirstChild() == null) break;
                Debug.printTree(n, 0);
                throw new RuntimeException("not really empty");
            }
            case 129: {
                this._append(n.getString() + ":", n);
                break;
            }
            case 119: {
                this._append("break " + n.getString() + ";\n", n);
                break;
            }
            case 120: {
                this._append("if ( true ) continue " + n.getString() + ";\n", n);
                break;
            }
            case 116: {
                this._assertLoopingConstructs();
                this._append("while( false || JS_evalToBool( ", n);
                this._add(n.getFirstChild(), state);
                this._append(" ) ){ ", n);
                this._add(n.getFirstChild().getNext(), state);
                this._append(" }\n", n);
                break;
            }
            case 118: {
                this._addFor(n, state);
                break;
            }
            case 130: {
                break;
            }
            case 26: {
                Convert._assertOne(n);
                this._append(" JS_not( ", n);
                this._add(n.getFirstChild(), state);
                this._append(" ) ", n);
                break;
            }
            case 103: 
            case 104: {
                Node cc = n.getFirstChild();
                if (cc.getNext() == null) {
                    throw new RuntimeException("what?");
                }
                if (cc.getNext().getNext() != null) {
                    throw new RuntimeException("what?");
                }
                String mod = n.getType() == 104 ? "and" : "or";
                this._append("JSInternalFunctions.self( scope." + mod + "Save( ", n);
                this._add(cc, state);
                this._append(" ) ? scope.get" + mod + "Save() : ( ", n);
                this._add(cc.getNext(), state);
                this._append(" ) ) ", n);
                break;
            }
            case 140: {
                Convert._assertOne(n);
                if (n.getFirstChild().getType() != 80) {
                    throw new RuntimeException("only know about LOCAL_BLOCK with try");
                }
                this._addTry(n.getFirstChild(), state);
                break;
            }
            case 64: 
            case 134: {
                break;
            }
            case 50: {
                this._append("if ( true ) _throw( ", n);
                this._add(n.getFirstChild(), state);
                this._append(" ); ", n);
                break;
            }
            case 53: {
                this._append("JS_instanceof( ", n);
                this._add(n.getFirstChild(), state);
                this._append(" , ", n);
                this._add(n.getFirstChild().getNext(), state);
                this._append(" ) ", n);
                if (n.getFirstChild().getNext().getNext() == null) break;
                throw new RuntimeException("something is wrong");
            }
            case 31: {
                if (n.getFirstChild().getType() == 49) {
                    this._append("scope", n);
                } else {
                    this._addAsJSObject(n.getFirstChild(), state);
                }
                this._append(".removeField( ", n);
                this._add(n.getFirstChild().getNext(), state);
                this._append(" ) ", n);
                break;
            }
            case 69: {
                this._addAsJSObject(n.getFirstChild().getFirstChild(), state);
                this._append(".removeField( ", n);
                this._add(n.getFirstChild(), state);
                this._append(" )", n);
                break;
            }
            case 113: {
                this._addSwitch(n, state);
                break;
            }
            case 88: {
                this._append("JS_comma( ", n);
                boolean first = true;
                for (Node inner = n.getFirstChild(); inner != null; inner = inner.getNext()) {
                    if (first) {
                        first = false;
                    } else {
                        this._append(" , ", n);
                    }
                    this._append("\n ( ", n);
                    this._add(inner, state);
                    this._append(" )\n ", n);
                }
                this._append(" ) ", n);
                break;
            }
            case 52: {
                this._addAsJSObject(n.getFirstChild().getNext(), state);
                this._append(".containsKey( ", n);
                this._add(n.getFirstChild(), state);
                this._append(".toString() ) ", n);
                break;
            }
            case 29: {
                this._append("JS_mul( -1 , ", n);
                this._add(n.getFirstChild(), state);
                this._append(" )", n);
                break;
            }
            case 2: {
                this._append("scope.enterWith( (JSObject)", n);
                this._add(n.getFirstChild(), state);
                this._append(" );", n);
                break;
            }
            case 3: {
                this._append("scope.leaveWith();", n);
                break;
            }
            case 122: {
                this._add(n.getFirstChild(), state);
                break;
            }
            case 145: {
                this._addAsJSObject(n.getFirstChild(), state);
                this._append(".get( new ed.js.e4x.Query( ", n);
                Node n2 = n.getFirstChild().getNext();
                switch (n2.getFirstChild().getType()) {
                    case 67: {
                        this._append("\"@\" + ", n);
                        this._add(n2.getFirstChild().getFirstChild(), state);
                        break;
                    }
                    case 39: {
                        this._append("\"" + n2.getFirstChild().getString() + "\"", n);
                    }
                }
                this._append(" , ", n);
                this._add(n2.getFirstChild().getNext(), state);
                this._append(" + \"\" , ", n);
                String comp = Token.name((int)n2.getType());
                this._append("\"" + comp + "\" ) ) ", n);
                break;
            }
            case 73: {
                this._append("((ed.js.e4x.ENode.Cons)scope.get( \"XML\")).setAndGetDefaultNamespace( ", n);
                this._add(n.getFirstChild(), state);
                this._append(")", n);
                break;
            }
            default: {
                Debug.printTree(n, 0);
                throw new RuntimeException("can't handle : " + n.getType() + ":" + Token.name((int)n.getType()) + ":" + n.getClass().getName() + " line no : " + n.getLineno());
            }
        }
    }

    private void _addAsJSObject(Node n, State state) {
        if (n.getType() == 40) {
            this._append("(new JSNumber( " + n.getDouble() + "))", n);
            return;
        }
        this._append("JS_toJSObject( ", n);
        this._add(n, state);
        this._append(")", n);
    }

    private void _addDotQuery(Node n, State state) {
        this._append("(new ed.js.e4x.E4X.Query(", n);
        String s = Token.name((int)n.getType());
        Node t = n.getFirstChild();
        switch (t.getType()) {
            case 67: {
                this._append("\"@\" + ", n);
                this._add(t.getFirstChild().getFirstChild(), state);
                break;
            }
            default: {
                throw new RuntimeException("don't know how to handle " + Token.name((int)t.getType()) + " in a DOTQUERY");
            }
        }
        this._append(" , ", n);
        this._add(n.getFirstChild().getNext(), state);
        this._append("))", n);
    }

    private void _addSwitch(Node n, State state) {
        this._assertType(n, 113);
        Node caseDefault = ((Node.Jump)n).getDefault();
        String switcherVar = "switcher" + this._rand();
        this._append("int " + switcherVar + " = -1;\n", n);
        Node caseArea = n.getFirstChild();
        String val = "val" + this._rand();
        this._append("Object " + val + " = ", n);
        this._add(caseArea, state);
        this._append(" ; \n ", n);
        n = n.getNext();
        this._assertType(n, 5);
        n = n.getNext();
        ArrayList<Node> targets = new ArrayList<Node>();
        for (caseArea = caseArea.getNext(); caseArea != null; caseArea = caseArea.getNext()) {
            Node target = ((Node.Jump)caseArea).target;
            int pos = targets.size();
            targets.add(target);
            this._append("if ( JS_sheq( " + val + " , ", caseArea);
            this._add(caseArea.getFirstChild(), state);
            this._append(" ) ) {\n " + switcherVar + " = " + pos + "; \n ", caseArea);
            this._append(" } \n ", caseArea);
            this._append("else ", caseArea);
        }
        this._append("; // default: switcher set to -1 \n", n);
        this._append("switch( " + switcherVar + " ) { \n", n);
        while (n != null && n.getNext() != null) {
            int pos = targets.indexOf(n);
            if (n == caseDefault) {
                this._append(" default: \n", n);
            } else {
                assert (pos >= 0);
                this._append(" case " + pos + ": \n", n);
            }
            n = n.getNext();
            this._assertType(n, 128);
            this._add(n, state);
            n = n.getNext();
        }
        this._append(" } \n", n);
    }

    private void _createRef(Node n, State state) {
        if (n.getType() == 39 || n.getType() == 55) {
            if (state.useLocalVariable(n.getString())) {
                throw new RuntimeException("can't create a JSRef from a local variable : " + n.getString());
            }
            this._append(" new JSRef( scope , null , ", n);
            this._append("\"" + n.getString() + "\"", n);
            this._append(" ) ", n);
            return;
        }
        if (n.getType() == 33 || n.getType() == 36) {
            this._append(" new JSRef( scope , (JSObject)", n);
            this._add(n.getFirstChild(), state);
            this._append(" , ", n);
            this._add(n.getFirstChild().getNext(), state);
            this._append(" ) ", n);
            return;
        }
        throw new RuntimeException("can't handle");
    }

    private void _addTry(Node n, State state) {
        this._assertType(n, 80);
        Node mainBlock = n.getFirstChild();
        this._assertType(mainBlock, 128);
        this._append("try { \n ", n);
        this._add(mainBlock, state);
        this._append(" \n } \n ", n);
        n = mainBlock.getNext();
        String num = this._rand();
        String javaEName = "javaEEE" + num;
        String javaName = "javaEEEO" + num;
        while (n != null) {
            if (n.getType() == 124) {
                this._assertType(n.getFirstChild(), 128);
                this._append("finally { \n", n);
                this._add(n.getFirstChild(), state);
                this._append(" \n } \n ", n);
                n = n.getNext();
                continue;
            }
            if (n.getType() == 140 && n.getFirstChild().getType() == 57) {
                Node c;
                this._append(" \n catch ( Exception " + javaEName + " ){ \n ", n);
                this._append(" \n Object " + javaName + " = ( " + javaEName + " instanceof JSException ) ? " + "  ((JSException)" + javaEName + ").getObject() : " + javaEName + " ; \n", n);
                this._append("try { scope.pushException( " + javaEName + " ); \n", n);
                Node catchScope = n.getFirstChild();
                while (catchScope != null && (c = catchScope).getType() == 57) {
                    boolean isIF;
                    Node b = c.getNext();
                    this._assertType(b, 128);
                    this._assertType(b.getFirstChild(), 2);
                    this._assertType(b.getFirstChild().getNext(), 122);
                    b = b.getFirstChild().getNext().getFirstChild();
                    this._assertType(b, 128);
                    String jsName = c.getFirstChild().getString();
                    this._append(" scope.put( \"" + jsName + "\" , " + javaName + " , true ); ", c);
                    b = b.getFirstChild();
                    boolean bl = isIF = b.getType() == 7;
                    if (isIF) {
                        this._append("\n if ( " + javaEName + " != null && JS_evalToBool( ", b);
                        this._add(b.getFirstChild(), state);
                        this._append(" ) ){ \n ", b);
                        b = b.getNext().getFirstChild();
                    }
                    while (b != null && b.getType() != 3) {
                        this._add(b, state);
                        b = b.getNext();
                    }
                    this._append("if ( true ) " + javaEName + " = null ;\n", b);
                    if (isIF) {
                        this._append("\n } \n ", b);
                    }
                    catchScope = catchScope.getNext().getNext();
                }
                this._append("if ( " + javaEName + " != null ){ if ( " + javaEName + " instanceof RuntimeException ){ throw (RuntimeException)" + javaEName + ";} throw new JSException( " + javaEName + ");}\n", n);
                this._append(" } finally { scope.popException(); } ", n);
                this._append("\n } \n ", n);
                n = n.getNext();
                continue;
            }
            if (n.getType() == 5 || n.getType() == 130 || n.getType() == 134) {
                n = n.getNext();
                continue;
            }
            if (n.getType() == 51) {
                n = n.getNext();
                continue;
            }
            throw new RuntimeException("what : " + Token.name((int)n.getType()));
        }
    }

    private void _addFor(Node n, State state) {
        this._assertType(n, 118);
        int numChildren = Convert.countChildren(n);
        if (numChildren == 4) {
            this._assertLoopingConstructs();
            this._append("\n for ( ", n);
            if (n.getFirstChild().getType() == 128) {
                Node temp = n.getFirstChild().getFirstChild();
                while (temp != null) {
                    if (temp.getType() == 132) {
                        this._add(temp.getFirstChild(), state);
                    } else {
                        this._add(temp, state);
                    }
                    if ((temp = temp.getNext()) == null) continue;
                    this._append(" , ", n);
                }
            } else if (n.getFirstChild().getType() != 127) {
                this._add(n.getFirstChild(), state);
            }
            this._append(" ; \n JS_evalToBool( ", n);
            if (n.getFirstChild().getNext().getType() == 127) {
                this._append("true", n);
            } else {
                this._add(n.getFirstChild().getNext(), state);
            }
            this._append(" ) ; \n", n);
            this._add(n.getFirstChild().getNext().getNext(), state);
            this._append(" )\n ", n);
            this._append(" { \n ", n);
            this._add(n.getFirstChild().getNext().getNext().getNext(), state);
            this._append(" } \n ", n);
        } else if (numChildren == 3) {
            String name = n.getFirstChild().getString();
            String tempName = name + "TEMP";
            if (n.getFirstChild().getFirstChild() != null && n.getFirstChild().getFirstChild().getType() == 59) {
                this._append("\n for ( Object ", n);
                this._append(tempName, n);
                this._append(" : JSInternalFunctions.JS_collForForEach( ", n);
                this._add(n.getFirstChild().getNext(), state);
                this._append(" ) ){\n ", n);
                if (state.useLocalVariable(name) && state.hasSymbol(name)) {
                    this._append(name + " = " + tempName + "; ", n);
                } else {
                    this._append("scope.put( \"" + name + "\" , " + tempName + " , true );\n", n);
                }
                this._add(n.getFirstChild().getNext().getNext(), state);
                this._append("\n}\n", n);
            } else {
                this._append("\n for ( String ", n);
                this._append(tempName, n);
                this._append(" : JSInternalFunctions.JS_collForFor( ", n);
                this._add(n.getFirstChild().getNext(), state);
                this._append(" ) ){\n ", n);
                if (state.useLocalVariable(name) && state.hasSymbol(name)) {
                    this._append(name + " = new JSString( " + tempName + ") ; ", n);
                } else {
                    this._append("scope.put( \"" + name + "\" , new JSString( " + tempName + " ) , true );\n", n);
                }
                this._add(n.getFirstChild().getNext().getNext(), state);
                this._append("\n}\n", n);
            }
        } else {
            throw new RuntimeException("wtf?");
        }
    }

    private void _addLoop(Node n, State state) {
        this._assertType(n, 131);
        Node theLoop = n;
        n = n.getFirstChild();
        Node[] nodes = null;
        nodes = Convert._matches(n, _while1);
        if (nodes != null) {
            Node main = nodes[1];
            Node predicate = nodes[5];
            this._append("while ( JS_evalToBool( ", theLoop);
            this._add(predicate.getFirstChild(), state);
            this._append(" ) ) ", theLoop);
            this._add(main, state);
        } else {
            nodes = Convert._matches(n, _doWhile1);
            if (nodes != null) {
                Node main = nodes[1];
                Node predicate = nodes[3];
                this._assertType(predicate, 6);
                this._append("do { \n ", theLoop);
                this._add(main, state);
                this._append(" } \n while ( false || JS_evalToBool( ", n);
                this._add(predicate.getFirstChild(), state);
                this._append(" ) );\n ", n);
            } else {
                throw new RuntimeException("what?");
            }
        }
    }

    private void _addIFNE(Node n, State state) {
        this._assertType(n, 7);
        Node.Jump theIf = (Node.Jump)n;
        Convert._assertOne(n);
        Node ifBlock = n.getNext();
        this._append("if ( JS_evalToBool( ", n);
        this._add(n.getFirstChild(), state);
        this._append(" ) ){\n", n);
        this._add(ifBlock, state);
        this._append("}\n", n);
        n = n.getNext().getNext();
        if (n.getType() == 130) {
            if (n.getNext() != null) {
                throw new RuntimeException("something is wrong");
            }
            return;
        }
        this._assertType(n, 5);
        this._assertType(n.getNext(), 130);
        if (theIf.target.hashCode() != n.getNext().hashCode()) {
            throw new RuntimeException("hashes don't match");
        }
        n = n.getNext().getNext();
        this._append(" else if ( true ) { ", n);
        this._add(n, state);
        this._append(" } \n", n);
        this._assertType(n.getNext(), 130);
        if (n.getNext().getNext() != null) {
            throw new RuntimeException("something is wrong");
        }
    }

    private void _addFunctionNodes(ScriptOrFnNode sn, State state) {
        HashSet<Integer> baseIds = new HashSet<Integer>();
        for (Node temp = sn.getFirstChild(); temp != null; temp = temp.getNext()) {
            int prop;
            if (temp.getType() != 108 || temp.getString() == null || (prop = temp.getIntProp(1, -1)) < 0) continue;
            baseIds.add(prop);
        }
        for (int i = 0; i < sn.getFunctionCount(); ++i) {
            boolean anon;
            FunctionNode fn = sn.getFunctionNode(i);
            this._setLineNumbers((Node)fn, (ScriptOrFnNode)fn);
            String name = fn.getFunctionName();
            String anonName = "tempFunc_" + this._id + "_" + i + "_" + this._methodId++;
            int funcType = fn.getFunctionType();
            boolean bl = anon = name.length() == 0;
            if (anon || funcType == 2) {
                name = anonName;
            }
            if (this.D) {
                System.out.println("***************");
                System.out.println(i + " : " + name);
            }
            String useName = name;
            if (!anon && !baseIds.contains(i)) {
                useName = anonName;
                state._nonRootFunctions.add(i);
            }
            state._functionIdToName.put(i, useName);
            state._functionIdToType.put(i, funcType);
            this._setVar(useName, (Node)fn, state, anon);
            this._append("; \n scope.getFunction( \"" + useName + "\" ).setName( \"" + name + "\" );\n\n", (Node)fn);
        }
    }

    private void _addFunction(Node n, State state) {
        int i;
        String foo3;
        if (!(n instanceof FunctionNode)) {
            if (n.getString() != null && n.getString().length() != 0) {
                int id = n.getIntProp(1, -1);
                if (state._nonRootFunctions.contains(id)) {
                    this._append("scope.set( \"" + n.getString() + "\" , scope.get( \"" + state._functionIdToName.get(id) + "\" ) )", n);
                    if (state._functionIdToType.get(id) != 2) {
                        this._append(";", n);
                    }
                }
                return;
            }
            this._append(this.getFunc(n, state), n);
            return;
        }
        Convert._assertOne(n);
        FunctionNode fn = (FunctionNode)n;
        FunctionInfo fi = FunctionInfo.create(fn);
        state = state.child();
        state._fi = fi;
        boolean hasArguments = fi.usesArguemnts();
        this._append("new JSFunctionCalls" + fn.getParamCount() + "( scope , null ){ \n", n);
        this._append("protected void init(){ super.init(); _sourceLanguage = getFileLanguage(); \n ", n);
        this._append("_arguments = new JSArray();\n", n);
        for (int i2 = 0; i2 < fn.getParamCount(); ++i2) {
            String foo2 = fn.getParamOrVarName(i2);
            this._append("_arguments.add( \"" + foo2 + "\" );\n", n);
        }
        this._append("_globals = new JSArray();\n", n);
        for (String g : fi._globals) {
            this._append("_globals.add( \"" + g + "\" );\n", n);
        }
        this._append("}\n", n);
        String callLine = "public Object call( final Scope passedIn ";
        String varSetup = "";
        ArrayList<String> paramNames = new ArrayList<String>();
        for (int i3 = 0; i3 < fn.getParamCount(); ++i3) {
            foo3 = fn.getParamOrVarName(i3);
            if (paramNames.contains(foo3)) {
                int index = paramNames.indexOf(foo3);
                paramNames.remove(index);
                paramNames.add(index, foo3 + this._rand());
            }
            paramNames.add(foo3);
        }
        for (String foo3 : paramNames) {
            callLine = callLine + " , ";
            callLine = callLine + " Object " + foo3;
            if (!state.useLocalVariable(foo3)) {
                callLine = callLine + "INNNNN";
                varSetup = varSetup + " \nscope.put(\"" + foo3 + "\"," + foo3 + "INNNNN , true  );\n ";
                if (hasArguments) {
                    varSetup = varSetup + "arguments.add( " + foo3 + "INNNNN );\n";
                }
            } else {
                state.addSymbol(foo3);
                if (hasArguments) {
                    varSetup = varSetup + "arguments.add( " + foo3 + " );\n";
                }
            }
            callLine = callLine + " ";
        }
        callLine = callLine + " , Object ___extra[] ){\n";
        this._append(callLine + " final Scope scope = usePassedInScope() ? passedIn : new Scope( \"func scope\" , getScope() , passedIn , getFileLanguage() ); ", n);
        if (hasArguments) {
            this._append("JSArray arguments = new JSArray();\n", n);
            this._append("arguments.set( \"callee\" , this );\n", n);
            this._append("scope.put( \"arguments\" , arguments , true );\n", n);
        }
        for (i = 0; i < fn.getParamCount(); ++i) {
            foo3 = fn.getParamOrVarName(i);
            String javaName = foo3 + (state.useLocalVariable(foo3) ? "" : "INNNNN");
            Node defArg = fn.getDefault(foo3);
            if (defArg == null) continue;
            this._append("if ( null == " + javaName + " ) ", defArg);
            this._append(javaName + " = ", defArg);
            this._add(defArg, state);
            this._append(";\n", defArg);
        }
        this._append(varSetup, n);
        if (hasArguments) {
            this._append("if ( ___extra != null ) for ( Object TTTT : ___extra ) arguments.add( TTTT );\n", n);
            this._append("{ Integer numArgs = _lastStart.get(); _lastStart.set( null ); while( numArgs != null && arguments.size() > numArgs && arguments.get( arguments.size() -1 ) == null ) arguments.remove( arguments.size() - 1 ); }", n);
        }
        for (i = fn.getParamCount(); i < fn.getParamAndVarCount(); ++i) {
            foo3 = fn.getParamOrVarName(i);
            if (state.useLocalVariable(foo3)) {
                state.addSymbol(foo3);
                if (state.isNumber(foo3)) {
                    this._append("double " + foo3 + " = 0;\n", n);
                    continue;
                }
                this._append("Object " + foo3 + " = null;\n", n);
                continue;
            }
            this._append("scope.put( \"" + foo3 + "\" , null , true );\n", n);
        }
        this._append("\nObject returnee = null;\n", n);
        this._addFunctionNodes((ScriptOrFnNode)fn, state);
        this._add(n.getFirstChild(), (ScriptOrFnNode)fn, state);
        this._append("}\n", n);
        int myStringId = this._strings.size();
        this._strings.add(this.getSource(fn));
        this._append("\t public String getSourceCode(){ return _strings[" + myStringId + "].toString(); }", (Node)fn);
        this._append("\t public String toString(){ return _strings[" + myStringId + "].toString(); }", (Node)fn);
        this._append("}\n", n);
    }

    private void _addBlock(Node n, State state) {
        Node c;
        this._assertType(n, 128);
        if (n.getFirstChild() == null) {
            this._append("{}", n);
            return;
        }
        boolean bogusBrace = true;
        for (c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (c.getType() != 132) {
                bogusBrace = false;
                break;
            }
            if (c.getFirstChild().getNext() != null) {
                bogusBrace = false;
                break;
            }
            if (c.getFirstChild().getType() == 56) continue;
            bogusBrace = false;
            break;
        }
        boolean bl = bogusBrace = bogusBrace || n.getFirstChild().getNext() == null && n.getFirstChild().getType() == 132 && n.getFirstChild().getFirstChild() == null;
        if (bogusBrace) {
            for (c = n.getFirstChild(); c != null; c = c.getNext()) {
                this._add(c, state);
            }
            return;
        }
        boolean endReturn = n.getLastChild() != null && n.getLastChild().getType() == 64;
        ++state._depth;
        this._append("{", n);
        for (Node child = n.getFirstChild(); !(child == null || endReturn && child.getType() == 3); child = child.getNext()) {
            this._add(child, state);
            if (child.getType() == 7 || child.getType() == 113) break;
        }
        if (endReturn) {
            this._append("\n\nif ( true ){ return returnee; }\n\n", n);
        }
        this._append("}", n);
        --state._depth;
    }

    private void _addSet(Node n, State state) {
        this._assertType(n, 8);
        Node name = n.getFirstChild();
        this._setVar(name.getString(), name.getNext(), state);
    }

    private void _addVar(Node n, State state) {
        this._assertType(n, 121);
        Convert._assertOne(n);
        Node name = n.getFirstChild();
        Convert._assertOne(name);
        this._setVar(name.getString(), name.getFirstChild(), state);
    }

    private void _addCall(Node n, State state) {
        this._addCall(n, state, false);
    }

    private void _addCall(Node n, State state, boolean isClass) {
        boolean useThis;
        Node name = n.getFirstChild();
        boolean bl = useThis = (name.getType() == 33 || name.getType() == 36) && !isClass;
        if (useThis) {
            this._append("scope.clearThisNormal( ", n);
        }
        Boolean[] inc = new Boolean[]{true};
        String f = this.getFunc(name, state, isClass, inc);
        this._append((inc[0] != false ? f : "") + ".call( scope" + (isClass ? ".newThis( " + f + " )" : "") + " ", n);
        int numParam = 0;
        Node param = name.getNext();
        while (param != null) {
            this._append(" , ", param);
            this._add(param, state);
            param = param.getNext();
            ++numParam;
        }
        if (numParam <= 28) {
            this._append(" , new Object[0] ", n);
        }
        this._append(" ) ", n);
        if (useThis) {
            this._append(" ) ", n);
        }
    }

    private void _setVar(String name, Node val, State state) {
        this._setVar(name, val, state, false);
    }

    private void _setVar(String name, Node val, State state, boolean local) {
        if (state.useLocalVariable(name) && state.hasSymbol(name)) {
            boolean prim = state.isPrimitive(name);
            if (!prim) {
                this._append("JSInternalFunctions.self( ", val);
            }
            this._append(name + " = ", val);
            this._add(val, state);
            this._append("\n", val);
            if (!prim) {
                this._append(")\n", val);
            }
            return;
        }
        this._append("scope.put( \"" + name + "\" , ", val);
        if (val.getType() == 108 && !(val instanceof FunctionNode) && val.getString().length() > 0) {
            this._append("scope.get( \"" + state._functionIdToName.get(val.getIntProp(1, -1)) + "\" )", val);
        } else {
            this._add(val, state);
        }
        this._append(" , " + local + "  ) ", val);
    }

    static int countChildren(Node n) {
        int num = 0;
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            ++num;
        }
        return num;
    }

    public static void _assertOne(Node n) {
        if (n.getFirstChild() == null) {
            Debug.printTree(n, 0);
            throw new RuntimeException("no child");
        }
        if (n.getFirstChild().getNext() != null) {
            Debug.printTree(n, 0);
            throw new RuntimeException("more than 1 child");
        }
    }

    public void _assertType(Node n, int type) {
        Convert._assertType(n, type, this);
    }

    public static void _assertType(Node n, int type, Convert c) {
        if (type == n.getType()) {
            return;
        }
        String msg = "wrong type. was : " + Token.name((int)n.getType()) + " should be " + Token.name((int)type);
        if (c != null) {
            msg = msg + " file : " + c._name + " : " + (c._nodeToSourceLine.get(n) + 1);
        }
        throw new RuntimeException(msg);
    }

    void _assertLoopingConstructs() {
        if (this._options.allowLoopingConstructs()) {
            return;
        }
        throw new RuntimeException("looping constructs not allowed");
    }

    private void _setLineNumbers(Node startN, ScriptOrFnNode startSOF) {
        IdentitySet seen = new IdentitySet();
        LinkedList<Pair> overallTODO = new LinkedList<Pair>();
        overallTODO.add(new Pair((Object)startN, (Object)startSOF));
        while (overallTODO.size() > 0) {
            Pair temp = (Pair)overallTODO.remove(0);
            Node n = (Node)temp.first;
            ScriptOrFnNode sof = (ScriptOrFnNode)temp.second;
            assert (sof != null);
            int line = n.getLineno();
            if (line < 0) {
                throw new RuntimeException("something is wrong");
            }
            LinkedList<Node> todo = new LinkedList<Node>();
            this._nodeToSourceLine.put(n, line);
            this._nodeToSOR.put(n, sof);
            if (n.getFirstChild() != null) {
                todo.add(n.getFirstChild());
            }
            if (n.getNext() != null) {
                todo.add(n.getNext());
            }
            while (todo.size() > 0) {
                n = (Node)todo.remove(0);
                if (seen.contains((Object)n)) continue;
                seen.add((Object)n);
                if (n.getLineno() > 0) {
                    overallTODO.add(new Pair((Object)n, (Object)(n instanceof ScriptOrFnNode ? (ScriptOrFnNode)n : sof)));
                    continue;
                }
                this._nodeToSourceLine.put(n, line);
                this._nodeToSOR.put(n, sof);
                if (n.getFirstChild() != null) {
                    todo.add(n.getFirstChild());
                }
                if (n.getNext() == null) continue;
                todo.add(n.getNext());
            }
        }
    }

    private void _append(String s, Node n) {
        this._mainJavaCode.append(s);
        if (n == null) {
            return;
        }
        int numLines = 0;
        int max = s.length();
        for (int i = 0; i < max; ++i) {
            if (s.charAt(i) != '\n') continue;
            ++numLines;
        }
        int start = this._currentLineNumber;
        int end = this._currentLineNumber + numLines;
        for (int i = start; i < end; ++i) {
            List<Node> l = this._javaCodeToLines.get(i);
            if (l == null) {
                l = new ArrayList<Node>();
                this._javaCodeToLines.put(i, l);
            }
            l.add(n);
        }
        this._currentLineNumber = end;
    }

    private String getFunc(Node n, State state) {
        return this.getFunc(n, state, false, null);
    }

    private String getFunc(Node n, State state, boolean isClass, Boolean[] inc) {
        int type;
        if (n.getClass().getName().indexOf("StringNode") < 0) {
            if (!(n.getType() != 33 && n.getType() != 36 || isClass)) {
                this._append("scope.getFunctionAndSetThis( ", n);
                this._add(n.getFirstChild(), state);
                this._append(" , String.valueOf( ", n);
                this._append(" JSNumericFunctions.fixType( ", n);
                this._add(n.getFirstChild().getNext(), state);
                this._append(" , true )", n);
                this._append(" ) ) ", n);
                return "";
            }
            int start = this._mainJavaCode.length();
            this._append("((JSFunction )", n);
            this._add(n, state);
            this._append(")", n);
            int end = this._mainJavaCode.length();
            if (isClass) {
                if (inc == null) {
                    throw new RuntimeException("inc is null and can't be here");
                }
                inc[0] = false;
                return "(" + this._mainJavaCode.substring(start, end) + ")";
            }
            return "";
        }
        String name = n.getString();
        int id = n.getIntProp(1, -1);
        int n2 = type = id == -1 ? -1 : state._functionIdToType.get(id);
        if (name == null || name.length() == 0 || type == 2) {
            if (id == -1) {
                throw new RuntimeException("no name or id for this thing");
            }
            name = state._functionIdToName.get(id);
            if (name == null || name.length() == 0) {
                throw new RuntimeException("no name for this id ");
            }
        }
        if (state.hasSymbol(name)) {
            return "(( JSFunction)" + name + ")";
        }
        return "scope.getFunction( \"" + name + "\" )";
    }

    public String getClassName() {
        return this._className;
    }

    public String getClassString() {
        StringBuilder buf = new StringBuilder();
        buf.append("package ed.js.gen;\n");
        buf.append("import ed.js.*;\n");
        buf.append("import ed.js.func.*;\n");
        buf.append("import ed.js.engine.Scope;\n");
        buf.append("import ed.js.engine.JSCompiledScript;\n");
        buf.append("public class ").append(this._className).append(" extends JSCompiledScript {\n");
        buf.append("\t protected void myInit(){\n");
        if (this._loadOnce) {
            buf.append("\t\t _loadOnce = true; \n");
        }
        buf.append("\t} \n");
        buf.append("\tpublic Object _call( Scope scope , Object extra[] ) throws Exception {\n");
        buf.append("\t\t final Scope passedIn = scope; \n");
        if (!this._options.createNewScope()) {
            buf.append("\t\t // not creating new scope for execution as we're being run in the context of an eval\n");
        } else {
            String cleanName = FileUtil.clean((String)this._name);
            buf.append("\t\t if ( ! usePassedInScope() ){\n");
            buf.append("\t\t\t scope = new Scope( \"compiled script for:" + cleanName + "\" , scope , null , getFileLanguage() ); \n");
            buf.append("\t\t }\n");
            buf.append("\t\t scope.putAll( getTLScope() );\n");
        }
        buf.append("\t\t JSArray arguments = new JSArray(); scope.put( \"arguments\" , arguments , true );\n ");
        buf.append("\t\t if ( extra != null ) for ( Object TTTT : extra ) arguments.add( TTTT );\n");
        this._preMainLines = StringUtil.count((String)buf.toString(), (String)"\n");
        buf.append((CharSequence)this._mainJavaCode);
        buf.append("\n\n\t}\n\n");
        buf.append("\n}\n\n");
        return buf.toString();
    }

    public JSFunction get() {
        if (this._it != null) {
            return this._it;
        }
        try {
            Class<?> c = CompileUtil.compile(DEFAULT_PACKAGE, this.getClassName(), this.getClassString(), this);
            JSCompiledScript it = (JSCompiledScript)c.newInstance();
            this._scriptInfo.setup(this);
            it._scriptInfo = this._scriptInfo;
            it._regex = this._regex;
            it._strings = new String[this._strings.size()];
            for (int i = 0; i < this._strings.size(); ++i) {
                it._strings[i] = this._strings.get(i);
            }
            it.setName(this._name);
            this._it = it;
            StackTraceHolder.getInstance().set(this._fullClassName, (StackTraceFixer)this._scriptInfo);
            StackTraceHolder.getInstance().setPackage("ed.js", (StackTraceFixer)this._scriptInfo);
            StackTraceHolder.getInstance().setPackage("ed.js.func", (StackTraceFixer)this._scriptInfo);
            StackTraceHolder.getInstance().setPackage("ed.js.engine", (StackTraceFixer)this._scriptInfo);
            return this._it;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            this.fixStack(re);
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fixStack(e);
            throw new RuntimeException(e);
        }
    }

    public void fixStack(Throwable e) {
        StackTraceHolder.getInstance().fix(e);
    }

    Node _getNodeFromJavaLine(int line) {
        List<Node> nodes = this._javaCodeToLines.get(line = line - this._preMainLines - 1);
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        return nodes.get(0);
    }

    public int _mapLineNumber(int line) {
        Node n = this._getNodeFromJavaLine(line);
        if (n == null) {
            return -1;
        }
        Integer i = this._nodeToSourceLine.get(n);
        if (i == null) {
            return -1;
        }
        return i + 1;
    }

    public void _debugLineNumber(int line) {
        System.out.println("-----");
        for (int temp = Math.max(0, line - 5); temp < line + 5; ++temp) {
            System.out.println("\t" + temp + "->" + this._mapLineNumber(temp) + " || " + this._getNodeFromJavaLine(temp));
        }
        System.out.println("-----");
    }

    String getSource(FunctionNode fn) {
        int start = fn.getEncodedSourceStart();
        int end = fn.getEncodedSourceEnd();
        String encoded = this._encodedSource.substring(start, end);
        String realSource = Decompiler.decompile((String)encoded, (int)0, (UintMap)new UintMap());
        return realSource;
    }

    private String getStringCode(String s) {
        int stringId = this._strings.size();
        this._strings.add(s);
        return "_string(" + stringId + ")";
    }

    public boolean hasReturn() {
        return this._hasReturn;
    }

    public int findStringId(String s) {
        for (int i = 0; i < this._strings.size(); ++i) {
            if (!this._strings.get(i).equals(s)) continue;
            return i;
        }
        return -1;
    }

    String _rand() {
        return String.valueOf(this._random.nextInt(1000000));
    }

    int _randNonNegativeInt() {
        return Math.abs(this._random.nextInt());
    }

    static Random _random(String name) {
        return new Random(name.hashCode());
    }

    private static Node[] _matches(Node n, int[] types2) {
        Node[] foo = new Node[types2.length];
        for (int i = 0; i < types2.length; ++i) {
            foo[i] = n;
            if (types2[i] > 0 && n.getType() != types2[i]) {
                return null;
            }
            n = n.getNext();
        }
        return n == null ? foo : null;
    }

    static synchronized int _getNumForClass(String name, String source) {
        ClassInfo ci = _classes.get(name);
        if (ci == null) {
            ci = new ClassInfo();
            _classes.put(name, ci);
        }
        return ci.getNum(source);
    }

    static class ClassInfo {
        final MD5 _myMd5 = new MD5();
        final Map<String, Integer> _sourceToNumber = new TreeMap<String, Integer>();
        int _numSoFar = 0;

        ClassInfo() {
        }

        synchronized int getNum(String source) {
            this._myMd5.Init();
            this._myMd5.Update(source);
            String hash = this._myMd5.asHex();
            Integer num = this._sourceToNumber.get(hash);
            if (num != null) {
                return num;
            }
            num = ++this._numSoFar;
            this._sourceToNumber.put(hash, num);
            return num;
        }
    }

    static class ScriptInfo
    implements StackTraceFixer {
        final String _name;
        final String _fullClassName;
        final Language _sourceLanguage;
        final Convert _convert;
        final Map<Integer, Pair<Integer, String>> _lines = new HashMap<Integer, Pair<Integer, String>>();

        ScriptInfo(String name, String fullClassName, Language l, Convert c) {
            this._name = name;
            this._fullClassName = fullClassName;
            this._sourceLanguage = l;
            this._convert = DJS ? c : null;
        }

        public void fixStack(Throwable e) {
            StackTraceHolder.getInstance().fix(e);
        }

        public StackTraceElement fixSTElement(StackTraceElement element) {
            return this.fixSTElement(element, false);
        }

        public StackTraceElement fixSTElement(StackTraceElement element, boolean debug) {
            Pair<Integer, String> p;
            if (!element.getClassName().startsWith(this._fullClassName)) {
                return null;
            }
            if (debug) {
                System.out.println(element);
                if (this._convert != null) {
                    this._convert._debugLineNumber(element.getLineNumber());
                }
            }
            if ((p = this._lines.get(element.getLineNumber())) == null) {
                return null;
            }
            return new StackTraceElement(this._name, (String)p.second, this._name, (Integer)p.first);
        }

        public boolean removeSTElement(StackTraceElement element) {
            String s = element.toString();
            return s.contains(".call(JSFunctionCalls") || s.contains("ed.js.JSFunctionBase.call(") || s.contains("ed.js.engine.JSCompiledScript.call");
        }

        void setup(Convert c) {
            for (int i = 0; i < c._currentLineNumber + 100; ++i) {
                Node n = c._getNodeFromJavaLine(i);
                if (n == null) continue;
                int line = c._mapLineNumber(i);
                ScriptOrFnNode sof = c._nodeToSOR.get(n);
                String method = "___";
                if (sof instanceof FunctionNode) {
                    method = ((FunctionNode)sof).getFunctionName();
                }
                this._lines.put(i, (Pair<Integer, String>)new Pair((Object)line, (Object)method));
            }
        }
    }
}

