/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import ed.EDFinder;
import ed.io.FileUtil;
import ed.io.RollingNamedPipe;
import ed.io.StreamUtil;
import ed.io.WorkingFiles;
import ed.js.engine.Convert;
import ed.util.SimplePool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.jdt.internal.compiler.batch.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileUtil {
    static boolean CD;
    private static final ClassLoader _loader;
    private static final SimplePool<MyCompiler> _compilerPool;
    private static final String _globalLock = "CompileUtil-GlobalLock-123";
    private static final Set<File> _dependFiles;
    private static final String[] _possibleRoots;
    private static final String[] _dependsDirs;
    private static final RollingNamedPipe _rollingLog;

    public static String getCompileSrcDir(String pack) {
        return WorkingFiles.getTmpDir() + pack.replace('.', '/') + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> compile(String pack, String c, String source, Convert convert) throws IOException, ClassNotFoundException {
        boolean D = convert.D;
        if (CD) {
            System.err.println("compile called on : " + pack + " " + c);
        }
        if (D) {
            System.out.println(source);
        }
        File dir = new File(CompileUtil.getCompileSrcDir(pack));
        String string = _globalLock;
        synchronized (_globalLock) {
            dir.mkdirs();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            File f = new File(dir, c + ".java");
            File jarFile = new File(dir, c + ".jar");
            String string2 = jarFile.toString().intern();
            synchronized (string2) {
                boolean oldOK;
                long depend = CompileUtil.getDependencyLastTime();
                String old = null;
                if (f.exists()) {
                    old = StreamUtil.readFully((InputStream)new FileInputStream(f));
                }
                boolean oldSourceSame = source.equals(old);
                boolean oldExists = jarFile.exists();
                boolean oldDepends = jarFile.lastModified() > depend;
                boolean bl = oldOK = oldExists && oldSourceSame && oldDepends;
                if (!oldOK) {
                    _rollingLog.write(f.toString());
                    if (CD) {
                        System.out.println(" compiling  oldSourceSame: " + oldSourceSame + " oldExists:" + oldExists + " oldDepends:" + oldDepends + "\t" + f);
                    }
                    CompileUtil._cleanOld(dir, c, false);
                    FileOutputStream fout = new FileOutputStream(f);
                    fout.write(source.getBytes());
                    fout.close();
                    if (CD) {
                        System.err.println("going to start compiling ");
                    }
                    String cp = "build";
                    if (EDFinder.whereIsEd != null) {
                        cp = cp + File.pathSeparatorChar + EDFinder.whereIsEd;
                        if (EDFinder.whereIsEd.endsWith(".jar")) {
                            File temp = new File(EDFinder.whereIsEd).getParentFile();
                            if (temp.exists() && temp.isDirectory()) {
                                for (File tempFile : temp.listFiles()) {
                                    if (!tempFile.toString().endsWith(".jar") || !tempFile.getName().startsWith("mongojs-")) continue;
                                    cp = cp + File.pathSeparatorChar + tempFile.toString();
                                }
                            }
                        } else {
                            cp = cp + "/build";
                        }
                    }
                    MyCompiler compiler = (MyCompiler)_compilerPool.get();
                    boolean res = false;
                    try {
                        res = compiler.compile("-g -1.5 -classpath " + cp + " " + f.toString());
                    }
                    finally {
                        _compilerPool.done((Object)compiler);
                    }
                    if (D) {
                        System.out.println(f + " : " + res);
                    }
                    if (CD) {
                        System.err.println("done compiling ");
                    }
                    if (!res) {
                        System.err.println("**" + compiler.getLastMessage());
                        throw new RuntimeException(compiler.getLastMessage());
                    }
                    CompileUtil._createJar(jarFile, pack, dir, c);
                    CompileUtil._cleanOld(dir, c, true);
                }
                Class<?> result = _loader.loadClass(pack + "." + c);
                return result;
            }
        }
    }

    static void _cleanOld(File dir, String prefix, boolean onlyClassFiles) {
        File[] toDelete;
        if (!dir.exists()) {
            return;
        }
        for (File f : toDelete = dir.listFiles(new MyFilter(prefix, onlyClassFiles))) {
            f.delete();
        }
    }

    static void _createJar(File jar, String pack, File dir, String prefix) throws IOException {
        File[] classFiles = dir.listFiles(new MyFilter(prefix, true));
        FileOutputStream fout = new FileOutputStream(jar);
        JarOutputStream jout = new JarOutputStream(fout);
        for (File f : classFiles) {
            FileUtil.add((ZipOutputStream)jout, (String)(pack + "." + f.getName()), (File)f);
        }
        jout.closeEntry();
        jout.close();
        fout.close();
    }

    static long getDependencyLastTime() {
        if (_dependFiles.size() == 0) {
            return Long.MAX_VALUE;
        }
        long max = 0L;
        for (File f : _dependFiles) {
            max = Math.max(max, f.lastModified());
        }
        return max;
    }

    static {
        File temp;
        CD = false;
        _loader = new MyClassLoader();
        _compilerPool = new SimplePool<MyCompiler>("MyCompiler", 4, 4){

            public MyCompiler createNew() {
                return new MyCompiler();
            }

            public boolean ok(MyCompiler c) {
                return c.ok();
            }
        };
        _dependFiles = new HashSet<File>();
        _possibleRoots = new String[]{"./", "../ed", "../../ed"};
        _dependsDirs = new String[]{"src/main/ed/js", "src/main/ed/js/engine", "src/main/ed/js/func"};
        _rollingLog = new RollingNamedPipe("compile");
        _rollingLog.setMessageDivider("\n");
        String root = null;
        for (int i = 0; i < _possibleRoots.length; ++i) {
            File temp2 = new File(_possibleRoots[i], _dependsDirs[0]);
            if (!temp2.exists() || !temp2.isDirectory()) continue;
            root = _possibleRoots[i];
            break;
        }
        if (root == null && EDFinder.whereIsEd != null && (temp = new File(EDFinder.whereIsEd, _dependsDirs[0])).exists() && temp.isDirectory()) {
            root = EDFinder.whereIsEd;
        }
        if (root == null) {
            System.out.println("Warning : can't find core appserver js sources : no harm, but js will be recompiled on appserver startup");
        } else {
            for (String dirName : _dependsDirs) {
                File dir = new File(root, dirName);
                if (!dir.exists() || !dir.isDirectory()) {
                    System.out.println("bad dir : " + dir);
                    _dependFiles.clear();
                    break;
                }
                for (File f : dir.listFiles()) {
                    if (!f.getName().endsWith(".java")) continue;
                    _dependFiles.add(f);
                }
            }
        }
    }

    static class MyCompiler {
        final StringWriter _output = new StringWriter();
        final Main _main;
        boolean _lastRes = true;
        String _lastMessage = null;

        MyCompiler() {
            PrintWriter pw = new PrintWriter(this._output);
            this._main = new Main(pw, pw, false);
        }

        boolean compile(String commandLine) {
            this._output.getBuffer().setLength(0);
            this._lastRes = this._main.compile(Main.tokenize((String)commandLine));
            this._lastMessage = this._output.toString();
            return this._lastRes;
        }

        boolean ok() {
            return this._lastRes;
        }

        String getLastMessage() {
            return this._lastMessage;
        }
    }

    static class MyFilter
    implements FilenameFilter {
        final String _prefix;
        final boolean _onlyClassFiles;

        MyFilter(String prefix, boolean onlyClassFiles) {
            this._prefix = prefix;
            this._onlyClassFiles = onlyClassFiles;
        }

        public boolean accept(File mydir, String name) {
            if (!name.startsWith(this._prefix)) {
                return false;
            }
            String remaining = name.substring(this._prefix.length());
            if (remaining.matches("[\\$\\d]*\\.class")) {
                return true;
            }
            if (this._onlyClassFiles) {
                return false;
            }
            if (name.equals(this._prefix)) {
                return true;
            }
            return name.lastIndexOf(".") == this._prefix.length();
        }
    }

    static class MyClassLoader
    extends ClassLoader {
        MyClassLoader() {
        }

        public Class findClass(String name) throws ClassNotFoundException {
            byte[] b = this.loadClassData(name);
            return this.defineClass(name, b, 0, b.length);
        }

        File _getJarFile(String name) {
            String file = CompileUtil.getCompileSrcDir(name);
            file = file.substring(0, file.length() - 1);
            file = file.replaceAll("\\$[\\d\\$]+$", "");
            return new File(file + ".jar");
        }

        private byte[] loadClassData(String name) throws ClassNotFoundException {
            File f = this._getJarFile(name);
            if (!f.exists()) {
                throw new ClassNotFoundException("Jar file doesn't exist [" + f + "]");
            }
            try {
                JarFile jar = new JarFile(f);
                JarEntry entry = jar.getJarEntry(name + ".class");
                if (entry == null) {
                    throw new ClassNotFoundException("can't find [" + name + "] in [" + f + "]");
                }
                return StreamUtil.readBytesFully((InputStream)jar.getInputStream(entry));
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException("error loading [" + name + "] from [" + f + "]" + ioe);
            }
        }
    }
}

