/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.js.JSArray;
import ed.js.JSException;
import ed.js.JSFunction;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.js.func.JSFunctionCalls1;
import ed.util.IdentitySet;
import java.util.IdentityHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class JSRegex
extends JSObjectBase {
    private static final JSFunction _cons = new Cons();
    String source = null;
    boolean global = false;
    boolean multiline = false;
    boolean ignoreCase = false;
    String _p;
    String _f;
    int _compilePatterns;
    Pattern _patt;
    boolean _replaceAll;
    private CRLast _last = new CRLast();
    static ThreadLocal<JSRegex> _lastRegex = new ThreadLocal();
    static int num = 0;

    private JSRegex() {
        super(Scope.getThreadLocalFunction("RegExp", _cons));
    }

    public JSRegex(String p) {
        this(p, "");
    }

    public JSRegex(String p, String f) {
        super(Scope.getThreadLocalFunction("RegExp", _cons));
        this.init(p, f);
    }

    public void setProps(String p, String f) {
        CachedResult cr = this._last.get();
        this.source = p;
        this.global = f.indexOf("g") >= 0;
        this.ignoreCase = f.indexOf("i") >= 0;
        this.multiline = f.indexOf("m") >= 0;
    }

    private static final boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    static String _jsToJava(String p) {
        StringBuilder buf = new StringBuilder(p.length() + 10);
        int parenCount = 0;
        boolean inCharClass = false;
        for (int i = 0; i < p.length(); ++i) {
            char c = p.charAt(i);
            if (c == '(') {
                ++parenCount;
            }
            if (c == '\\') {
                boolean isOctal;
                int end = i + 1;
                if (i + 1 < p.length() && p.charAt(i + 1) == 'u') {
                    ++end;
                    while (end < p.length() && JSRegex.isHex(p.charAt(end)) && end < i + 6) {
                        ++end;
                    }
                    if (end - (i + 2) != 4) continue;
                    buf.append("\\");
                    continue;
                }
                boolean bl = end < p.length() ? p.charAt(end) == '0' : (isOctal = false);
                while (end < p.length() && Character.isDigit(p.charAt(end)) && (!isOctal || isOctal && p.charAt(end) < '8')) {
                    ++end;
                }
                if (end - (i + 1) >= 1 && (inCharClass || isOctal)) {
                    char ch = (char)Integer.parseInt(p.substring(i + 1, end), 8);
                    if (!inCharClass && Pattern.matches("[-^$*+()\\[\\]{}?!<>,\\.]", ch + "")) {
                        buf.append("\\" + ch);
                    } else {
                        buf.append(ch);
                    }
                    i = end - 1;
                    continue;
                }
                if (i + 1 < p.length() && Character.isDigit(p.charAt(i + 1)) && p.charAt(i + 1) - 48 > parenCount) {
                    ++i;
                    continue;
                }
                buf.append("\\");
                continue;
            }
            if (inCharClass) {
                if (c == '[' && p.charAt(i - 1) != '\\') {
                    buf.append("\\");
                }
                if (c == ']' && p.charAt(i - 1) != '\\') {
                    inCharClass = false;
                }
                buf.append(c);
                continue;
            }
            if (p.charAt(i) == '[' && (i == 0 || p.charAt(i - 1) != '\\')) {
                if (p.charAt(i + 1) == ']') {
                    buf.append("[\uffff]");
                    ++i;
                    continue;
                }
                if (p.charAt(i + 1) == '^' && p.charAt(i + 2) == ']') {
                    buf.append("[^\uffff]");
                    i += 2;
                    continue;
                }
                inCharClass = true;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private void init(String p, String f) {
        this.setProps(p, f);
        this._p = JSRegex._jsToJava(p);
        this._f = f == null ? "" : f;
        int compilePatterns = 0;
        if (f.contains("i")) {
            compilePatterns |= 2;
        }
        if (f.contains("m") || ((Boolean)_cons.get("multiline")).booleanValue()) {
            compilePatterns |= 8;
        }
        this._compilePatterns = compilePatterns;
        this._replaceAll = f.contains("g");
        try {
            this._patt = Pattern.compile(this._p, this._compilePatterns);
        }
        catch (PatternSyntaxException pe) {
            throw new RuntimeException("bad pattern \"" + this._p + "\" : " + pe.getMessage());
        }
    }

    public Object set(Object n, Object v) {
        String s = n.toString();
        if (s.equals("lastIndex")) {
            this._last.get().lastIndex = Integer.parseInt(v.toString());
        }
        return v;
    }

    public Object get(Object n) {
        String s = n.toString();
        if (s.equals("lastIndex")) {
            return this._last.get().lastIndex;
        }
        if (s.equals("source")) {
            return this.source;
        }
        if (s.equals("global")) {
            return this.global;
        }
        if (s.equals("ignoreCase")) {
            return this.ignoreCase;
        }
        if (s.equals("multiline")) {
            return this.multiline;
        }
        return super.get(n);
    }

    public String getPattern() {
        return this._p;
    }

    public String getFlags() {
        return this._f;
    }

    public String toString() {
        String source = this.source;
        if (source == null) {
            source = "(?:)";
        }
        if (this._f == null) {
            this._f = "";
        }
        return "/" + source + "/" + this._f;
    }

    public int hashCode(IdentitySet seen) {
        return this._p.hashCode() + this._f.hashCode();
    }

    public boolean equals(Object o) {
        return this.toString().equals(o.toString());
    }

    public Pattern getCompiled() {
        return this._patt;
    }

    public boolean matches(String s) {
        Matcher m = this._patt.matcher(s);
        return m.matches();
    }

    public boolean test(String s) {
        if (s == null) {
            s = this.getConstructor().get("input") + "";
        }
        this.getConstructor().set("input", s);
        Matcher m = this._patt.matcher(s);
        CachedResult cr = this._last.get();
        int idx = cr.lastIndex;
        if (idx >= s.length()) {
            idx = 0;
        }
        boolean b = m.find(idx);
        if (this.global) {
            this.getConstructor().set("lastMatch", b ? m.group(0) : null);
            this.getConstructor().set("lastParen", b && m.groupCount() > 0 ? m.group(m.groupCount()) : "");
            this.getConstructor().set("leftContext", b ? s.substring(0, m.start(0)) : "");
            this.getConstructor().set("rightContext", b ? s.substring(m.end(0)) : "");
            cr.lastIndex = b ? m.end() : 0;
        }
        return b;
    }

    public JSArray exec(String s) {
        return this.exec(s == null ? this.getConstructor().get("input") + "" : s, true);
    }

    public JSArray exec(String s, boolean canUseOld) {
        CachedResult cr = this._last.get();
        if (cr == null) {
            this._last.set(new CachedResult(s, null, null));
            cr = this._last.get();
        }
        Matcher m = canUseOld && cr._matcher != null && s == cr._input && s.equals(cr._input) ? cr._matcher : this._patt.matcher(s);
        this.getConstructor().set("input", s);
        if (cr.lastIndex > s.length() || !m.find(cr.lastIndex)) {
            if (this.global) {
                cr.lastIndex = 0;
            }
            this.getConstructor().set("lastMatch", null);
            this.getConstructor().set("lastParen", "");
            this.getConstructor().set("leftContext", "");
            this.getConstructor().set("rightContext", "");
            return null;
        }
        JSArray a = new JSArray();
        for (int i = 0; i <= m.groupCount(); ++i) {
            String temp = m.group(i);
            if (temp == null) {
                a.add((Object)null);
                continue;
            }
            a.add(new JSString(temp));
        }
        this.getConstructor().set("lastMatch", m.group(0));
        this.getConstructor().set("lastParen", m.groupCount() > 0 ? m.group(m.groupCount()) : "");
        this.getConstructor().set("leftContext", s.substring(0, m.start(0)));
        this.getConstructor().set("rightContext", s.substring(m.end(0)));
        a.set("_matcher", (Object)m);
        a.set("input", (Object)new JSString(s));
        a.set("index", (Object)m.start());
        if (this.global) {
            cr.lastIndex = m.end();
        }
        if (this._replaceAll) {
            if (cr == null) {
                this._last.set(new CachedResult(s, m, a));
            } else {
                cr._array = a;
            }
        } else {
            this._last.set(null);
        }
        _lastRegex.set(this);
        this.getConstructor().set("matchArray", new JSArray(a));
        return a;
    }

    void _setLast(JSArray arr) {
        CachedResult cr = this._last.get();
        if (cr == null) {
            cr = this._last.set(new CachedResult(null, null, null));
        }
        cr._array = arr;
        if (arr == null) {
            return;
        }
        cr._input = arr.get("input") + "";
        cr._matcher = (Matcher)arr.get("_matcher");
    }

    public JSArray getLast() {
        CachedResult cr = this._last.get();
        if (cr == null) {
            return null;
        }
        return cr._array;
    }

    public static String quote(String s) {
        StringBuilder buf = new StringBuilder(s.length() + 10);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '}': {
                    buf.append("\\");
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    class CRLast {
        ThreadLocal<CachedResult> _tl = new ThreadLocal<CachedResult>(){

            @Override
            protected CachedResult initialValue() {
                return CRLast.this._initialValue();
            }
        };

        CRLast() {
        }

        public CachedResult get() {
            CachedResult cr = this._tl.get();
            if (cr != null) {
                return cr;
            }
            return this._initialValue();
        }

        public CachedResult set(CachedResult cr) {
            this._tl.set(cr);
            return cr;
        }

        CachedResult _initialValue() {
            return new CachedResult(null, null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RegexToCRtMap
    extends IdentityHashMap<JSRegex, CachedResult> {
        RegexToCRtMap() {
        }
    }

    static class CachedResult {
        int lastIndex = 0;
        String _input;
        Matcher _matcher;
        JSArray _array;

        CachedResult(String input, Matcher m, JSArray arr) {
            this._input = input;
            this._matcher = m;
            this._array = arr;
        }
    }

    public static class Cons
    extends JSFunctionCalls1 {
        public JSObject newOne() {
            return new JSRegex();
        }

        public Object call(Scope s, Object[] args) {
            return new JSRegex("", "");
        }

        public Object call(Scope s, Object a, Object[] args) {
            Object o = s.getThis();
            if (a instanceof JSRegex) {
                if (args != null && args.length > 0 && args[0] != null && args[0] != VOID) {
                    throw new JSException((Object)"can't supply flags when constructing one RegExp from another ");
                }
                if (!(o instanceof JSRegex)) {
                    return a;
                }
                JSRegex r = (JSRegex)a;
                String g = r.global ? "g" : "";
                String i = r.ignoreCase ? "i" : "";
                String m = r.multiline ? "m" : "";
                ((JSRegex)o).init(r.source, g + i + m);
                return o;
            }
            String p = a + "";
            String f = "";
            if (args != null && args.length > 0) {
                f = this.getFlags(args[0]);
            }
            if (o == null || !(o instanceof JSRegex)) {
                return new JSRegex(p, f);
            }
            JSRegex r = (JSRegex)o;
            r.init(p, f);
            return r;
        }

        private String getFlags(Object o) {
            if (o == null) {
                return "";
            }
            if (!(o instanceof String) && !(o instanceof JSString) || !Pattern.matches("[gim]*", o.toString())) {
                throw new JSException((Object)("Syntax Error: illegal flags " + o));
            }
            return o.toString();
        }

        public Object get(Object o) {
            if (o == null) {
                return null;
            }
            String s = o.toString();
            if (s.equals("$_")) {
                return this.get("input");
            }
            if (s.equals("$&")) {
                return this.get("lastMatch");
            }
            if (s.equals("$+")) {
                return this.get("lastParen");
            }
            if (s.equals("$`")) {
                return this.get("leftContext");
            }
            if (s.equals("$'")) {
                return this.get("rightContext");
            }
            if (s.equals("$*")) {
                return this.get("multiline");
            }
            if (s.startsWith("$")) {
                int m = Integer.parseInt(s.substring(1));
                Object obj = ((JSArray)this.get("matchArray")).get(m);
                return obj == null ? "" : obj.toString();
            }
            return super.get(o);
        }

        public Object set(Object n, Object v) {
            String s;
            if (n == null) {
                return false;
            }
            if (v == null) {
                v = "";
            }
            if ((s = n.toString()).equals("$_")) {
                this.set("input", v.toString());
                return v;
            }
            if (s.equals("$*")) {
                this.set("multiline", Boolean.parseBoolean(v.toString()));
                return v;
            }
            return super.set(n, v);
        }

        protected void init() {
            JSObjectBase proto = this._prototype;
            this._prototype.set("toString", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    Object o = s.getThis();
                    if (!(o instanceof JSRegex)) {
                        return null;
                    }
                    JSRegex r = (JSRegex)o;
                    String source = r.source;
                    if (source.equals("")) {
                        source = "(?:)";
                    }
                    String g = r.global ? "g" : "";
                    String i = r.ignoreCase ? "i" : "";
                    String m = r.multiline ? "m" : "";
                    return new JSString("/" + source + "/" + g + i + m);
                }
            });
            this._prototype.set("test", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    if (o == null) {
                        return ((JSRegex)s.getThis()).test((String)o);
                    }
                    return ((JSRegex)s.getThis()).test(o.toString());
                }
            });
            this._prototype.set("exec", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    if (o == null) {
                        return ((JSRegex)s.getThis()).exec((String)o);
                    }
                    return ((JSRegex)s.getThis()).exec(o.toString());
                }
            });
            this._prototype.set("compile", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    if (foo == null || foo.length == 0) {
                        ((JSRegex)s.getThis()).init(o.toString(), null);
                    } else {
                        ((JSRegex)s.getThis()).init(o.toString(), foo[0].toString());
                    }
                    return null;
                }
            });
            this._prototype.set("__rmatch", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    if (o == null) {
                        return -1;
                    }
                    String str = o.toString();
                    JSRegex r = (JSRegex)s.getThis();
                    JSArray a = r.exec(str);
                    r._setLast(a);
                    if (a == null) {
                        return null;
                    }
                    return a.get("index");
                }
            });
            this._prototype.set("match", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    if (o == null) {
                        return -1;
                    }
                    String str = o.toString();
                    JSRegex r = (JSRegex)s.getThis();
                    JSArray a = r.exec(str, false);
                    r._setLast(a);
                    if (a == null) {
                        return null;
                    }
                    String res = a.getInt(0).toString();
                    return res;
                }
            });
            this.set("quote", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    return JSRegex.quote(o.toString());
                }
            });
            this.set("last", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    return _lastRegex.get();
                }
            });
            this.set("matchArray", new JSArray());
            this.set("input", "");
            this.set("lastMatch", null);
            this.set("lastParen", "");
            this.set("leftContext", "");
            this.set("rightContext", "");
            this.set("multiline", false);
            this.dontEnumExisting();
            this._prototype.dontEnumExisting();
        }
    }
}

