/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.db.DBRef;
import ed.db.ObjectId;
import ed.js.JSDate;
import ed.js.JSObjectBase;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.log.Level;
import ed.util.SeenPath;
import ed.util.Sizable;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class JSObjectSize {
    public static final long OBJ_OVERHEAD = 8L;
    public static final long STRING_CONS_OVERHEAD = 127552L;
    private static Set<String> _seenClasses = Collections.synchronizedSet(new HashSet());

    public static long size(Object o) {
        return JSObjectSize.size(o, null, null);
    }

    public static long size(Object o, SeenPath seen, Object from) {
        if (o == null) {
            return 0L;
        }
        long size = JSObjectSize._size(o, seen, from);
        return size;
    }

    private static long _size(Object o, SeenPath seen, Object from) {
        if (o == null || o instanceof Boolean || o instanceof Short || o instanceof Character || o instanceof String) {
            return 0L;
        }
        if (o instanceof DBRef || o instanceof JSDate || o instanceof Number || o instanceof JSDate || o instanceof File || o instanceof Level || o instanceof ObjectId) {
            return 16L;
        }
        if (seen == null) {
            seen = new SeenPath();
        } else if (!seen.shouldVisit(o, from)) {
            return 0L;
        }
        if (o instanceof JSString) {
            return (long)(10 * o.toString().length()) + (seen.isFirstString() ? 127552L : 0L);
        }
        if (o instanceof WeakReference) {
            return 8L;
        }
        if (o instanceof WeakHashMap) {
            return 8L + (long)((WeakHashMap)o).size() * 8L;
        }
        if (o instanceof Scope) {
            return ((Scope)o).approxSize(seen);
        }
        if (o instanceof JSObjectBase) {
            return ((JSObjectBase)o).approxSize(seen);
        }
        if (o instanceof Sizable) {
            return ((Sizable)o).approxSize(seen);
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            Iterator i = c.iterator();
            long temp = 0L;
            temp += o instanceof HashSet ? 184L : 80L;
            if (i == null) {
                return temp;
            }
            while (i.hasNext()) {
                Object foo = i.next();
                if (foo == null || seen.contains(foo)) continue;
                temp += JSObjectSize._size(foo, seen, o);
            }
            return temp;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            long temp = 32L;
            for (Map.Entry e : m.entrySet()) {
                temp += 32L + JSObjectSize._size(e.getKey(), seen, o) + JSObjectSize._size(e.getValue(), seen, o);
            }
            return temp;
        }
        String blah = o.getClass().toString();
        if (!_seenClasses.contains(blah)) {
            System.err.println("can't size : " + blah);
            _seenClasses.add(blah);
        }
        return 32L;
    }
}

