/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.db.ByteEncoder;
import ed.db.DBRef;
import ed.db.ObjectId;
import ed.js.JS;
import ed.js.JSArray;
import ed.js.JSFunction;
import ed.js.JSInternalFunctions;
import ed.js.JSON;
import ed.js.JSObject;
import ed.js.JSObjectLame;
import ed.js.JSObjectSize;
import ed.js.JSRef;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.js.func.JSFunctionCalls1;
import ed.js.func.JSFunctionCalls2;
import ed.util.FastStringMap;
import ed.util.IdentitySet;
import ed.util.OrderedSet;
import ed.util.Pair;
import ed.util.SeenPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSObjectBase
implements JSObject {
    public static final String GETSET_PREFIX = "_____gs____";
    public static final String SCOPE_FAILOVER_PREFIX = "_____scope_failover____";
    static final Set<String> BAD_KEY_NAMES = new HashSet<String>();
    public static int READ_ONLY;
    public static int DONT_DELETE;
    public static int DONT_ENUM;
    public static int LOCK;
    static final String OBJECT_STRING = "Object";
    protected FastStringMap _map = null;
    protected Map<String, Pair<JSFunction, JSFunction>> _setterAndGetters = null;
    private Collection<String> _keys = null;
    private Set<String> _readOnlyKeys;
    private Set<String> _dontDeleteKeys;
    private Set<String> _dontEnum;
    private JSFunction _constructor;
    private JSObject __proto__ = null;
    private boolean _readOnly = false;
    private boolean _locked = false;
    private String _name;
    private boolean _dirty = true;
    private long _lastHash = 0L;
    private boolean _isPartialObject = false;
    private static final String _setterAndGettersSetLOCK = "_setterAndGettersSetLOCK-asdhaskfhk32qsdsfdasd";
    private int _version = 0;
    private List<JSObjectBase> _dependencies = null;
    private boolean _badDepencies = false;
    private int _dependencySum = 0;
    private boolean _placesToLookUpdated = false;
    private JSObject[] _placesToLook = new JSObject[4];
    private int _getFromParentCalls = 0;
    private Map<String, Object> _jitCache;
    static final Set<String> EMPTY_SET;
    static final Object UNDEF;
    private static final JSFunction DEFAULT_TO_STRING;
    public static final JSObject _objectLowFunctions;
    private static final ThreadLocal<Boolean> _inNotFoundHandler;

    public JSObjectBase() {
    }

    public JSObjectBase(JSFunction constructor) {
        this.setConstructor(constructor);
    }

    public Object prefunc() {
        return this;
    }

    public boolean isNull() {
        return false;
    }

    @Override
    public Object set(Object n, Object v) {
        this._readOnlyCheck();
        this.prefunc();
        boolean bl = this._dirty = this._dirty || !ByteEncoder.dbOnlyField((Object)n);
        if (n == null) {
            n = "null";
        }
        if (this._readOnlyKeys != null && this._readOnlyKeys.contains(n.toString())) {
            return v;
        }
        if (v != null && "_id".equals(n) && (v instanceof String || v instanceof JSString)) {
            v = new ObjectId(v.toString());
        }
        if (v != null && v instanceof String) {
            v = new JSString(v.toString());
        }
        if (n instanceof Number) {
            this.setInt(((Number)n).intValue(), v);
            return v;
        }
        String name = n.toString();
        if (name.startsWith(GETSET_PREFIX)) {
            name = name.substring(GETSET_PREFIX.length());
            String type = name.substring(0, 3);
            name = name.substring(3);
            if (type.equals("GET")) {
                this.setGetter(name, (JSFunction)v);
            } else if (type.equals("SET")) {
                this.setSetter(name, (JSFunction)v);
            } else {
                throw new RuntimeException("broken");
            }
            return v;
        }
        if (name.equals("constructor") || name.equals("__constructor__")) {
            this._constructor = (JSFunction)v;
            this._dirtyMyself();
            return this._constructor;
        }
        if (name.equals("__proto__")) {
            this.__proto__ = (JSObject)v;
            this._dirtyMyself();
            return this.__proto__;
        }
        JSFunction func = this.getSetter(name);
        if (func != null) {
            return this._call(func, v);
        }
        this._checkMap();
        if (!BAD_KEY_NAMES.contains(name) && !this._map.containsKey(name)) {
            this._keys.add(name);
        }
        this._dirtyMyself();
        this._map.put(name, v);
        if (v instanceof JSObjectBase) {
            ((JSObjectBase)v)._name = name;
        }
        return v;
    }

    public void setProperties(String s, int opts) {
        if ((opts & DONT_ENUM) != 0) {
            this.dontEnum(s);
        }
        if ((opts & DONT_DELETE) != 0) {
            if (this._dontDeleteKeys == null) {
                this._dontDeleteKeys = new HashSet<String>();
            }
            this._dontDeleteKeys.add(s);
        }
        if ((opts & READ_ONLY) != 0) {
            if (this._readOnlyKeys == null) {
                this._readOnlyKeys = new HashSet<String>();
            }
            this._readOnlyKeys.add(s);
        }
    }

    protected void _checkMap() {
        if (this._map == null) {
            this._map = new FastStringMap();
        }
        if (this._keys == null) {
            this._keys = new ArrayList<String>();
        }
        this._dirtyMyself();
    }

    public String getAsString(Object n) {
        Object v = this.get(n);
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    @Override
    public JSFunction getFunction(String name) {
        return JSObjectBase.getFunction(this, name);
    }

    public static final JSFunction getFunction(JSObject o, String name) {
        if (o == null) {
            return null;
        }
        Object f = o.get(name);
        if (f == null) {
            return null;
        }
        if (f instanceof JSFunction) {
            return (JSFunction)f;
        }
        return null;
    }

    @Override
    public Object get(Object n) {
        this.prefunc();
        if (n == null) {
            n = "null";
        }
        if (n instanceof Number) {
            return this.getInt(((Number)n).intValue());
        }
        Object ret = this._simpleGet(n.toString());
        if (ret instanceof JSObjectBase && ((JSObjectBase)ret).isNull()) {
            return null;
        }
        if (ret instanceof DBRef) {
            return ((DBRef)ret).getRealObject();
        }
        return ret;
    }

    public Object _simpleGet(String s) {
        boolean scopeFailover = s.startsWith(SCOPE_FAILOVER_PREFIX);
        if (scopeFailover) {
            s = s.substring(SCOPE_FAILOVER_PREFIX.length());
        }
        return this._simpleGet(s.hashCode(), s, 0, null, scopeFailover, BAD_KEY_NAMES.contains(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object _simpleGet(int hash, String s, int depth, IdentitySet<JSObject> seen, boolean scopeFailover, boolean badKey) {
        Scope scope;
        JSFunction f;
        if (depth > 100) {
            return null;
        }
        if (depth > 5) {
            if (seen == null) {
                seen = new IdentitySet();
            } else {
                if (seen.contains((Object)this)) {
                    return null;
                }
                seen.add((Object)this);
            }
        }
        if (depth == 0) {
            if (s.equals("constructor") || s.equals("__constructor__")) {
                return this._constructor;
            }
            if (s.equals("__proto__")) {
                return this.__proto__;
            }
        }
        Object res = null;
        if (depth == 0 && !badKey && (f = this.getGetter(s)) != null) {
            return this._call(f, new Object[0]);
        }
        if (this._map != null && ((res = this._mapGet(hash, s)) != null || this._map.containsKey(hash, s))) {
            return res;
        }
        res = this._getFromParent(hash, s, depth, (IdentitySet<JSObject>)seen, scopeFailover, badKey);
        if (res != null) {
            return res;
        }
        if (_objectLowFunctions != null && (this._constructor == null || this == this._constructor._prototype) && (res = _objectLowFunctions.get(s)) != null) {
            return res;
        }
        if (!(depth != 0 || "__notFoundHandler".equals(s) || scopeFailover || badKey || (f = this._getNotFoundHandler()) == null)) {
            Scope scope2 = f.getScope();
            if (scope2 == null && (scope2 = Scope.getAScope(false)) == null) {
                throw new RuntimeException("not found handler doesn't have a scope and no thread local scope");
            }
            scope2 = scope2.child();
            scope2.setThis(this);
            if (!_inNotFoundHandler.get().booleanValue()) {
                try {
                    _inNotFoundHandler.set(true);
                    Object object = f.call(scope2, s);
                    return object;
                }
                finally {
                    _inNotFoundHandler.set(false);
                }
            }
        }
        if (scopeFailover && (scope = Scope.getAScope(false)) != null) {
            return scope.get(s);
        }
        return null;
    }

    private JSFunction _getNotFoundHandler() {
        Object blah = this._simpleGet("__notFoundHandler");
        if (blah instanceof JSFunction) {
            return (JSFunction)blah;
        }
        return null;
    }

    private Object _getFromParent(int hash, String s, int depth, IdentitySet<JSObject> seen, boolean scopeFailover, boolean badKey) {
        ++this._getFromParentCalls;
        if (s.equals("__proto__") || s.equals("prototype")) {
            return null;
        }
        boolean jit = false;
        if (depth > 0 && this._getFromParentCalls > 50 || this._getFromParentCalls > 1000) {
            if (this._dependenciesOk()) {
                jit = true;
                if (this._jitCache == null) {
                    this._jitCache = new FastStringMap();
                }
                if (this._jitCache.containsKey(s)) {
                    return this._jitCache.get(s);
                }
            } else {
                this._dependencies();
            }
        }
        Object res = this._getFromParentHelper(hash, s, depth, seen, scopeFailover, badKey);
        if (jit) {
            this._jitCache.put(s, res);
        }
        return res;
    }

    private Object _getFromParentHelper(int hash, String s, int depth, IdentitySet<JSObject> seen, boolean scopeFailover, boolean badKey) {
        this._updatePlacesToLook();
        for (JSObject o : this._placesToLook) {
            if (o == null || o == this) continue;
            if (o instanceof JSObjectBase) {
                JSObjectBase job = (JSObjectBase)o;
                Object res = job._simpleGet(hash, s, depth + 1, seen, scopeFailover, badKey);
                if (res == null) continue;
                return res;
            }
            Object res = o.get(s);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private void _updatePlacesToLook() {
        if (this._placesToLookUpdated) {
            return;
        }
        this._placesToLook[0] = this.__proto__;
        Object p = this._mapGet("prototype");
        if (p instanceof JSObject) {
            this._placesToLook[1] = (JSObject)p;
        }
        if (this._constructor != null) {
            this._placesToLook[2] = this._constructor._prototype;
            this._placesToLook[3] = this._constructor;
        } else {
            this._placesToLook[2] = null;
            this._placesToLook[3] = null;
        }
        for (int i = 1; i < this._placesToLook.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this._placesToLook[i] != this._placesToLook[j]) continue;
                this._placesToLook[i] = null;
            }
        }
        this._placesToLookUpdated = true;
    }

    private boolean _dependenciesOk() {
        if (this._badDepencies) {
            return false;
        }
        if (this._dependencies == null) {
            return false;
        }
        List<JSObjectBase> lst = this._dependencies;
        return JSObjectBase.sum(lst) == this._dependencySum;
    }

    private List<JSObjectBase> _dependencies() {
        if (this._badDepencies) {
            return null;
        }
        if (this._dependenciesOk()) {
            return this._dependencies;
        }
        List<JSObjectBase> lst = new ArrayList<JSObjectBase>();
        if ((lst = this._addDependencies(lst)) == null) {
            this._badDepencies = true;
        }
        this._dependencies = lst;
        this._dependencySum = JSObjectBase.sum(lst);
        return lst;
    }

    private static int sum(List<JSObjectBase> lst) {
        int sum = 0;
        for (int i = 0; i < lst.size(); ++i) {
            sum += lst.get((int)i)._version;
        }
        return sum;
    }

    protected List<JSObjectBase> _addDependencies(List<JSObjectBase> lst) {
        this._updatePlacesToLook();
        block0: for (int i = 0; i < this._placesToLook.length; ++i) {
            JSObjectBase job = (JSObjectBase)this._placesToLook[i];
            if (job == null || job == this) continue;
            if (!(job instanceof JSObjectBase)) {
                return null;
            }
            for (int j = 0; j < lst.size(); ++j) {
                if (lst.get(j) == job) continue block0;
            }
            lst.add(job);
            job._addDependencies(lst);
        }
        return lst;
    }

    public void clear() {
        if (this._map != null) {
            this._map.clear();
        }
        if (this._keys != null) {
            this._keys.clear();
        }
    }

    @Override
    public Object removeField(Object n) {
        if (n == null) {
            return false;
        }
        if (n instanceof JSString) {
            n = n.toString();
        }
        Object val = true;
        if (n instanceof String) {
            if (this._dontDeleteKeys != null && this._dontDeleteKeys.contains((String)n)) {
                return false;
            }
            if (this._map != null) {
                val = this._map.remove((String)n);
            }
            if (this._keys != null) {
                this._keys.remove(n);
            }
        }
        return !(val instanceof JSRef) ? Boolean.valueOf(true) : val;
    }

    @Override
    public Object setInt(int n, Object v) {
        this._readOnlyCheck();
        this.prefunc();
        return this.set(String.valueOf(n), v);
    }

    @Override
    public Object getInt(int n) {
        this.prefunc();
        return this.get(String.valueOf(n));
    }

    public boolean containsKey(Object o) {
        return this.containsKey(o.toString(), true);
    }

    @Override
    public boolean containsKey(String s) {
        return this.containsKey(s, true);
    }

    @Override
    public boolean containsKey(String s, boolean includePrototype) {
        return this.containsKey(s.hashCode(), s, includePrototype);
    }

    public boolean containsKey(int hash, String s, boolean includePrototype) {
        this.prefunc();
        if (this._map != null && this._map.containsKey(hash, s)) {
            return true;
        }
        if (!includePrototype || this._constructor == null) {
            return false;
        }
        IdentitySet seen = new IdentitySet();
        JSObjectBase start = this._constructor._prototype;
        while (start != null && !seen.contains((Object)start)) {
            if (start.containsKey(hash, s, false)) {
                return true;
            }
            seen.add((Object)start);
            if (start._constructor == null) break;
            start = start._constructor._prototype;
        }
        return false;
    }

    public boolean hasOwnProperty(String s) {
        this.prefunc();
        return this._map != null && this._map.containsKey(s);
    }

    @Override
    public final Set<String> keySet() {
        return this.keySet(true);
    }

    @Override
    public Set<String> keySet(boolean includePrototype) {
        return this.keySet(includePrototype, false);
    }

    public Set<String> keySet(boolean includePrototype, boolean ignoreDontEnum) {
        this.prefunc();
        OrderedSet keys = new OrderedSet();
        if (this._keys != null) {
            keys.addAll(this._keys);
        }
        if (includePrototype && this._constructor != null && !this.equals(this._constructor._prototype)) {
            IdentitySet seen = new IdentitySet();
            JSObjectBase start = this._constructor._prototype;
            while (start != null && !JSInternalFunctions.JS_evalToBool(start.get("_dontEnum")) && !seen.contains((Object)start)) {
                keys.addAll(start.keySet(false));
                seen.add((Object)start);
                if (start._constructor == null) break;
                start = start._constructor._prototype;
            }
        }
        if (!ignoreDontEnum && this._dontEnum != null) {
            keys.removeAll(this._dontEnum);
        }
        return keys;
    }

    public void dontEnumExisting() {
        if (this._dontEnum == null) {
            this._dontEnum = new HashSet<String>();
        }
        this._dontEnum.addAll(this.keySet());
    }

    public void dontEnum(String s) {
        if (this._dontEnum == null) {
            this._dontEnum = new HashSet<String>();
        }
        this._dontEnum.add(s);
    }

    void setSetter(String name, JSFunction func) {
        this._dirtyMyself();
        this._getSetterAndGetter((String)name, (boolean)true).second = func;
    }

    void setGetter(String name, JSFunction func) {
        this._dirtyMyself();
        this._getSetterAndGetter((String)name, (boolean)true).first = func;
    }

    JSFunction getSetter(String name) {
        Pair<JSFunction, JSFunction> p = this._getSetterAndGetter(name, false);
        if (p != null) {
            return (JSFunction)p.second;
        }
        JSObject s = this.getSuper();
        if (s != null && s != this) {
            return ((JSObjectBase)s).getSetter(name);
        }
        return null;
    }

    JSFunction getGetter(String name) {
        Pair<JSFunction, JSFunction> p = this._getSetterAndGetter(name, false);
        if (p != null) {
            return (JSFunction)p.first;
        }
        JSObject s = this.getSuper();
        if (s instanceof JSObjectBase && s != this) {
            return ((JSObjectBase)s).getGetter(name);
        }
        return null;
    }

    public static String setterName(String name) {
        return "_____gs____SET" + name;
    }

    public static String getterName(String name) {
        return "_____gs____GET" + name;
    }

    public String toPrettyString() {
        Object temp = this.get("toString");
        if (temp == DEFAULT_TO_STRING || !(temp instanceof JSFunction)) {
            return JSON.serialize(this);
        }
        return this.toString();
    }

    public String toString() {
        JSFunction f = this.getFunction("toString");
        if (f == null) {
            return OBJECT_STRING;
        }
        Scope s = f.getScope();
        s = s == null ? new Scope() : s.child();
        s.setThis(this);
        Object res = f.call(s);
        if (res == null) {
            return "Object(toString was null)";
        }
        return res.toString();
    }

    protected void addAll(JSObject other) {
        for (String s : other.keySet()) {
            this.set(s, other.get(s));
        }
    }

    protected void addAll(Map other) {
        for (Object key : other.keySet()) {
            this.set(key, other.get(key));
        }
    }

    public Object put(String key, Object v) {
        Object prev = this.get(key);
        this.set(key, v);
        return prev;
    }

    public void putAll(Map<? extends String, ? extends Object> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _call(JSFunction func, Object ... params) {
        Scope sc = Scope.getAScope();
        sc.setThis(this);
        try {
            Object object = func.call(sc, params);
            return object;
        }
        finally {
            sc.clearThisNormal(null);
        }
    }

    public String getJavaString(Object name) {
        Object foo = this.get(name);
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    public void setConstructor(JSFunction cons2) {
        this.setConstructor(cons2, false, null);
    }

    public void setConstructor(JSFunction cons2, boolean exec) {
        this.setConstructor(cons2, exec, null);
    }

    public void setConstructor(JSFunction cons2, boolean exec, Object[] args) {
        this._readOnlyCheck();
        this._dirtyMyself();
        this._constructor = cons2;
        JSObject jSObject = this.__proto__ = this._constructor == null ? null : this._constructor._prototype;
        if (this._constructor != null && exec) {
            Scope s = this._constructor.getScope();
            if (s == null) {
                s = Scope.getThreadLocal();
            }
            s = s.child();
            s.setThis(this);
            this._constructor.call(s, args);
            s.removeFromParent();
        }
    }

    @Override
    public JSFunction getConstructor() {
        return this._constructor;
    }

    @Override
    public JSObject getSuper() {
        if (this.__proto__ != null) {
            return this.__proto__;
        }
        if (this._constructor != null && this._constructor._prototype != null) {
            return this._constructor._prototype;
        }
        return null;
    }

    public void lock() {
        this.setReadOnly(true);
        this._locked = true;
    }

    public boolean isLocked() {
        return this._readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly == this._readOnly) {
            return;
        }
        if (this._locked) {
            throw new RuntimeException("locked");
        }
        this._readOnly = readOnly;
    }

    protected final void _readOnlyCheck() {
        if (this._readOnly) {
            throw new RuntimeException("can't modify JSObject - read only");
        }
    }

    public void extend(JSObject other) {
        if (other == null) {
            return;
        }
        for (String key : other.keySet()) {
            this.set(key, other.get(key));
        }
    }

    public void debug() {
        try {
            this.debug(0, System.out);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    Appendable _space(int level, Appendable a) throws IOException {
        for (int i = 0; i < level; ++i) {
            a.append("  ");
        }
        return a;
    }

    public void debug(int level, Appendable a) throws IOException {
        JSObjectBase p;
        this._space(level, a);
        a.append("me :");
        if (this._name != null) {
            a.append(" name : [").append(this._name).append("] ");
        }
        if (this._keys != null) {
            a.append("keys : ").append(this._keys.toString());
        }
        a.append(" " + System.identityHashCode(this));
        a.append("\n");
        if (this._map != null && (p = (JSObjectBase)this._simpleGet("prototype")) != null) {
            this._space(level + 1, a).append("prototype || " + System.identityHashCode(p) + "\n");
            p.debug(level + 2, a);
        }
        if (this._constructor != null) {
            this._space(level + 1, a).append("__constructor__ ||\n");
            this._constructor.debug(level + 2, a);
        }
    }

    public final int hashCode() {
        return this.hashCode(null);
    }

    protected int hashCode(IdentitySet seen) {
        int hash = 81623;
        if (this._constructor != null) {
            hash += this._constructor.hashCode();
        }
        if (this._map == null) {
            return hash;
        }
        if (seen == null) {
            seen = new IdentitySet();
            seen.add((Object)this);
        }
        for (Map.Entry e : this._map.entrySet()) {
            String key = (String)e.getKey();
            if (JSON.IGNORE_NAMES.contains(key)) continue;
            hash += 3 * key.hashCode();
            Object value = e.getValue();
            int myHash = this._hash(seen, value);
            hash += myHash;
        }
        return hash;
    }

    protected int _hash(IdentitySet seen, Object value) {
        if (value == null) {
            return 0;
        }
        if (seen != null) {
            if (seen.contains(value)) {
                return 0;
            }
            seen.add(value);
        }
        if (value instanceof JSObjectBase) {
            return 7 * ((JSObjectBase)value).hashCode(seen);
        }
        return 91 * (123 + value.hashCode());
    }

    public String _getName() {
        return this._name;
    }

    public void _setName(String n) {
        this._name = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Pair<JSFunction, JSFunction> _getSetterAndGetter(String name, boolean add) {
        if (this._setterAndGetters == null && !add) {
            return null;
        }
        if (this._setterAndGetters == null) {
            TreeMap<String, Pair<JSFunction, JSFunction>> m = new TreeMap<String, Pair<JSFunction, JSFunction>>();
            String string = _setterAndGettersSetLOCK;
            // MONITORENTER : "_setterAndGettersSetLOCK-asdhaskfhk32qsdsfdasd"
            if (this._setterAndGetters == null) {
                this._setterAndGetters = m;
            }
            // MONITOREXIT : string
        }
        Map<String, Pair<JSFunction, JSFunction>> map = this._setterAndGetters;
        // MONITORENTER : map
        Pair p = this._setterAndGetters.get(name);
        if (add && p == null) {
            p = new Pair();
            this._setterAndGetters.put(name, (Pair<JSFunction, JSFunction>)p);
            // MONITOREXIT : map
            return p;
        }
        // MONITOREXIT : map
        return p;
    }

    private Object _mapGet(String s) {
        return this._mapGet(s.hashCode(), s);
    }

    private Object _mapGet(int hash, String s) {
        if (this._map == null) {
            return null;
        }
        Object o = this._map.get(hash, s);
        if (o == UNDEF) {
            return null;
        }
        return o;
    }

    private void _mapSet(String s, Object o) {
        this._checkMap();
        this._map.put(s, o);
    }

    private void _dirtyMyself() {
        ++this._version;
        this._placesToLookUpdated = false;
        this._dependencies = null;
        if (this._jitCache != null) {
            this._jitCache.clear();
        }
    }

    public long approxSize() {
        return this.approxSize(new SeenPath());
    }

    public long approxSize(SeenPath seen) {
        long size = 120L;
        size += JSObjectSize.size(this._name, seen, this);
        size += JSObjectSize.size(this._keys, seen, this);
        size += JSObjectSize.size(this._dontDeleteKeys, seen, this);
        size += JSObjectSize.size(this._readOnlyKeys, seen, this);
        size += JSObjectSize.size(this._dontEnum, seen, this);
        size += JSObjectSize.size(this._dependencies, seen, this);
        if (seen.shouldVisit((Object)this._map, (Object)this)) {
            size += this._map.approxSize(seen);
        }
        if (seen.shouldVisit((Object)this._constructor, (Object)this)) {
            size += this._constructor.approxSize(seen);
        }
        size += JSObjectSize.size(this.__proto__, seen, this);
        for (int i = 0; i < this._placesToLook.length; ++i) {
            size += JSObjectSize.size(this._placesToLook[i], seen, this);
        }
        return size;
    }

    public boolean isPartialObject() {
        return this._isPartialObject;
    }

    public void markAsPartialObject() {
        this._isPartialObject = true;
    }

    public void forceNonPartial() {
        this._isPartialObject = false;
    }

    public boolean isDirty() {
        return this._dirty || this._lastHash != (long)this.hashCode();
    }

    public void markClean() {
        this._dirty = false;
        this._lastHash = this.hashCode();
    }

    static {
        BAD_KEY_NAMES.add("__proto__");
        BAD_KEY_NAMES.add("__constructor__");
        BAD_KEY_NAMES.add("constructor");
        BAD_KEY_NAMES.add("__parent____");
        BAD_KEY_NAMES.add("_dontEnum");
        JS._debugSIStart("JSObjectBase");
        READ_ONLY = 1;
        DONT_DELETE = 2;
        DONT_ENUM = 4;
        LOCK = 7;
        EMPTY_SET = Collections.unmodifiableSet(new HashSet());
        UNDEF = new Object(){

            public String toString() {
                return "undefined";
            }
        };
        DEFAULT_TO_STRING = new JSFunctionCalls0(){

            public Object call(Scope s, Object[] extra) {
                String className = this.JS_typeof(s.getThis()).toString();
                className = className.substring(0, 1).toUpperCase() + className.substring(1);
                return new JSString("[object " + className + "]");
            }
        };
        _objectLowFunctions = new BaseThings();
        _inNotFoundHandler = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BaseThings
    extends JSObjectLame {
        private Map<String, Object> _things = new HashMap<String, Object>();

        public BaseThings() {
            this.init();
        }

        @Override
        public Object get(Object o) {
            String name = o.toString();
            return this._things.get(name);
        }

        @Override
        public Object set(Object name, Object val) {
            this._things.put(name.toString(), val);
            return val;
        }

        protected void init() {
            this.set("__extend", new JSFunctionCalls1(){

                public Object call(Scope s, Object other, Object[] args) {
                    if (other == null) {
                        return null;
                    }
                    Object blah = s.getThis();
                    if (blah == null || !(blah instanceof JSObjectBase)) {
                        throw new RuntimeException("extendt not passed real thing");
                    }
                    if (!(other instanceof JSObject)) {
                        throw new RuntimeException("can't extend with a non-object");
                    }
                    ((JSObjectBase)s.getThis()).extend((JSObject)other);
                    return null;
                }
            });
            this.set("merge", new JSFunctionCalls1(){

                public Object call(Scope s, Object other, Object[] args) {
                    if (other == null) {
                        return null;
                    }
                    Object blah = s.getThis();
                    if (blah == null || !(blah instanceof JSObject)) {
                        throw new RuntimeException("extend not passed real thing");
                    }
                    if (!(other instanceof JSObject)) {
                        throw new RuntimeException("can't extend with a non-object");
                    }
                    JSObjectBase n = new JSObjectBase();
                    n.extend((JSObject)s.getThis());
                    n.extend((JSObject)other);
                    return n;
                }
            });
            this.set("__include", new JSFunctionCalls1(){

                public Object call(Scope s, Object other, Object[] args) {
                    if (other == null) {
                        return null;
                    }
                    if (!(other instanceof JSObject)) {
                        throw new RuntimeException("can't include with a non-object");
                    }
                    Object blah = s.getThis();
                    if (blah == null || !(blah instanceof JSObjectBase)) {
                        throw new RuntimeException("extend not passed real thing");
                    }
                    ((JSObjectBase)s.getThis()).extend((JSObject)other);
                    return null;
                }
            });
            this.set("__send", new JSFunctionCalls1(){

                public Object call(Scope s, Object name, Object[] args) {
                    JSObject obj = (JSObject)s.getThis();
                    if (obj == null) {
                        throw new NullPointerException("send called on a null thing");
                    }
                    JSFunction func = (JSFunction)obj.get(name);
                    if (func == null) {
                        func = (JSFunction)obj.get("__" + name);
                    }
                    if (func == null) {
                        func = (JSFunction)s.get(name);
                    }
                    if (func == null) {
                        throw new NullPointerException("can't find method [" + name + "] to send");
                    }
                    return func.call(s, args);
                }
            });
            this.set("valueOf", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] args) {
                    return s.getThis();
                }
            });
            this.set("class", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] args) {
                    return s.getThis();
                }
            });
            this.set("__keySet", new JSFunctionCalls1(){

                public Object call(Scope s, Object name, Object[] args) {
                    JSObjectBase obj = (JSObjectBase)s.getThis();
                    return new JSArray(obj.keySet());
                }
            });
            this.set("instance_methods", new JSFunctionCalls1(){

                public Object call(Scope s, Object name, Object[] args) {
                    JSObjectBase obj = (JSObjectBase)s.getThis();
                    return new JSArray(obj.keySet());
                }
            });
            this.set("__debug", new JSFunctionCalls1(){

                public Object call(Scope s, Object name, Object[] args) {
                    JSObjectBase obj = (JSObjectBase)s.getThis();
                    obj.debug();
                    return null;
                }
            });
            this.set("__hashCode", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] args) {
                    JSObjectBase obj = (JSObjectBase)s.getThis();
                    return obj.hashCode();
                }
            });
            this.set("is_a_q_", new JSFunctionCalls1(){

                public Object call(Scope s, Object type, Object[] args) {
                    return JSInternalFunctions.JS_instanceof(s.getThis(), type);
                }
            });
            this.set("eql_q_", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] crap) {
                    return s.getThis().equals(o);
                }
            });
            this.set("_lb__rb_", new JSFunctionCalls1(){

                public Object call(Scope s, Object name, Object[] args) {
                    return ((JSObjectBase)s.getThis()).get(name);
                }
            });
            this.set("key_q_", new JSFunctionCalls1(){

                public Object call(Scope s, Object name, Object[] args) {
                    if (name == null) {
                        return null;
                    }
                    return ((JSObjectBase)s.getThis()).containsKey(name.toString());
                }
            });
            this.set("has_key_q_", this.get("key_q_"));
            this.set("__delete", new JSFunctionCalls1(){

                public Object call(Scope s, Object name, Object[] args) {
                    return ((JSObjectBase)s.getThis()).removeField(name);
                }
            });
            this.set("const_defined_q_", new JSFunctionCalls1(){

                public Object call(Scope s, Object type, Object[] args) {
                    return s.get(type) != null;
                }
            });
            this.set("__defineGetter__", new JSFunctionCalls2(){

                public Object call(Scope s, Object name, Object func, Object[] args) {
                    if (!(s.getThis() instanceof JSObjectBase)) {
                        throw new RuntimeException("not a JSObjectBase");
                    }
                    JSObjectBase o = (JSObjectBase)s.getThis();
                    o.setGetter(name.toString(), (JSFunction)func);
                    return null;
                }
            });
            this.set("__defineSetter__", new JSFunctionCalls2(){

                public Object call(Scope s, Object name, Object func, Object[] args) {
                    if (!(s.getThis() instanceof JSObjectBase)) {
                        throw new RuntimeException("not a JSObjectBase");
                    }
                    JSObjectBase o = (JSObjectBase)s.getThis();
                    o.setSetter(name.toString(), (JSFunction)func);
                    return null;
                }
            });
            this.set("__lookupGetter__", new JSFunctionCalls2(){

                public Object call(Scope s, Object name, Object func, Object[] args) {
                    if (!(s.getThis() instanceof JSObjectBase)) {
                        throw new RuntimeException("not a JSObjectBase");
                    }
                    JSObjectBase o = (JSObjectBase)s.getThis();
                    return o.getGetter(name.toString());
                }
            });
            this.set("__lookupSetter__", new JSFunctionCalls2(){

                public Object call(Scope s, Object name, Object func, Object[] args) {
                    if (!(s.getThis() instanceof JSObjectBase)) {
                        throw new RuntimeException("not a JSObjectBase");
                    }
                    JSObjectBase o = (JSObjectBase)s.getThis();
                    return o.getSetter(name.toString());
                }
            });
            this.set("to_i", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] args) {
                    return JSInternalFunctions.parseNumber(s.getThis(), null);
                }
            });
            this.set("dontEnum", new JSFunctionCalls1(){

                public Object call(Scope s, Object type, Object[] args) {
                    ((JSObjectBase)s.getThis()).dontEnum(type.toString());
                    return null;
                }
            });
            this.set("toJSON", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] args) {
                    StringBuilder buf = new StringBuilder();
                    try {
                        JSON.serialize(buf, s.getThis(), false, true, "\n");
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        throw new RuntimeException("impossible", ioe);
                    }
                    return new JSString(buf.toString());
                }
            });
            this.set("toString", DEFAULT_TO_STRING);
        }

        @Override
        public Set<String> keySet(boolean includePrototype) {
            return this._things.keySet();
        }
    }
}

