/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.db.ObjectId;
import ed.ext.org.mozilla.javascript.CompilerEnvirons;
import ed.ext.org.mozilla.javascript.Node;
import ed.ext.org.mozilla.javascript.Parser;
import ed.ext.org.mozilla.javascript.ScriptOrFnNode;
import ed.ext.org.mozilla.javascript.Token;
import ed.js.JSArray;
import ed.js.JSBoolean;
import ed.js.JSDate;
import ed.js.JSException;
import ed.js.JSFunction;
import ed.js.JSInternalFunctions;
import ed.js.JSNumericFunctions;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSRegex;
import ed.js.JSString;
import ed.js.e4x.ENode;
import ed.js.e4x.Namespace;
import ed.js.e4x.QName;
import ed.js.e4x.XMLList;
import ed.js.engine.Convert;
import ed.js.engine.Debug;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls1;
import ed.log.Logger;
import ed.util.IdentitySet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JSON {
    static boolean PRETTY = true;
    static int INDENT_AMOUNT = 4;
    public static Set<String> IGNORE_NAMES = new HashSet<String>();
    private static Scope JSON_SCOPE;
    static final Set<String> ALLOWED_FUNCTIONS;

    public static void init(Scope s) {
        s.put("tojson", new JSFunctionCalls1(){

            public Object call(Scope s, Object o, Object[] foo) {
                return new JSString(JSON.serialize(o, true));
            }
        }, true);
        s.put("tojson_u", new JSFunctionCalls1(){

            public Object call(Scope s, Object o, Object[] foo) {
                return new JSString(JSON.serialize(o, false));
            }
        }, true);
        s.put("fromjson", new JSFunctionCalls1(){

            public Object call(Scope s, Object o, Object[] foo) {
                return JSON.parse(o.toString());
            }
        }, true);
    }

    public static String serialize(Object o) {
        return JSON.serialize(o, true);
    }

    public static String serialize(Object o, boolean trusted) {
        return JSON.serialize(o, trusted, "\n");
    }

    public static String serialize(Object o, boolean trusted, String nl) {
        StringBuilder buf = new StringBuilder();
        try {
            JSON.serialize(buf, o, trusted, nl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buf.toString();
    }

    public static void serialize(Appendable a, Object o, boolean trusted) throws IOException {
        JSON.serialize(a, o, trusted, "\n");
    }

    public static void serialize(Appendable a, Object o, boolean trusted, String nl) throws IOException {
        JSON.serialize(a, o, trusted, false, nl);
    }

    public static void serialize(Appendable a, Object o, boolean trusted, boolean strict, String nl) throws IOException {
        Serializer.go(a, o, trusted, strict, 0, nl, new IdentitySet());
    }

    public static Object parse(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        CompilerEnvirons ce = new CompilerEnvirons();
        Parser p = new Parser(ce, ce.getErrorReporter());
        s = "return " + s.trim() + ";";
        ScriptOrFnNode theNode = p.parse(s, "foo", 0);
        Node ret = theNode.getFirstChild();
        Convert._assertType(ret, 4, null);
        Convert._assertOne(ret);
        Node lit = ret.getFirstChild();
        if (lit.getType() != 66 && lit.getType() != 65) {
            Debug.printTree(lit, 0);
            throw new JSException((Object)"not a literal");
        }
        return JSON.build(lit, theNode);
    }

    private static Object build(Node n, ScriptOrFnNode script) {
        if (n == null) {
            return null;
        }
        switch (n.getType()) {
            case 66: {
                JSObjectBase o = new JSObjectBase();
                Object[] names = (Object[])n.getProp(12);
                int i = 0;
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    o.set(names[i++].toString(), JSON.build(c, script));
                }
                return o;
            }
            case 65: {
                JSArray a = new JSArray();
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    a.add(JSON.build(c, script));
                }
                return a;
            }
            case 40: {
                double d = n.getDouble();
                if (JSNumericFunctions.couldBeInt(d)) {
                    return (int)d;
                }
                return d;
            }
            case 41: {
                return new JSString(n.getString());
            }
            case 42: {
                return null;
            }
            case 45: {
                return true;
            }
            case 44: {
                return false;
            }
            case 48: {
                int rId = n.getIntProp(4, -1);
                return new JSRegex(script.getRegexpString(rId), script.getRegexpFlags(rId));
            }
            case 38: {
                String name = n.getFirstChild().getString();
                Object[] args = JSON.getArgs(n.getFirstChild().getNext(), script);
                if (ALLOWED_FUNCTIONS.contains(name)) {
                    return JSON.getJsonScope().getFunction(name).call(JSON.getJsonScope(), args);
                }
                throw new RuntimeException("not allowed to call [" + name + "] in json");
            }
            case 30: {
                String name = n.getFirstChild().getString();
                Object[] args = JSON.getArgs(n.getFirstChild().getNext(), script);
                if (!ALLOWED_FUNCTIONS.contains(name)) {
                    throw new RuntimeException("not allowed to create [" + name + "] in json");
                }
                JSFunction func = JSON.getJsonScope().getFunction(name);
                Scope s = JSON.getJsonScope().child();
                JSObject newThing = func.newOne();
                s.setThis(newThing);
                func.call(s, args);
                return newThing;
            }
        }
        Debug.printTree(n, 0);
        throw new RuntimeException("don't know how to convert from json: " + Token.name((int)n.getType()));
    }

    static Object[] getArgs(Node start, ScriptOrFnNode script) {
        ArrayList<Object> l = new ArrayList<Object>();
        while (start != null) {
            l.add(JSON.build(start, script));
            start = start.getNext();
        }
        return l.toArray();
    }

    static Scope getJsonScope() {
        if (JSON_SCOPE == null) {
            JSON_SCOPE = Scope.newGlobal();
        }
        return JSON_SCOPE;
    }

    static {
        IGNORE_NAMES.add("_save");
        IGNORE_NAMES.add("_update");
        IGNORE_NAMES.add("_ns");
        ALLOWED_FUNCTIONS = new HashSet<String>();
        ALLOWED_FUNCTIONS.add("ObjectId");
        ALLOWED_FUNCTIONS.add("Date");
    }

    static class Serializer {
        static Map<Integer, String> _indents = new HashMap<Integer, String>();

        Serializer() {
        }

        static String _i(int i) {
            String s = _indents.get(i);
            if (s == null) {
                s = "";
                for (int j = 0; j < i; ++j) {
                    s = s + " ";
                }
                _indents.put(i, s);
            }
            return s;
        }

        static void string(Appendable a, String s) throws IOException {
            a.append("\"");
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\\') {
                    a.append("\\\\");
                    continue;
                }
                if (c == '\"') {
                    a.append("\\\"");
                    continue;
                }
                if (c == '\n') {
                    a.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    a.append("\\r");
                    continue;
                }
                if (c == '\t') {
                    a.append("\\t");
                    continue;
                }
                a.append(c);
            }
            a.append("\"");
        }

        static boolean _loopable(Object o) {
            if (o == null) {
                return false;
            }
            return !(o instanceof Number) && !(o instanceof String) && !(o instanceof Boolean) && !(o instanceof JSString);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void go(Appendable a, Object something, boolean trusted, boolean strict, int indent, String nl, IdentitySet seen) throws IOException {
            if (Serializer._loopable(something)) {
                if (seen.contains(something)) {
                    throw new RuntimeException("loop depetected.  can't serialize a loop : " + something + " : " + something.getClass());
                }
                seen.add(something);
            }
            if (nl.length() > 0 && a instanceof StringBuilder) {
                StringBuilder sb = (StringBuilder)a;
                int lastNL = sb.lastIndexOf(nl);
            }
            try {
                if (something == null || something instanceof JSInternalFunctions.Void) {
                    a.append("null");
                    return;
                }
                if (something instanceof Number || something instanceof Boolean || something instanceof JSRegex || something instanceof JSBoolean) {
                    a.append(something.toString());
                    return;
                }
                if (something instanceof JSDate) {
                    if (trusted) {
                        a.append("new Date( " + ((JSDate)something)._time + " ) ");
                        return;
                    }
                    a.append(new Long(((JSDate)something)._time).toString());
                    return;
                }
                if (something instanceof JSString || something instanceof String) {
                    Serializer.string(a, something.toString());
                    return;
                }
                if (something instanceof Logger) {
                    Serializer.string(a, something.toString());
                    return;
                }
                if (something instanceof ENode || something instanceof XMLList || something instanceof Namespace || something instanceof QName) {
                    a.append(something.toString());
                    return;
                }
                if (something instanceof JSFunction) {
                    if (strict) {
                        return;
                    }
                    if (trusted) {
                        String s = something.toString();
                        if (s.trim().startsWith("function ()")) {
                            a.append(s);
                        } else {
                            Serializer.string(a, s);
                        }
                        return;
                    }
                    throw new IOException("can't serialize functions in untrusted mode");
                }
                if (something instanceof ObjectId) {
                    if (trusted) {
                        a.append("ObjectId( \"" + something + "\" )");
                        return;
                    }
                    Serializer.string(a, something.toString());
                    return;
                }
                if (!(something instanceof JSObject)) {
                    Serializer.string(a, something.toString());
                    return;
                }
                if (something instanceof JSArray) {
                    JSArray arr = (JSArray)something;
                    a.append("[");
                    a.append(nl);
                    for (int i = 0; i < arr._array.size(); ++i) {
                        if (i > 0) {
                            a.append(" ,");
                            a.append(nl);
                        }
                        a.append(Serializer._i(indent + INDENT_AMOUNT));
                        Serializer.go(a, arr._array.get(i), trusted, strict, indent + INDENT_AMOUNT, nl, seen);
                    }
                    a.append(nl);
                    a.append(Serializer._i(indent));
                    a.append("]");
                    return;
                }
                if (something instanceof Scope) {
                    a.append(something.toString());
                    return;
                }
                JSObject o = (JSObject)something;
                Object foo = o.get("tojson");
                if (foo != null && foo instanceof JSFunction) {
                    a.append(((JSFunction)foo).call(Scope.getAScope()).toString());
                    return;
                }
                a.append("{");
                a.append(nl);
                boolean first = true;
                for (String s : o.keySet(false)) {
                    Object val;
                    if (IGNORE_NAMES.contains(s)) continue;
                    Object object = val = o instanceof JSObjectBase ? ((JSObjectBase)o)._simpleGet(s) : o.get(s);
                    if (val instanceof JSObjectBase) {
                        ((JSObjectBase)val).prefunc();
                        if ((o instanceof JSObjectBase ? ((JSObjectBase)o)._simpleGet(s) : o.get(s)) == null) continue;
                    }
                    if (strict && val instanceof JSFunction) continue;
                    if (first) {
                        first = false;
                    } else {
                        a.append(" ,");
                        a.append(nl);
                    }
                    a.append(Serializer._i(indent + INDENT_AMOUNT));
                    Serializer.string(a, s);
                    a.append(" : ");
                    Serializer.go(a, val, trusted, strict, indent + INDENT_AMOUNT, nl, seen);
                }
                a.append(nl);
                a.append(Serializer._i(indent));
                a.append("}");
            }
            finally {
                if (Serializer._loopable(something)) {
                    seen.remove(something);
                }
            }
        }
    }
}

