/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.js.JS;
import ed.js.JSDate;
import ed.js.JSFunction;
import ed.js.JSInternalFunctions;
import ed.js.JSNumber;
import ed.js.JSObjectBase;
import ed.js.JSString;
import ed.js.e4x.E4X;
import ed.js.e4x.ENode;
import ed.js.e4x.XMLList;

public class JSNumericFunctions
extends JSObjectBase {
    JSNumericFunctions(JSFunction cons2) {
        super(cons2);
    }

    public static final Object fixType(Object o) {
        return JSNumericFunctions.fixType(o, true);
    }

    public static final Object fixType(Object o, boolean numbers) {
        if (o == null) {
            return o;
        }
        if (o instanceof String) {
            return new JSString(o.toString());
        }
        if (numbers && o instanceof Number) {
            if (o instanceof Float || o instanceof Double) {
                Number n = (Number)o;
                double d = n.doubleValue();
                if (JSNumericFunctions.couldBeInt(d)) {
                    return n.intValue();
                }
                if (JSNumericFunctions.couldBeLong(d)) {
                    return (long)d;
                }
            }
            return o;
        }
        return o;
    }

    public static final boolean couldBeInt(double d) {
        if (d > 1.073741823E9) {
            return false;
        }
        if (d < -1.073741824E9) {
            return false;
        }
        return Math.floor(d) == d;
    }

    public static final boolean couldBeLong(double d) {
        if (d > 4.611686018427388E18) {
            return false;
        }
        if (d < -4.611686018427388E18) {
            return false;
        }
        long l = (long)d;
        return (double)l == d;
    }

    public Double JS_mul(Object a, Object b) {
        a = JSNumericFunctions._parseNumber(a);
        b = JSNumericFunctions._parseNumber(b);
        if (a != null && a instanceof Number && b != null && b instanceof Number) {
            Number an = (Number)a;
            Number bn = (Number)b;
            return an.doubleValue() * bn.doubleValue();
        }
        return Double.NaN;
    }

    public Double JS_div(Object a, Object b) {
        a = JSNumericFunctions._parseNumber(a);
        b = JSNumericFunctions._parseNumber(b);
        if (a != null && a instanceof Number && b != null && b instanceof Number) {
            Number an = (Number)a;
            Number bn = (Number)b;
            return an.doubleValue() / bn.doubleValue();
        }
        return Double.NaN;
    }

    public Double JS_sub(Object a, Object b) {
        a = JSNumericFunctions._parseNumber(a);
        b = JSNumericFunctions._parseNumber(b);
        if (a != null && a instanceof Number && b != null && b instanceof Number) {
            Number an = (Number)a;
            Number bn = (Number)b;
            return an.doubleValue() - bn.doubleValue();
        }
        return Double.NaN;
    }

    static Object _addParse(Object o) {
        if (o instanceof JSDate) {
            return o.toString();
        }
        return o;
    }

    public Object JS_add(Object a, Object b) {
        a = JSNumericFunctions._addParse(a);
        b = JSNumericFunctions._addParse(b);
        if (a != null && a instanceof Number && b != null && b instanceof Number) {
            Number an = (Number)a;
            Number bn = (Number)b;
            if (an instanceof Integer && bn instanceof Integer) {
                return an.intValue() + bn.intValue();
            }
            if (an instanceof Long && bn instanceof Integer || an instanceof Integer && bn instanceof Long) {
                return an.longValue() + bn.longValue();
            }
            return an.doubleValue() + bn.doubleValue();
        }
        if (a != null && a instanceof Number && b == null || b != null && b instanceof Number && a == null) {
            return Double.NaN;
        }
        if (a instanceof ENode && b instanceof ENode) {
            XMLList list = E4X.addNodes((ENode)a, (ENode)b);
            return list;
        }
        String s1 = JSNumericFunctions.JS_toString(a);
        String s2 = JSNumericFunctions.JS_toString(b);
        StringBuilder buf = new StringBuilder(s1.length() + s2.length() + 5);
        buf.append(s1).append(s2);
        return new JSString(buf.toString());
    }

    public static Number JS_bitor(Object a, Object b) {
        return JSNumber.toInt32(a) | JSNumber.toInt32(b);
    }

    public Number JS_bitand(Object a, Object b) {
        return JSNumber.toInt32(a) & JSNumber.toInt32(b);
    }

    public Number JS_bitxor(Object a, Object b) {
        return JSNumber.toInt32(a) ^ JSNumber.toInt32(b);
    }

    public Number JS_mod(Object a, Object b) {
        a = JSNumber.getNumber(a);
        b = JSNumber.getNumber(b);
        if (Double.isNaN(((Number)a).doubleValue()) || Double.isNaN(((Number)b).doubleValue()) || Double.isInfinite(((Number)a).doubleValue()) || ((Number)b).longValue() == 0L) {
            return Double.NaN;
        }
        return ((Number)a).longValue() % ((Number)b).longValue();
    }

    public Number JS_lsh(Object a, Object b) {
        return JSNumber.toInt32(a) << (int)JSNumber.toUint32(b);
    }

    public Number JS_rsh(Object a, Object b) {
        return JSNumber.toInt32(a) >> (int)JSNumber.toUint32(b);
    }

    public Number JS_ursh(Object a, Object b) {
        return JSNumber.toInt32(a) >>> (int)JSNumber.toUint32(b);
    }

    public Number JS_bitnot(Object a) {
        return ~JSNumber.toInt32(a);
    }

    public static String JS_toString(Object o) {
        if (o == JSInternalFunctions.VOID) {
            return "undefined";
        }
        if (o instanceof Number) {
            return JSNumber.formatNumber((Number)o);
        }
        return o + "";
    }

    static final Number _parseNumber(Object orig) {
        Object o = orig;
        if (o == null) {
            return Double.NaN;
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        if (o instanceof JSDate) {
            return ((JSDate)o).getTime();
        }
        return JSNumber.getDouble(o);
    }

    static {
        JS._debugSIStart("JSNumericFunctions");
    }
}

