/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.js.JS;
import ed.js.JSArray;
import ed.js.JSException;
import ed.js.JSFunctionBase;
import ed.js.JSInternalFunctions;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSObjectSize;
import ed.js.PrintBuffer;
import ed.js.Prototype;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.js.func.JSFunctionCalls1;
import ed.js.func.JSFunctionCalls3;
import ed.lang.Language;
import ed.util.IdentitySet;
import ed.util.SeenPath;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class JSFunction
extends JSFunctionBase {
    static final int CACHE_SIZE = 100;
    public static final String TO_STRING_PREFIX = "JSFunction : ";
    private final Scope _scope;
    private ThreadLocal<Scope> _tlScope;
    private boolean _forceUsePassedInScope = false;
    private final ThreadLocal<Boolean> _forceUsePassedInScopeTL = new ThreadLocal();
    private boolean _forceUsePassedInScopeTLEver = false;
    protected JSObjectBase _prototype;
    protected Language _sourceLanguage = Language.JS();
    protected JSArray _arguments;
    protected JSArray _globals;
    protected String _name = "NO NAME SET";
    private FunctionResultCache _callCache;
    public static JSFunction _call;
    static JSFunction _apply;
    static JSFunction _cache;
    static JSFunction _cacheSize;
    private static JSObjectBase _staticFunctions;

    public JSFunction(int num) {
        this(null, null, num);
    }

    public JSFunction(Scope scope, String name, int num) {
        super(num);
        this._scope = scope;
        this._name = name;
        this._prototype = new JSObjectBase(this);
        this.set("prototype", this._prototype);
        this.set("length", num);
        this.setProperties("length", JSObjectBase.LOCK);
        this.init();
    }

    public int getNumParameters() {
        return this._num;
    }

    public Object set(Object n, Object b) {
        if (n != null && "prototype".equals(n.toString())) {
            this._prototype = (JSObjectBase)b;
        }
        return super.set(n, b);
    }

    public JSObject newOne() {
        return new JSObjectBase(this);
    }

    protected void init() {
    }

    public Object get(Object n) {
        Object foo = super.get(n);
        if (foo != null) {
            return foo;
        }
        if (this._prototype != null && (foo = this._prototype.get(n)) != null) {
            return foo;
        }
        foo = _staticFunctions.get(n);
        if (foo != null) {
            return foo;
        }
        return null;
    }

    public JSFunction getFunction(String name, boolean tryLower) {
        Object blah = this._prototype.get(name);
        if (blah == null && tryLower) {
            blah = this._prototype.get(name.toLowerCase());
        }
        if (blah == null) {
            return null;
        }
        if (!(blah instanceof JSFunction)) {
            return null;
        }
        return (JSFunction)blah;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public Scope getAScopeForThis() {
        if (this._scope == null) {
            return new Scope();
        }
        return this._scope.child();
    }

    public Scope getScope() {
        return this.getScope(false);
    }

    public JSObject getPrototype() {
        return this._prototype;
    }

    public Scope getScope(boolean threadLocal) {
        Scope s = null;
        if (this._tlScope != null && (s = this._tlScope.get()) != null) {
            return s;
        }
        if (threadLocal) {
            s = this._scope == null ? new Scope("func tl scope", null) : this._scope.child("func tl scope");
            s.setGlobal(true);
            this.setTLScope(s);
            return s;
        }
        return this._scope;
    }

    public void setTLScope(Scope tl) {
        if (this._tlScope == null) {
            this._tlScope = new ThreadLocal();
        }
        this._tlScope.set(tl);
    }

    public Scope getTLScope() {
        if (this._tlScope == null) {
            return null;
        }
        return this._tlScope.get();
    }

    public void clearScope() {
        Scope s;
        if (this._tlScope != null && (s = this._tlScope.get()) != null) {
            s.reset();
        }
    }

    public String getSourceCode() {
        return null;
    }

    public String toString() {
        return TO_STRING_PREFIX + this._name;
    }

    public JSArray argumentNames() {
        if (this._arguments != null) {
            return this._arguments;
        }
        JSArray temp = new JSArray();
        for (int i = 0; i < this._num; ++i) {
            temp.add("unknown" + i);
        }
        return temp;
    }

    public boolean usePassedInScope() {
        if (this._forceUsePassedInScope) {
            return true;
        }
        if (!this._forceUsePassedInScopeTLEver) {
            return false;
        }
        Boolean b = this._forceUsePassedInScopeTL.get();
        return b == null ? false : b;
    }

    public void setUsePassedInScope(boolean usePassedInScope) {
        this._forceUsePassedInScope = usePassedInScope;
    }

    public Boolean setUsePassedInScopeTL(Boolean usePassedInScopeTL) {
        this._forceUsePassedInScopeTLEver = this._forceUsePassedInScopeTLEver || usePassedInScopeTL != false;
        Boolean old = this._forceUsePassedInScopeTL.get();
        this._forceUsePassedInScopeTL.set(usePassedInScopeTL);
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object _cache(Scope s, long cacheTime, Object[] args) {
        JSFunction print2;
        FunctionResultCache myCache = this._callCache;
        if (myCache == null) {
            this._callCache = myCache = new FunctionResultCache();
        }
        myCache = this._callCache;
        long now = System.currentTimeMillis();
        Long hash = JSInternalFunctions.hash(args);
        CacheEntry entry = null;
        boolean force = false;
        FunctionResultCache functionResultCache = myCache;
        synchronized (functionResultCache) {
            entry = (CacheEntry)myCache.get(hash);
            if (entry != null && entry.expired(now)) {
                entry.setExpiration(now + cacheTime);
                entry = null;
                force = true;
            }
        }
        if (entry == null) {
            String synckey;
            String string = synckey = ("function-synckey" + System.identityHashCode(this) + ":" + hash).intern();
            synchronized (string) {
                FunctionResultCache functionResultCache2 = myCache;
                synchronized (functionResultCache2) {
                    entry = (CacheEntry)myCache.get(hash);
                }
                if (entry == null || force) {
                    PrintBuffer buf = new PrintBuffer();
                    this.getScope(true).set("print", buf);
                    entry = new CacheEntry(now + cacheTime, this.call(s, args), buf.toString());
                    FunctionResultCache functionResultCache3 = myCache;
                    synchronized (functionResultCache3) {
                        myCache.put(hash, entry);
                    }
                    this.clearScope();
                }
            }
        }
        if ((print2 = (JSFunction)s.get("print")) == null) {
            throw new JSException((Object)"print is null");
        }
        print2.call(s, entry._print);
        return entry._res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callAndSetThis(Scope s, Object obj, Object[] args) {
        if (s == null) {
            s = new Scope();
        }
        s.setThis(obj);
        try {
            Object object = this.call(s, args);
            return object;
        }
        finally {
            s.clearThisNormal(null);
        }
    }

    public JSFunction synchronizedVersion() {
        final JSFunction t = this;
        final String myLock = "some-lock-" + Math.random();
        return new JSFunctionCalls0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Scope s, Object[] args) {
                String string = myLock;
                synchronized (string) {
                    return t.call(s, args);
                }
            }
        };
    }

    public long approxSize(SeenPath seen) {
        long size = super.approxSize(seen);
        size += 128L;
        if (seen.shouldVisit((Object)this._prototype, (Object)this)) {
            size += this._prototype.approxSize(seen);
        }
        if (seen.shouldVisit((Object)this._callCache, (Object)this)) {
            size += this._callCache.approxSize(seen);
        }
        if (seen.shouldVisit((Object)this._scope, (Object)this)) {
            size += this._scope.approxSize(seen);
        }
        return size;
    }

    public Language getSourceLanguage() {
        return this._sourceLanguage;
    }

    public int hashCode(IdentitySet seen) {
        return System.identityHashCode(this);
    }

    public boolean isCallable() {
        return true;
    }

    public JSArray getGlobals() {
        return this._globals;
    }

    public static void _init(JSFunction fcons) {
        if (_staticFunctions == null) {
            return;
        }
        for (String s : _staticFunctions.keySet()) {
            fcons._prototype.set(s, _staticFunctions.get(s));
        }
        fcons._prototype.dontEnumExisting();
    }

    static {
        JS._debugSIStart("JSFunction");
        _call = new JSFunctionCalls1(){

            public Object call(Scope s, Object obj, Object[] args) {
                JSFunction func = (JSFunction)s.getThis();
                return func.callAndSetThis(s, obj, args);
            }
        };
        _apply = new JSFunctionCalls3(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Scope s, Object obj, Object args, Object explodeArgs, Object[] foo) {
                JSFunction func = (JSFunction)s.getThis();
                if (args == null) {
                    args = new JSArray();
                }
                if (!(args instanceof JSArray)) {
                    throw new RuntimeException("second argument to Function.prototype.apply must be an array not a " + args.getClass());
                }
                JSArray jary = (JSArray)args;
                if (explodeArgs instanceof JSObject) {
                    if (func._arguments == null) {
                        throw new RuntimeException("can't explode b/c no argument unnamed");
                    }
                    JSObject explode = (JSObject)explodeArgs;
                    for (int i = 0; i < func._arguments.size(); ++i) {
                        String name = func._arguments.get(i).toString();
                        if (!explode.containsKey(name)) continue;
                        if (jary.get(i) != null) {
                            throw new RuntimeException("can't have a named an array value for [" + name + "]");
                        }
                        jary.set(i, explode.get(name));
                    }
                }
                s.setThis(obj);
                try {
                    Object object = func.call(s, jary.toArray());
                    return object;
                }
                finally {
                    s.clearThisNormal(null);
                }
            }
        };
        _cache = new JSFunctionCalls1(){

            public Object call(Scope s, Object cacheTimeObj, Object[] args) {
                JSFunction func = (JSFunction)s.getThis();
                long cacheTime = Long.MAX_VALUE;
                if (cacheTimeObj != null && cacheTimeObj instanceof Number) {
                    cacheTime = ((Number)cacheTimeObj).longValue();
                }
                return func._cache(s, cacheTime, args);
            }
        };
        _cacheSize = new JSFunctionCalls0(){

            public Object call(Scope s, Object[] args) {
                JSFunction func = (JSFunction)s.getThis();
                if (func._callCache == null) {
                    return 0;
                }
                return func._callCache.size();
            }
        };
        _staticFunctions = new JSObjectBase();
        _staticFunctions.set("wrap", Prototype._functionWrap);
        _staticFunctions.set("bind", Prototype._functionBind);
        Prototype._functionWrap.lock();
        Prototype._functionBind.lock();
        _staticFunctions.set("call", _call);
        _staticFunctions.set("apply", _apply);
        _staticFunctions.set("cache", _cache);
        _staticFunctions.set("cacheSize", _cacheSize);
        _call.lock();
        _apply.lock();
        _cache.lock();
        _cacheSize.lock();
        JS._debugSIDone("JSFunction");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FunctionResultCache
    extends LinkedHashMap<Long, CacheEntry> {
        FunctionResultCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long approxSize(SeenPath seen) {
            long s = 0L;
            FunctionResultCache functionResultCache = this;
            synchronized (functionResultCache) {
                for (Map.Entry e : this.entrySet()) {
                    CacheEntry ce = (CacheEntry)e.getValue();
                    s += (long)(64 + ce._print.length() * 2) + JSObjectSize.size(ce._res, seen, this);
                }
            }
            return s;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, CacheEntry> eldest) {
            return this.size() > 100;
        }
    }

    static class CacheEntry {
        long _expiration;
        final Object _res;
        final String _print;

        CacheEntry(long expiration, Object res, String print2) {
            this._expiration = expiration;
            this._res = res;
            this._print = print2;
        }

        boolean expired(long now) {
            return now > this._expiration;
        }

        void setExpiration(long when) {
            this._expiration = when;
        }
    }
}

