/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class JSBinaryData {
    public abstract int length();

    public abstract void put(ByteBuffer var1);

    public abstract void write(OutputStream var1) throws IOException;

    public abstract ByteBuffer asByteBuffer();

    public String toString() {
        return "JSBinaryData";
    }

    public static class ByteArray
    extends JSBinaryData {
        final byte[] _data;
        final int _offset;
        final int _len;

        public ByteArray(byte[] data) {
            this(data, 0, data.length);
        }

        public ByteArray(byte[] data, int offset, int len) {
            this._data = data;
            this._offset = offset;
            this._len = len;
        }

        public int length() {
            return this._len;
        }

        public void put(ByteBuffer buf) {
            buf.put(this._data, this._offset, this._len);
        }

        public void write(OutputStream out) throws IOException {
            out.write(this._data, this._offset, this._len);
        }

        public ByteBuffer asByteBuffer() {
            return ByteBuffer.wrap(this._data, this._offset, this._len);
        }
    }
}

