/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import ed.js.JSFunction;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls1;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encoding {
    public static JSFunction escape = new JSFunctionCalls1(){

        public Object call(Scope s, Object o, Object[] extra) {
            return new JSString(Encoding._escape(o.toString(), _noEscaping));
        }
    };
    public static JSFunction encodeURI = new JSFunctionCalls1(){

        public Object call(Scope s, Object o, Object[] extra) {
            return new JSString(Encoding._escape(o.toString(), _noEncoding));
        }
    };
    public static JSFunction encodeURIComponent = new JSFunctionCalls1(){

        public Object call(Scope s, Object o, Object[] extra) {
            return new JSString(Encoding._escape(o.toString(), _noEncodingComonent));
        }
    };
    public static JSFunction unescape = new JSFunctionCalls1(){

        public Object call(Scope s, Object o, Object[] extra) {
            return new JSString(Encoding._unescape(o.toString()));
        }
    };
    static final int _upperDiff = -32;
    static final Set<Character> _noEscaping = new HashSet<Character>();
    static final Set<Character> _noEncoding = new HashSet<Character>();
    static final Set<Character> _noEncodingComonent = new HashSet<Character>();
    public static JSFunction escapeHTML;

    static final String _escape(String str, Set<Character> skip) {
        StringBuilder buf = new StringBuilder((int)((double)str.length() * 1.5));
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c;
            char val = c = str.charAt(i);
            if ((c + "").matches("\\w") || skip.contains(Character.valueOf(c))) {
                buf.append(c);
                continue;
            }
            if (val >= '\u0100') {
                buf.append("%u");
                Encoding.toHex(c, 4, buf);
                continue;
            }
            buf.append("%");
            Encoding.toHex(c, 2, buf);
        }
        return buf.toString();
    }

    static final char _forDigit(int val) {
        char c = Character.forDigit(val, 16);
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
        }
        return c;
    }

    public static final String _unescape(String str) {
        StringBuilder buf = new StringBuilder(str.length());
        int len = str.length();
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (c == '%') {
                String toDecode;
                if (i <= len - 6 && str.charAt(i + 1) == 'u' && Encoding._isHex(toDecode = str.substring(i + 2, i + 6))) {
                    buf.append(Character.toChars(Integer.parseInt(toDecode, 16))[0]);
                    i += 6;
                    continue;
                }
                if (i <= len - 3 && Encoding._isHex(toDecode = str.substring(i + 1, i + 3))) {
                    buf.append(Character.toChars(Integer.parseInt(toDecode, 16))[0]);
                    i += 3;
                    continue;
                }
            }
            buf.append(c);
            ++i;
        }
        return buf.toString();
    }

    static final boolean _isHex(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Encoding._isHex(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static final boolean _isHex(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'a' && c <= 'f') {
            return true;
        }
        return c >= 'A' && c <= 'F';
    }

    static void toHex(char c, int size, StringBuilder buf) {
        int s = c;
        --size;
        while (size >= 0) {
            int num = s / (int)Math.pow(16.0, size);
            switch (num) {
                case 15: {
                    buf.append('F');
                    break;
                }
                case 14: {
                    buf.append('E');
                    break;
                }
                case 13: {
                    buf.append('D');
                    break;
                }
                case 12: {
                    buf.append('C');
                    break;
                }
                case 11: {
                    buf.append('B');
                    break;
                }
                case 10: {
                    buf.append('A');
                    break;
                }
                default: {
                    buf.append(num);
                }
            }
            s %= (int)Math.pow(16.0, size);
            --size;
        }
    }

    public static String _escapeHTML(String html) {
        if (html == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder((int)((double)html.length() * 1.2));
        int max = html.length();
        block7: for (int i = 0; i < max; ++i) {
            char c = html.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&#39;");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static void install(Scope s) {
        s.set("escape", escape);
        s.set("encodeURI", encodeURI);
        s.set("encodeURIComponent", encodeURIComponent);
        s.set("unescape", unescape);
        s.set("decodeURI", unescape);
        s.set("decodeURIComponent", unescape);
        s.set("escapeHTML", escapeHTML);
    }

    static {
        _noEscaping.add(Character.valueOf('@'));
        _noEscaping.add(Character.valueOf('*'));
        _noEscaping.add(Character.valueOf('-'));
        _noEscaping.add(Character.valueOf('+'));
        _noEscaping.add(Character.valueOf('/'));
        _noEscaping.add(Character.valueOf('.'));
        _noEncoding.add(Character.valueOf('~'));
        _noEncoding.add(Character.valueOf('!'));
        _noEncoding.add(Character.valueOf('@'));
        _noEncoding.add(Character.valueOf('#'));
        _noEncoding.add(Character.valueOf('$'));
        _noEncoding.add(Character.valueOf('&'));
        _noEncoding.add(Character.valueOf('*'));
        _noEncoding.add(Character.valueOf('('));
        _noEncoding.add(Character.valueOf(')'));
        _noEncoding.add(Character.valueOf('-'));
        _noEncoding.add(Character.valueOf('+'));
        _noEncoding.add(Character.valueOf('='));
        _noEncoding.add(Character.valueOf(';'));
        _noEncoding.add(Character.valueOf(':'));
        _noEncoding.add(Character.valueOf('\''));
        _noEncoding.add(Character.valueOf('/'));
        _noEncoding.add(Character.valueOf('?'));
        _noEncoding.add(Character.valueOf('.'));
        _noEncoding.add(Character.valueOf(','));
        _noEncodingComonent.add(Character.valueOf('~'));
        _noEncodingComonent.add(Character.valueOf('!'));
        _noEncodingComonent.add(Character.valueOf('*'));
        _noEncodingComonent.add(Character.valueOf('('));
        _noEncodingComonent.add(Character.valueOf(')'));
        _noEncodingComonent.add(Character.valueOf('-'));
        _noEncodingComonent.add(Character.valueOf('\''));
        _noEncodingComonent.add(Character.valueOf('.'));
        escapeHTML = new JSFunctionCalls1(){

            public Object call(Scope s, Object o, Object[] extra) {
                if (o == null) {
                    return null;
                }
                return new JSString(Encoding._escapeHTML(o.toString()));
            }
        };
    }
}

