/*
 * Decompiled with CFR 0.152.
 */
package ed.ext.org.mozilla.javascript.optimizer;

import ed.ext.org.mozilla.javascript.Callable;
import ed.ext.org.mozilla.javascript.Context;
import ed.ext.org.mozilla.javascript.ContextAction;
import ed.ext.org.mozilla.javascript.JavaScriptException;
import ed.ext.org.mozilla.javascript.NativeFunction;
import ed.ext.org.mozilla.javascript.NativeGenerator;
import ed.ext.org.mozilla.javascript.Script;
import ed.ext.org.mozilla.javascript.ScriptRuntime;
import ed.ext.org.mozilla.javascript.Scriptable;
import ed.ext.org.mozilla.javascript.ScriptableObject;

public final class OptRuntime
extends ScriptRuntime {
    public static final Double zeroObj = new Double(0.0);
    public static final Double oneObj = new Double(1.0);
    public static final Double minusOneObj = new Double(-1.0);

    public static Object call0(Callable fun, Scriptable thisObj, Context cx, Scriptable scope) {
        return fun.call(cx, scope, thisObj, ScriptRuntime.emptyArgs);
    }

    public static Object call1(Callable fun, Scriptable thisObj, Object arg0, Context cx, Scriptable scope) {
        return fun.call(cx, scope, thisObj, new Object[]{arg0});
    }

    public static Object call2(Callable fun, Scriptable thisObj, Object arg0, Object arg1, Context cx, Scriptable scope) {
        return fun.call(cx, scope, thisObj, new Object[]{arg0, arg1});
    }

    public static Object callN(Callable fun, Scriptable thisObj, Object[] args, Context cx, Scriptable scope) {
        return fun.call(cx, scope, thisObj, args);
    }

    public static Object callName(Object[] args, String name, Context cx, Scriptable scope) {
        Callable f = OptRuntime.getNameFunctionAndThis(name, cx, scope);
        Scriptable thisObj = OptRuntime.lastStoredScriptable(cx);
        return f.call(cx, scope, thisObj, args);
    }

    public static Object callName0(String name, Context cx, Scriptable scope) {
        Callable f = OptRuntime.getNameFunctionAndThis(name, cx, scope);
        Scriptable thisObj = OptRuntime.lastStoredScriptable(cx);
        return f.call(cx, scope, thisObj, ScriptRuntime.emptyArgs);
    }

    public static Object callProp0(Object value, String property, Context cx, Scriptable scope) {
        Callable f = OptRuntime.getPropFunctionAndThis(value, property, cx);
        Scriptable thisObj = OptRuntime.lastStoredScriptable(cx);
        return f.call(cx, scope, thisObj, ScriptRuntime.emptyArgs);
    }

    public static Object add(Object val1, double val2) {
        if (val1 instanceof Scriptable) {
            val1 = ((Scriptable)val1).getDefaultValue(null);
        }
        if (!(val1 instanceof String)) {
            return OptRuntime.wrapDouble(OptRuntime.toNumber(val1) + val2);
        }
        return ((String)val1).concat(OptRuntime.toString(val2));
    }

    public static Object add(double val1, Object val2) {
        if (val2 instanceof Scriptable) {
            val2 = ((Scriptable)val2).getDefaultValue(null);
        }
        if (!(val2 instanceof String)) {
            return OptRuntime.wrapDouble(OptRuntime.toNumber(val2) + val1);
        }
        return OptRuntime.toString(val1).concat((String)val2);
    }

    public static Object elemIncrDecr(Object obj, double index, Context cx, int incrDecrMask) {
        return ScriptRuntime.elemIncrDecr(obj, new Double(index), cx, incrDecrMask);
    }

    public static Object[] padStart(Object[] currentArgs, int count) {
        Object[] result = new Object[currentArgs.length + count];
        System.arraycopy(currentArgs, 0, result, count, currentArgs.length);
        return result;
    }

    public static void initFunction(NativeFunction fn, int functionType, Scriptable scope, Context cx) {
        ScriptRuntime.initFunction(cx, scope, fn, functionType, false);
    }

    public static Object callSpecial(Context cx, Callable fun, Scriptable thisObj, Object[] args, Scriptable scope, Scriptable callerThis, int callType, String fileName, int lineNumber) {
        return ScriptRuntime.callSpecial(cx, fun, thisObj, args, scope, callerThis, callType, fileName, lineNumber);
    }

    public static Object newObjectSpecial(Context cx, Object fun, Object[] args, Scriptable scope, Scriptable callerThis, int callType) {
        return ScriptRuntime.newSpecial(cx, fun, args, scope, callType);
    }

    public static Double wrapDouble(double num) {
        if (num == 0.0) {
            if (1.0 / num > 0.0) {
                return zeroObj;
            }
        } else {
            if (num == 1.0) {
                return oneObj;
            }
            if (num == -1.0) {
                return minusOneObj;
            }
            if (num != num) {
                return NaNobj;
            }
        }
        return new Double(num);
    }

    static String encodeIntArray(int[] array) {
        if (array == null) {
            return null;
        }
        int n = array.length;
        char[] buffer = new char[1 + n * 2];
        buffer[0] = '\u0001';
        for (int i = 0; i != n; ++i) {
            int value = array[i];
            int shift = 1 + i * 2;
            buffer[shift] = (char)(value >>> 16);
            buffer[shift + 1] = (char)value;
        }
        return new String(buffer);
    }

    private static int[] decodeIntArray(String str, int arraySize) {
        if (arraySize == 0) {
            if (str != null) {
                throw new IllegalArgumentException();
            }
            return null;
        }
        if (str.length() != 1 + arraySize * 2 && str.charAt(0) != '\u0001') {
            throw new IllegalArgumentException();
        }
        int[] array = new int[arraySize];
        for (int i = 0; i != arraySize; ++i) {
            int shift = 1 + i * 2;
            array[i] = str.charAt(shift) << 16 | str.charAt(shift + 1);
        }
        return array;
    }

    public static Scriptable newArrayLiteral(Object[] objects, String encodedInts, int skipCount, Context cx, Scriptable scope) {
        int[] skipIndexces = OptRuntime.decodeIntArray(encodedInts, skipCount);
        return OptRuntime.newArrayLiteral(objects, skipIndexces, cx, scope);
    }

    public static void main(final Script script, final String[] args) {
        Context.call(new ContextAction(){

            public Object run(Context cx) {
                ScriptableObject global = ScriptRuntime.getGlobal(cx);
                Object[] argsCopy = new Object[args.length];
                System.arraycopy(args, 0, argsCopy, 0, args.length);
                Scriptable argsObj = cx.newArray((Scriptable)global, argsCopy);
                global.defineProperty("arguments", argsObj, 2);
                script.exec(cx, global);
                return null;
            }
        });
    }

    public static void throwStopIteration(Object obj) {
        Scriptable top = ScriptableObject.getTopLevelScope((ScriptableObject)obj);
        Object e = top.get("StopIteration", (Scriptable)((ScriptableObject)obj));
        throw new JavaScriptException(e, "", 0);
    }

    public static Scriptable createNativeGenerator(NativeFunction funObj, Scriptable scope, int maxLocals, int maxStack) {
        return new NativeGenerator(scope, funObj, new RuntimeGeneratorState(maxLocals, maxStack));
    }

    public static int GetGeneratorResumptionPoint(Object obj) {
        return ((RuntimeGeneratorState)obj).getGeneratorState();
    }

    public static void SetGeneratorResumptionPoint(Object obj, int rp) {
        ((RuntimeGeneratorState)obj).setGeneratorState(rp);
    }

    public static Object[] GetGeneratorStackState(Object obj) {
        return ((RuntimeGeneratorState)obj).getStackState();
    }

    public static Object[] GetGeneratorLocalsState(Object obj) {
        return ((RuntimeGeneratorState)obj).getLocalsState();
    }

    public static class RuntimeGeneratorState {
        public int resumptionPoint = 0;
        public Object[] stackState = null;
        public Object[] localsState = null;
        public boolean hasClosed = false;
        private int maxLocals;
        private int maxStack;

        public RuntimeGeneratorState(int maxLocals, int maxStack) {
            this.maxLocals = maxLocals;
            this.maxStack = maxStack;
        }

        public int getGeneratorState() {
            return this.resumptionPoint;
        }

        public void setGeneratorState(int rp) {
            this.resumptionPoint = rp;
        }

        public boolean getHasClosed() {
            return this.hasClosed;
        }

        public void setHasClosed(boolean flag) {
            this.hasClosed = flag;
        }

        public Object[] getStackState() {
            if (this.stackState == null) {
                this.stackState = new Object[this.maxStack];
            }
            return this.stackState;
        }

        public Object[] getLocalsState() {
            if (this.localsState == null) {
                this.localsState = new Object[this.maxLocals];
            }
            return this.localsState;
        }
    }
}

