/*
 * Decompiled with CFR 0.152.
 */
package ed.ext.org.mozilla.javascript;

import ed.ext.org.mozilla.javascript.BaseFunction;
import ed.ext.org.mozilla.javascript.Context;
import ed.ext.org.mozilla.javascript.Decompiler;
import ed.ext.org.mozilla.javascript.EvaluatorException;
import ed.ext.org.mozilla.javascript.NativeCall;
import ed.ext.org.mozilla.javascript.ScriptRuntime;
import ed.ext.org.mozilla.javascript.Scriptable;
import ed.ext.org.mozilla.javascript.UintMap;
import ed.ext.org.mozilla.javascript.debug.DebuggableScript;

public abstract class NativeFunction
extends BaseFunction {
    public final void initScriptFunction(Context cx, Scriptable scope) {
        ScriptRuntime.setFunctionProtoAndParent(this, scope);
    }

    final String decompile(int indent, int flags) {
        String encodedSource = this.getEncodedSource();
        if (encodedSource == null) {
            return super.decompile(indent, flags);
        }
        UintMap properties = new UintMap(1);
        properties.put(1, indent);
        return Decompiler.decompile(encodedSource, flags, properties);
    }

    public int getLength() {
        int paramCount = this.getParamCount();
        if (this.getLanguageVersion() != 120) {
            return paramCount;
        }
        Context cx = Context.getContext();
        NativeCall activation = ScriptRuntime.findFunctionActivation(cx, this);
        if (activation == null) {
            return paramCount;
        }
        return activation.originalArgs.length;
    }

    public int getArity() {
        return this.getParamCount();
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }

    public String getEncodedSource() {
        return null;
    }

    public DebuggableScript getDebuggableView() {
        return null;
    }

    public Object resumeGenerator(Context cx, Scriptable scope, int operation, Object state, Object value) {
        throw new EvaluatorException("resumeGenerator() not implemented");
    }

    protected abstract int getLanguageVersion();

    protected abstract int getParamCount();

    protected abstract int getParamAndVarCount();

    protected abstract String getParamOrVarName(int var1);

    protected abstract boolean getParamOrVarConst(int var1);
}

