/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import ed.js.JSString;
import ed.util.ThreadUtil;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectId
implements Comparable<ObjectId> {
    static final boolean D = false;
    final long _base;
    final int _inc;
    boolean _new;
    private static byte _nextByte = (byte)new Random().nextInt();
    private static short _nextShort = (short)new Random().nextInt();
    private static final String _incLock = new String("ObjectId._incLock");
    private static int _time = (int)(System.currentTimeMillis() / 1000L);
    static final Thread _timeFixer;
    private static final long _machine;
    private static final int _bottomTop;

    public static ObjectId get() {
        return new ObjectId();
    }

    public static boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() < 18) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static ObjectId massageToObjectId(Object o) {
        String s;
        if (o == null) {
            return null;
        }
        if (o instanceof ObjectId) {
            return (ObjectId)o;
        }
        if ((o instanceof String || o instanceof JSString) && ObjectId.isValid(s = o.toString())) {
            return new ObjectId(s);
        }
        return null;
    }

    public ObjectId(String s) {
        if (!ObjectId.isValid(s)) {
            throw new IllegalArgumentException("invalid ObjectId [" + s + "]");
        }
        String baseString = s.substring(0, 16);
        String incString = s.substring(16);
        this._base = Long.parseLong(baseString, 16);
        this._inc = Integer.parseInt(incString, 16);
        this._new = false;
    }

    ObjectId(long base, int inc) {
        this._base = base;
        this._inc = inc;
        this._new = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId() {
        this._base = (long)_time << 32 | _machine;
        String string = _incLock;
        synchronized (string) {
            if (_nextShort == Short.MAX_VALUE) {
                _nextByte = (byte)(_nextByte + 1);
            }
            int myb = _nextByte << 16 & 0xFF0000;
            short s = _nextShort;
            _nextShort = (short)(s + 1);
            int myi = s & 0xFFFF;
            this._inc = myb | myi;
        }
        this._new = true;
    }

    public int hashCode() {
        return this._inc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        ObjectId other = ObjectId.massageToObjectId(o);
        if (other == null) {
            return false;
        }
        return this._base == other._base && this._inc == other._inc;
    }

    public String toString() {
        int i;
        String a = Long.toHexString(this._base);
        String b = Integer.toHexString(this._inc);
        StringBuilder buf = new StringBuilder(16);
        for (i = 0; i < 16 - a.length(); ++i) {
            buf.append("0");
        }
        buf.append(a);
        for (i = 0; i < 8 - b.length(); ++i) {
            buf.append("0");
        }
        buf.append(b);
        return buf.toString();
    }

    @Override
    public int compareTo(ObjectId id) {
        if (id == null) {
            return -1;
        }
        if (id._base == this._base) {
            if (this._inc < id._inc) {
                return -1;
            }
            if (this._inc > id._inc) {
                return 1;
            }
            return 0;
        }
        if (this._base < id._base) {
            return -1;
        }
        if (this._base > id._base) {
            return 1;
        }
        return 0;
    }

    public static void main(String[] args) {
        ObjectId o;
        ObjectId i;
        HashSet<ObjectId> s = new HashSet<ObjectId>();
        do {
            if (s.contains(i = ObjectId.get())) {
                throw new RuntimeException("fuck");
            }
            s.add(i);
        } while (i.equals(o = new ObjectId(i.toString())));
        throw new RuntimeException(o.toString() + " != " + i.toString());
    }

    static {
        try {
            int startTime = (int)(ManagementFactory.getRuntimeMXBean().getStartTime() & 0xFFFFL);
            _bottomTop = (startTime & 0xFF) << 24;
            int machinePiece = (InetAddress.getLocalHost().getHostName().hashCode() & 0xFFFFFF) << 8;
            _machine = (startTime >> 8 | machinePiece) & Integer.MAX_VALUE;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        _timeFixer = new Thread("ObjectId-TimeFixer"){

            public void run() {
                while (true) {
                    ThreadUtil.sleep((long)499L);
                    _time = (int)(System.currentTimeMillis() / 1000L);
                }
            }
        };
        _timeFixer.setDaemon(true);
        _timeFixer.start();
    }
}

