/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import ed.MyAsserts;
import ed.db.DBBase;
import ed.db.DBCollection;
import ed.db.ObjectId;
import ed.js.JS;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.log.Logger;
import java.util.HashMap;

public class DBRef
extends JSObjectBase {
    static final boolean D = Boolean.getBoolean("DEBUG.DBREF");
    final JSObject _parent;
    final String _fieldName;
    final ObjectId _id;
    final String _ns;
    final DBBase _db;
    boolean _inited = false;
    boolean _loaded = false;
    boolean _doneLoading = false;
    private Object _actual;
    private boolean _loadedPointedTo = false;
    private JSObject _pointedTo;

    DBRef(JSObject parent, String fieldName, DBBase db, String ns, ObjectId id) {
        this._parent = parent;
        this._fieldName = fieldName;
        this._ns = ns;
        this._id = id;
        this._db = db;
        super.set((Object)"_ns", (Object)ns);
        super.set((Object)"_id", (Object)id);
        this._inited = true;
        this.markClean();
    }

    public boolean isNull() {
        if (this._db == null) {
            return false;
        }
        return this._getPointedTo() == null;
    }

    public JSObject getRealObject() {
        JSObject o = this._getPointedTo();
        if (JS.isBaseObject((Object)o)) {
            return this;
        }
        return o;
    }

    public Object prefunc() {
        return this.doLoad();
    }

    public Object doLoad() {
        if (!this._inited) {
            return this._actual;
        }
        if (this._loaded) {
            return this._actual;
        }
        JSObject o = this._getPointedTo();
        if (o == null) {
            this._parent.set((Object)this._fieldName, null);
            return null;
        }
        MyAsserts.assertEquals((Object)this._id, (Object)o.get((Object)"_id"));
        MyAsserts.assertEquals((String)this._ns.toString(), (Object)o.get((Object)"_ns").toString());
        this._loaded = true;
        DBRef ret = this;
        if (!JS.isBaseObject((Object)o)) {
            this._parent.set((Object)this._fieldName, (Object)o);
            ret = o;
        }
        if (o instanceof JSObjectBase) {
            this.setConstructor(((JSObjectBase)o).getConstructor());
        }
        this.addAll(o);
        this._doneLoading = true;
        this.markClean();
        this._actual = ret;
        return ret;
    }

    public boolean isDirty() {
        return this._doneLoading && super.isDirty();
    }

    private JSObject _getPointedTo() {
        JSObject o;
        if (this._loadedPointedTo) {
            return this._pointedTo;
        }
        if (this._db == null) {
            return this;
        }
        if (D) {
            System.out.println("following dbref.  parent.field:" + this._fieldName + " ref to ns:" + this._ns);
            Throwable t = new Throwable();
            t.fillInStackTrace();
            t.printStackTrace();
        }
        RefCache rc = DBRef.getRefCache();
        DBCollection coll = this._db.getCollectionFromString(this._ns);
        JSObject jSObject = o = rc == null ? null : (JSObject)rc.get(this._id);
        if (o == null) {
            o = coll.find(this._id);
            if (o != null && rc != null) {
                rc.put(this._id, o);
            }
        } else {
            coll.apply(o);
        }
        if (o == null) {
            Logger.getRoot().getChild("missingref").info((Object)("ns:" + this._ns + " id:" + this._id));
        }
        this._pointedTo = o;
        this._loadedPointedTo = true;
        return this._pointedTo;
    }

    static void objectSaved(Object id) {
        if (id instanceof ObjectId) {
            DBRef.objectSaved((ObjectId)id);
        }
    }

    static void objectSaved(ObjectId id) {
        if (id == null) {
            return;
        }
        RefCache rc = DBRef.getRefCache();
        if (rc == null) {
            return;
        }
        rc.remove(id);
    }

    private static RefCache getRefCache() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RefCache
    extends HashMap<ObjectId, JSObject> {
        private RefCache() {
        }
    }
}

