/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import ed.db.Bytes;
import ed.db.DBApiLayer;
import ed.db.DBCollection;
import ed.db.DBRef;
import ed.js.JS;
import ed.js.JSArray;
import ed.js.JSFunction;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSObjectLame;
import ed.js.JSObjectSize;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls1;
import ed.lang.ProfilingTracker;
import ed.util.OrderedSet;
import ed.util.SeenPath;
import ed.util.StringParseUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCursor
extends JSObjectLame
implements Iterator<JSObject> {
    public static final long MAX_RAW_BYTES = 0x1900000L;
    public static final long MAX_OBJ_BYTES = 0x3200000L;
    private static Map<String, JSFunction> _staticMehods = new TreeMap<String, JSFunction>();
    final DBCollection _collection;
    final JSObject _query;
    final JSObject _keysWanted;
    final JSFunction _constructor;
    private JSObject _orderBy;
    private String _hint;
    private boolean _explain = false;
    private int _numWanted = 0;
    private int _skip = 0;
    private Iterator<JSObject> _it;
    private CursorType _cursorType;
    private JSObject _cur = null;
    private int _num = 0;
    private long _totalObjectSize = 0L;
    private SeenPath _objectsSeenSoFar;
    private final ArrayList<JSObject> _all = new ArrayList();
    private final List<String> _nums = new ArrayList<String>();

    public DBCursor(DBCollection collection, JSObject q, JSObject k, JSFunction cons) {
        this._collection = collection;
        this._query = q;
        this._keysWanted = k;
        this._constructor = cons;
    }

    public DBCursor copy() {
        DBCursor c = new DBCursor(this._collection, this._query, this._keysWanted, this._constructor);
        c._orderBy = this._orderBy;
        c._hint = this._hint;
        c._numWanted = this._numWanted;
        c._skip = this._skip;
        return c;
    }

    public DBCursor sort(JSObject orderBy) {
        if (this._it != null) {
            throw new RuntimeException("can't sort after executing query");
        }
        this._orderBy = orderBy;
        return this;
    }

    public DBCursor hint(JSObject indexKeys) {
        if (this._it != null) {
            throw new RuntimeException("can't hint after executing query");
        }
        this._hint = indexKeys == null ? null : DBCollection.genIndexName(indexKeys);
        return this;
    }

    public DBCursor hint(Scope scope, JSString indexName) {
        if (this._it != null) {
            throw new RuntimeException("can't hint after executing query");
        }
        String s = null;
        if (indexName != null) {
            s = indexName.toString();
        }
        return this.hint(s);
    }

    public DBCursor hint(String indexName) {
        if (this._it != null) {
            throw new RuntimeException("can't hint after executing query");
        }
        this._hint = indexName;
        return this;
    }

    public JSObject explain() {
        DBCursor c = this.copy();
        c._explain = true;
        return c.next();
    }

    public DBCursor limit(int n) {
        if (this._it != null) {
            throw new RuntimeException("can't set limit after executing query");
        }
        this._numWanted = n;
        return this;
    }

    public DBCursor skip(int n) {
        if (this._it != null) {
            throw new RuntimeException("can't set skip after executing query");
        }
        this._skip = n;
        return this;
    }

    private void _check() {
        if (this._it != null) {
            return;
        }
        if (this._collection != null && this._query != null) {
            this._lookForHints();
            JSObject foo = this._query;
            if (this.hasSpecialQueryFields()) {
                foo = new JSObjectBase();
                this._addToQueryObject(foo, "query", this._query, true);
                this._addToQueryObject(foo, "orderby", this._orderBy, false);
                this._addToQueryObject(foo, "$hint", this._hint);
                if (this._explain) {
                    foo.set((Object)"$explain", (Object)true);
                }
            }
            long start = System.currentTimeMillis();
            this._it = this._collection.find(foo, this._keysWanted, this._skip, -1 * this._numWanted);
            ProfilingTracker.tlGotTime((String)("db.queries." + this._collection.getFullName()), (long)(System.currentTimeMillis() - start), (long)(this._it instanceof DBApiLayer.Result ? ((DBApiLayer.Result)this._it).totalBytes() : 0L), (Object)foo);
        }
        if (this._it == null) {
            this._it = new LinkedList().iterator();
        }
    }

    private void _lookForHints() {
        if (this._hint != null) {
            return;
        }
        if (this._collection._hintFields == null) {
            return;
        }
        Set mykeys = this._query.keySet(false);
        for (JSObject o : this._collection._hintFields) {
            Set hintKeys = o.keySet(false);
            if (!mykeys.containsAll(hintKeys)) continue;
            this.hint(o);
            return;
        }
    }

    boolean hasSpecialQueryFields() {
        if (this._orderBy != null && this._orderBy.keySet(false).size() > 0) {
            return true;
        }
        if (this._hint != null) {
            return true;
        }
        return this._explain;
    }

    void _addToQueryObject(JSObject query, String field, JSObject thing, boolean sendEmpty) {
        if (thing == null) {
            return;
        }
        if (!sendEmpty && thing.keySet(false).size() == 0) {
            return;
        }
        this._noRefCheck(thing);
        this._addToQueryObject(query, field, thing);
    }

    void _addToQueryObject(JSObject query, String field, Object thing) {
        if (thing == null) {
            return;
        }
        query.set((Object)field, thing);
    }

    void _noRefCheck(JSObject o) {
        if (!Bytes.cameFromDB(o)) {
            return;
        }
        o.set((Object)"_____nodbref_____", (Object)"z");
    }

    void _checkType(CursorType type) {
        if (this._cursorType == null) {
            this._cursorType = type;
            return;
        }
        if (type == this._cursorType) {
            return;
        }
        throw new RuntimeException("can't switch cursor access methods");
    }

    private JSObject _next() {
        if (this._cursorType == null) {
            this._checkType(CursorType.ITERATOR);
        }
        this._check();
        this._cur = null;
        this._cur = this._it.next();
        this._collection.apply(this._cur, false);
        ++this._num;
        if (this._keysWanted != null && this._keysWanted.keySet(false).size() > 0 && this._cur instanceof JSObjectBase) {
            ((JSObjectBase)this._cur).markAsPartialObject();
        }
        if (this._constructor != null && this._cur instanceof JSObjectBase) {
            JSFunction postLoad;
            JSObjectBase job = (JSObjectBase)this._cur;
            if (job.getConstructor() == null) {
                job.setConstructor(this._constructor, true);
            }
            if ((postLoad = this._constructor.getFunction("postLoad", true)) != null) {
                Scope s = postLoad.getAScopeForThis();
                s.setThis((Object)this._cur);
                postLoad.call(s);
            }
        }
        if (this._cursorType == CursorType.ARRAY) {
            long tb = -1L;
            if (this._it instanceof DBApiLayer.Result && (tb = ((DBApiLayer.Result)this._it).totalBytes()) >= 0x1900000L) {
                throw new RuntimeException("database cursor in array mode and trying to store too much data");
            }
            long mySize = this._size(this._cur);
            this._totalObjectSize += mySize;
            if (this._totalObjectSize > 0x3200000L) {
                throw new RuntimeException("database cursor in array mode and total object size is too big  object size(" + this._totalObjectSize + ") raw size(" + tb + ")");
            }
            this._nums.add(String.valueOf(this._all.size()));
            this._all.add(this._cur);
        }
        if (this._cur instanceof JSObjectBase) {
            ((JSObjectBase)this._cur).markClean();
        }
        return this._cur;
    }

    private long _size(JSObject cur) {
        if (this._objectsSeenSoFar == null) {
            this._objectsSeenSoFar = new SeenPath();
            if (this._constructor != null) {
                this._objectsSeenSoFar.visited((Object)this._constructor);
                this._objectsSeenSoFar.visited((Object)this._constructor.getPrototype());
            }
        }
        if (!this._objectsSeenSoFar.shouldVisit((Object)cur, (Object)this)) {
            return 0L;
        }
        long size = 20L;
        for (String s : cur.keySet(false)) {
            Object o = cur instanceof JSObjectBase ? ((JSObjectBase)cur)._simpleGet(s) : cur.get((Object)s);
            size += 16L;
            if (o == null || o instanceof JSFunction || o instanceof DBRef) continue;
            long me = 0L;
            me = o instanceof JSObject && !JS.isPrimitive((Object)o) ? this._size((JSObject)o) : JSObjectSize.size((Object)o, (SeenPath)this._objectsSeenSoFar, (Object)this);
            size += me;
        }
        return size;
    }

    private boolean _hasNext() {
        this._check();
        if (this._numWanted > 0 && this._num >= this._numWanted) {
            return false;
        }
        return this._it.hasNext();
    }

    public int numSeen() {
        return this._num;
    }

    @Override
    public boolean hasNext() {
        this._checkType(CursorType.ITERATOR);
        return this._hasNext();
    }

    @Override
    public JSObject next() {
        this._checkType(CursorType.ITERATOR);
        return this._next();
    }

    public JSObject curr() {
        this._checkType(CursorType.ITERATOR);
        return this._cur;
    }

    @Override
    public void remove() {
        throw new RuntimeException("no");
    }

    void _fill(int n) {
        this._checkType(CursorType.ARRAY);
        while (n >= this._all.size() && this._hasNext()) {
            this._next();
        }
    }

    public Object get(Object n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Number) {
            return this.getInt(((Number)n).intValue());
        }
        int i = StringParseUtil.parseInt((String)n.toString(), (int)-1);
        if (i >= 0) {
            return this.getInt(i);
        }
        return _staticMehods.get(n.toString());
    }

    public Object getInt(int n) {
        this._checkType(CursorType.ARRAY);
        this._fill(n);
        return this._all.get(n);
    }

    public int length() {
        this._checkType(CursorType.ARRAY);
        this._fill(Integer.MAX_VALUE);
        return this._all.size();
    }

    public JSArray toArray() {
        return this.toArray(Integer.MAX_VALUE);
    }

    public JSArray toArray(int min) {
        this._checkType(CursorType.ARRAY);
        this._fill(min);
        return JSArray.wrap(this._all);
    }

    public Set<String> keySet(boolean includePrototype) {
        this._fill(Integer.MAX_VALUE);
        return new OrderedSet(this._nums);
    }

    public int count() {
        if (this._collection == null) {
            throw new RuntimeException("why is _collection null");
        }
        if (this._collection._base == null) {
            throw new RuntimeException("why is _collection._base null");
        }
        if (this._collection._base._collectionPrototype == null) {
            throw new RuntimeException("why is _collection._base._collectionPrototype null");
        }
        JSFunction c = this._collection._base._collectionPrototype.getFunction("count");
        if (c == null) {
            throw new RuntimeException("can't find count function");
        }
        Scope s = c.getScope().child();
        s.setThis((Object)this._collection);
        Object o = c.call(s, (Object)this._query);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        throw new RuntimeException("why did call return a non-number");
    }

    static {
        _staticMehods.put("forEach", (JSFunction)new JSFunctionCalls1(){

            public Object call(Scope s, Object fo, Object[] foo) {
                DBCursor c = (DBCursor)s.getThis();
                JSFunction f = (JSFunction)fo;
                while (c.hasNext()) {
                    f.call(s, (Object)c.next());
                }
                return null;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CursorType {
        ITERATOR,
        ARRAY;

    }
}

