/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import ed.db.Bytes;
import ed.db.DBBase;
import ed.db.DBCursor;
import ed.db.DBRef;
import ed.db.ObjectId;
import ed.js.JS;
import ed.js.JSArray;
import ed.js.JSDate;
import ed.js.JSDict;
import ed.js.JSException;
import ed.js.JSFunction;
import ed.js.JSInternalFunctions;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSObjectLame;
import ed.js.JSRegex;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.js.func.JSFunctionCalls1;
import ed.js.func.JSFunctionCalls2;
import ed.js.func.JSFunctionCalls4;
import ed.util.IdentitySet;
import ed.util.SeenPath;
import ed.util.Sizable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBCollection
extends JSObjectLame
implements Sizable {
    static final boolean DEBUG = Boolean.getBoolean("DEBUG.DB");
    final DBBase _base;
    final JSFunction _save;
    final JSFunction _update;
    final JSFunction _apply;
    final JSFunction _find;
    static Set<String> _javaMethods;
    protected Map _entries = new TreeMap();
    protected final String _name;
    protected final String _fullName;
    protected JSFunction _constructor;
    protected List<JSObject> _hintFields;
    private boolean _anyUpdateSave = false;
    private boolean _checkedIdIndex = false;
    private final Set<String> _createIndexes = new HashSet<String>();
    private final Set<String> _createIndexesAfterSave = new HashSet<String>();
    private static final JSObjectBase _upsertOptions;
    private static final JSObjectBase _idKey;

    protected abstract JSObject doSave(JSObject var1);

    public abstract JSObject update(JSObject var1, JSObject var2, boolean var3, boolean var4);

    protected abstract void doapply(JSObject var1);

    public abstract int remove(JSObject var1);

    protected abstract JSObject dofind(ObjectId var1);

    public abstract Iterator<JSObject> find(JSObject var1, JSObject var2, int var3, int var4);

    public abstract void ensureIndex(JSObject var1, String var2);

    public final JSObject find(ObjectId id) {
        this.ensureIDIndex();
        JSObject ret = this.dofind(id);
        if (ret == null) {
            return null;
        }
        this.apply(ret, false);
        return ret;
    }

    public final JSObject find(String id) {
        if (!ObjectId.isValid(id)) {
            throw new IllegalArgumentException("invalid object id [" + id + "]");
        }
        return this.find(new ObjectId(id));
    }

    public void checkForIDIndex(JSObject key) {
        if (this._checkedIdIndex) {
            return;
        }
        if (key.get((Object)"_id") == null) {
            return;
        }
        if (key.keySet(false).size() > 1) {
            return;
        }
        this.ensureIDIndex();
    }

    public void ensureIDIndex() {
        if (this._checkedIdIndex) {
            return;
        }
        this.ensureIndex((JSObject)_idKey);
        this._checkedIdIndex = true;
    }

    public final void ensureIndex(JSObject keys) {
        this.ensureIndex(keys, false);
    }

    public final void createIndex(JSObject keys) {
        this.ensureIndex(keys, true);
    }

    public final void ensureIndex(JSObject keys, boolean force) {
        if (this.checkReadOnly(false)) {
            return;
        }
        String name = DBCollection.genIndexName(keys);
        boolean doEnsureIndex = false;
        if (Math.random() > 0.999) {
            doEnsureIndex = true;
        } else if (!this._createIndexes.contains(name)) {
            doEnsureIndex = true;
        } else if (this._anyUpdateSave && !this._createIndexesAfterSave.contains(name)) {
            doEnsureIndex = true;
        }
        if (!force && !doEnsureIndex) {
            return;
        }
        this.ensureIndex(keys, name);
        this._createIndexes.add(name);
        if (this._anyUpdateSave) {
            this._createIndexesAfterSave.add(name);
        }
    }

    public void resetIndexCache() {
        this._createIndexes.clear();
    }

    public static String genIndexName(JSObject keys) {
        String name = "";
        for (String s : keys.keySet(false)) {
            if (name.length() > 0) {
                name = name + "_";
            }
            name = name + s + "_";
            Object val = keys.get((Object)s);
            if (!(val instanceof Number)) continue;
            name = name + JSInternalFunctions.JS_toString((Object)val).replace(' ', '_');
        }
        return name;
    }

    public void setHintFields(List<JSObject> lst) {
        this._hintFields = lst;
    }

    public final Iterator<JSObject> find(JSObject ref) {
        return this.find((JSObject)(ref == null ? new JSObjectBase() : ref), null, 0, 0);
    }

    public final Iterator<JSObject> find() {
        Iterator<JSObject> i = this.find((JSObject)new JSObjectBase(), null, 0, 0);
        if (i == null) {
            return new LinkedList().iterator();
        }
        return i;
    }

    public final JSObject findOne() {
        return this.findOne((JSObject)new JSObjectBase());
    }

    public final JSObject findOne(JSObject o) {
        Iterator<JSObject> i = this.find(o, null, 0, 1);
        if (i == null || !i.hasNext()) {
            return null;
        }
        return i.next();
    }

    public final Object apply(JSObject o) {
        return this.apply(o, true);
    }

    public final Object apply(JSObject jo, boolean ensureID) {
        jo.set((Object)"_save", (Object)this._save);
        jo.set((Object)"_update", (Object)this._update);
        Object id = jo.get((Object)"_id");
        if (ensureID && id == null) {
            id = ObjectId.get();
            jo.set((Object)"_id", id);
        }
        this.doapply(jo);
        return id;
    }

    public void setConstructor(JSFunction cons) {
        this._constructor = cons;
    }

    public JSFunction getConstructor() {
        return this._constructor;
    }

    public final JSObject save(JSObject o) {
        if (this.checkReadOnly(true)) {
            return null;
        }
        return this.save(null, o);
    }

    public final Map save(Map m) {
        if (m instanceof JSObject) {
            return (Map)this.save(null, (JSObject)m);
        }
        JSDict d = new JSDict(m);
        this.save(null, (JSObject)d);
        if (m.get("_id") == null && d.get((Object)"_id") != null) {
            m.put("_id", d.get((Object)"_id"));
        }
        return m;
    }

    public final JSObject save(Scope s, JSObject jo) {
        if (this.checkReadOnly(true)) {
            return jo;
        }
        jo = this._handleThis(s, jo);
        this._checkObject(jo, false, false);
        if (s != null) {
            Object presaveObject = jo.get((Object)"preSave");
            if (presaveObject == null) {
                presaveObject = jo.get((Object)"presave");
            }
            if (presaveObject != null) {
                if (presaveObject instanceof JSFunction) {
                    s.setThis((Object)jo);
                    ((JSFunction)presaveObject).call(s);
                    s.clearThisNormal(null);
                } else {
                    System.out.println("warning, preSave is a " + presaveObject.getClass());
                }
            }
            this._findSubObject(s, jo, null);
        }
        Object id = null;
        id = jo.get((Object)"_id");
        if (id instanceof ObjectId) {
            DBRef.objectSaved(id);
        }
        if (DEBUG) {
            System.out.println("id : " + id);
        }
        if (id == null || id instanceof ObjectId && ((ObjectId)id)._new) {
            if (DEBUG) {
                System.out.println("saving new object");
            }
            if (id != null) {
                ((ObjectId)id)._new = false;
            }
            this.doSave(jo);
            return jo;
        }
        if (DEBUG) {
            System.out.println("doing implicit upsert : " + jo.get((Object)"_id"));
        }
        JSObjectBase q = new JSObjectBase();
        q.set((Object)"_id", id);
        return (JSObject)this._update.call(s, (Object)q, (Object)jo, (Object)_upsertOptions);
    }

    protected DBCollection(DBBase base, String name) {
        this._base = base;
        this._name = name;
        this._fullName = this._base.getName() + "." + name;
        this._entries.put("base", this._base.getName());
        this._entries.put("name", this._name);
        this._save = new JSFunctionCalls1(){

            public Object call(Scope s, Object o, Object[] fooasd) {
                DBCollection.this._anyUpdateSave = true;
                if (o == null) {
                    o = DBCollection.this._handleThis(s, null);
                }
                return DBCollection.this.save(s, DBCollection.this._checkObject(o, false, false));
            }
        };
        this._entries.put("save", this._save);
        this._update = new JSFunctionCalls4(){

            public Object call(Scope s, Object q, Object o, Object options, Object seen, Object[] foo) {
                if (DBCollection.this.checkReadOnly(true)) {
                    return o;
                }
                DBCollection.this._anyUpdateSave = true;
                DBCollection.this._checkObject(q, false, true);
                DBCollection.this._checkObject(o, false, true);
                if (s != null) {
                    DBCollection.this._findSubObject(s, (JSObject)o, (IdentitySet)seen);
                }
                boolean upsert = false;
                boolean apply = true;
                if (o instanceof JSObject) {
                    apply = false;
                    for (String key : ((JSObject)o).keySet()) {
                        if (key.startsWith("$")) continue;
                        apply = true;
                        break;
                    }
                }
                if (options instanceof JSObject) {
                    JSObject params = (JSObject)options;
                    upsert = JSInternalFunctions.JS_evalToBool((Object)params.get((Object)"upsert"));
                    if (params.get((Object)"ids") != null) {
                        apply = JSInternalFunctions.JS_evalToBool((Object)params.get((Object)"ids"));
                    }
                }
                return DBCollection.this.update((JSObject)q, (JSObject)o, upsert, apply);
            }
        };
        this._entries.put("update", this._update);
        this._entries.put("remove", new JSFunctionCalls1(){

            public Object call(Scope s, Object o, Object[] foo) {
                if (DBCollection.this.checkReadOnly(true)) {
                    return o;
                }
                o = DBCollection.this._massageObjectToFilter(o, false, true);
                DBCollection.this._checkObject(o, true, true);
                JSObject jo = DBCollection.this._handleThis(s, (JSObject)o);
                if (o == null) {
                    throw new NullPointerException("can't pass null to collection.remove. if you mean to remove everything, do remove( {} ) ");
                }
                return DBCollection.this.remove(jo);
            }
        });
        this._apply = new JSFunctionCalls1(){

            public Object call(Scope s, Object o, Object[] foo) {
                return DBCollection.this.apply(DBCollection.this._checkObject(o, false, false));
            }
        };
        this._entries.put("apply", this._apply);
        this._find = new JSFunctionCalls2(){

            public Object call(Scope s, Object o, Object fieldsWantedO, Object[] foo) {
                if ((o = DBCollection.this._massageObjectToFilter(o, true, true)) instanceof JSObject) {
                    JSObject key = (JSObject)o;
                    DBCollection.this.checkForIDIndex(key);
                    return new DBCursor(DBCollection.this, key, (JSObject)fieldsWantedO, DBCollection.this._constructor);
                }
                throw new IllegalArgumentException("invalid type for db find [" + o.getClass().getName() + "]");
            }
        };
        this._entries.put("find", this._find);
        this._entries.put("findOne", new JSFunctionCalls1(){

            public Object call(Scope s, Object o, Object[] foo) {
                if ((o = DBCollection.this._massageObjectToFilter(o, true, false)) instanceof ObjectId && (foo == null || foo.length == 0 || foo[0] == null)) {
                    DBCollection.this.ensureIDIndex();
                    return DBCollection.this.find((ObjectId)o);
                }
                Object res = DBCollection.this._find.call(s, o, foo);
                if (res == null) {
                    return null;
                }
                if (res instanceof DBCursor) {
                    ((DBCursor)res).limit(1);
                }
                if (res instanceof JSArray) {
                    JSArray a = (JSArray)res;
                    if (a.size() == 0) {
                        return null;
                    }
                    return a.getInt(0);
                }
                if (res instanceof Iterator) {
                    Iterator it = (Iterator)res;
                    if (!it.hasNext()) {
                        return null;
                    }
                    return it.next();
                }
                if (res instanceof JSObject) {
                    return res;
                }
                throw new RuntimeException("wtf : " + res.getClass());
            }
        });
        this._entries.put("tojson", new JSFunctionCalls0(){

            public Object call(Scope s, Object[] foo) {
                return DBCollection.this._fullName;
            }
        });
    }

    Object _massageObjectToFilter(Object o, boolean maskNull, boolean convertIdToObject) {
        if (o == null) {
            if (maskNull) {
                return new JSObjectBase();
            }
            return null;
        }
        if (o instanceof JSFunction && ((JSFunction)o).isCallable() && ((JSFunction)o).getSourceCode() != null) {
            JSObjectBase obj = new JSObjectBase();
            obj.set((Object)"$where", o);
            return obj;
        }
        if (o instanceof DBRef) {
            o = ((DBRef)((Object)o))._id;
        }
        if (o instanceof String || o instanceof JSString) {
            String str = o.toString();
            if (ObjectId.isValid(str)) {
                o = new ObjectId(str);
            } else {
                JSObjectBase obj = new JSObjectBase();
                obj.set((Object)"$where", o);
                return obj;
            }
        }
        if (convertIdToObject && o instanceof ObjectId) {
            JSObjectBase obj = new JSObjectBase();
            obj.set((Object)"_id", o);
            return obj;
        }
        return o;
    }

    protected void _finishInit() {
    }

    private final JSObject _handleThis(Scope s, JSObject o) {
        if (o != null) {
            return o;
        }
        Object t = s.getThis();
        if (t == null) {
            return null;
        }
        if (!(t instanceof JSObject)) {
            return null;
        }
        if (JS.isBaseObject((Object)t)) {
            return (JSObject)t;
        }
        return null;
    }

    private final JSObject _checkObject(Object o, boolean canBeNull, boolean query) {
        if (o == null) {
            if (canBeNull) {
                return null;
            }
            throw new NullPointerException("can't be null");
        }
        if (!(o instanceof JSObject)) {
            throw new IllegalArgumentException(" has to be a JSObject not : " + o.getClass());
        }
        if (o instanceof JSObjectBase && ((JSObjectBase)o).isPartialObject()) {
            throw new IllegalArgumentException("can't save partial objects");
        }
        JSObject jo = (JSObject)o;
        if (!query) {
            for (String s : jo.keySet()) {
                if (s.contains(".")) {
                    throw new IllegalArgumentException("fields stored in the db can't have . in them");
                }
                if (!s.contains("$")) continue;
                throw new IllegalArgumentException("fields stored in the db can't have $ in them");
            }
        }
        return jo;
    }

    private void _findSubObject(Scope scope, JSObject jo, IdentitySet seenSubs) {
        if (seenSubs == null) {
            seenSubs = new IdentitySet();
        }
        if (seenSubs.contains((Object)jo)) {
            return;
        }
        seenSubs.add((Object)jo);
        if (DEBUG) {
            System.out.println("_findSubObject on : " + jo.get((Object)"_id"));
        }
        LinkedList<JSObject> toSearch = new LinkedList<JSObject>();
        IdentityHashMap seen = new IdentityHashMap();
        toSearch.add(jo);
        while (toSearch.size() > 0) {
            IdentityHashMap<JSObject, String> seenNow = new IdentityHashMap<JSObject, String>(seen);
            JSObject n = (JSObject)toSearch.remove(0);
            for (String name : n.keySet(false)) {
                Object foo = Bytes.safeGet(n, name);
                if (foo == null || !(foo instanceof JSObject)) continue;
                if (foo instanceof DBRef) {
                    DBRef ref = (DBRef)((Object)foo);
                    if (!ref.isDirty()) continue;
                    foo = ref.getRealObject();
                }
                if (foo instanceof JSFunction || foo instanceof JSString || foo instanceof JSRegex || foo instanceof JSDate || foo instanceof DBCollection || foo instanceof DBBase) continue;
                JSObject e = (JSObject)foo;
                if (e instanceof JSObjectBase) {
                    ((JSObjectBase)e).prefunc();
                }
                if (n.get((Object)name) == null) continue;
                if (e.get((Object)"_ns") == null) {
                    if (seen.containsKey(e)) {
                        throw new RuntimeException("you have a loop. key : " + name + " from a " + n.getClass() + " which is a : " + e.getClass());
                    }
                    seenNow.put(e, "a");
                    toSearch.add(e);
                    continue;
                }
                if (e instanceof JSObjectBase && ((JSObjectBase)e).isPartialObject()) continue;
                if (e.get((Object)"_id") == null) {
                    JSFunction otherSave = e.getFunction("_save");
                    if (otherSave == null) {
                        throw new RuntimeException("no save :(");
                    }
                    otherSave.call(scope, (Object)e, null);
                    continue;
                }
                JSObjectBase lookup = new JSObjectBase();
                lookup.set((Object)"_id", e.get((Object)"_id"));
                JSFunction otherUpdate = e.getFunction("_update");
                if (otherUpdate == null) {
                    if (e instanceof DBRef) continue;
                    throw new RuntimeException("_update is null class: " + e.getClass().getName() + "  keyset : " + e.keySet(false) + " ns:" + e.get((Object)"_ns"));
                }
                if (e instanceof JSObjectBase && !((JSObjectBase)e).isDirty()) continue;
                otherUpdate.call(scope, (Object)lookup, (Object)e, (Object)_upsertOptions, (Object)seenSubs);
            }
            seen.putAll(seenNow);
        }
    }

    public Object get(Object n) {
        if (n == null) {
            return null;
        }
        Object foo = this._entries.get(n.toString());
        if (foo != null) {
            return foo;
        }
        foo = this._base._collectionPrototype.get(n);
        if (foo != null) {
            return foo;
        }
        String s = n.toString();
        if (this._getJavaMethods().contains(s)) {
            return null;
        }
        return this.getCollection(s);
    }

    public Object set(Object n, Object v) {
        return this._entries.put(n.toString(), v);
    }

    public Set<String> keySet(boolean includePrototype) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this._entries.keySet());
        set.addAll(this._base._collectionPrototype.keySet());
        set.addAll(this._getJavaMethods());
        return set;
    }

    public DBCollection getCollection(String n) {
        return this._base.getCollection(this._name + "." + n);
    }

    public String getName() {
        return this._name;
    }

    public String getFullName() {
        return this._fullName;
    }

    public DBBase getDB() {
        return this._base;
    }

    public DBBase getBase() {
        return this._base;
    }

    protected boolean checkReadOnly(boolean strict) {
        if (!this._base._readOnly) {
            return false;
        }
        if (!strict) {
            return true;
        }
        Scope scope = Scope.getThreadLocal();
        if (scope == null) {
            throw new JSException((Object)"db is read only");
        }
        Object foo = scope.get("dbStrict");
        if (foo == null || JSInternalFunctions.JS_evalToBool((Object)foo)) {
            throw new JSException((Object)"db is read only");
        }
        return true;
    }

    public int hashCode() {
        return this._fullName.hashCode();
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public String toString() {
        return this._name;
    }

    public long approxSize(SeenPath seen) {
        long size = 256L;
        if (seen.shouldVisit((Object)this._constructor, (Object)this)) {
            size += this._constructor.approxSize(seen);
        }
        return size;
    }

    private Set<String> _getJavaMethods() {
        if (_javaMethods == null) {
            HashSet<String> temp = new HashSet<String>();
            for (Method m : ((Object)((Object)this)).getClass().getMethods()) {
                temp.add(m.getName());
            }
            _javaMethods = temp;
        }
        return _javaMethods;
    }

    static {
        _upsertOptions = new JSObjectBase();
        _upsertOptions.set((Object)"upsert", (Object)true);
        _upsertOptions.setReadOnly(true);
        _idKey = new JSObjectBase();
        _idKey.set((Object)"_id", (Object)ObjectId.get());
        _idKey.setReadOnly(true);
    }
}

