/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import ed.db.ByteDecoder;
import ed.db.ByteEncoder;
import ed.db.DBBase;
import ed.db.DBCollection;
import ed.db.DBRef;
import ed.db.ObjectId;
import ed.js.JSException;
import ed.js.JSON;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.util.OrderedSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBApiLayer
extends DBBase {
    static final boolean D = Boolean.getBoolean("DEBUG.DB");
    static final int NUM_CURSORS_BEFORE_KILL = 100;
    static final boolean SHOW = Boolean.getBoolean("DB.SHOW");
    final String _root;
    final Map<String, MyCollection> _collections = Collections.synchronizedMap(new HashMap());
    final Map<String, DBApiLayer> _sisters = Collections.synchronizedMap(new HashMap());
    List<Long> _deadCursorIds = new Vector<Long>();
    static final List<JSObject> EMPTY = Collections.unmodifiableList(new LinkedList());

    protected DBApiLayer(String root) {
        super(root);
        this._root = root;
    }

    protected abstract void doInsert(ByteBuffer var1);

    protected abstract void doDelete(ByteBuffer var1);

    protected abstract void doUpdate(ByteBuffer var1);

    protected abstract void doKillCursors(ByteBuffer var1);

    protected abstract int doQuery(ByteBuffer var1, ByteBuffer var2);

    protected abstract int doGetMore(ByteBuffer var1, ByteBuffer var2);

    public abstract String debugString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MyCollection doGetCollection(String name) {
        MyCollection c = this._collections.get(name);
        if (c != null) {
            return c;
        }
        Map<String, MyCollection> map = this._collections;
        synchronized (map) {
            c = this._collections.get(name);
            if (c != null) {
                return c;
            }
            c = new MyCollection(name);
            this._collections.put(name, c);
        }
        return c;
    }

    String _removeRoot(String ns) {
        if (!ns.startsWith(this._root + ".")) {
            return ns;
        }
        return ns.substring(this._root.length() + 1);
    }

    @Override
    public Set<String> getCollectionNames() {
        DBCollection namespaces = this.getCollection("system.namespaces");
        if (namespaces == null) {
            throw new RuntimeException("this is impossible");
        }
        Iterator<JSObject> i = namespaces.find((JSObject)new JSObjectBase(), null, 0, 0);
        if (i == null) {
            return new HashSet<String>();
        }
        ArrayList<String> tables = new ArrayList<String>();
        while (i.hasNext()) {
            int idx;
            JSObject o = i.next();
            String n = o.get((Object)"name").toString();
            String root = n.substring(0, idx = n.indexOf("."));
            if (!root.equals(this._root) || n.indexOf("$") >= 0) continue;
            String table = n.substring(idx + 1);
            tables.add(table);
        }
        Collections.sort(tables);
        return new OrderedSet(tables);
    }

    private static String _cleanAndValidateDBFileName(String s) {
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        int idx = s.lastIndexOf("/");
        if (idx > 0) {
            s = s.substring(idx + 1);
        }
        if (!s.endsWith(".ns")) {
            return null;
        }
        if (s.startsWith("sys.")) {
            return null;
        }
        return s.substring(0, s.length() - 3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Result
    implements Iterator<JSObject> {
        SingleResult _curResult;
        Iterator<JSObject> _cur;
        final MyCollection _collection;
        final int _numToReturn;
        private long _totalBytes = 0L;

        Result(MyCollection coll, SingleResult res, int numToReturn) {
            this.init(res);
            this._collection = coll;
            this._numToReturn = numToReturn;
        }

        private void init(SingleResult res) {
            this._totalBytes += res._bytes;
            this._curResult = res;
            this._cur = res._lst.iterator();
        }

        @Override
        public JSObject next() {
            if (this._cur.hasNext()) {
                return this._cur.next();
            }
            if (!this._curResult.hasGetMore()) {
                throw new RuntimeException("no more");
            }
            this._advance();
            return this.next();
        }

        @Override
        public boolean hasNext() {
            if (this._cur.hasNext()) {
                return true;
            }
            if (!this._curResult.hasGetMore()) {
                return false;
            }
            this._advance();
            return this.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _advance() {
            if (this._curResult._cursor <= 0L) {
                throw new RuntimeException("can't advance a cursor <= 0");
            }
            ByteEncoder encoder = ByteEncoder.get();
            encoder._buf.putInt(0);
            encoder._put(this._curResult._fullNameSpace);
            encoder._buf.putInt(this._numToReturn);
            encoder._buf.putLong(this._curResult._cursor);
            encoder.flip();
            ByteDecoder decoder = ByteDecoder.get(DBApiLayer.this, this._collection._fullNameSpace, this._collection._constructor);
            try {
                int len = DBApiLayer.this.doGetMore(encoder._buf, decoder._buf);
                decoder.doneReading(len);
                SingleResult res = new SingleResult(this._curResult._fullNameSpace, decoder);
                this.init(res);
            }
            finally {
                decoder.done();
                encoder.done();
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("can't remove this way");
        }

        public String toString() {
            return "DBCursor";
        }

        protected void finalize() {
            if (this._curResult != null && this._curResult._cursor > 0L) {
                DBApiLayer.this._deadCursorIds.add(this._curResult._cursor);
            }
        }

        public long totalBytes() {
            return this._totalBytes;
        }
    }

    class SingleResult
    extends QueryHeader {
        final long _bytes;
        final String _fullNameSpace;
        final List<JSObject> _lst;

        SingleResult(String fullNameSpace, ByteDecoder decoder) {
            super(decoder._buf);
            this._bytes = decoder.remaining();
            this._fullNameSpace = fullNameSpace;
            this.skipPastHeader(decoder._buf);
            this._lst = this._num == 0 ? EMPTY : (this._num < 3 ? new LinkedList<JSObject>() : new ArrayList<JSObject>(this._num));
            if (this._num > 0) {
                int num = 0;
                while (decoder.more() && num < this._num) {
                    JSObject o = decoder.readObject();
                    o.set((Object)"_ns", (Object)DBApiLayer.this._removeRoot(this._fullNameSpace));
                    this._lst.add(o);
                    ++num;
                    if (!D) continue;
                    System.out.println("-- : " + o.keySet(false).size());
                    for (String s : o.keySet(false)) {
                        System.out.println("\t " + s + " : " + o.get((Object)s));
                    }
                }
            }
        }

        boolean hasGetMore() {
            return this._num > 0 && this._cursor > 0L;
        }

        public String toString() {
            return "reserved:" + this._reserved + " _cursor:" + this._cursor + " _startingFrom:" + this._startingFrom + " _num:" + this._num;
        }
    }

    class QueryHeader {
        final int _reserved;
        final long _cursor;
        final int _startingFrom;
        final int _num;

        QueryHeader(ByteBuffer buf) {
            this(buf, buf.position());
        }

        QueryHeader(ByteBuffer buf, int start) {
            this._reserved = buf.getInt(start);
            this._cursor = buf.getLong(start + 4);
            this._startingFrom = buf.getInt(start + 12);
            this._num = buf.getInt(16);
        }

        int headerSize() {
            return 20;
        }

        void skipPastHeader(ByteBuffer buf) {
            buf.position(buf.position() + this.headerSize());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyCollection
    extends DBCollection {
        final String _fullNameSpace;

        MyCollection(String name) {
            super(DBApiLayer.this, name);
            this._fullNameSpace = DBApiLayer.this._root + "." + name;
            this._finishInit();
        }

        @Override
        public void doapply(JSObject o) {
            o.set((Object)"_ns", (Object)DBApiLayer.this._removeRoot(this._fullNameSpace));
        }

        @Override
        public JSObject dofind(ObjectId id) {
            JSObjectBase lookup = new JSObjectBase();
            lookup.set((Object)"_id", (Object)id);
            Iterator<JSObject> res = this.find((JSObject)lookup);
            if (res == null) {
                return null;
            }
            JSObject o = res.next();
            if (res.hasNext()) {
                System.out.println("multiple entries with same _id.  collection:" + this._fullNameSpace + " id:" + id);
            }
            if (this._constructor != null && o instanceof JSObjectBase) {
                ((JSObjectBase)o).setConstructor(this._constructor);
            }
            return o;
        }

        @Override
        public JSObject doSave(JSObject o) {
            return this.save(o, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSObject save(JSObject o, boolean shouldApply) {
            if (SHOW) {
                System.out.println("save:  " + this._fullNameSpace + " " + JSON.serialize((Object)o));
            }
            if (shouldApply) {
                this.apply(o);
                if (o.get((Object)"_id") instanceof ObjectId) {
                    ((ObjectId)o.get((Object)"_id"))._new = false;
                }
            }
            ByteEncoder encoder = ByteEncoder.get();
            encoder._buf.putInt(0);
            encoder._put(this._fullNameSpace);
            encoder.putObject(o);
            encoder.flip();
            try {
                DBApiLayer.this.doInsert(encoder._buf);
            }
            finally {
                encoder.done();
            }
            return o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int remove(JSObject o) {
            if (SHOW) {
                System.out.println("remove: " + this._fullNameSpace + " " + JSON.serialize((Object)o));
            }
            ByteEncoder encoder = ByteEncoder.get();
            encoder._buf.putInt(0);
            encoder._put(this._fullNameSpace);
            Set keys = o.keySet(false);
            if (keys.size() == 1 && ((String)keys.iterator().next()).equals("_id") && o.get(keys.iterator().next()) instanceof ObjectId) {
                encoder._buf.putInt(1);
            } else {
                encoder._buf.putInt(0);
            }
            encoder.putObject(o);
            encoder.flip();
            try {
                DBApiLayer.this.doDelete(encoder._buf);
            }
            finally {
                encoder.done();
            }
            return -1;
        }

        void _cleanCursors() {
            if (DBApiLayer.this._deadCursorIds.size() == 0) {
                return;
            }
            if (DBApiLayer.this._deadCursorIds.size() % 20 != 0 && DBApiLayer.this._deadCursorIds.size() < 100) {
                return;
            }
            List<Long> l = DBApiLayer.this._deadCursorIds;
            DBApiLayer.this._deadCursorIds = new Vector<Long>();
            System.out.println("trying to kill cursors : " + l.size());
            try {
                this.killCursors(l);
            }
            catch (Throwable t) {
                t.printStackTrace();
                DBApiLayer.this._deadCursorIds.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void killCursors(List<Long> all) {
            if (all == null || all.size() == 0) {
                return;
            }
            ByteEncoder encoder = ByteEncoder.get();
            encoder._buf.putInt(0);
            encoder._buf.putInt(all.size());
            for (int i = 0; i < all.size(); ++i) {
                encoder._buf.putLong(all.get(i));
            }
            try {
                DBApiLayer.this.doKillCursors(encoder._buf);
            }
            finally {
                encoder.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<JSObject> find(JSObject ref, JSObject fields, int numToSkip, int numToReturn) {
            if (SHOW) {
                System.out.println("find: " + this._fullNameSpace + " " + JSON.serialize((Object)ref));
            }
            this._cleanCursors();
            ByteEncoder encoder = ByteEncoder.get();
            encoder._buf.putInt(0);
            encoder._put(this._fullNameSpace);
            encoder._buf.putInt(numToSkip);
            encoder._buf.putInt(numToReturn);
            encoder.putObject(ref);
            if (fields != null) {
                encoder.putObject(fields);
            }
            encoder.flip();
            ByteDecoder decoder = ByteDecoder.get(DBApiLayer.this, this._fullNameSpace, this._constructor);
            try {
                Object err;
                int len = DBApiLayer.this.doQuery(encoder._buf, decoder._buf);
                decoder.doneReading(len);
                SingleResult res = new SingleResult(this._fullNameSpace, decoder);
                if (res._lst.size() == 0) {
                    Iterator<JSObject> iterator = null;
                    return iterator;
                }
                if (res._lst.size() == 1 && (err = res._lst.get(0).get((Object)"$err")) != null) {
                    throw new JSException((Object)("db error [" + err + "]"));
                }
                Result result = new Result(this, res, numToReturn);
                return result;
            }
            finally {
                decoder.done();
                encoder.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JSObject update(JSObject query, JSObject o, boolean upsert, boolean apply) {
            if (SHOW) {
                System.out.println("update: " + this._fullNameSpace + " " + JSON.serialize((Object)query));
            }
            if (apply) {
                this.apply(o);
                if (o.get((Object)"_id") instanceof ObjectId) {
                    ObjectId id = (ObjectId)o.get((Object)"_id");
                    id._new = false;
                    DBRef.objectSaved(id);
                }
            }
            ByteEncoder encoder = ByteEncoder.get();
            encoder._buf.putInt(0);
            encoder._put(this._fullNameSpace);
            encoder._buf.putInt(upsert ? 1 : 0);
            encoder.putObject(query);
            encoder.putObject(o);
            encoder.flip();
            try {
                DBApiLayer.this.doUpdate(encoder._buf);
            }
            finally {
                encoder.done();
            }
            return o;
        }

        @Override
        public void ensureIndex(JSObject keys, String name) {
            JSObjectBase o = new JSObjectBase();
            o.set((Object)"name", (Object)name);
            o.set((Object)"ns", (Object)this._fullNameSpace);
            o.set((Object)"key", (Object)keys);
            DBApiLayer.this.doGetCollection("system.indexes").save((JSObject)o, false);
        }
    }
}

