/*
 * Decompiled with CFR 0.152.
 */
package ed.db;

import ed.MyAsserts;
import ed.db.Bytes;
import ed.db.DBRef;
import ed.db.ObjectId;
import ed.js.JSArray;
import ed.js.JSBinaryData;
import ed.js.JSDate;
import ed.js.JSFunction;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSRegex;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.util.IdentitySet;
import ed.util.SimplePool;
import ed.util.WatchedSimplePool;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ByteEncoder
extends Bytes {
    static final boolean DEBUG = Boolean.getBoolean("DEBUG.BE");
    static final Set<String> BAD_GLOBALS = new HashSet<String>();
    private static final int _poolSize;
    private static final SimplePool<ByteEncoder> _pool;
    static SimplePool<CharBuffer> _charBufferPool;
    private final CharBuffer _cbuf = (CharBuffer)_charBufferPool.get();
    private final CharsetEncoder _encoder = _utf8.newEncoder();
    private Stack<IdentitySet> _dontRef = new Stack();
    private boolean _flipped = false;
    private boolean _doneForever = false;
    final ByteBuffer _buf;

    public static boolean dbOnlyField(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof String || o instanceof JSString) {
            return ByteEncoder.dbOnlyField(o.toString());
        }
        return false;
    }

    public static boolean dbOnlyField(String s) {
        return s.equals("_ns") || s.equals("_save") || s.equals("_update");
    }

    static ByteEncoder get() {
        return (ByteEncoder)_pool.get();
    }

    protected void done() {
        if (this._doneForever) {
            throw new RuntimeException("you broke something");
        }
        this.reset();
        _pool.done((Object)this);
    }

    public ByteEncoder(ByteBuffer buf) {
        this._buf = buf;
        this._buf.order(Bytes.ORDER);
    }

    private ByteEncoder() {
        this._buf = ByteBuffer.allocateDirect(0x500000);
        this._buf.order(Bytes.ORDER);
    }

    protected void reset() {
        this._buf.position(0);
        this._buf.limit(this._buf.capacity());
        this._flipped = false;
        this._dontRef.clear();
    }

    protected void flip() {
        this._buf.flip();
        this._flipped = true;
    }

    public int putObject(JSObject o) {
        try {
            return this.putObject(null, o);
        }
        catch (BufferOverflowException bof) {
            this.reset();
            throw new RuntimeException("tried to save too large of an object.  max size : " + this._buf.capacity() / 2);
        }
    }

    private int putObject(String name, JSObject o) {
        if (o == null) {
            throw new NullPointerException("can't save a null object");
        }
        if (this._doneForever) {
            throw new RuntimeException("you broke something");
        }
        if (DEBUG) {
            System.out.println("putObject : " + name + " [" + o.getClass() + "]" + " # keys " + o.keySet(false).size());
        }
        if (this._flipped) {
            throw new RuntimeException("already flipped");
        }
        int start = this._buf.position();
        byte myType = 3;
        if (o instanceof JSArray || o instanceof List) {
            myType = 4;
        }
        if (this._handleSpecialObjects(name, o)) {
            return this._buf.position() - start;
        }
        if (name != null) {
            this._put(myType, name);
        }
        int sizePos = this._buf.position();
        this._buf.putInt(0);
        if (o.containsKey("_id")) {
            this._putObjectField("_id", o.get((Object)"_id"));
        }
        List transientFields = null;
        Object temp = o.get((Object)"_transientFields");
        if (temp instanceof List) {
            transientFields = (List)temp;
        }
        for (String s : o.keySet(false)) {
            if (s.equals("_id") || transientFields != null && transientFields.contains(s)) continue;
            Object val = ByteEncoder.safeGet(o, s);
            this._putObjectField(s, val);
        }
        this._buf.put((byte)0);
        this._buf.putInt(sizePos, this._buf.position() - sizePos);
        return this._buf.position() - start;
    }

    private void _putObjectField(String name, Object val) {
        JSFunction func;
        if (ByteEncoder.dbOnlyField(name) || name.equals("_transientFields")) {
            return;
        }
        if (DEBUG) {
            System.out.println("\t put thing : " + name);
        }
        if (name.equals("$where") && (val instanceof String || val instanceof JSString)) {
            this._put((byte)13, name);
            this._putValueString(val.toString());
            return;
        }
        if (val instanceof JSFunction && (func = (JSFunction)val).isCallable()) {
            if (name.startsWith("$") && func.getSourceCode() != null) {
                this.putFunction(name, func);
            }
            return;
        }
        if (val == null) {
            this.putNull(name);
        } else if (val instanceof Number) {
            this.putNumber(name, (Number)val);
        } else if (val instanceof JSString.Symbol) {
            this.putSymbol(name, val.toString());
        } else if (val instanceof String || val instanceof JSString) {
            this.putString(name, val.toString());
        } else if (val instanceof ObjectId) {
            this.putObjectId(name, (ObjectId)val);
        } else if (val instanceof JSObject) {
            this.putObject(name, (JSObject)val);
        } else if (val instanceof Boolean) {
            this.putBoolean(name, (Boolean)val);
        } else if (val instanceof JSBinaryData) {
            this.putBinary(name, (JSBinaryData)val);
        } else if (val instanceof Map) {
            this.putMap(name, (Map)val);
        } else {
            throw new RuntimeException("can't serialize " + val.getClass());
        }
    }

    private void putMap(String name, Map m) {
        this._put((byte)3, name);
        int sizePos = this._buf.position();
        this._buf.putInt(0);
        for (Object key : m.keySet()) {
            this._putObjectField(key.toString(), m.get(key));
        }
        this._buf.put((byte)0);
        this._buf.putInt(sizePos, this._buf.position() - sizePos);
    }

    private boolean _handleSpecialObjects(String name, JSObject o) {
        if (o == null) {
            return false;
        }
        if (o instanceof JSDate) {
            this._put((byte)9, name);
            this._buf.putLong(((JSDate)o).getTime());
            return true;
        }
        if (o instanceof JSRegex) {
            JSRegex r = (JSRegex)o;
            this._put((byte)11, name);
            this._put(r.getPattern());
            this._put(r.getFlags());
            return true;
        }
        if (!this._dontRefContains(o) && name != null && o instanceof DBRef) {
            DBRef r = (DBRef)o;
            this.putDBRef(name, r._ns, r._id);
            return true;
        }
        if (o.get((Object)"_____nodbref_____") != null) {
            o.removeField((Object)"_____nodbref_____");
            return false;
        }
        if (!this._dontRefContains(o) && name != null && ByteEncoder.cameFromDB(o)) {
            this.putDBRef(name, o.get((Object)"_ns").toString(), (ObjectId)o.get((Object)"_id"));
            return true;
        }
        return false;
    }

    protected int putNull(String name) {
        int start = this._buf.position();
        this._put((byte)10, name);
        return this._buf.position() - start;
    }

    protected void putBinary(String name, JSBinaryData bin) {
        if (bin.length() < 0) {
            throw new RuntimeException("wtf?");
        }
        this._put((byte)5, name);
        this._buf.putInt(4 + bin.length());
        this._buf.put((byte)2);
        this._buf.putInt(bin.length());
        int before = this._buf.position();
        bin.put(this._buf);
        int after = this._buf.position();
        MyAsserts.assertEquals((int)(after - before), (int)bin.length());
    }

    protected int putBoolean(String name, Boolean b) {
        int start = this._buf.position();
        this._put((byte)8, name);
        this._buf.put(b != false ? (byte)1 : 0);
        return this._buf.position() - start;
    }

    protected int putNumber(String name, Number n) {
        int start = this._buf.position();
        if (n instanceof Integer) {
            this._put((byte)16, name);
            this._buf.putInt(n.intValue());
        } else {
            this._put((byte)1, name);
            this._buf.putDouble(n.doubleValue());
        }
        return this._buf.position() - start;
    }

    protected int putFunction(String name, JSFunction func) {
        if (D) {
            System.out.println("putFunction [" + name + "]");
        }
        int start = this._buf.position();
        HashSet<String> globalsToSend = new HashSet<String>();
        JSArray globals = func.getGlobals();
        if (globals != null) {
            for (Object var : globals) {
                if (BAD_GLOBALS.contains(var.toString())) continue;
                globalsToSend.add(var.toString());
            }
        }
        if (D) {
            System.out.println("globalsToSend : " + globalsToSend);
        }
        if (name.startsWith("$") && globalsToSend.size() > 0 && func.getScope() != null) {
            this._put((byte)15, name);
            int save = this._buf.position();
            this._buf.putInt(0);
            this._putValueString(func.getSourceCode());
            JSObjectBase scopeToPass = new JSObjectBase();
            Scope s = func.getScope();
            IdentitySet dontRef = new IdentitySet();
            this._dontRef.push(dontRef);
            for (String var : globalsToSend) {
                Object val = s.get(var);
                dontRef.add(val);
                scopeToPass.set((Object)var, val);
            }
            this.putObject(null, (JSObject)scopeToPass);
            this._dontRef.pop();
            this._buf.putInt(save, this._buf.position() - save);
        } else {
            this._put((byte)13, name);
            this._putValueString(func.getSourceCode());
        }
        return this._buf.position() - start;
    }

    protected int putSymbol(String name, String s) {
        int start = this._buf.position();
        this._put((byte)14, name);
        this._putValueString(s);
        return this._buf.position() - start;
    }

    protected int putString(String name, String s) {
        int start = this._buf.position();
        this._put((byte)2, name);
        this._putValueString(s);
        return this._buf.position() - start;
    }

    protected int putObjectId(String name, ObjectId oid) {
        int start = this._buf.position();
        this._put((byte)7, name);
        this._buf.putLong(oid._base);
        this._buf.putInt(oid._inc);
        return this._buf.position() - start;
    }

    protected int putDBRef(String name, String ns, ObjectId oid) {
        int start = this._buf.position();
        this._put((byte)12, name);
        this._putValueString(ns);
        this._buf.putLong(oid._base);
        this._buf.putInt(oid._inc);
        return this._buf.position() - start;
    }

    private void _put(byte type, String name) {
        this._buf.put(type);
        this._put(name);
    }

    void _putValueString(String s) {
        int lenPos = this._buf.position();
        this._buf.putInt(0);
        int strLen = this._put(s);
        this._buf.putInt(lenPos, strLen);
    }

    int _put(String name) {
        this._cbuf.position(0);
        this._cbuf.limit(this._cbuf.capacity());
        this._cbuf.append(name);
        this._cbuf.flip();
        int start = this._buf.position();
        this._encoder.encode(this._cbuf, this._buf, false);
        this._buf.put((byte)0);
        return this._buf.position() - start;
    }

    boolean _dontRefContains(Object o) {
        if (this._dontRef.size() == 0) {
            return false;
        }
        return this._dontRef.peek().contains(o);
    }

    void neverUsingThisAgain() {
        this._doneForever = true;
        _charBufferPool.done((Object)this._cbuf);
    }

    static {
        BAD_GLOBALS.add("db");
        BAD_GLOBALS.add("local");
        BAD_GLOBALS.add("core");
        BAD_GLOBALS.add("args");
        BAD_GLOBALS.add("obj");
        _poolSize = Math.min(30, 20);
        _pool = new WatchedSimplePool<ByteEncoder>("ByteEncoders", _poolSize, -1){

            protected ByteEncoder createNew() {
                if (Bytes.D) {
                    System.out.println("creating new ByteEncoder");
                }
                return new ByteEncoder();
            }

            protected long memSize(ByteEncoder d) {
                return 0x600400L;
            }
        };
        _charBufferPool = new SimplePool("ByteEncoder.CharBuffer", 10, -1){

            protected CharBuffer createNew() {
                return CharBuffer.allocate(524288);
            }
        };
    }
}

