/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine.line;

import ed.TestCase;
import ed.io.StreamUtil;
import ed.js.JSFunction;
import ed.js.engine.Convert;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

public class LineTest
extends TestCase {
    final List<OneLineTest> _all = new ArrayList<OneLineTest>();

    public LineTest() {
        File dir = new File("src/test/ed/js/engine/line/");
        for (File f : dir.listFiles()) {
            if (!f.toString().endsWith(".js")) continue;
            OneLineTest t = new OneLineTest(f);
            this.add(t);
            this._all.add(t);
        }
    }

    @Factory
    public Object[] createTestInstances() {
        return this._all.toArray();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            TestCase all = new TestCase();
            for (String s : args) {
                all.add((TestCase)new OneLineTest(new File(s)));
            }
            all.runConsole();
        } else {
            LineTest lt = new LineTest();
            lt.runConsole();
        }
    }

    public static class OneLineTest
    extends TestCase {
        final File _file;

        OneLineTest(File f) {
            super(f.toString());
            this._file = f;
        }

        @Test
        public void test() throws IOException {
            boolean debug = false;
            Convert c = new Convert(this._file);
            JSFunction f = c.get();
            String jsCode = StreamUtil.readFully((InputStream)new FileInputStream(this._file));
            String javaCode = c.getClassString();
            String[] javaLines = javaCode.split("\n");
            Matcher m = Pattern.compile("LINE_(\\d+)_").matcher(jsCode);
            while (m.find()) {
                int j;
                int line = Integer.parseInt(m.group(1));
                if (debug) {
                    System.out.println(line);
                }
                int stringid = c.findStringId(m.group());
                String matchString = "_string(" + stringid + ")";
                if (debug) {
                    System.out.println("\t" + matchString);
                }
                for (j = 0; j < javaLines.length && !javaLines[j].contains(matchString); ++j) {
                }
                ++j;
                if (debug) {
                    System.out.println("\t" + j);
                }
                if (line != c._mapLineNumber(j)) {
                    c._debugLineNumber(j);
                }
                OneLineTest.assertEquals((int)line, (int)c._mapLineNumber(j));
            }
        }
    }
}

