/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import ed.ext.org.mozilla.javascript.Node;
import ed.js.engine.CompileOptions;
import ed.js.engine.FunctionInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class State {
    final Set<String> _localSymbols = new HashSet<String>();
    final Map<Integer, String> _functionIdToName = new HashMap<Integer, String>();
    final Map<Integer, Integer> _functionIdToType = new HashMap<Integer, Integer>();
    final Set<Integer> _nonRootFunctions = new HashSet<Integer>();
    final Stack<String> _tempOpNames = new Stack();
    final State _parent;
    final CompileOptions _options;
    int _depth = 0;
    FunctionInfo _fi;
    static final Set<String> JAVA_RESERVED_WORDS = new HashSet<String>();

    State(CompileOptions options) {
        this._parent = null;
        this._options = options;
    }

    State(CompileOptions options, State s) {
        this._parent = s;
        this._options = s._options;
    }

    State child() {
        return new State(this._options, this);
    }

    State parent() {
        return this._parent;
    }

    boolean hasSymbol(String s) {
        return this._localSymbols.contains(s);
    }

    boolean addSymbol(String s) {
        return this._localSymbols.add(s);
    }

    boolean isNumberAndLocal(String s) {
        return this.isNumber(s) && this.useLocalVariable(s);
    }

    boolean isNumber(String s) {
        if (this._fi == null) {
            return false;
        }
        return this._fi.isNumber(s);
    }

    boolean isNumberAndLocal(Node n) {
        if (!this.isNumber(n)) {
            return false;
        }
        if (n.getType() == 55 || n.getType() == 39) {
            return this.useLocalVariable(n.getString());
        }
        return true;
    }

    boolean isNumber(Node n) {
        if (n.getType() == 40) {
            return true;
        }
        if (this._fi == null) {
            return false;
        }
        return this._fi.isNumber(n);
    }

    boolean isPrimitive(String s) {
        return this.isNumber(s);
    }

    boolean useLocalVariable(String name) {
        if (!this._options.useLocalJavaVariables()) {
            return false;
        }
        if (name.equals("arguments")) {
            return false;
        }
        if (JAVA_RESERVED_WORDS.contains(name)) {
            return false;
        }
        if (this._fi == null) {
            return false;
        }
        return this._fi.canUseLocal(name);
    }

    static {
        JAVA_RESERVED_WORDS.add("first");
        JAVA_RESERVED_WORDS.add("final");
        JAVA_RESERVED_WORDS.add("assert");
        JAVA_RESERVED_WORDS.add("abstract");
        JAVA_RESERVED_WORDS.add("default");
        JAVA_RESERVED_WORDS.add("goto");
        JAVA_RESERVED_WORDS.add("package");
        JAVA_RESERVED_WORDS.add("synchronized");
        JAVA_RESERVED_WORDS.add("boolean");
        JAVA_RESERVED_WORDS.add("private");
        JAVA_RESERVED_WORDS.add("double");
        JAVA_RESERVED_WORDS.add("implements");
        JAVA_RESERVED_WORDS.add("protected");
        JAVA_RESERVED_WORDS.add("byte");
        JAVA_RESERVED_WORDS.add("import");
        JAVA_RESERVED_WORDS.add("public");
        JAVA_RESERVED_WORDS.add("throws");
        JAVA_RESERVED_WORDS.add("case");
        JAVA_RESERVED_WORDS.add("enum");
        JAVA_RESERVED_WORDS.add("instanceof");
        JAVA_RESERVED_WORDS.add("transient");
        JAVA_RESERVED_WORDS.add("extends");
        JAVA_RESERVED_WORDS.add("int");
        JAVA_RESERVED_WORDS.add("short");
        JAVA_RESERVED_WORDS.add("char");
        JAVA_RESERVED_WORDS.add("final");
        JAVA_RESERVED_WORDS.add("interface");
        JAVA_RESERVED_WORDS.add("static");
        JAVA_RESERVED_WORDS.add("void");
        JAVA_RESERVED_WORDS.add("class");
        JAVA_RESERVED_WORDS.add("finally");
        JAVA_RESERVED_WORDS.add("long");
        JAVA_RESERVED_WORDS.add("strictfp");
        JAVA_RESERVED_WORDS.add("volatile");
        JAVA_RESERVED_WORDS.add("const");
        JAVA_RESERVED_WORDS.add("float");
        JAVA_RESERVED_WORDS.add("native");
        JAVA_RESERVED_WORDS.add("super");
    }
}

