/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import ed.js.JSArray;
import ed.js.JSDate;
import ed.js.JSException;
import ed.js.JSFunction;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSString;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.lang.StackTraceHolder;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeBridge {
    private static final Object[] EMPTY_OBJET_ARRAY = new Object[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Set<String> _disallowedNativeNames = new HashSet<String>();
    private static final Map<Class, Set<String>> _publicMethodNames;
    static final JSFunctionCalls0 _nativeFuncCall;
    private static final Map<Class, Map<String, List<Method>>> _classToMethods;
    static final Comparator<Method> _methodLengthComparator;
    static final Comparator<Constructor> _consLengthComparator;

    public static final synchronized Set<String> getPublicMethodNames(Class c) {
        Set<String> names = _publicMethodNames.get(c);
        if (names == null) {
            names = new HashSet<String>();
            for (Method m : c.getMethods()) {
                names.add(m.getName());
            }
            _publicMethodNames.put(c, names);
        }
        return names;
    }

    public static final JSFunction getNativeFunc(final Object o, final String name) {
        if (o == null) {
            throw new IllegalArgumentException("o can't be null");
        }
        Class<?> c = o.getClass();
        if (c == JSObjectBase.class) {
            return null;
        }
        List<Method> methods = NativeBridge.getMethods(o.getClass(), name);
        if (methods == null || methods.size() == 0) {
            return null;
        }
        return new JSFunctionCalls0(){

            public Object call(Scope s, Object[] params) {
                return NativeBridge.callNative(s, o, name, params);
            }
        };
    }

    private static List<Method> getMethods(Class c, String n) {
        List<Method> l;
        Map<String, List<Method>> m = _classToMethods.get(c);
        if (m == null) {
            m = new HashMap<String, List<Method>>();
            _classToMethods.put(c, m);
        }
        if ((l = m.get(n)) != null) {
            return l;
        }
        l = new ArrayList<Method>();
        Method[] all = c.getMethods();
        Arrays.sort(all, _methodLengthComparator);
        for (Method method : all) {
            if (!method.getName().equals(n)) continue;
            l.add(method);
        }
        m.put(n, l);
        return l;
    }

    public static Object toJSObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof JSObject) {
            return o;
        }
        if (o instanceof String) {
            return new JSString(o.toString());
        }
        if (o instanceof Date) {
            return new JSDate((Date)o);
        }
        if (o instanceof Collection) {
            JSArray a = new JSArray();
            for (Object foo : (Collection)o) {
                a.add(foo);
            }
            return a;
        }
        if (o.getClass().isArray() && o.getClass().getName().toString().length() > 3) {
            JSArray a = new JSArray();
            for (Object foo : (Object[])o) {
                a.add(foo);
            }
            return a;
        }
        if (o instanceof Enumeration) {
            JSArray a = new JSArray();
            a.addAll((Enumeration)o);
            return a;
        }
        if (o instanceof Iterator) {
            JSArray a = new JSArray();
            a.addAll((Iterator)o);
            return a;
        }
        return o;
    }

    public static Object toJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof JSObject)) {
            return o;
        }
        if (o instanceof JSString) {
            return o.toString();
        }
        if (o instanceof JSDate) {
            return ((JSDate)o).toJavaDate();
        }
        return o;
    }

    public static Object callNative(Scope s, Object obj, String name, Object[] params) {
        return NativeBridge.callNative(s, obj, name, params, false);
    }

    public static Object callNative(Scope s, Object obj, String name, Object[] params, boolean debug) {
        List<Method> methods;
        if (_disallowedNativeNames.contains(name)) {
            throw new JSException((Object)("[" + name + "] is not allowed"));
        }
        if (debug) {
            System.out.println("callNative " + obj.getClass() + " [" + name + "]");
        }
        if ((methods = NativeBridge.getMethods(obj.getClass(), name)) != null && methods.size() > 0) {
            for (Method m : methods) {
                Object[] nParams;
                if (debug) {
                    System.out.println("\t " + m.getName());
                }
                if ((nParams = NativeBridge.doParamsMatch(m.getParameterTypes(), params, s, debug)) == null) {
                    if (!debug) continue;
                    System.out.println("\t\t boo");
                    continue;
                }
                if (debug) {
                    System.out.println("\t\t yay");
                }
                m.setAccessible(true);
                try {
                    return NativeBridge.toJSObject(m.invoke(obj, nParams));
                }
                catch (InvocationTargetException e) {
                    StackTraceHolder.getInstance().fix(e.getCause());
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    if (e.getCause() instanceof Error) {
                        throw (Error)e.getCause();
                    }
                    throw new RuntimeException(e.getCause());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new NullPointerException("no method with matching params [" + name + "] (from a [" + obj.getClass() + "])");
        }
        if (obj.getClass() == JSObjectBase.class) {
            throw new NullPointerException("no function called : " + name + " fields [" + ((JSObjectBase)obj).keySet() + "]");
        }
        String msg = " (from a [" + obj.getClass() + "] ";
        if (obj instanceof JSObjectBase) {
            msg = msg + "name: " + ((JSObjectBase)obj)._getName();
        }
        msg = msg + ")";
        throw new NullPointerException(name + msg);
    }

    static Object[] doParamsMatch(Class[] myClasses, Object[] params, Scope scope) {
        return NativeBridge.doParamsMatch(myClasses, params, scope, false);
    }

    static Object[] doParamsMatch(Class[] myClasses, Object[] params, Scope scope, boolean debug) {
        int i;
        Object[] foo;
        int i2;
        Object[] n;
        if (myClasses == null) {
            myClasses = EMPTY_CLASS_ARRAY;
        }
        if (params == null) {
            params = EMPTY_OBJET_ARRAY;
        }
        if (myClasses.length > 0 && myClasses[0] == Scope.class) {
            if (debug) {
                System.out.println("Adding scope to front");
            }
            n = new Object[params.length + 1];
            n[0] = scope;
            for (i2 = 0; i2 < params.length; ++i2) {
                n[i2 + 1] = params[i2];
            }
            params = n;
        }
        if (myClasses.length > params.length) {
            n = new Object[myClasses.length];
            for (i2 = 0; i2 < params.length; ++i2) {
                n[i2] = params[i2];
            }
            params = n;
        }
        if (params.length > myClasses.length && params[params.length - 1] != null && params[params.length - 1].getClass().isArray() && (foo = (Object[])params[params.length - 1]).length == 0) {
            Object[] n2 = new Object[params.length - 1];
            for (i = 0; i < n2.length; ++i) {
                n2[i] = params[i];
            }
            params = n2;
        }
        if (params.length >= myClasses.length && myClasses.length > 0 && myClasses[myClasses.length - 1].isArray() && params[params.length - 1] != null && !params[params.length - 1].getClass().isArray() && !(params[params.length - 1] instanceof List)) {
            if (debug) {
                System.out.println("\t\t possible var args : " + myClasses[myClasses.length - 1]);
            }
            Object[] varArgs = new Object[1 + params.length - myClasses.length];
            for (int i3 = 0; i3 < varArgs.length; ++i3) {
                varArgs[i3] = params[i3 + myClasses.length - 1];
            }
            Object[] foo2 = new Object[myClasses.length];
            for (i = 0; i < myClasses.length - 1; ++i) {
                foo2[i] = params[i];
            }
            foo2[myClasses.length - 1] = varArgs;
            params = foo2;
        }
        if (myClasses.length != params.length) {
            if (debug) {
                int i4;
                System.out.println("\t\t param length don't match " + myClasses.length + " != " + params.length);
                System.out.print("\t\t\t");
                for (i4 = 0; i4 < myClasses.length; ++i4) {
                    System.out.print(myClasses[i4].getName() + "\t");
                }
                System.out.println();
                System.out.print("\t\t\t");
                for (i4 = 0; i4 < params.length; ++i4) {
                    if (params[i4] == null) {
                        System.out.print("null\t");
                        continue;
                    }
                    System.out.print(params[i4].getClass().getName() + "\t");
                }
                System.out.println();
            }
            return null;
        }
        for (int i5 = 0; i5 < myClasses.length; ++i5) {
            if (params[i5] == null) continue;
            Class myClass = myClasses[i5];
            Class<Number> origMyClass = myClass;
            if (myClass == String.class || myClass == CharSequence.class) {
                params[i5] = params[i5].toString();
            }
            if (myClass.isPrimitive()) {
                if (myClass == Integer.TYPE || myClass == Long.TYPE || myClass == Double.TYPE) {
                    myClass = Number.class;
                } else if (myClass == Boolean.TYPE) {
                    myClass = Boolean.class;
                }
            }
            if (myClass.isArray() && params[i5] instanceof JSArray) {
                JSArray a = (JSArray)params[i5];
                Object newArray = Array.newInstance(myClass.getComponentType(), a.size());
                for (int j = 0; j < a.size(); ++j) {
                    Array.set(newArray, j, a.get(j));
                }
                params[i5] = newArray;
                continue;
            }
            if (!myClass.isAssignableFrom(params[i5].getClass())) {
                if (debug) {
                    System.out.println("\t native assignement failed b/c " + myClasses[i5] + " is not mappable from " + params[i5].getClass());
                }
                return null;
            }
            if (myClass == Number.class && origMyClass != params[i5].getClass()) {
                Number theNumber = (Number)params[i5];
                if (origMyClass == Double.class || origMyClass == Double.TYPE) {
                    params[i5] = theNumber.doubleValue();
                } else if (origMyClass == Integer.class || origMyClass == Integer.TYPE) {
                    params[i5] = theNumber.intValue();
                } else if (origMyClass == Float.class || origMyClass == Float.TYPE) {
                    params[i5] = Float.valueOf(theNumber.floatValue());
                } else if (origMyClass == Long.class || origMyClass == Long.TYPE) {
                    params[i5] = theNumber.longValue();
                } else if (origMyClass == Short.class || origMyClass == Short.TYPE) {
                    params[i5] = theNumber.shortValue();
                } else if (origMyClass == Number.class) {
                    params[i5] = theNumber;
                } else {
                    throw new RuntimeException("what is : " + origMyClass);
                }
            }
            if (myClass != Object.class || params[i5].getClass() != JSString.class) continue;
            params[i5] = params[i5].toString();
        }
        return params;
    }

    static final int compareParams(Class[] as, Class[] bs) {
        if (as.length != bs.length) {
            int diff = as.length - bs.length;
            if (Math.abs(diff) == 1) {
                if (as.length > 0 && as[0] == Scope.class) {
                    return -1;
                }
                if (bs.length > 0 && bs[0] == Scope.class) {
                    return 1;
                }
            }
            return diff;
        }
        for (int i = 0; i < as.length; ++i) {
            Class a = as[i];
            Class b = bs[i];
            if (a == String.class && b != String.class) {
                return 1;
            }
            if (b != String.class || a == String.class) continue;
            return -1;
        }
        return 0;
    }

    static {
        _disallowedNativeNames.add("getClassLoader");
        _disallowedNativeNames.add("loadClass");
        _publicMethodNames = new HashMap<Class, Set<String>>();
        _nativeFuncCall = new JSFunctionCalls0(){

            public Object call(Scope s, Object[] params) {
                boolean debug = false;
                Scope.This temp = (Scope.This)s._this.peek();
                if (temp._this != null) {
                    throw new RuntimeException("why is this._this is not null : " + temp._this + " s:" + s.hashCode());
                }
                Object obj = temp._nThis;
                String name = temp._nThisFunc;
                if (obj == null) {
                    throw new NullPointerException("object was null.  name was:" + name);
                }
                return NativeBridge.callNative(s, obj, name, params, false);
            }
        };
        _classToMethods = new HashMap<Class, Map<String, List<Method>>>();
        _methodLengthComparator = new Comparator<Method>(){

            @Override
            public int compare(Method a, Method b) {
                return NativeBridge.compareParams(a.getParameterTypes(), b.getParameterTypes());
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        };
        _consLengthComparator = new Comparator<Constructor>(){

            @Override
            public int compare(Constructor a, Constructor b) {
                return NativeBridge.compareParams(a.getParameterTypes(), b.getParameterTypes());
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        };
    }
}

