/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import ed.MyAsserts;
import ed.io.StreamUtil;
import ed.js.JSFunction;
import ed.js.JSInternalFunctions;
import ed.js.engine.Convert;
import ed.js.engine.ConvertTest;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls1;
import ed.util.ScriptTestInstanceBase;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;

public class JSTestInstance
extends ScriptTestInstanceBase {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();

    public JSFunction convert() throws Exception {
        File f = this.getTestScriptFile();
        if (f.toString().endsWith(".js")) {
            Convert c = new Convert(this.getTestScriptFile());
            return c.get();
        }
        throw new RuntimeException("couldn't run " + f);
    }

    public void preTest(Scope scope) throws Exception {
        File jsFile = this.getTestScriptFile();
        final PrintStream out = new PrintStream(this.bout);
        if (jsFile.toString().contains("/engine/")) {
            JSFunctionCalls1 myout = new JSFunctionCalls1(){

                public Object call(Scope scope, Object o, Object[] extra) {
                    out.println(JSInternalFunctions.JS_toString(o));
                    return null;
                }
            };
            scope.put("print", myout, true);
            scope.put("SYSOUT", myout, true);
        }
    }

    public void validateOutput(Scope scope) throws Exception {
        String outString = this._clean(this.bout.toString());
        File jsFile = this.getTestScriptFile();
        if (this._isEngineFile()) {
            File correct = new File(jsFile.toString().replaceAll(".js$", ".out"));
            if (!correct.exists()) {
                throw new Exception("Error - no correct file for " + jsFile.toString());
            }
            String correctOut = this._clean(StreamUtil.readFully((File)correct));
            if (!MyAsserts.isClose((String)correctOut, (String)outString)) {
                System.out.println();
                System.out.println(correctOut.replaceAll("[\r\n ]+", " "));
                System.out.println(outString.replaceAll("[\r\n ]+", " "));
                throw new Exception(" for test " + jsFile.toString() + " : [" + correctOut + "] != [" + outString + "]");
            }
        }
    }

    private boolean _isEngineFile() {
        return this.getTestScriptFile().toString().contains("/engine/");
    }

    private String _clean(String s) {
        return ConvertTest._clean(s);
    }

    public static void main(String[] args) throws Exception {
        JSTestInstance jsti = new JSTestInstance();
        jsti.setTestScriptFile(new File(args[0]));
        jsti.test();
    }
}

