/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import ed.js.JSException;
import ed.js.JSRegex;
import ed.js.JSString;
import ed.js.engine.Convert;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.lang.Language;
import ed.util.Pair;
import ed.util.SeenPath;
import java.util.List;

public abstract class JSCompiledScript
extends JSFunctionCalls0 {
    Convert.ScriptInfo _scriptInfo;
    protected List<Pair<String, String>> _regex;
    protected String[] _strings;
    protected JSString[] _jsstrings;
    protected boolean _loadOnce = false;
    static String _nullMarker = "_nullMarker";

    public JSCompiledScript() {
        this.myInit();
    }

    protected abstract void myInit();

    protected abstract Object _call(Scope var1, Object[] var2) throws Exception;

    public Object call(Scope scope, Object[] extra) {
        if (this._loadOnce) {
            return this.loadOnce(scope);
        }
        return this.docall(scope, extra);
    }

    Object docall(Scope scope, Object[] extra) {
        try {
            return this._call(scope, extra);
        }
        catch (RuntimeException re) {
            if (Convert.DJS) {
                re.printStackTrace();
            }
            this._scriptInfo.fixStack(re);
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (Convert.DJS) {
                e.printStackTrace();
            }
            this._scriptInfo.fixStack(e);
            throw new RuntimeException("weird error : " + e.getClass().getName(), e);
        }
    }

    protected void _throw(Object foo) {
        if (foo instanceof JSException) {
            throw (JSException)foo;
        }
        if (foo instanceof Throwable) {
            throw new JSException((Object)foo.toString(), (Throwable)foo);
        }
        throw new JSException(foo);
    }

    public Object loadOnce(Scope scope) {
        String name = this.getClass().getName();
        Object res = scope.getLoaded(name);
        if (res != null) {
            if (res == _nullMarker) {
                return null;
            }
            return res;
        }
        res = this.docall(scope, null);
        if (res == null) {
            res = _nullMarker;
        }
        scope.markLoaded(name, res);
        return res;
    }

    public Language getFileLanguage() {
        if (this._scriptInfo == null) {
            return Language.JS();
        }
        return this._scriptInfo._sourceLanguage;
    }

    public JSString _string(int id) {
        if (this._jsstrings == null) {
            this._jsstrings = new JSString[this._strings.length];
        }
        if (this._jsstrings[id] == null) {
            this._jsstrings[id] = new JSString(this._strings[id]);
        }
        return this._jsstrings[id];
    }

    public JSRegex _regex(int id) {
        Pair<String, String> p = this._regex.get(id);
        return new JSRegex((String)p.first, (String)p.second);
    }

    public long approxSize(SeenPath seen) {
        int i;
        long size = super.approxSize(seen);
        if (this._strings != null) {
            for (i = 0; i < this._strings.length; ++i) {
                if (this._strings[i] == null) continue;
                size += (long)(8 + this._strings[i].length() * 2);
            }
        }
        if (this._jsstrings != null) {
            for (i = 0; i < this._jsstrings.length; ++i) {
                if (this._jsstrings[i] == null) continue;
                size += (long)(8 + this._jsstrings[i].length() * 2);
            }
        }
        if (this._regex != null) {
            for (i = 0; i < this._regex.size(); ++i) {
                size += (long)(32 + ((String)this._regex.get((int)i).first).length() * 2 + ((String)this._regex.get((int)i).second).length() * 2);
            }
        }
        return size;
    }
}

