/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import ed.ext.org.mozilla.javascript.FunctionNode;
import ed.ext.org.mozilla.javascript.Node;
import ed.ext.org.mozilla.javascript.ScriptOrFnNode;
import ed.ext.org.mozilla.javascript.Token;
import ed.js.engine.NodeUtil;

public class Debug {
    public static void print(ScriptOrFnNode sn, int indent) {
        for (int i = 0; i < sn.getFunctionCount(); ++i) {
            FunctionNode fn = sn.getFunctionNode(i);
            Debug.print((ScriptOrFnNode)fn, indent);
        }
        Debug.printTree((Node)sn, indent);
    }

    public static void printTree(Node n, int indent) {
        int id;
        if (n == null) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            System.out.print("  ");
        }
        System.out.print(Token.name((int)n.getType()) + " [" + n.getClass().getName().replaceAll("ed.ext.org.mozilla.javascript.", "") + "]");
        if (n instanceof FunctionNode) {
            System.out.print(" " + ((FunctionNode)n).getFunctionName());
        }
        if (n.getType() == 108 && (id = n.getIntProp(1, -17)) != -17) {
            System.out.print(" functionId=" + id);
        }
        if (NodeUtil.hasString(n)) {
            System.out.print(" [" + n.getString() + "]");
        }
        if (n.getType() == 40) {
            System.out.print(" NUMBER:" + n.getDouble());
        }
        if (n instanceof Node.Jump) {
            Node.Jump j = (Node.Jump)n;
            if (j.target != null) {
                System.out.print(" -> " + j.target.hashCode());
            }
        }
        System.out.print(" (" + n.hashCode() + ")");
        StringBuffer sb = new StringBuffer();
        n.handlePropList(sb);
        System.out.print(" " + sb);
        System.out.print(" line:" + n.getLineno());
        System.out.println();
        Debug.printTree(n.getFirstChild(), indent + 1);
        Debug.printTree(n.getNext(), indent);
    }
}

