/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import ed.MyAsserts;
import ed.TestCase;
import ed.io.StreamUtil;
import ed.js.JSFunction;
import ed.js.JSInternalFunctions;
import ed.js.engine.Convert;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls1;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.testng.annotations.Test;

public class ConvertTest
extends TestCase {
    final Scope _scope;

    public ConvertTest() {
        File dir = new File("src/test/ed/js/engine/");
        for (File f : dir.listFiles()) {
            if (f.toString().contains("_") || !f.toString().endsWith(".js")) continue;
            this.add(new FileTest(f));
        }
        this._scope = Scope.newGlobal().child(new File("."));
    }

    @Test
    public void testMakeAnon() {
        ConvertTest.assertClose((String)"5", (String)this._makeAnon("return 5;").toString());
        ConvertTest.assertClose((String)"6", (String)this._makeAnon("function(){ return 6; }").toString());
    }

    @Test
    public void testFixStack() {
        JSFunction f = Convert.makeAnon("x = {};\nx.a.b = 5;\n");
        try {
            f.call(this._scope.child());
        }
        catch (Exception e) {
            ConvertTest.assertEquals((int)2, (int)e.getStackTrace()[0].getLineNumber());
        }
    }

    @Test
    public void testCleanName() {
        ConvertTest.assertEquals((String)"abc_123", (Object)Convert.cleanName("abc/123"));
        ConvertTest.assertEquals((String)"abc__123", (Object)Convert.cleanName("abc//123"));
        ConvertTest.assertEquals((String)"abc__123", (Object)Convert.cleanName("/abc//123"));
        ConvertTest.assertEquals((String)"N123abc", (Object)Convert.cleanName("123abc"));
    }

    Object _makeAnon(String code) {
        return Convert.makeAnon(code).call(this._scope);
    }

    static String _clean(String s) {
        s = s.replaceAll("tempFunc_\\d+_", "tempFunc_");
        return s;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            TestCase all = new TestCase();
            for (String s : args) {
                if (s.contains("_")) continue;
                all.add((TestCase)new FileTest(new File(s)));
            }
            all.runConsole();
        } else {
            ConvertTest ct = new ConvertTest();
            ct.runConsole();
        }
    }

    public static class FileTest
    extends TestCase {
        final File _file;

        FileTest(File f) {
            super(f.toString());
            this._file = f;
        }

        public void test() throws IOException {
            Convert c = new Convert(this._file);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            final PrintStream out = new PrintStream(bout);
            JSFunction f = c.get();
            Scope scope = Scope.newGlobal().child(new File("."));
            scope.setGlobal(true);
            scope.makeThreadLocal();
            if (this._file.toString().contains("/engine/")) {
                JSFunctionCalls1 myout = new JSFunctionCalls1(){

                    public Object call(Scope scope, Object o, Object[] extra) {
                        out.println(JSInternalFunctions.JS_toString(o));
                        return null;
                    }
                };
                scope.put("print", myout, true);
                scope.put("SYSOUT", myout, true);
            }
            f.call(scope);
            String outString = ConvertTest._clean(bout.toString());
            if (this._file.toString().contains("/engine/")) {
                File correct = new File(this._file.toString().replaceAll(".js$", ".out"));
                if (!correct.exists()) {
                    FileTest.assertTrue((boolean)correct.exists());
                }
                String correctOut = ConvertTest._clean(StreamUtil.readFully((File)correct));
                try {
                    FileTest.assertClose((String)correctOut, (String)outString);
                }
                catch (MyAsserts.MyAssert a) {
                    System.out.println();
                    System.out.println(correctOut.replaceAll("[\r\n ]+", " "));
                    System.out.println(outString.replaceAll("[\r\n ]+", " "));
                    throw a;
                }
            }
        }
    }
}

