/*
 * Decompiled with CFR 0.152.
 */
package ed.js.engine;

import ed.lang.Language;

public class CompileOptions {
    private boolean _locked = false;
    private boolean _useLocalJavaVariables = true;
    private boolean _allowLoopingConstructs = true;
    private boolean _createNewScope = true;
    private Language _sourceLanguage = Language.JS();

    public static CompileOptions forEval() {
        CompileOptions co = new CompileOptions();
        co.createNewScope(false);
        return co;
    }

    public CompileOptions copy() {
        CompileOptions options = new CompileOptions();
        options._useLocalJavaVariables = this._useLocalJavaVariables;
        options._allowLoopingConstructs = this._allowLoopingConstructs;
        options._createNewScope = this._createNewScope;
        options._sourceLanguage = this._sourceLanguage;
        return options;
    }

    public CompileOptions useLocalJavaVariables(boolean useLocalJavaVariables) {
        if (this._useLocalJavaVariables != useLocalJavaVariables) {
            this._check();
            this._useLocalJavaVariables = useLocalJavaVariables;
        }
        return this;
    }

    public boolean useLocalJavaVariables() {
        return this._useLocalJavaVariables;
    }

    public CompileOptions allowLoopingConstructs(boolean allowLoopingConstructs) {
        if (this._allowLoopingConstructs != allowLoopingConstructs) {
            this._check();
            this._allowLoopingConstructs = allowLoopingConstructs;
        }
        return this;
    }

    public boolean allowLoopingConstructs() {
        return this._allowLoopingConstructs;
    }

    public CompileOptions createNewScope(boolean createNewScope) {
        if (this._createNewScope != createNewScope) {
            this._check();
            this._createNewScope = createNewScope;
        }
        return this;
    }

    public boolean createNewScope() {
        return this._createNewScope;
    }

    public CompileOptions sourceLanguage(Language sourceLanguage) {
        if (this._sourceLanguage != sourceLanguage) {
            this._check();
            this._sourceLanguage = sourceLanguage;
        }
        return this;
    }

    public Language sourceLanguage() {
        return this._sourceLanguage;
    }

    public CompileOptions lock() {
        this._locked = true;
        return this;
    }

    void _check() {
        if (this._locked) {
            throw new RuntimeException("locked");
        }
    }
}

