/*
 * Decompiled with CFR 0.152.
 */
package ed.js;

import com.twmacinta.util.MD5;
import ed.js.JS;
import ed.js.JSArray;
import ed.js.JSException;
import ed.js.JSFunction;
import ed.js.JSNumber;
import ed.js.JSObject;
import ed.js.JSObjectBase;
import ed.js.JSRegex;
import ed.js.engine.Scope;
import ed.js.func.JSFunctionCalls0;
import ed.js.func.JSFunctionCalls1;
import ed.js.func.JSFunctionCalls2;
import ed.util.IdentitySet;
import ed.util.OrderedSet;
import ed.util.StringEncrypter;
import ed.util.StringParseUtil;
import java.util.Set;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSString
extends JSObjectBase
implements Comparable {
    private static JSFunction _cons;
    static JSString EMPTY;
    String _s;
    private boolean isObj = false;

    public JSString(String s) {
        super(Scope.getThreadLocalFunction("String", _cons, true));
        this._s = s;
    }

    public JSString(char[] c) {
        this(new String(c));
    }

    @Override
    public Object get(Object name) {
        if (name instanceof JSString) {
            name = name.toString();
        }
        if (name instanceof String && name.toString().equals("length")) {
            return this._s.length();
        }
        return super.get(name);
    }

    @Override
    public String toString() {
        return this._s;
    }

    @Override
    public String toPrettyString() {
        return this._s;
    }

    public int compareTo(Object o) {
        if (o == null) {
            o = "";
        }
        return this._s.compareTo(o.toString());
    }

    public int length() {
        return this._s.length();
    }

    @Override
    public Object getInt(int n) {
        if (n >= this._s.length()) {
            return null;
        }
        return new JSString(new char[]{this._s.charAt(n)});
    }

    @Override
    public int hashCode(IdentitySet seen) {
        return this._s.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return this._s == null;
        }
        if (this._s == null) {
            return false;
        }
        return this._s.equals(o.toString());
    }

    public byte[] getBytes() {
        return this._s.getBytes();
    }

    @Override
    public Set<String> keySet(boolean includePrototype) {
        OrderedSet keys = new OrderedSet();
        for (int i = 0; i < this._s.length(); ++i) {
            keys.add(String.valueOf(i));
        }
        keys.addAll(super.keySet(includePrototype));
        return keys;
    }

    private void setObj(boolean b) {
        this.isObj = b;
    }

    public boolean isObj() {
        return this.isObj;
    }

    static {
        JS._debugSIStart("JSString");
        JS._debugSI("JSString", "0");
        JS._debugSI("JSString", "1");
        _cons = new JSStringCons();
        JS._debugSI("JSString", "2");
        EMPTY = new JSString("");
        JS._debugSIDone("JSString");
    }

    public static class Symbol
    extends JSString {
        public Symbol(String s) {
            super(s);
        }
    }

    public static class JSStringCons
    extends JSFunctionCalls1 {
        public JSObject newOne() {
            return new JSString("");
        }

        public Object call(Scope s, Object[] args) {
            return new JSString("");
        }

        public Object call(Scope s, Object fooO, Object[] args) {
            JSString foo = new JSString(fooO + "");
            Object o = s.getThis();
            if (o == null || !(o instanceof JSString)) {
                return foo;
            }
            JSString str = (JSString)o;
            str._s = foo != null ? foo.toString() : "";
            return str;
        }

        protected void init() {
            JS._debugSI("JSString", "JSStringCons init 0");
            final JSObjectBase myPrototype = this._prototype;
            if (!JS.JNI) {
                final StringEncrypter encrypter = new StringEncrypter("knsd8712@!98sad");
                this._prototype.set("encrypt", new JSFunctionCalls0(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object call(Scope s, Object[] foo) {
                        StringEncrypter stringEncrypter = encrypter;
                        synchronized (stringEncrypter) {
                            return new JSString(encrypter.encrypt(s.getThis().toString()));
                        }
                    }
                });
                this._prototype.set("decrypt", new JSFunctionCalls0(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object call(Scope s, Object[] foo) {
                        StringEncrypter stringEncrypter = encrypter;
                        synchronized (stringEncrypter) {
                            return new JSString(encrypter.decrypt(s.getThis().toString()));
                        }
                    }
                });
            }
            JS._debugSI("JSString", "JSStringCons init 1");
            this._prototype.set("trim", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    return new JSString(s.getThis().toString().trim());
                }
            });
            this._prototype.set("md5", new JSFunctionCalls0(){
                private final MD5 _myMd5 = new MD5();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object call(Scope s, Object[] extra) {
                    MD5 mD5 = this._myMd5;
                    synchronized (mD5) {
                        this._myMd5.Init();
                        this._myMd5.Update(s.getThis().toString());
                        return new JSString(this._myMd5.asHex());
                    }
                }
            });
            this._prototype.set("to_sym", new JSFunctionCalls0(){
                private final MD5 _myMd5 = new MD5();

                public Object call(Scope s, Object[] extra) {
                    return s.getThis().toString();
                }
            });
            this._prototype.set("toString", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] extra) {
                    Object o = s.getThis();
                    if (!(o instanceof JSString)) {
                        if (o == myPrototype) {
                            return new JSString("");
                        }
                        throw new JSException((Object)"String.prototype.toString can only be called on Strings");
                    }
                    return new JSString(((JSString)o)._s);
                }
            });
            this._prototype.set("toLowerCase", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    return new JSString(s.getThis().toString().toLowerCase());
                }
            });
            this._prototype.set("toUpperCase", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] foo) {
                    return new JSString(s.getThis().toString().toUpperCase());
                }
            });
            this._prototype.set("charCodeAt", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    String str = s.getThis().toString();
                    int idx = (int)JSNumber.getDouble(o);
                    if (idx >= str.length() || idx < 0) {
                        return Double.NaN;
                    }
                    return (int)str.charAt(idx);
                }
            });
            this._prototype.set("charAt", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    String str = s.getThis().toString();
                    int idx = (int)JSNumber.getDouble(o);
                    if (idx >= str.length() || idx < 0) {
                        return EMPTY;
                    }
                    return new JSString(str.substring(idx, idx + 1));
                }
            });
            this._prototype.set("indexOf", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    String str = s.getThis().toString();
                    if (o == null) {
                        return -1;
                    }
                    String thing = o.toString();
                    int start = 0;
                    if (foo != null && foo.length > 0 && foo[0] != null) {
                        start = JSNumber.getNumber(foo[0]).intValue();
                    }
                    return str.indexOf(thing, start);
                }
            });
            this._prototype.set("contains", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    String str = s.getThis().toString();
                    String thing = o.toString();
                    return str.contains(thing);
                }
            });
            this._prototype.set("__rshift", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    JSString me = (JSString)s.getThis();
                    String thing = o.toString();
                    me._s = me._s + thing;
                    return me;
                }
            });
            this._prototype.set("lastIndexOf", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    String str = s.getThis().toString();
                    String thing = o.toString();
                    int end = str.length();
                    if (foo != null && foo.length > 0) {
                        end = ((Number)foo[0]).intValue();
                    }
                    return str.lastIndexOf(thing, end);
                }
            });
            this._prototype.set("startsWith", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    String str = s.getThis().toString();
                    String thing = o.toString();
                    return str.startsWith(thing);
                }
            });
            this._prototype.set("endsWith", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    String str = s.getThis().toString();
                    String thing = o.toString();
                    return str.endsWith(thing);
                }
            });
            this._prototype.set("substring", new JSFunctionCalls2(){

                public Object call(Scope s, Object startO, Object endO, Object[] foo) {
                    String str = s.getThis().toString();
                    if (endO == null || endO == VOID) {
                        endO = str.length();
                    }
                    int len = str.length();
                    int temp1 = (int)Math.min(Math.max(JSNumber.getDouble(startO), 0.0), (double)len);
                    int temp2 = (int)Math.min(Math.max(JSNumber.getDouble(endO), 0.0), (double)len);
                    int start = Math.min(temp1, temp2);
                    int end = Math.max(temp1, temp2);
                    return new JSString(str.substring(start, end));
                }
            });
            this._prototype.set("substr", new JSFunctionCalls2(){

                public Object call(Scope s, Object startO, Object lengthO, Object[] foo) {
                    String str = s.getThis().toString();
                    int start = ((Number)startO).intValue();
                    if (start < 0) {
                        start = 0;
                    }
                    if (start >= str.length() || start < 0) {
                        return EMPTY;
                    }
                    int length = -1;
                    if (lengthO != null && lengthO instanceof Number) {
                        length = ((Number)lengthO).intValue();
                    }
                    if (start + length > str.length()) {
                        length = str.length() - start;
                    }
                    if (length < 0) {
                        return new JSString(str.substring(start));
                    }
                    return new JSString(str.substring(start, start + length));
                }
            });
            this._prototype.set("match", new JSFunctionCalls1(){

                public Object call(Scope s, Object o, Object[] foo) {
                    String str = s.getThis().toString();
                    if (o instanceof String || o instanceof JSString) {
                        o = new JSRegex(o.toString(), "");
                    }
                    if (!(o instanceof JSRegex)) {
                        throw new RuntimeException("not a regex : " + o.getClass());
                    }
                    JSRegex r = (JSRegex)o;
                    Matcher m = r._patt.matcher(str);
                    if (!m.find()) {
                        return null;
                    }
                    if (r.getFlags().contains("g")) {
                        JSArray a = new JSArray();
                        do {
                            a.add(new JSString(m.group()));
                        } while (m.find());
                        return a;
                    }
                    return r.exec(str);
                }
            });
            this._prototype.set("split", new JSFunctionCalls2(){

                public Object call(Scope s, Object o, Object limit, Object[] extra) {
                    String str = s.getThis().toString();
                    JSArray a = new JSArray();
                    if (limit == null) {
                        limit = Integer.MAX_VALUE;
                    } else if (((Number)(limit = StringParseUtil.parseStrict((String)limit.toString()))).intValue() == 0) {
                        return a;
                    }
                    if (o == null || o == VOID) {
                        a.add(s.getThis());
                        return a;
                    }
                    if (o instanceof String || o instanceof JSString) {
                        o = new JSRegex(JSRegex.quote(o.toString()), "");
                    }
                    if (!(o instanceof JSRegex)) {
                        throw new RuntimeException("not a regex : " + o.getClass());
                    }
                    JSRegex r = (JSRegex)o;
                    String spacer = null;
                    if (r.getPattern().contains("(")) {
                        spacer = r.getPattern().replaceAll("[()]", "");
                    }
                    for (String pc : r._patt.split(str, -1)) {
                        if (a.size() > 0 && spacer != null) {
                            a.add(spacer);
                        }
                        a.add(new JSString(pc));
                        if (a.size() >= ((Number)limit).intValue()) break;
                    }
                    if (r.getPattern().length() == 0) {
                        a.remove(0);
                        if (a.size() > 0) {
                            a.remove(a.size() - 1);
                        }
                    }
                    return a;
                }
            });
            this._prototype.set("reverse", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] args) {
                    String str = s.getThis().toString();
                    StringBuffer buf = new StringBuffer(str.length());
                    for (int i = str.length() - 1; i >= 0; --i) {
                        buf.append(str.charAt(i));
                    }
                    return new JSString(buf.toString());
                }
            });
            this._prototype.set("slice", new JSFunctionCalls2(){

                public Object call(Scope s, Object o1, Object o2, Object[] args) {
                    String str = s.getThis().toString();
                    int start = 0;
                    if (o1 != null && o1 instanceof Number && (start = ((Number)o1).intValue()) < 0) {
                        start = str.length() + start;
                    }
                    if (start < 0) {
                        start = 0;
                    }
                    if (start >= str.length()) {
                        return EMPTY;
                    }
                    int end = str.length();
                    if (o2 != null && o2 instanceof Number) {
                        end = ((Number)o2).intValue();
                        if (end < 0 && (end = str.length() + end) < 0) {
                            end = 0;
                        }
                        if (end > str.length()) {
                            end = str.length();
                        }
                        if (end < start) {
                            end = start;
                        }
                    }
                    return new JSString(str.substring(start, end));
                }
            });
            this._prototype.set("pluralize", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] args) {
                    String str = s.getThis().toString();
                    return str + "s";
                }
            });
            this._prototype.set("_eq__t_", this._prototype.get("match"));
            this._prototype.set("__delete", new JSFunctionCalls1(){

                public Object call(Scope s, Object all, Object[] args) {
                    String str = s.getThis().toString();
                    if (all == null) {
                        return str;
                    }
                    String bad = all.toString();
                    StringBuffer buf = new StringBuffer(str.length());
                    block0: for (int i = 0; i < str.length(); ++i) {
                        char c = str.charAt(i);
                        for (int j = 0; j < bad.length(); ++j) {
                            if (bad.charAt(j) == c) continue block0;
                        }
                        buf.append(c);
                    }
                    return new JSString(buf.toString());
                }
            });
            this._prototype.set("_lb__rb_", new JSFunctionCalls1(){

                public Object call(Scope s, Object thing, Object[] args) {
                    JSString str = (JSString)s.getThis();
                    if (thing instanceof Number) {
                        return (int)str._s.charAt(((Number)thing).intValue());
                    }
                    if (thing instanceof JSArray) {
                        JSArray a = (JSArray)thing;
                        int start = ((Number)a.get("start")).intValue();
                        int end = ((Number)a.get("end")).intValue();
                        String sub = str._s.substring(start, end + 1);
                        return new JSString(sub);
                    }
                    return null;
                }
            });
            this._prototype.set("each_byte", new JSFunctionCalls1(){

                public Object call(Scope s, Object funcObject, Object[] args) {
                    if (funcObject == null) {
                        throw new NullPointerException("each_byte needs a function");
                    }
                    JSFunction func = (JSFunction)funcObject;
                    String str = s.getThis().toString();
                    for (int i = 0; i < str.length(); ++i) {
                        func.call(s, str.charAt(i));
                    }
                    return null;
                }
            });
            this._prototype.set("replace", new JSFunctionCalls2(){

                public Object call(Scope s, Object o, Object repl, Object[] crap) {
                    String str = s.getThis().toString();
                    if (o instanceof String || o instanceof JSString) {
                        o = new JSRegex(JSRegex.quote(o.toString()), "");
                    }
                    if (!(o instanceof JSRegex)) {
                        throw new RuntimeException("not a regex : " + o.getClass());
                    }
                    JSRegex r = (JSRegex)o;
                    Matcher m = r._patt.matcher(str);
                    StringBuffer buf = null;
                    int start = 0;
                    JSObject options = crap != null && crap.length > 0 && crap[0] instanceof JSObject ? (JSObject)crap[0] : null;
                    boolean replaceAll = r._replaceAll || options != null && options.get("all") != null;
                    Object[] replArgs = null;
                    while (m.find()) {
                        if (buf == null) {
                            buf = new StringBuffer(str.length());
                        }
                        buf.append(str.substring(start, m.start()));
                        if (repl == null) {
                            repl = "null";
                        }
                        if (repl instanceof JSString || repl instanceof String) {
                            String foo = repl.toString();
                            for (int i = 0; i < foo.length(); ++i) {
                                int end;
                                char c = foo.charAt(i);
                                if (c != '$') {
                                    buf.append(c);
                                    continue;
                                }
                                if (i + 1 >= foo.length() || !Character.isDigit(foo.charAt(i + 1))) {
                                    buf.append(c);
                                    continue;
                                }
                                for (end = ++i; end < foo.length() && Character.isDigit(foo.charAt(end)); ++end) {
                                }
                                int num = Integer.parseInt(foo.substring(i, end));
                                buf.append(m.group(num) == null ? "" : m.group(num));
                                i = end - 1;
                            }
                        } else if (repl instanceof JSFunction) {
                            if (replArgs == null) {
                                replArgs = new Object[m.groupCount() + 1];
                            }
                            for (int i = 0; i < replArgs.length; ++i) {
                                replArgs[i] = new JSString(m.group(i));
                            }
                            buf.append(((JSFunction)repl).call(s, replArgs));
                        } else {
                            throw new RuntimeException("can't use replace with : " + repl.getClass());
                        }
                        start = m.end();
                        if (replaceAll) continue;
                    }
                    if (buf == null) {
                        return new JSString(str);
                    }
                    buf.append(str.substring(start));
                    return new JSString(buf.toString());
                }
            });
            this._prototype.set("sub", this._prototype.get("replace"));
            JSObjectBase gsubOptions = new JSObjectBase();
            gsubOptions.set("all", "asd");
            final Object[] gsubOptionsArray = new Object[]{gsubOptions};
            this._prototype.set("gsub", new JSFunctionCalls2(){

                public Object call(Scope s, Object o, Object repl, Object[] crap) {
                    return ((JSFunction)myPrototype.get("replace")).call(s, o, repl, gsubOptionsArray);
                }
            });
            this._prototype.set("valueOf", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] crap) {
                    Object o = s.getThis();
                    if (o == myPrototype) {
                        return new JSString("");
                    }
                    return new JSString(((JSString)o).toString());
                }
            });
            this.set("fromCharCode", new JSFunctionCalls0(){

                public Object call(Scope s, Object[] args) {
                    if (args == null) {
                        return new JSString("");
                    }
                    StringBuffer buf = new StringBuffer();
                    for (int i = 0; i < args.length; ++i) {
                        buf.append((char)JSNumber.toUint16(args[i]));
                    }
                    return new JSString(buf.toString());
                }
            });
            this.set("isUpper", new JSFunctionCalls1(){

                public Object call(Scope s, Object thing, Object[] args) {
                    String str = thing.toString();
                    for (int i = 0; i < str.length(); ++i) {
                        char c = str.charAt(i);
                        if (Character.isLetter(c) && Character.isUpperCase(c)) continue;
                        return false;
                    }
                    return true;
                }
            });
            this._prototype.dontEnumExisting();
        }
    }
}

